import numpy as np
from . import core as jiminy, tree as tree
from .dynamics import State as State, TrajectoryDataType as TrajectoryDataType
from _typeshed import Incomplete
from typing import Any, Callable, Dict, List, Literal, Sequence, Type, overload

SENSORS_FIELDS: Dict[Type[jiminy.AbstractSensor], List[str] | Dict[str, List[str]]]
FieldNested: Incomplete
read_log: Incomplete

@overload
def extract_variables_from_log(log_vars: Dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[False] = False) -> List[np.ndarray]: ...
@overload
def extract_variables_from_log(log_vars: Dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[True]) -> Dict[str, np.ndarray]: ...
def build_robot_from_log(log_data: Dict[str, Any], mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = (), *, robot_name: str = '') -> jiminy.Robot: ...
def build_robots_from_log(log_data: Dict[str, Any], mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = ()) -> Sequence[jiminy.Robot]: ...
def extract_trajectory_from_log(log_data: Dict[str, Any], robot: jiminy.Model | None = None, *, robot_name: str | None = None) -> TrajectoryDataType: ...
def extract_trajectories_from_log(log_data: Dict[str, Any], robots: Sequence[jiminy.Model] | None = None) -> Dict[str, TrajectoryDataType]: ...
def update_sensor_measurements_from_log(log_data: Dict[str, Any], robot: jiminy.Model) -> Callable[[float, np.ndarray, np.ndarray], None]: ...
