"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_nag_1 = require("cdk-nag");
const fs = require("fs-extra");
const Mustache = require("mustache");
const aws_prototyping_rules_1 = require("../src/packs/aws-prototyping-rules");
aws_prototyping_rules_1.RuleMetadata.forEach((x) => {
    x.info = x.info.replace("\n\n", "<br /><br />");
    x.explanation = x.explanation.replace("\n\n", "<br /><br />");
});
const renderedMarkdown = Mustache.render(fs
    .readFileSync(`${__dirname}/templates/markdown/awsprototypingrules-readme.mustache`)
    .toString(), {
    packName: aws_prototyping_rules_1.PackName,
    sections: [
        {
            sectionTitle: "Errors",
            rules: aws_prototyping_rules_1.RuleMetadata.filter((r) => r.level === cdk_nag_1.NagMessageLevel.ERROR),
        },
        {
            sectionTitle: "Warnings",
            rules: aws_prototyping_rules_1.RuleMetadata.filter((r) => r.level === cdk_nag_1.NagMessageLevel.WARN),
        },
    ],
});
fs.writeFileSync(`${__dirname}/../src/packs/README.md`, renderedMarkdown);
//# sourceMappingURL=data:application/json;base64,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