"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Java Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineJavaProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineJavaProject", {
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)["src/test/java/projenrc.java"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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