# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from datetime import datetime
from typing import Optional

from .amount_data import AmountData
from .card_payment_data import CardPaymentData
from .dcc_data import DccData
from .merchant_data import MerchantData
from .payment_references import PaymentReferences
from .terminal_data import TerminalData

from worldline.acquiring.sdk.domain.data_object import DataObject


class ApiPaymentRequest(DataObject):

    __amount: Optional[AmountData] = None
    __authorization_type: Optional[str] = None
    __card_payment_data: Optional[CardPaymentData] = None
    __dynamic_currency_conversion: Optional[DccData] = None
    __merchant: Optional[MerchantData] = None
    __operation_id: Optional[str] = None
    __references: Optional[PaymentReferences] = None
    __terminal_data: Optional[TerminalData] = None
    __transaction_timestamp: Optional[datetime] = None

    @property
    def amount(self) -> Optional[AmountData]:
        """
        | Amount for the operation.

        Type: :class:`worldline.acquiring.sdk.v1.domain.amount_data.AmountData`
        """
        return self.__amount

    @amount.setter
    def amount(self, value: Optional[AmountData]) -> None:
        self.__amount = value

    @property
    def authorization_type(self) -> Optional[str]:
        """
        | The type of authorization

        Type: str
        """
        return self.__authorization_type

    @authorization_type.setter
    def authorization_type(self, value: Optional[str]) -> None:
        self.__authorization_type = value

    @property
    def card_payment_data(self) -> Optional[CardPaymentData]:
        """
        | Card data

        Type: :class:`worldline.acquiring.sdk.v1.domain.card_payment_data.CardPaymentData`
        """
        return self.__card_payment_data

    @card_payment_data.setter
    def card_payment_data(self, value: Optional[CardPaymentData]) -> None:
        self.__card_payment_data = value

    @property
    def dynamic_currency_conversion(self) -> Optional[DccData]:
        """
        | Dynamic Currency Conversion (DCC) rate data from DCC lookup response.
        | Mandatory for DCC transactions.

        Type: :class:`worldline.acquiring.sdk.v1.domain.dcc_data.DccData`
        """
        return self.__dynamic_currency_conversion

    @dynamic_currency_conversion.setter
    def dynamic_currency_conversion(self, value: Optional[DccData]) -> None:
        self.__dynamic_currency_conversion = value

    @property
    def merchant(self) -> Optional[MerchantData]:
        """
        | Merchant Data

        Type: :class:`worldline.acquiring.sdk.v1.domain.merchant_data.MerchantData`
        """
        return self.__merchant

    @merchant.setter
    def merchant(self, value: Optional[MerchantData]) -> None:
        self.__merchant = value

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A globally unique identifier of the operation, generated by you.
        | We advise you to submit a UUID or an identifier composed of an arbitrary string and a UUID/URL-safe Base64 UUID (RFC 4648 §5).
        | It's used to detect duplicate requests or to reference an operation in technical reversals.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def references(self) -> Optional[PaymentReferences]:
        """
        | Payment References

        Type: :class:`worldline.acquiring.sdk.v1.domain.payment_references.PaymentReferences`
        """
        return self.__references

    @references.setter
    def references(self, value: Optional[PaymentReferences]) -> None:
        self.__references = value

    @property
    def terminal_data(self) -> Optional[TerminalData]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.terminal_data.TerminalData`
        """
        return self.__terminal_data

    @terminal_data.setter
    def terminal_data(self, value: Optional[TerminalData]) -> None:
        self.__terminal_data = value

    @property
    def transaction_timestamp(self) -> Optional[datetime]:
        """
        | Timestamp of transaction in ISO 8601 format (YYYY-MM-DDThh:mm:ss+TZD)
        | It can be expressed in merchant time zone (ex: 2023-10-10T08:00+02:00) or in UTC (ex: 2023-10-10T08:00Z)

        Type: datetime
        """
        return self.__transaction_timestamp

    @transaction_timestamp.setter
    def transaction_timestamp(self, value: Optional[datetime]) -> None:
        self.__transaction_timestamp = value

    def to_dictionary(self) -> dict:
        dictionary = super(ApiPaymentRequest, self).to_dictionary()
        if self.amount is not None:
            dictionary['amount'] = self.amount.to_dictionary()
        if self.authorization_type is not None:
            dictionary['authorizationType'] = self.authorization_type
        if self.card_payment_data is not None:
            dictionary['cardPaymentData'] = self.card_payment_data.to_dictionary()
        if self.dynamic_currency_conversion is not None:
            dictionary['dynamicCurrencyConversion'] = self.dynamic_currency_conversion.to_dictionary()
        if self.merchant is not None:
            dictionary['merchant'] = self.merchant.to_dictionary()
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.references is not None:
            dictionary['references'] = self.references.to_dictionary()
        if self.terminal_data is not None:
            dictionary['terminalData'] = self.terminal_data.to_dictionary()
        if self.transaction_timestamp is not None:
            dictionary['transactionTimestamp'] = DataObject.format_datetime(self.transaction_timestamp)
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'ApiPaymentRequest':
        super(ApiPaymentRequest, self).from_dictionary(dictionary)
        if 'amount' in dictionary:
            if not isinstance(dictionary['amount'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['amount']))
            value = AmountData()
            self.amount = value.from_dictionary(dictionary['amount'])
        if 'authorizationType' in dictionary:
            self.authorization_type = dictionary['authorizationType']
        if 'cardPaymentData' in dictionary:
            if not isinstance(dictionary['cardPaymentData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['cardPaymentData']))
            value = CardPaymentData()
            self.card_payment_data = value.from_dictionary(dictionary['cardPaymentData'])
        if 'dynamicCurrencyConversion' in dictionary:
            if not isinstance(dictionary['dynamicCurrencyConversion'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['dynamicCurrencyConversion']))
            value = DccData()
            self.dynamic_currency_conversion = value.from_dictionary(dictionary['dynamicCurrencyConversion'])
        if 'merchant' in dictionary:
            if not isinstance(dictionary['merchant'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['merchant']))
            value = MerchantData()
            self.merchant = value.from_dictionary(dictionary['merchant'])
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'references' in dictionary:
            if not isinstance(dictionary['references'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['references']))
            value = PaymentReferences()
            self.references = value.from_dictionary(dictionary['references'])
        if 'terminalData' in dictionary:
            if not isinstance(dictionary['terminalData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['terminalData']))
            value = TerminalData()
            self.terminal_data = value.from_dictionary(dictionary['terminalData'])
        if 'transactionTimestamp' in dictionary:
            self.transaction_timestamp = DataObject.parse_datetime(dictionary['transactionTimestamp'])
        return self
