#      Copyright (C)  2022. CQ Inversiones SAS.
#
#      This program is free software: you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation, either version 3 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

# Generated by Django 3.2.11 on 2022-04-29 23:45

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangocms_zb_filer.lib.fields
import filer.fields.file
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name_plural': 'Categories',
            },
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
                ('description', models.TextField(blank=True, max_length=1000, null=True, verbose_name='Description')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='Date Modified')),
                ('published_at', models.DateTimeField(blank=True, null=True, verbose_name='Date Published')),
                ('publish_end_at', models.DateTimeField(blank=True, null=True, verbose_name='Date Published End')),
                ('notification', djangocms_zb_filer.lib.fields.MultiEmailField(blank=True, default=[], help_text='Specify the email addresses. These email addresses will be used when sending a certification.', null=True, verbose_name='Notification')),
                ('icon_class', models.CharField(choices=[('fa-light fa-file', 'Default'), ('fa-light fa-file-pdf', 'Pdf'), ('fa-light fa-file-word', 'Word'), ('fa-light fa-file-excel', 'Excel'), ('fa-light fa-file-powerpoint', 'Power Point')], default='fa-light fa-file', max_length=30, verbose_name='Icon')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='zb_publication_author', to=settings.AUTH_USER_MODEL, verbose_name='Author')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='zb_publication_category', to='djangocms_zb_filer.category', verbose_name='Category')),
                ('file', filer.fields.file.FilerFileField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='zb_publication_file', to='filer.file', verbose_name='File')),
            ],
            options={
                'verbose_name_plural': 'Publications',
            },
        ),
        migrations.CreateModel(
            name='FilerPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_zb_filer_filerpluginmodel', serialize=False, to='cms.cmsplugin')),
                ('order', models.CharField(choices=[('published_at', '[Date Published] From the oldest to the most recent'), ('-published_at', '[Date Published] From the most recent to the oldest'), ('title', '[Title] A-Z'), ('-title', '[Title] Z-A')], default='-published_at', max_length=15, verbose_name='Order By')),
                ('pagination', models.IntegerField(default=10, help_text='Result by page', verbose_name='Pagination')),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='(HTML) Alternative template for the design of list publications.', max_length=70, verbose_name='Template')),
                ('target', models.CharField(blank=True, choices=[('_blank', '_blank'), ('_parent', '_parent'), ('_self', '_self'), ('_top', '_top')], max_length=7, null=True, verbose_name='Link Target')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='zb_plugins_category', to='djangocms_zb_filer.category', verbose_name='Filter by category')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='CertificateConfigs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('title', models.CharField(max_length=300, verbose_name='Title')),
                ('description', models.TextField(max_length=2000, verbose_name='Description')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('template', models.CharField(choices=[('default', 'Default')], default='default', help_text='(HTML) Alternative template for the design of certificate.', max_length=70, verbose_name='Template')),
                ('header', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='zb_header_filer_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Header')),
                ('sign', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='zb_sign_filer_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Sign')),
            ],
            options={
                'verbose_name_plural': 'Certificate Configs',
            },
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(verbose_name='Date Created')),
                ('file_path', models.CharField(max_length=250, verbose_name='File Path')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='zb_certifies_publication', to='djangocms_zb_filer.publication', verbose_name='Publication')),
            ],
            options={
                'verbose_name_plural': 'Certificates',
            },
        ),
        migrations.AddField(
            model_name='category',
            name='certificate',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='zb_category_certifies', to='djangocms_zb_filer.certificateconfigs', verbose_name='Certificate'),
        ),
        migrations.AddField(
            model_name='category',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='zb_subcategory', to='djangocms_zb_filer.category', verbose_name='parent category'),
        ),
    ]
