import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the access key id for the AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#access_key_id AwsStorage#access_key_id}
    */
    readonly accessKeyId?: string;
    /**
    * Specifies the bucket name used for AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#bucket AwsStorage#bucket}
    */
    readonly bucket: string;
    /**
    * Specifies the company id to which the created AWS storage should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#company_id AwsStorage#company_id}
    */
    readonly companyId?: number;
    /**
    * Sepcifies the saved creation name for creating AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#credentials_name AwsStorage#credentials_name}
    */
    readonly credentialsName?: string;
    /**
    * Specifies the Deduplication path for the AWS Storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#ddb_location AwsStorage#ddb_location}
    */
    readonly ddbLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#id AwsStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the Media agent used for the AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#mediaagent AwsStorage#mediaagent}
    */
    readonly mediaagent: string;
    /**
    * Specifies the secret access key for the AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#secret_access_key AwsStorage#secret_access_key}
    */
    readonly secretAccessKey?: string;
    /**
    * Specifies the service host name for the AWS storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#service_host AwsStorage#service_host}
    */
    readonly serviceHost: string;
    /**
    * Specifies the Name of the AWS Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#storage_name AwsStorage#storage_name}
    */
    readonly storageName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage commvault_aws_storage}
*/
export declare class AwsStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_aws_storage";
    /**
    * Generates CDKTF code for importing a AwsStorage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AwsStorage to import
    * @param importFromId The id of the existing AwsStorage that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AwsStorage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/aws_storage commvault_aws_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsStorageConfig
    */
    constructor(scope: Construct, id: string, config: AwsStorageConfig);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    resetAccessKeyId(): void;
    get accessKeyIdInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _credentialsName?;
    get credentialsName(): string;
    set credentialsName(value: string);
    resetCredentialsName(): void;
    get credentialsNameInput(): string | undefined;
    private _ddbLocation?;
    get ddbLocation(): string;
    set ddbLocation(value: string);
    resetDdbLocation(): void;
    get ddbLocationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaagent?;
    get mediaagent(): string;
    set mediaagent(value: string);
    get mediaagentInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    resetSecretAccessKey(): void;
    get secretAccessKeyInput(): string | undefined;
    private _serviceHost?;
    get serviceHost(): string;
    set serviceHost(value: string);
    get serviceHostInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    get storageNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
