import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureHypervisorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies The clients that have the VSA package installed and that act as proxy clients for Azure hypervisors.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#access_nodes AzureHypervisor#access_nodes}
    */
    readonly accessNodes: string;
    /**
    * Specifies The application ID of the tenant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#application_id AzureHypervisor#application_id}
    */
    readonly applicationId: string;
    /**
    * Specifies The password for the application ID of the tenant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#application_password AzureHypervisor#application_password}
    */
    readonly applicationPassword: string;
    /**
    * Specifies the company id to which the Azure Hypervisor should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#company_id AzureHypervisor#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies The name of the hypervisor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#hypervisor_name AzureHypervisor#hypervisor_name}
    */
    readonly hypervisorName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#id AzureHypervisor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies The subscription ID for your Azure account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#subscription_id AzureHypervisor#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * Specifies The tenant ID for your Azure account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#tenant_id AzureHypervisor#tenant_id}
    */
    readonly tenantId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor commvault_azure_hypervisor}
*/
export declare class AzureHypervisor extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_azure_hypervisor";
    /**
    * Generates CDKTF code for importing a AzureHypervisor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AzureHypervisor to import
    * @param importFromId The id of the existing AzureHypervisor that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AzureHypervisor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_hypervisor commvault_azure_hypervisor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureHypervisorConfig
    */
    constructor(scope: Construct, id: string, config: AzureHypervisorConfig);
    private _accessNodes?;
    get accessNodes(): string;
    set accessNodes(value: string);
    get accessNodesInput(): string | undefined;
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _applicationPassword?;
    get applicationPassword(): string;
    set applicationPassword(value: string);
    get applicationPasswordInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _hypervisorName?;
    get hypervisorName(): string;
    set hypervisorName(value: string);
    get hypervisorNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
