import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the access key id for the Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#access_key_id AzureStorage#access_key_id}
    */
    readonly accessKeyId?: string;
    /**
    * Specifies the Account name for the Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#account_name AzureStorage#account_name}
    */
    readonly accountName?: string;
    /**
    * Specifies the company id to which the created Azure storage should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#company_id AzureStorage#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies the container name user for the Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#container AzureStorage#container}
    */
    readonly container: string;
    /**
    * Specifies the saved creation name for creating Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#credentials_name AzureStorage#credentials_name}
    */
    readonly credentialsName?: string;
    /**
    * Specifies the Deduplication path for the Azure Storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#ddb_location AzureStorage#ddb_location}
    */
    readonly ddbLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#id AzureStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the Media agent used for the Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#mediaagent AzureStorage#mediaagent}
    */
    readonly mediaagent: string;
    /**
    * Specifies the service host name for the Azure storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#service_host AzureStorage#service_host}
    */
    readonly serviceHost: string;
    /**
    * Specifies the Name of the Azure Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#storage_name AzureStorage#storage_name}
    */
    readonly storageName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage commvault_azure_storage}
*/
export declare class AzureStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_azure_storage";
    /**
    * Generates CDKTF code for importing a AzureStorage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AzureStorage to import
    * @param importFromId The id of the existing AzureStorage that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AzureStorage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/azure_storage commvault_azure_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureStorageConfig
    */
    constructor(scope: Construct, id: string, config: AzureStorageConfig);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    resetAccessKeyId(): void;
    get accessKeyIdInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    resetAccountName(): void;
    get accountNameInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _credentialsName?;
    get credentialsName(): string;
    set credentialsName(value: string);
    resetCredentialsName(): void;
    get credentialsNameInput(): string | undefined;
    private _ddbLocation?;
    get ddbLocation(): string;
    set ddbLocation(value: string);
    resetDdbLocation(): void;
    get ddbLocationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaagent?;
    get mediaagent(): string;
    set mediaagent(value: string);
    get mediaagentInput(): string | undefined;
    private _serviceHost?;
    get serviceHost(): string;
    set serviceHost(value: string);
    get serviceHostInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    get storageNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
