import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CompanyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the SMTP address of the company.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#associated_smtp Company#associated_smtp}
    */
    readonly associatedSmtp?: string;
    /**
    * Specifies the Alias name for the company.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#company_alias Company#company_alias}
    */
    readonly companyAlias: string;
    /**
    * Specifies  the company id to which the child company should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#company_id Company#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies the name of the Company.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#company_name Company#company_name}
    */
    readonly companyName: string;
    /**
    * Specifies Name of the tenant administrator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#contact_name Company#contact_name}
    */
    readonly contactName: string;
    /**
    * Specifies Email address for the tenant administrator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#email Company#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#id Company#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the data protection plans to use for the company. The plans you select are the plans that the tenant administrator can choose from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#plans Company#plans}
    */
    readonly plans?: string[];
    /**
    * Specifies whether  email needs to be sent ot not
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#send_email Company#send_email}
    */
    readonly sendEmail?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company commvault_company}
*/
export declare class Company extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_company";
    /**
    * Generates CDKTF code for importing a Company resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Company to import
    * @param importFromId The id of the existing Company that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Company to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/company commvault_company} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CompanyConfig
    */
    constructor(scope: Construct, id: string, config: CompanyConfig);
    private _associatedSmtp?;
    get associatedSmtp(): string;
    set associatedSmtp(value: string);
    resetAssociatedSmtp(): void;
    get associatedSmtpInput(): string | undefined;
    private _companyAlias?;
    get companyAlias(): string;
    set companyAlias(value: string);
    get companyAliasInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    get companyNameInput(): string | undefined;
    private _contactName?;
    get contactName(): string;
    set contactName(value: string);
    get contactNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plans?;
    get plans(): string[];
    set plans(value: string[]);
    resetPlans(): void;
    get plansInput(): string[] | undefined;
    private _sendEmail?;
    get sendEmail(): boolean | cdktf.IResolvable;
    set sendEmail(value: boolean | cdktf.IResolvable);
    resetSendEmail(): void;
    get sendEmailInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
