import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access Key ID of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#accesskeyid CredentialAws#accesskeyid}
    */
    readonly accesskeyid: string;
    /**
    * [WINDOWSACCOUNT, LINUXACCOUNT, STORAGE_ARRAY_ACCOUNT, CLOUD_ACCOUNT]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#accounttype CredentialAws#accounttype}
    */
    readonly accounttype?: string;
    /**
    * Description of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#description CredentialAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#id CredentialAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#name CredentialAws#name}
    */
    readonly name: string;
    /**
    * Secret Access Key of Credential and must be in base64 encoded format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#secretaccesskey CredentialAws#secretaccesskey}
    */
    readonly secretaccesskey: string;
    /**
    * Cloud vendor types appilcable only for Cloud Account type [ALICLOUD_OSS, AMAZON_GLACIER, AMAZON, ATT_SYNAPTIC, REVERA_VAULT, CEPH_OBJECT_GATEWAY_S3, CMCC_ONEST, CLOUDIAN_HYPERSTORE, DELL_EMC_ECS_S3, EMC_ATMOS, FUJITSU_STORAGE_ETERNUS, GOOGLE_CLOUD, HDS_HCP, HITACHI_VANTARA_HCP_S3, HUAWEI_OSS, IBM_CLOUD, IBM_CLOUD_S3, INSPUR_CLOUD, IRON_MOUNTAIN_CLOUD, KINGSOFT_KS3, MICROSOFT_AZURE_TYPE, NETAPP_STORAGEGRID, NUTANIX_BUCKETS, OPENSTACK, AMPLIDATA, RACKSPACE_CLOUD_FILES, S3_COMPATIBLE, SALESFORCE_CONNECTED_APP, SCALITY_RING, TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE, VERIZON_CLOUD, WASABI_HOT_CLOUD_STORAGE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#vendortype CredentialAws#vendortype}
    */
    readonly vendortype?: string;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#security CredentialAws#security}
    */
    readonly security?: CredentialAwsSecurity[] | cdktf.IResolvable;
}
export interface CredentialAwsSecurityAssociationsPermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#categoryid CredentialAws#categoryid}
    */
    readonly categoryid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#categoryname CredentialAws#categoryname}
    */
    readonly categoryname?: string;
    /**
    * Flag to specify if this is included permission or excluded permission.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#exclude CredentialAws#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#permissionid CredentialAws#permissionid}
    */
    readonly permissionid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#permissionname CredentialAws#permissionname}
    */
    readonly permissionname?: string;
    /**
    * Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#type CredentialAws#type}
    */
    readonly type?: string;
}
export declare function credentialAwsSecurityAssociationsPermissionsToTerraform(struct?: CredentialAwsSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare function credentialAwsSecurityAssociationsPermissionsToHclTerraform(struct?: CredentialAwsSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityAssociationsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityAssociationsPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityAssociationsPermissions | cdktf.IResolvable | undefined);
    private _categoryid?;
    get categoryid(): number;
    set categoryid(value: number);
    resetCategoryid(): void;
    get categoryidInput(): number | undefined;
    private _categoryname?;
    get categoryname(): string;
    set categoryname(value: string);
    resetCategoryname(): void;
    get categorynameInput(): string | undefined;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _permissionid?;
    get permissionid(): number;
    set permissionid(value: number);
    resetPermissionid(): void;
    get permissionidInput(): number | undefined;
    private _permissionname?;
    get permissionname(): string;
    set permissionname(value: string);
    resetPermissionname(): void;
    get permissionnameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class CredentialAwsSecurityAssociationsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityAssociationsPermissionsOutputReference;
}
export interface CredentialAwsSecurityAssociationsUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#id CredentialAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAwsSecurityAssociationsUserToTerraform(struct?: CredentialAwsSecurityAssociationsUser | cdktf.IResolvable): any;
export declare function credentialAwsSecurityAssociationsUserToHclTerraform(struct?: CredentialAwsSecurityAssociationsUser | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityAssociationsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityAssociationsUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityAssociationsUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAwsSecurityAssociationsUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityAssociationsUserOutputReference;
}
export interface CredentialAwsSecurityAssociationsUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#id CredentialAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAwsSecurityAssociationsUsergroupToTerraform(struct?: CredentialAwsSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare function credentialAwsSecurityAssociationsUsergroupToHclTerraform(struct?: CredentialAwsSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityAssociationsUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityAssociationsUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityAssociationsUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAwsSecurityAssociationsUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityAssociationsUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityAssociationsUsergroupOutputReference;
}
export interface CredentialAwsSecurityAssociations {
    /**
    * To check if the user/user group associated is the owner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#iscreatorassociation CredentialAws#iscreatorassociation}
    */
    readonly iscreatorassociation?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#permissions CredentialAws#permissions}
    */
    readonly permissions?: CredentialAwsSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#user CredentialAws#user}
    */
    readonly user?: CredentialAwsSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#usergroup CredentialAws#usergroup}
    */
    readonly usergroup?: CredentialAwsSecurityAssociationsUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAwsSecurityAssociationsToTerraform(struct?: CredentialAwsSecurityAssociations | cdktf.IResolvable): any;
export declare function credentialAwsSecurityAssociationsToHclTerraform(struct?: CredentialAwsSecurityAssociations | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityAssociations | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityAssociations | cdktf.IResolvable | undefined);
    private _iscreatorassociation?;
    get iscreatorassociation(): string;
    set iscreatorassociation(value: string);
    resetIscreatorassociation(): void;
    get iscreatorassociationInput(): string | undefined;
    private _permissions;
    get permissions(): CredentialAwsSecurityAssociationsPermissionsList;
    putPermissions(value: CredentialAwsSecurityAssociationsPermissions[] | cdktf.IResolvable): void;
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | CredentialAwsSecurityAssociationsPermissions[] | undefined;
    private _user;
    get user(): CredentialAwsSecurityAssociationsUserList;
    putUser(value: CredentialAwsSecurityAssociationsUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAwsSecurityAssociationsUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAwsSecurityAssociationsUsergroupList;
    putUsergroup(value: CredentialAwsSecurityAssociationsUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAwsSecurityAssociationsUsergroup[] | undefined;
}
export declare class CredentialAwsSecurityAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityAssociations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityAssociationsOutputReference;
}
export interface CredentialAwsSecurityOwnerUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#id CredentialAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#name CredentialAws#name}
    */
    readonly name?: string;
}
export declare function credentialAwsSecurityOwnerUserToTerraform(struct?: CredentialAwsSecurityOwnerUser | cdktf.IResolvable): any;
export declare function credentialAwsSecurityOwnerUserToHclTerraform(struct?: CredentialAwsSecurityOwnerUser | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityOwnerUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityOwnerUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityOwnerUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAwsSecurityOwnerUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityOwnerUserOutputReference;
}
export interface CredentialAwsSecurityOwnerUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#id CredentialAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#name CredentialAws#name}
    */
    readonly name?: string;
}
export declare function credentialAwsSecurityOwnerUsergroupToTerraform(struct?: CredentialAwsSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare function credentialAwsSecurityOwnerUsergroupToHclTerraform(struct?: CredentialAwsSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityOwnerUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityOwnerUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityOwnerUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAwsSecurityOwnerUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityOwnerUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityOwnerUsergroupOutputReference;
}
export interface CredentialAwsSecurityOwner {
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#user CredentialAws#user}
    */
    readonly user?: CredentialAwsSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#usergroup CredentialAws#usergroup}
    */
    readonly usergroup?: CredentialAwsSecurityOwnerUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAwsSecurityOwnerToTerraform(struct?: CredentialAwsSecurityOwner | cdktf.IResolvable): any;
export declare function credentialAwsSecurityOwnerToHclTerraform(struct?: CredentialAwsSecurityOwner | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurityOwner | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurityOwner | cdktf.IResolvable | undefined);
    private _user;
    get user(): CredentialAwsSecurityOwnerUserList;
    putUser(value: CredentialAwsSecurityOwnerUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAwsSecurityOwnerUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAwsSecurityOwnerUsergroupList;
    putUsergroup(value: CredentialAwsSecurityOwnerUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAwsSecurityOwnerUsergroup[] | undefined;
}
export declare class CredentialAwsSecurityOwnerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurityOwner[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityOwnerOutputReference;
}
export interface CredentialAwsSecurity {
    /**
    * associations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#associations CredentialAws#associations}
    */
    readonly associations?: CredentialAwsSecurityAssociations[] | cdktf.IResolvable;
    /**
    * owner block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#owner CredentialAws#owner}
    */
    readonly owner?: CredentialAwsSecurityOwner[] | cdktf.IResolvable;
}
export declare function credentialAwsSecurityToTerraform(struct?: CredentialAwsSecurity | cdktf.IResolvable): any;
export declare function credentialAwsSecurityToHclTerraform(struct?: CredentialAwsSecurity | cdktf.IResolvable): any;
export declare class CredentialAwsSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwsSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwsSecurity | cdktf.IResolvable | undefined);
    private _associations;
    get associations(): CredentialAwsSecurityAssociationsList;
    putAssociations(value: CredentialAwsSecurityAssociations[] | cdktf.IResolvable): void;
    resetAssociations(): void;
    get associationsInput(): cdktf.IResolvable | CredentialAwsSecurityAssociations[] | undefined;
    private _owner;
    get owner(): CredentialAwsSecurityOwnerList;
    putOwner(value: CredentialAwsSecurityOwner[] | cdktf.IResolvable): void;
    resetOwner(): void;
    get ownerInput(): cdktf.IResolvable | CredentialAwsSecurityOwner[] | undefined;
}
export declare class CredentialAwsSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwsSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwsSecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws commvault_credential_aws}
*/
export declare class CredentialAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_credential_aws";
    /**
    * Generates CDKTF code for importing a CredentialAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialAws to import
    * @param importFromId The id of the existing CredentialAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_aws commvault_credential_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialAwsConfig
    */
    constructor(scope: Construct, id: string, config: CredentialAwsConfig);
    private _accesskeyid?;
    get accesskeyid(): string;
    set accesskeyid(value: string);
    get accesskeyidInput(): string | undefined;
    private _accounttype?;
    get accounttype(): string;
    set accounttype(value: string);
    resetAccounttype(): void;
    get accounttypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretaccesskey?;
    get secretaccesskey(): string;
    set secretaccesskey(value: string);
    get secretaccesskeyInput(): string | undefined;
    private _vendortype?;
    get vendortype(): string;
    set vendortype(value: string);
    resetVendortype(): void;
    get vendortypeInput(): string | undefined;
    private _security;
    get security(): CredentialAwsSecurityList;
    putSecurity(value: CredentialAwsSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | CredentialAwsSecurity[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
