import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialAzurewithtenantidConfig extends cdktf.TerraformMetaArguments {
    /**
    * [WINDOWSACCOUNT, LINUXACCOUNT, STORAGE_ARRAY_ACCOUNT, CLOUD_ACCOUNT]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#accounttype CredentialAzurewithtenantid#accounttype}
    */
    readonly accounttype?: string;
    /**
    * Unique Azure application ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#applicationid CredentialAzurewithtenantid#applicationid}
    */
    readonly applicationid: string;
    /**
    * Application secret of Credential and must be in base64 encoded format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#applicationsecret CredentialAzurewithtenantid#applicationsecret}
    */
    readonly applicationsecret: string;
    /**
    * Description of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#description CredentialAzurewithtenantid#description}
    */
    readonly description?: string;
    /**
    * Azure cloud deployed region [AZURE_CLOUD, AZURE_USGOV, AZURE_GERMANCLOUD, AZURE_CHINACLOUD, AZURE_STACK]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#environment CredentialAzurewithtenantid#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#id CredentialAzurewithtenantid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#name CredentialAzurewithtenantid#name}
    */
    readonly name: string;
    /**
    * Unique Azure active directory ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#tenantid CredentialAzurewithtenantid#tenantid}
    */
    readonly tenantid: string;
    /**
    * Cloud vendor types appilcable only for Cloud Account type [ALICLOUD_OSS, AMAZON_GLACIER, AMAZON, ATT_SYNAPTIC, REVERA_VAULT, CEPH_OBJECT_GATEWAY_S3, CMCC_ONEST, CLOUDIAN_HYPERSTORE, DELL_EMC_ECS_S3, EMC_ATMOS, FUJITSU_STORAGE_ETERNUS, GOOGLE_CLOUD, HDS_HCP, HITACHI_VANTARA_HCP_S3, HUAWEI_OSS, IBM_CLOUD, IBM_CLOUD_S3, INSPUR_CLOUD, IRON_MOUNTAIN_CLOUD, KINGSOFT_KS3, MICROSOFT_AZURE_TYPE, NETAPP_STORAGEGRID, NUTANIX_BUCKETS, OPENSTACK, AMPLIDATA, RACKSPACE_CLOUD_FILES, S3_COMPATIBLE, SALESFORCE_CONNECTED_APP, SCALITY_RING, TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE, VERIZON_CLOUD, WASABI_HOT_CLOUD_STORAGE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#vendortype CredentialAzurewithtenantid#vendortype}
    */
    readonly vendortype?: string;
    /**
    * endpoints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#endpoints CredentialAzurewithtenantid#endpoints}
    */
    readonly endpoints?: CredentialAzurewithtenantidEndpoints[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#security CredentialAzurewithtenantid#security}
    */
    readonly security?: CredentialAzurewithtenantidSecurity[] | cdktf.IResolvable;
}
export interface CredentialAzurewithtenantidEndpoints {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#activedirectory CredentialAzurewithtenantid#activedirectory}
    */
    readonly activedirectory?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#resourcemanager CredentialAzurewithtenantid#resourcemanager}
    */
    readonly resourcemanager?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#storage CredentialAzurewithtenantid#storage}
    */
    readonly storage?: string;
}
export declare function credentialAzurewithtenantidEndpointsToTerraform(struct?: CredentialAzurewithtenantidEndpoints | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidEndpointsToHclTerraform(struct?: CredentialAzurewithtenantidEndpoints | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidEndpoints | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidEndpoints | cdktf.IResolvable | undefined);
    private _activedirectory?;
    get activedirectory(): string;
    set activedirectory(value: string);
    resetActivedirectory(): void;
    get activedirectoryInput(): string | undefined;
    private _resourcemanager?;
    get resourcemanager(): string;
    set resourcemanager(value: string);
    resetResourcemanager(): void;
    get resourcemanagerInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
}
export declare class CredentialAzurewithtenantidEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidEndpoints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidEndpointsOutputReference;
}
export interface CredentialAzurewithtenantidSecurityAssociationsPermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#categoryid CredentialAzurewithtenantid#categoryid}
    */
    readonly categoryid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#categoryname CredentialAzurewithtenantid#categoryname}
    */
    readonly categoryname?: string;
    /**
    * Flag to specify if this is included permission or excluded permission.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#exclude CredentialAzurewithtenantid#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#permissionid CredentialAzurewithtenantid#permissionid}
    */
    readonly permissionid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#permissionname CredentialAzurewithtenantid#permissionname}
    */
    readonly permissionname?: string;
    /**
    * Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#type CredentialAzurewithtenantid#type}
    */
    readonly type?: string;
}
export declare function credentialAzurewithtenantidSecurityAssociationsPermissionsToTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityAssociationsPermissionsToHclTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityAssociationsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityAssociationsPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityAssociationsPermissions | cdktf.IResolvable | undefined);
    private _categoryid?;
    get categoryid(): number;
    set categoryid(value: number);
    resetCategoryid(): void;
    get categoryidInput(): number | undefined;
    private _categoryname?;
    get categoryname(): string;
    set categoryname(value: string);
    resetCategoryname(): void;
    get categorynameInput(): string | undefined;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _permissionid?;
    get permissionid(): number;
    set permissionid(value: number);
    resetPermissionid(): void;
    get permissionidInput(): number | undefined;
    private _permissionname?;
    get permissionname(): string;
    set permissionname(value: string);
    resetPermissionname(): void;
    get permissionnameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class CredentialAzurewithtenantidSecurityAssociationsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityAssociationsPermissionsOutputReference;
}
export interface CredentialAzurewithtenantidSecurityAssociationsUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#id CredentialAzurewithtenantid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAzurewithtenantidSecurityAssociationsUserToTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsUser | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityAssociationsUserToHclTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsUser | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityAssociationsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityAssociationsUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityAssociationsUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAzurewithtenantidSecurityAssociationsUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityAssociationsUserOutputReference;
}
export interface CredentialAzurewithtenantidSecurityAssociationsUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#id CredentialAzurewithtenantid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAzurewithtenantidSecurityAssociationsUsergroupToTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityAssociationsUsergroupToHclTerraform(struct?: CredentialAzurewithtenantidSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityAssociationsUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityAssociationsUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityAssociationsUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAzurewithtenantidSecurityAssociationsUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityAssociationsUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityAssociationsUsergroupOutputReference;
}
export interface CredentialAzurewithtenantidSecurityAssociations {
    /**
    * To check if the user/user group associated is the owner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#iscreatorassociation CredentialAzurewithtenantid#iscreatorassociation}
    */
    readonly iscreatorassociation?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#permissions CredentialAzurewithtenantid#permissions}
    */
    readonly permissions?: CredentialAzurewithtenantidSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#user CredentialAzurewithtenantid#user}
    */
    readonly user?: CredentialAzurewithtenantidSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#usergroup CredentialAzurewithtenantid#usergroup}
    */
    readonly usergroup?: CredentialAzurewithtenantidSecurityAssociationsUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAzurewithtenantidSecurityAssociationsToTerraform(struct?: CredentialAzurewithtenantidSecurityAssociations | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityAssociationsToHclTerraform(struct?: CredentialAzurewithtenantidSecurityAssociations | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityAssociations | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityAssociations | cdktf.IResolvable | undefined);
    private _iscreatorassociation?;
    get iscreatorassociation(): string;
    set iscreatorassociation(value: string);
    resetIscreatorassociation(): void;
    get iscreatorassociationInput(): string | undefined;
    private _permissions;
    get permissions(): CredentialAzurewithtenantidSecurityAssociationsPermissionsList;
    putPermissions(value: CredentialAzurewithtenantidSecurityAssociationsPermissions[] | cdktf.IResolvable): void;
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityAssociationsPermissions[] | undefined;
    private _user;
    get user(): CredentialAzurewithtenantidSecurityAssociationsUserList;
    putUser(value: CredentialAzurewithtenantidSecurityAssociationsUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityAssociationsUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAzurewithtenantidSecurityAssociationsUsergroupList;
    putUsergroup(value: CredentialAzurewithtenantidSecurityAssociationsUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityAssociationsUsergroup[] | undefined;
}
export declare class CredentialAzurewithtenantidSecurityAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityAssociations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityAssociationsOutputReference;
}
export interface CredentialAzurewithtenantidSecurityOwnerUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#id CredentialAzurewithtenantid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#name CredentialAzurewithtenantid#name}
    */
    readonly name?: string;
}
export declare function credentialAzurewithtenantidSecurityOwnerUserToTerraform(struct?: CredentialAzurewithtenantidSecurityOwnerUser | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityOwnerUserToHclTerraform(struct?: CredentialAzurewithtenantidSecurityOwnerUser | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityOwnerUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityOwnerUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityOwnerUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAzurewithtenantidSecurityOwnerUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityOwnerUserOutputReference;
}
export interface CredentialAzurewithtenantidSecurityOwnerUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#id CredentialAzurewithtenantid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#name CredentialAzurewithtenantid#name}
    */
    readonly name?: string;
}
export declare function credentialAzurewithtenantidSecurityOwnerUsergroupToTerraform(struct?: CredentialAzurewithtenantidSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityOwnerUsergroupToHclTerraform(struct?: CredentialAzurewithtenantidSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityOwnerUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityOwnerUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityOwnerUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAzurewithtenantidSecurityOwnerUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityOwnerUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityOwnerUsergroupOutputReference;
}
export interface CredentialAzurewithtenantidSecurityOwner {
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#user CredentialAzurewithtenantid#user}
    */
    readonly user?: CredentialAzurewithtenantidSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#usergroup CredentialAzurewithtenantid#usergroup}
    */
    readonly usergroup?: CredentialAzurewithtenantidSecurityOwnerUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAzurewithtenantidSecurityOwnerToTerraform(struct?: CredentialAzurewithtenantidSecurityOwner | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityOwnerToHclTerraform(struct?: CredentialAzurewithtenantidSecurityOwner | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurityOwner | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurityOwner | cdktf.IResolvable | undefined);
    private _user;
    get user(): CredentialAzurewithtenantidSecurityOwnerUserList;
    putUser(value: CredentialAzurewithtenantidSecurityOwnerUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityOwnerUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAzurewithtenantidSecurityOwnerUsergroupList;
    putUsergroup(value: CredentialAzurewithtenantidSecurityOwnerUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityOwnerUsergroup[] | undefined;
}
export declare class CredentialAzurewithtenantidSecurityOwnerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurityOwner[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityOwnerOutputReference;
}
export interface CredentialAzurewithtenantidSecurity {
    /**
    * associations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#associations CredentialAzurewithtenantid#associations}
    */
    readonly associations?: CredentialAzurewithtenantidSecurityAssociations[] | cdktf.IResolvable;
    /**
    * owner block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#owner CredentialAzurewithtenantid#owner}
    */
    readonly owner?: CredentialAzurewithtenantidSecurityOwner[] | cdktf.IResolvable;
}
export declare function credentialAzurewithtenantidSecurityToTerraform(struct?: CredentialAzurewithtenantidSecurity | cdktf.IResolvable): any;
export declare function credentialAzurewithtenantidSecurityToHclTerraform(struct?: CredentialAzurewithtenantidSecurity | cdktf.IResolvable): any;
export declare class CredentialAzurewithtenantidSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzurewithtenantidSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzurewithtenantidSecurity | cdktf.IResolvable | undefined);
    private _associations;
    get associations(): CredentialAzurewithtenantidSecurityAssociationsList;
    putAssociations(value: CredentialAzurewithtenantidSecurityAssociations[] | cdktf.IResolvable): void;
    resetAssociations(): void;
    get associationsInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityAssociations[] | undefined;
    private _owner;
    get owner(): CredentialAzurewithtenantidSecurityOwnerList;
    putOwner(value: CredentialAzurewithtenantidSecurityOwner[] | cdktf.IResolvable): void;
    resetOwner(): void;
    get ownerInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurityOwner[] | undefined;
}
export declare class CredentialAzurewithtenantidSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzurewithtenantidSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzurewithtenantidSecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid commvault_credential_azurewithtenantid}
*/
export declare class CredentialAzurewithtenantid extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_credential_azurewithtenantid";
    /**
    * Generates CDKTF code for importing a CredentialAzurewithtenantid resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialAzurewithtenantid to import
    * @param importFromId The id of the existing CredentialAzurewithtenantid that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialAzurewithtenantid to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azurewithtenantid commvault_credential_azurewithtenantid} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialAzurewithtenantidConfig
    */
    constructor(scope: Construct, id: string, config: CredentialAzurewithtenantidConfig);
    private _accounttype?;
    get accounttype(): string;
    set accounttype(value: string);
    resetAccounttype(): void;
    get accounttypeInput(): string | undefined;
    private _applicationid?;
    get applicationid(): string;
    set applicationid(value: string);
    get applicationidInput(): string | undefined;
    private _applicationsecret?;
    get applicationsecret(): string;
    set applicationsecret(value: string);
    get applicationsecretInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tenantid?;
    get tenantid(): string;
    set tenantid(value: string);
    get tenantidInput(): string | undefined;
    private _vendortype?;
    get vendortype(): string;
    set vendortype(value: string);
    resetVendortype(): void;
    get vendortypeInput(): string | undefined;
    private _endpoints;
    get endpoints(): CredentialAzurewithtenantidEndpointsList;
    putEndpoints(value: CredentialAzurewithtenantidEndpoints[] | cdktf.IResolvable): void;
    resetEndpoints(): void;
    get endpointsInput(): cdktf.IResolvable | CredentialAzurewithtenantidEndpoints[] | undefined;
    private _security;
    get security(): CredentialAzurewithtenantidSecurityList;
    putSecurity(value: CredentialAzurewithtenantidSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | CredentialAzurewithtenantidSecurity[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
