import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCommvaultKubernetesVolumesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes#clusterid DataCommvaultKubernetesVolumes#clusterid}
    */
    readonly clusterid: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes#id DataCommvaultKubernetesVolumes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes#name DataCommvaultKubernetesVolumes#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes#namespace DataCommvaultKubernetesVolumes#namespace}
    */
    readonly namespace: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes commvault_kubernetes_volumes}
*/
export declare class DataCommvaultKubernetesVolumes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "commvault_kubernetes_volumes";
    /**
    * Generates CDKTF code for importing a DataCommvaultKubernetesVolumes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataCommvaultKubernetesVolumes to import
    * @param importFromId The id of the existing DataCommvaultKubernetesVolumes that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataCommvaultKubernetesVolumes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/data-sources/kubernetes_volumes commvault_kubernetes_volumes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCommvaultKubernetesVolumesConfig
    */
    constructor(scope: Construct, id: string, config: DataCommvaultKubernetesVolumesConfig);
    private _clusterid?;
    get clusterid(): number;
    set clusterid(value: number);
    get clusteridInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
