import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HypervisorAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application id of Azure login Application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#applicationid HypervisorAzure#applicationid}
    */
    readonly applicationid?: string;
    /**
    * Application Password of Azure login Application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#applicationpassword HypervisorAzure#applicationpassword}
    */
    readonly applicationpassword?: string;
    /**
    * The name of the hypervisor that has to be changed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#displayname HypervisorAzure#displayname}
    */
    readonly displayname?: string;
    /**
    * [Azure_V2]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#hypervisortype HypervisorAzure#hypervisortype}
    */
    readonly hypervisortype?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the hypervisor group being created
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name: string;
    /**
    * Application Password of Azure login Application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#password HypervisorAzure#password}
    */
    readonly password?: string;
    /**
    * Client Name to Update
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#servername HypervisorAzure#servername}
    */
    readonly servername?: string;
    /**
    * if credential validation has to be skipped.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#skipcredentialvalidation HypervisorAzure#skipcredentialvalidation}
    */
    readonly skipcredentialvalidation?: string;
    /**
    * subscription id of Azure
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#subscriptionid HypervisorAzure#subscriptionid}
    */
    readonly subscriptionid: string;
    /**
    * Tenant id of Azure login Application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#tenantid HypervisorAzure#tenantid}
    */
    readonly tenantid: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#usemanagedidentity HypervisorAzure#usemanagedidentity}
    */
    readonly usemanagedidentity?: string;
    /**
    * Application id of Azure login Application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#username HypervisorAzure#username}
    */
    readonly username?: string;
    /**
    * accessnodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#accessnodes HypervisorAzure#accessnodes}
    */
    readonly accessnodes?: HypervisorAzureAccessnodes[] | cdktf.IResolvable;
    /**
    * activitycontrol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#activitycontrol HypervisorAzure#activitycontrol}
    */
    readonly activitycontrol?: HypervisorAzureActivitycontrol[] | cdktf.IResolvable;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#credentials HypervisorAzure#credentials}
    */
    readonly credentials?: HypervisorAzureCredentials[] | cdktf.IResolvable;
    /**
    * etcdprotection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#etcdprotection HypervisorAzure#etcdprotection}
    */
    readonly etcdprotection?: HypervisorAzureEtcdprotection[] | cdktf.IResolvable;
    /**
    * fbrunixmediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#fbrunixmediaagent HypervisorAzure#fbrunixmediaagent}
    */
    readonly fbrunixmediaagent?: HypervisorAzureFbrunixmediaagent[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#security HypervisorAzure#security}
    */
    readonly security?: HypervisorAzureSecurity[] | cdktf.IResolvable;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#settings HypervisorAzure#settings}
    */
    readonly settings?: HypervisorAzureSettings[] | cdktf.IResolvable;
    /**
    * workloadregion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#workloadregion HypervisorAzure#workloadregion}
    */
    readonly workloadregion?: HypervisorAzureWorkloadregion[] | cdktf.IResolvable;
}
export interface HypervisorAzureAccessnodes {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Type of access node , Ex: 3 - access Node , 28 - Access Node Groups
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#type HypervisorAzure#type}
    */
    readonly type?: number;
}
export declare function hypervisorAzureAccessnodesToTerraform(struct?: HypervisorAzureAccessnodes | cdktf.IResolvable): any;
export declare function hypervisorAzureAccessnodesToHclTerraform(struct?: HypervisorAzureAccessnodes | cdktf.IResolvable): any;
export declare class HypervisorAzureAccessnodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureAccessnodes | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureAccessnodes | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _type?;
    get type(): number;
    set type(value: number);
    resetType(): void;
    get typeInput(): number | undefined;
}
export declare class HypervisorAzureAccessnodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureAccessnodes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureAccessnodesOutputReference;
}
export interface HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#time HypervisorAzure#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#value HypervisorAzure#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#timezone HypervisorAzure#timezone}
    */
    readonly timezone?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeToTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeToHclTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference;
}
export interface HypervisorAzureActivitycontrolBackupactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#activitytype HypervisorAzure#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enableactivitytype HypervisorAzure#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enableafteradelay HypervisorAzure#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#delaytime HypervisorAzure#delaytime}
    */
    readonly delaytime?: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsToTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolBackupactivitycontroloptionsToHclTerraform(struct?: HypervisorAzureActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytimeList;
    putDelaytime(value: HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolBackupactivitycontroloptionsDelaytime[] | undefined;
}
export declare class HypervisorAzureActivitycontrolBackupactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolBackupactivitycontroloptionsOutputReference;
}
export interface HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#time HypervisorAzure#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#value HypervisorAzure#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#timezone HypervisorAzure#timezone}
    */
    readonly timezone?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeToTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeToHclTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference;
}
export interface HypervisorAzureActivitycontrolRestoreactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#activitytype HypervisorAzure#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enableactivitytype HypervisorAzure#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enableafteradelay HypervisorAzure#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#delaytime HypervisorAzure#delaytime}
    */
    readonly delaytime?: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsToTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolRestoreactivitycontroloptionsToHclTerraform(struct?: HypervisorAzureActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytimeList;
    putDelaytime(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolRestoreactivitycontroloptionsDelaytime[] | undefined;
}
export declare class HypervisorAzureActivitycontrolRestoreactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsOutputReference;
}
export interface HypervisorAzureActivitycontrol {
    /**
    * true if Backup is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enablebackup HypervisorAzure#enablebackup}
    */
    readonly enablebackup?: string;
    /**
    * true if Restore is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enablerestore HypervisorAzure#enablerestore}
    */
    readonly enablerestore?: string;
    /**
    * backupactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#backupactivitycontroloptions HypervisorAzure#backupactivitycontroloptions}
    */
    readonly backupactivitycontroloptions?: HypervisorAzureActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * restoreactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#restoreactivitycontroloptions HypervisorAzure#restoreactivitycontroloptions}
    */
    readonly restoreactivitycontroloptions?: HypervisorAzureActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
}
export declare function hypervisorAzureActivitycontrolToTerraform(struct?: HypervisorAzureActivitycontrol | cdktf.IResolvable): any;
export declare function hypervisorAzureActivitycontrolToHclTerraform(struct?: HypervisorAzureActivitycontrol | cdktf.IResolvable): any;
export declare class HypervisorAzureActivitycontrolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureActivitycontrol | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureActivitycontrol | cdktf.IResolvable | undefined);
    private _enablebackup?;
    get enablebackup(): string;
    set enablebackup(value: string);
    resetEnablebackup(): void;
    get enablebackupInput(): string | undefined;
    private _enablerestore?;
    get enablerestore(): string;
    set enablerestore(value: string);
    resetEnablerestore(): void;
    get enablerestoreInput(): string | undefined;
    private _backupactivitycontroloptions;
    get backupactivitycontroloptions(): HypervisorAzureActivitycontrolBackupactivitycontroloptionsList;
    putBackupactivitycontroloptions(value: HypervisorAzureActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable): void;
    resetBackupactivitycontroloptions(): void;
    get backupactivitycontroloptionsInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolBackupactivitycontroloptions[] | undefined;
    private _restoreactivitycontroloptions;
    get restoreactivitycontroloptions(): HypervisorAzureActivitycontrolRestoreactivitycontroloptionsList;
    putRestoreactivitycontroloptions(value: HypervisorAzureActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable): void;
    resetRestoreactivitycontroloptions(): void;
    get restoreactivitycontroloptionsInput(): cdktf.IResolvable | HypervisorAzureActivitycontrolRestoreactivitycontroloptions[] | undefined;
}
export declare class HypervisorAzureActivitycontrolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureActivitycontrol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureActivitycontrolOutputReference;
}
export interface HypervisorAzureCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureCredentialsToTerraform(struct?: HypervisorAzureCredentials | cdktf.IResolvable): any;
export declare function hypervisorAzureCredentialsToHclTerraform(struct?: HypervisorAzureCredentials | cdktf.IResolvable): any;
export declare class HypervisorAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureCredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureCredentialsOutputReference;
}
export interface HypervisorAzureEtcdprotectionPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureEtcdprotectionPlanToTerraform(struct?: HypervisorAzureEtcdprotectionPlan | cdktf.IResolvable): any;
export declare function hypervisorAzureEtcdprotectionPlanToHclTerraform(struct?: HypervisorAzureEtcdprotectionPlan | cdktf.IResolvable): any;
export declare class HypervisorAzureEtcdprotectionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureEtcdprotectionPlan | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureEtcdprotectionPlan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureEtcdprotectionPlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureEtcdprotectionPlan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureEtcdprotectionPlanOutputReference;
}
export interface HypervisorAzureEtcdprotection {
    /**
    * Denote if etcd protection is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#enabled HypervisorAzure#enabled}
    */
    readonly enabled?: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#plan HypervisorAzure#plan}
    */
    readonly plan?: HypervisorAzureEtcdprotectionPlan[] | cdktf.IResolvable;
}
export declare function hypervisorAzureEtcdprotectionToTerraform(struct?: HypervisorAzureEtcdprotection | cdktf.IResolvable): any;
export declare function hypervisorAzureEtcdprotectionToHclTerraform(struct?: HypervisorAzureEtcdprotection | cdktf.IResolvable): any;
export declare class HypervisorAzureEtcdprotectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureEtcdprotection | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureEtcdprotection | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _plan;
    get plan(): HypervisorAzureEtcdprotectionPlanList;
    putPlan(value: HypervisorAzureEtcdprotectionPlan[] | cdktf.IResolvable): void;
    resetPlan(): void;
    get planInput(): cdktf.IResolvable | HypervisorAzureEtcdprotectionPlan[] | undefined;
}
export declare class HypervisorAzureEtcdprotectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureEtcdprotection[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureEtcdprotectionOutputReference;
}
export interface HypervisorAzureFbrunixmediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureFbrunixmediaagentToTerraform(struct?: HypervisorAzureFbrunixmediaagent | cdktf.IResolvable): any;
export declare function hypervisorAzureFbrunixmediaagentToHclTerraform(struct?: HypervisorAzureFbrunixmediaagent | cdktf.IResolvable): any;
export declare class HypervisorAzureFbrunixmediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureFbrunixmediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureFbrunixmediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureFbrunixmediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureFbrunixmediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureFbrunixmediaagentOutputReference;
}
export interface HypervisorAzureSecurityAssociatedusergroups {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function hypervisorAzureSecurityAssociatedusergroupsToTerraform(struct?: HypervisorAzureSecurityAssociatedusergroups | cdktf.IResolvable): any;
export declare function hypervisorAzureSecurityAssociatedusergroupsToHclTerraform(struct?: HypervisorAzureSecurityAssociatedusergroups | cdktf.IResolvable): any;
export declare class HypervisorAzureSecurityAssociatedusergroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSecurityAssociatedusergroups | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSecurityAssociatedusergroups | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class HypervisorAzureSecurityAssociatedusergroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSecurityAssociatedusergroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSecurityAssociatedusergroupsOutputReference;
}
export interface HypervisorAzureSecurity {
    /**
    * Client owners for the Hypervisor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#clientowners HypervisorAzure#clientowners}
    */
    readonly clientowners?: string;
    /**
    * associatedusergroups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#associatedusergroups HypervisorAzure#associatedusergroups}
    */
    readonly associatedusergroups?: HypervisorAzureSecurityAssociatedusergroups[] | cdktf.IResolvable;
}
export declare function hypervisorAzureSecurityToTerraform(struct?: HypervisorAzureSecurity | cdktf.IResolvable): any;
export declare function hypervisorAzureSecurityToHclTerraform(struct?: HypervisorAzureSecurity | cdktf.IResolvable): any;
export declare class HypervisorAzureSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSecurity | cdktf.IResolvable | undefined);
    private _clientowners?;
    get clientowners(): string;
    set clientowners(value: string);
    resetClientowners(): void;
    get clientownersInput(): string | undefined;
    private _associatedusergroups;
    get associatedusergroups(): HypervisorAzureSecurityAssociatedusergroupsList;
    putAssociatedusergroups(value: HypervisorAzureSecurityAssociatedusergroups[] | cdktf.IResolvable): void;
    resetAssociatedusergroups(): void;
    get associatedusergroupsInput(): cdktf.IResolvable | HypervisorAzureSecurityAssociatedusergroups[] | undefined;
}
export declare class HypervisorAzureSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSecurityOutputReference;
}
export interface HypervisorAzureSettingsApplicationcredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#password HypervisorAzure#password}
    */
    readonly password?: string;
}
export declare function hypervisorAzureSettingsApplicationcredentialsToTerraform(struct?: HypervisorAzureSettingsApplicationcredentials | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsApplicationcredentialsToHclTerraform(struct?: HypervisorAzureSettingsApplicationcredentials | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsApplicationcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsApplicationcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsApplicationcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class HypervisorAzureSettingsApplicationcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsApplicationcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsApplicationcredentialsOutputReference;
}
export interface HypervisorAzureSettingsCustomattributes {
    /**
    * client custom attribute type . Ex- 3 - For client 8- For clientGroup
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#type HypervisorAzure#type}
    */
    readonly type?: number;
    /**
    * client/Client Group custom attribute value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#value HypervisorAzure#value}
    */
    readonly value?: string;
}
export declare function hypervisorAzureSettingsCustomattributesToTerraform(struct?: HypervisorAzureSettingsCustomattributes | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsCustomattributesToHclTerraform(struct?: HypervisorAzureSettingsCustomattributes | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsCustomattributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsCustomattributes | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsCustomattributes | cdktf.IResolvable | undefined);
    private _type?;
    get type(): number;
    set type(value: number);
    resetType(): void;
    get typeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class HypervisorAzureSettingsCustomattributesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsCustomattributes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsCustomattributesOutputReference;
}
export interface HypervisorAzureSettingsGuestcredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#password HypervisorAzure#password}
    */
    readonly password?: string;
}
export declare function hypervisorAzureSettingsGuestcredentialsToTerraform(struct?: HypervisorAzureSettingsGuestcredentials | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsGuestcredentialsToHclTerraform(struct?: HypervisorAzureSettingsGuestcredentials | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsGuestcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsGuestcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsGuestcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class HypervisorAzureSettingsGuestcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsGuestcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsGuestcredentialsOutputReference;
}
export interface HypervisorAzureSettingsMetricsmonitoringpolicy {
    /**
    * Metrics Moitoring PolicyId
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * True if Metrics Monioring policy is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#isenabled HypervisorAzure#isenabled}
    */
    readonly isenabled?: string;
    /**
    * Metrics Moitoring Policy Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureSettingsMetricsmonitoringpolicyToTerraform(struct?: HypervisorAzureSettingsMetricsmonitoringpolicy | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsMetricsmonitoringpolicyToHclTerraform(struct?: HypervisorAzureSettingsMetricsmonitoringpolicy | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsMetricsmonitoringpolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsMetricsmonitoringpolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsMetricsmonitoringpolicy | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _isenabled?;
    get isenabled(): string;
    set isenabled(value: string);
    resetIsenabled(): void;
    get isenabledInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureSettingsMetricsmonitoringpolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsMetricsmonitoringpolicyOutputReference;
}
export interface HypervisorAzureSettingsMountaccessnode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureSettingsMountaccessnodeToTerraform(struct?: HypervisorAzureSettingsMountaccessnode | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsMountaccessnodeToHclTerraform(struct?: HypervisorAzureSettingsMountaccessnode | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsMountaccessnodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsMountaccessnode | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsMountaccessnode | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureSettingsMountaccessnodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsMountaccessnode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsMountaccessnodeOutputReference;
}
export interface HypervisorAzureSettingsRegioninfo {
    /**
    * Display Name of Region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#displayname HypervisorAzure#displayname}
    */
    readonly displayname?: string;
    /**
    * Region Id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Geolocation Latitude
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#latitude HypervisorAzure#latitude}
    */
    readonly latitude?: string;
    /**
    * Geolocation Longitude
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#longitude HypervisorAzure#longitude}
    */
    readonly longitude?: string;
    /**
    * Region Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureSettingsRegioninfoToTerraform(struct?: HypervisorAzureSettingsRegioninfo | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsRegioninfoToHclTerraform(struct?: HypervisorAzureSettingsRegioninfo | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsRegioninfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsRegioninfo | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsRegioninfo | cdktf.IResolvable | undefined);
    private _displayname?;
    get displayname(): string;
    set displayname(value: string);
    resetDisplayname(): void;
    get displaynameInput(): string | undefined;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _latitude?;
    get latitude(): string;
    set latitude(value: string);
    resetLatitude(): void;
    get latitudeInput(): string | undefined;
    private _longitude?;
    get longitude(): string;
    set longitude(value: string);
    resetLongitude(): void;
    get longitudeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureSettingsRegioninfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsRegioninfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsRegioninfoOutputReference;
}
export interface HypervisorAzureSettingsTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureSettingsTimezoneToTerraform(struct?: HypervisorAzureSettingsTimezone | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsTimezoneToHclTerraform(struct?: HypervisorAzureSettingsTimezone | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettingsTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettingsTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureSettingsTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettingsTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsTimezoneOutputReference;
}
export interface HypervisorAzureSettings {
    /**
    * applicationcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#applicationcredentials HypervisorAzure#applicationcredentials}
    */
    readonly applicationcredentials?: HypervisorAzureSettingsApplicationcredentials[] | cdktf.IResolvable;
    /**
    * customattributes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#customattributes HypervisorAzure#customattributes}
    */
    readonly customattributes?: HypervisorAzureSettingsCustomattributes[] | cdktf.IResolvable;
    /**
    * guestcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#guestcredentials HypervisorAzure#guestcredentials}
    */
    readonly guestcredentials?: HypervisorAzureSettingsGuestcredentials[] | cdktf.IResolvable;
    /**
    * metricsmonitoringpolicy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#metricsmonitoringpolicy HypervisorAzure#metricsmonitoringpolicy}
    */
    readonly metricsmonitoringpolicy?: HypervisorAzureSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable;
    /**
    * mountaccessnode block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#mountaccessnode HypervisorAzure#mountaccessnode}
    */
    readonly mountaccessnode?: HypervisorAzureSettingsMountaccessnode[] | cdktf.IResolvable;
    /**
    * regioninfo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#regioninfo HypervisorAzure#regioninfo}
    */
    readonly regioninfo?: HypervisorAzureSettingsRegioninfo[] | cdktf.IResolvable;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#timezone HypervisorAzure#timezone}
    */
    readonly timezone?: HypervisorAzureSettingsTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAzureSettingsToTerraform(struct?: HypervisorAzureSettings | cdktf.IResolvable): any;
export declare function hypervisorAzureSettingsToHclTerraform(struct?: HypervisorAzureSettings | cdktf.IResolvable): any;
export declare class HypervisorAzureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureSettings | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureSettings | cdktf.IResolvable | undefined);
    private _applicationcredentials;
    get applicationcredentials(): HypervisorAzureSettingsApplicationcredentialsList;
    putApplicationcredentials(value: HypervisorAzureSettingsApplicationcredentials[] | cdktf.IResolvable): void;
    resetApplicationcredentials(): void;
    get applicationcredentialsInput(): cdktf.IResolvable | HypervisorAzureSettingsApplicationcredentials[] | undefined;
    private _customattributes;
    get customattributes(): HypervisorAzureSettingsCustomattributesList;
    putCustomattributes(value: HypervisorAzureSettingsCustomattributes[] | cdktf.IResolvable): void;
    resetCustomattributes(): void;
    get customattributesInput(): cdktf.IResolvable | HypervisorAzureSettingsCustomattributes[] | undefined;
    private _guestcredentials;
    get guestcredentials(): HypervisorAzureSettingsGuestcredentialsList;
    putGuestcredentials(value: HypervisorAzureSettingsGuestcredentials[] | cdktf.IResolvable): void;
    resetGuestcredentials(): void;
    get guestcredentialsInput(): cdktf.IResolvable | HypervisorAzureSettingsGuestcredentials[] | undefined;
    private _metricsmonitoringpolicy;
    get metricsmonitoringpolicy(): HypervisorAzureSettingsMetricsmonitoringpolicyList;
    putMetricsmonitoringpolicy(value: HypervisorAzureSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable): void;
    resetMetricsmonitoringpolicy(): void;
    get metricsmonitoringpolicyInput(): cdktf.IResolvable | HypervisorAzureSettingsMetricsmonitoringpolicy[] | undefined;
    private _mountaccessnode;
    get mountaccessnode(): HypervisorAzureSettingsMountaccessnodeList;
    putMountaccessnode(value: HypervisorAzureSettingsMountaccessnode[] | cdktf.IResolvable): void;
    resetMountaccessnode(): void;
    get mountaccessnodeInput(): cdktf.IResolvable | HypervisorAzureSettingsMountaccessnode[] | undefined;
    private _regioninfo;
    get regioninfo(): HypervisorAzureSettingsRegioninfoList;
    putRegioninfo(value: HypervisorAzureSettingsRegioninfo[] | cdktf.IResolvable): void;
    resetRegioninfo(): void;
    get regioninfoInput(): cdktf.IResolvable | HypervisorAzureSettingsRegioninfo[] | undefined;
    private _timezone;
    get timezone(): HypervisorAzureSettingsTimezoneList;
    putTimezone(value: HypervisorAzureSettingsTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAzureSettingsTimezone[] | undefined;
}
export declare class HypervisorAzureSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureSettingsOutputReference;
}
export interface HypervisorAzureWorkloadregion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#id HypervisorAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#name HypervisorAzure#name}
    */
    readonly name?: string;
}
export declare function hypervisorAzureWorkloadregionToTerraform(struct?: HypervisorAzureWorkloadregion | cdktf.IResolvable): any;
export declare function hypervisorAzureWorkloadregionToHclTerraform(struct?: HypervisorAzureWorkloadregion | cdktf.IResolvable): any;
export declare class HypervisorAzureWorkloadregionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAzureWorkloadregion | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAzureWorkloadregion | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAzureWorkloadregionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAzureWorkloadregion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAzureWorkloadregionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure commvault_hypervisor_azure}
*/
export declare class HypervisorAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_hypervisor_azure";
    /**
    * Generates CDKTF code for importing a HypervisorAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HypervisorAzure to import
    * @param importFromId The id of the existing HypervisorAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HypervisorAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_azure commvault_hypervisor_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HypervisorAzureConfig
    */
    constructor(scope: Construct, id: string, config: HypervisorAzureConfig);
    private _applicationid?;
    get applicationid(): string;
    set applicationid(value: string);
    resetApplicationid(): void;
    get applicationidInput(): string | undefined;
    private _applicationpassword?;
    get applicationpassword(): string;
    set applicationpassword(value: string);
    resetApplicationpassword(): void;
    get applicationpasswordInput(): string | undefined;
    private _displayname?;
    get displayname(): string;
    set displayname(value: string);
    resetDisplayname(): void;
    get displaynameInput(): string | undefined;
    private _hypervisortype?;
    get hypervisortype(): string;
    set hypervisortype(value: string);
    resetHypervisortype(): void;
    get hypervisortypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _servername?;
    get servername(): string;
    set servername(value: string);
    resetServername(): void;
    get servernameInput(): string | undefined;
    private _skipcredentialvalidation?;
    get skipcredentialvalidation(): string;
    set skipcredentialvalidation(value: string);
    resetSkipcredentialvalidation(): void;
    get skipcredentialvalidationInput(): string | undefined;
    private _subscriptionid?;
    get subscriptionid(): string;
    set subscriptionid(value: string);
    get subscriptionidInput(): string | undefined;
    private _tenantid?;
    get tenantid(): string;
    set tenantid(value: string);
    get tenantidInput(): string | undefined;
    private _usemanagedidentity?;
    get usemanagedidentity(): string;
    set usemanagedidentity(value: string);
    resetUsemanagedidentity(): void;
    get usemanagedidentityInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _accessnodes;
    get accessnodes(): HypervisorAzureAccessnodesList;
    putAccessnodes(value: HypervisorAzureAccessnodes[] | cdktf.IResolvable): void;
    resetAccessnodes(): void;
    get accessnodesInput(): cdktf.IResolvable | HypervisorAzureAccessnodes[] | undefined;
    private _activitycontrol;
    get activitycontrol(): HypervisorAzureActivitycontrolList;
    putActivitycontrol(value: HypervisorAzureActivitycontrol[] | cdktf.IResolvable): void;
    resetActivitycontrol(): void;
    get activitycontrolInput(): cdktf.IResolvable | HypervisorAzureActivitycontrol[] | undefined;
    private _credentials;
    get credentials(): HypervisorAzureCredentialsList;
    putCredentials(value: HypervisorAzureCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | HypervisorAzureCredentials[] | undefined;
    private _etcdprotection;
    get etcdprotection(): HypervisorAzureEtcdprotectionList;
    putEtcdprotection(value: HypervisorAzureEtcdprotection[] | cdktf.IResolvable): void;
    resetEtcdprotection(): void;
    get etcdprotectionInput(): cdktf.IResolvable | HypervisorAzureEtcdprotection[] | undefined;
    private _fbrunixmediaagent;
    get fbrunixmediaagent(): HypervisorAzureFbrunixmediaagentList;
    putFbrunixmediaagent(value: HypervisorAzureFbrunixmediaagent[] | cdktf.IResolvable): void;
    resetFbrunixmediaagent(): void;
    get fbrunixmediaagentInput(): cdktf.IResolvable | HypervisorAzureFbrunixmediaagent[] | undefined;
    private _security;
    get security(): HypervisorAzureSecurityList;
    putSecurity(value: HypervisorAzureSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | HypervisorAzureSecurity[] | undefined;
    private _settings;
    get settings(): HypervisorAzureSettingsList;
    putSettings(value: HypervisorAzureSettings[] | cdktf.IResolvable): void;
    resetSettings(): void;
    get settingsInput(): cdktf.IResolvable | HypervisorAzureSettings[] | undefined;
    private _workloadregion;
    get workloadregion(): HypervisorAzureWorkloadregionList;
    putWorkloadregion(value: HypervisorAzureWorkloadregion[] | cdktf.IResolvable): void;
    resetWorkloadregion(): void;
    get workloadregionInput(): cdktf.IResolvable | HypervisorAzureWorkloadregion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
