import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InstallMaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the company id to which the installed MA should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#company_id InstallMa#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies the Media Agent Hostname user for the installation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#hostname InstallMa#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#id InstallMa#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether OS is Unix or not
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#is_unix InstallMa#is_unix}
    */
    readonly isUnix?: boolean | cdktf.IResolvable;
    /**
    * Specifies the Media Agent name used for installation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#mediaagent_name InstallMa#mediaagent_name}
    */
    readonly mediaagentName: string;
    /**
    * Specifies the password for the host computer for the installation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#password InstallMa#password}
    */
    readonly password: string;
    /**
    * Specifies the User name of the host computer for the installation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#user_name InstallMa#user_name}
    */
    readonly userName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma commvault_install_ma}
*/
export declare class InstallMa extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_install_ma";
    /**
    * Generates CDKTF code for importing a InstallMa resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the InstallMa to import
    * @param importFromId The id of the existing InstallMa that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the InstallMa to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/install_ma commvault_install_ma} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InstallMaConfig
    */
    constructor(scope: Construct, id: string, config: InstallMaConfig);
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isUnix?;
    get isUnix(): boolean | cdktf.IResolvable;
    set isUnix(value: boolean | cdktf.IResolvable);
    resetIsUnix(): void;
    get isUnixInput(): boolean | cdktf.IResolvable | undefined;
    private _mediaagentName?;
    get mediaagentName(): string;
    set mediaagentName(value: string);
    get mediaagentNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
