import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PlanServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag to enable overriding of plan. Plan cannot be overriden by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#allowplanoverride PlanServer#allowplanoverride}
    */
    readonly allowplanoverride?: string;
    /**
    * Primary Backup Destination Ids (which were created before plan creation). This is only considered when backupDestinations array object is not defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupdestinationids PlanServer#backupdestinationids}
    */
    readonly backupdestinationids?: number[];
    /**
    * flag to enable backup content association for applicable file system workload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#filesystemaddon PlanServer#filesystemaddon}
    */
    readonly filesystemaddon?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the new plan
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#planname PlanServer#planname}
    */
    readonly planname: string;
    /**
    * backupcontent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupcontent PlanServer#backupcontent}
    */
    readonly backupcontent?: PlanServerBackupcontent[] | cdktf.IResolvable;
    /**
    * backupdestinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupdestinations PlanServer#backupdestinations}
    */
    readonly backupdestinations?: PlanServerBackupdestinations[] | cdktf.IResolvable;
    /**
    * databaseoptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#databaseoptions PlanServer#databaseoptions}
    */
    readonly databaseoptions?: PlanServerDatabaseoptions[] | cdktf.IResolvable;
    /**
    * overrideinheritsettings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#overrideinheritsettings PlanServer#overrideinheritsettings}
    */
    readonly overrideinheritsettings?: PlanServerOverrideinheritsettings[] | cdktf.IResolvable;
    /**
    * overriderestrictions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#overriderestrictions PlanServer#overriderestrictions}
    */
    readonly overriderestrictions?: PlanServerOverriderestrictions[] | cdktf.IResolvable;
    /**
    * parentplan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#parentplan PlanServer#parentplan}
    */
    readonly parentplan?: PlanServerParentplan[] | cdktf.IResolvable;
    /**
    * regiontoconfigure block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#regiontoconfigure PlanServer#regiontoconfigure}
    */
    readonly regiontoconfigure?: PlanServerRegiontoconfigure[] | cdktf.IResolvable;
    /**
    * rpo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#rpo PlanServer#rpo}
    */
    readonly rpo?: PlanServerRpo[] | cdktf.IResolvable;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#settings PlanServer#settings}
    */
    readonly settings?: PlanServerSettings[] | cdktf.IResolvable;
    /**
    * snapshotoptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#snapshotoptions PlanServer#snapshotoptions}
    */
    readonly snapshotoptions?: PlanServerSnapshotoptions[] | cdktf.IResolvable;
    /**
    * workload block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#workload PlanServer#workload}
    */
    readonly workload?: PlanServerWorkload[] | cdktf.IResolvable;
}
export interface PlanServerBackupcontentMacnumberofdatareaders {
    /**
    * Number of data readers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#count PlanServer#count}
    */
    readonly count?: number;
    /**
    * Set optimal number of data readers. if it is set to true, count will be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#useoptimal PlanServer#useoptimal}
    */
    readonly useoptimal?: string;
}
export declare function planServerBackupcontentMacnumberofdatareadersToTerraform(struct?: PlanServerBackupcontentMacnumberofdatareaders | cdktf.IResolvable): any;
export declare function planServerBackupcontentMacnumberofdatareadersToHclTerraform(struct?: PlanServerBackupcontentMacnumberofdatareaders | cdktf.IResolvable): any;
export declare class PlanServerBackupcontentMacnumberofdatareadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupcontentMacnumberofdatareaders | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupcontentMacnumberofdatareaders | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _useoptimal?;
    get useoptimal(): string;
    set useoptimal(value: string);
    resetUseoptimal(): void;
    get useoptimalInput(): string | undefined;
}
export declare class PlanServerBackupcontentMacnumberofdatareadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupcontentMacnumberofdatareaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupcontentMacnumberofdatareadersOutputReference;
}
export interface PlanServerBackupcontentUnixnumberofdatareaders {
    /**
    * Number of data readers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#count PlanServer#count}
    */
    readonly count?: number;
    /**
    * Set optimal number of data readers. if it is set to true, count will be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#useoptimal PlanServer#useoptimal}
    */
    readonly useoptimal?: string;
}
export declare function planServerBackupcontentUnixnumberofdatareadersToTerraform(struct?: PlanServerBackupcontentUnixnumberofdatareaders | cdktf.IResolvable): any;
export declare function planServerBackupcontentUnixnumberofdatareadersToHclTerraform(struct?: PlanServerBackupcontentUnixnumberofdatareaders | cdktf.IResolvable): any;
export declare class PlanServerBackupcontentUnixnumberofdatareadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupcontentUnixnumberofdatareaders | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupcontentUnixnumberofdatareaders | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _useoptimal?;
    get useoptimal(): string;
    set useoptimal(value: string);
    resetUseoptimal(): void;
    get useoptimalInput(): string | undefined;
}
export declare class PlanServerBackupcontentUnixnumberofdatareadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupcontentUnixnumberofdatareaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupcontentUnixnumberofdatareadersOutputReference;
}
export interface PlanServerBackupcontentWindowsnumberofdatareaders {
    /**
    * Number of data readers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#count PlanServer#count}
    */
    readonly count?: number;
    /**
    * Set optimal number of data readers. if it is set to true, count will be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#useoptimal PlanServer#useoptimal}
    */
    readonly useoptimal?: string;
}
export declare function planServerBackupcontentWindowsnumberofdatareadersToTerraform(struct?: PlanServerBackupcontentWindowsnumberofdatareaders | cdktf.IResolvable): any;
export declare function planServerBackupcontentWindowsnumberofdatareadersToHclTerraform(struct?: PlanServerBackupcontentWindowsnumberofdatareaders | cdktf.IResolvable): any;
export declare class PlanServerBackupcontentWindowsnumberofdatareadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupcontentWindowsnumberofdatareaders | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupcontentWindowsnumberofdatareaders | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _useoptimal?;
    get useoptimal(): string;
    set useoptimal(value: string);
    resetUseoptimal(): void;
    get useoptimalInput(): string | undefined;
}
export declare class PlanServerBackupcontentWindowsnumberofdatareadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupcontentWindowsnumberofdatareaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupcontentWindowsnumberofdatareadersOutputReference;
}
export interface PlanServerBackupcontent {
    /**
    * Do you want to back up the system state? Applicable only for Windows
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupsystemstate PlanServer#backupsystemstate}
    */
    readonly backupsystemstate?: string;
    /**
    * Do you want to back up system state only with full backup? Applicable only if the value of backupSystemState is true
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupsystemstateonlywithfullbackup PlanServer#backupsystemstateonlywithfullbackup}
    */
    readonly backupsystemstateonlywithfullbackup?: string;
    /**
    * Do you want to sync properties on associated subclients even if properties are overriden at subclient level?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#forceupdateproperties PlanServer#forceupdateproperties}
    */
    readonly forceupdateproperties?: string;
    /**
    * Paths to exclude for Mac
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#macexcludedpaths PlanServer#macexcludedpaths}
    */
    readonly macexcludedpaths?: string[];
    /**
    * Paths that are exception to excluded paths for Mac
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#macfiltertoexcludepaths PlanServer#macfiltertoexcludepaths}
    */
    readonly macfiltertoexcludepaths?: string[];
    /**
    * Paths to include for Mac
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#macincludedpaths PlanServer#macincludedpaths}
    */
    readonly macincludedpaths?: string[];
    /**
    * Paths to exclude for UNIX
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#unixexcludedpaths PlanServer#unixexcludedpaths}
    */
    readonly unixexcludedpaths?: string[];
    /**
    * Paths that are exception to excluded paths for Unix
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#unixfiltertoexcludepaths PlanServer#unixfiltertoexcludepaths}
    */
    readonly unixfiltertoexcludepaths?: string[];
    /**
    * Paths to include for UNIX
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#unixincludedpaths PlanServer#unixincludedpaths}
    */
    readonly unixincludedpaths?: string[];
    /**
    * Do you want to back up system state with VSS? Applicable only if the value of backupSystemState is true
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#usevssforsystemstate PlanServer#usevssforsystemstate}
    */
    readonly usevssforsystemstate?: string;
    /**
    * Paths to exclude for Windows
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#windowsexcludedpaths PlanServer#windowsexcludedpaths}
    */
    readonly windowsexcludedpaths?: string[];
    /**
    * Paths that are exception to excluded paths for Windows
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#windowsfiltertoexcludepaths PlanServer#windowsfiltertoexcludepaths}
    */
    readonly windowsfiltertoexcludepaths?: string[];
    /**
    * Paths to include for Windows
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#windowsincludedpaths PlanServer#windowsincludedpaths}
    */
    readonly windowsincludedpaths?: string[];
    /**
    * macnumberofdatareaders block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#macnumberofdatareaders PlanServer#macnumberofdatareaders}
    */
    readonly macnumberofdatareaders?: PlanServerBackupcontentMacnumberofdatareaders[] | cdktf.IResolvable;
    /**
    * unixnumberofdatareaders block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#unixnumberofdatareaders PlanServer#unixnumberofdatareaders}
    */
    readonly unixnumberofdatareaders?: PlanServerBackupcontentUnixnumberofdatareaders[] | cdktf.IResolvable;
    /**
    * windowsnumberofdatareaders block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#windowsnumberofdatareaders PlanServer#windowsnumberofdatareaders}
    */
    readonly windowsnumberofdatareaders?: PlanServerBackupcontentWindowsnumberofdatareaders[] | cdktf.IResolvable;
}
export declare function planServerBackupcontentToTerraform(struct?: PlanServerBackupcontent | cdktf.IResolvable): any;
export declare function planServerBackupcontentToHclTerraform(struct?: PlanServerBackupcontent | cdktf.IResolvable): any;
export declare class PlanServerBackupcontentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupcontent | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupcontent | cdktf.IResolvable | undefined);
    private _backupsystemstate?;
    get backupsystemstate(): string;
    set backupsystemstate(value: string);
    resetBackupsystemstate(): void;
    get backupsystemstateInput(): string | undefined;
    private _backupsystemstateonlywithfullbackup?;
    get backupsystemstateonlywithfullbackup(): string;
    set backupsystemstateonlywithfullbackup(value: string);
    resetBackupsystemstateonlywithfullbackup(): void;
    get backupsystemstateonlywithfullbackupInput(): string | undefined;
    private _forceupdateproperties?;
    get forceupdateproperties(): string;
    set forceupdateproperties(value: string);
    resetForceupdateproperties(): void;
    get forceupdatepropertiesInput(): string | undefined;
    private _macexcludedpaths?;
    get macexcludedpaths(): string[];
    set macexcludedpaths(value: string[]);
    resetMacexcludedpaths(): void;
    get macexcludedpathsInput(): string[] | undefined;
    private _macfiltertoexcludepaths?;
    get macfiltertoexcludepaths(): string[];
    set macfiltertoexcludepaths(value: string[]);
    resetMacfiltertoexcludepaths(): void;
    get macfiltertoexcludepathsInput(): string[] | undefined;
    private _macincludedpaths?;
    get macincludedpaths(): string[];
    set macincludedpaths(value: string[]);
    resetMacincludedpaths(): void;
    get macincludedpathsInput(): string[] | undefined;
    private _unixexcludedpaths?;
    get unixexcludedpaths(): string[];
    set unixexcludedpaths(value: string[]);
    resetUnixexcludedpaths(): void;
    get unixexcludedpathsInput(): string[] | undefined;
    private _unixfiltertoexcludepaths?;
    get unixfiltertoexcludepaths(): string[];
    set unixfiltertoexcludepaths(value: string[]);
    resetUnixfiltertoexcludepaths(): void;
    get unixfiltertoexcludepathsInput(): string[] | undefined;
    private _unixincludedpaths?;
    get unixincludedpaths(): string[];
    set unixincludedpaths(value: string[]);
    resetUnixincludedpaths(): void;
    get unixincludedpathsInput(): string[] | undefined;
    private _usevssforsystemstate?;
    get usevssforsystemstate(): string;
    set usevssforsystemstate(value: string);
    resetUsevssforsystemstate(): void;
    get usevssforsystemstateInput(): string | undefined;
    private _windowsexcludedpaths?;
    get windowsexcludedpaths(): string[];
    set windowsexcludedpaths(value: string[]);
    resetWindowsexcludedpaths(): void;
    get windowsexcludedpathsInput(): string[] | undefined;
    private _windowsfiltertoexcludepaths?;
    get windowsfiltertoexcludepaths(): string[];
    set windowsfiltertoexcludepaths(value: string[]);
    resetWindowsfiltertoexcludepaths(): void;
    get windowsfiltertoexcludepathsInput(): string[] | undefined;
    private _windowsincludedpaths?;
    get windowsincludedpaths(): string[];
    set windowsincludedpaths(value: string[]);
    resetWindowsincludedpaths(): void;
    get windowsincludedpathsInput(): string[] | undefined;
    private _macnumberofdatareaders;
    get macnumberofdatareaders(): PlanServerBackupcontentMacnumberofdatareadersList;
    putMacnumberofdatareaders(value: PlanServerBackupcontentMacnumberofdatareaders[] | cdktf.IResolvable): void;
    resetMacnumberofdatareaders(): void;
    get macnumberofdatareadersInput(): cdktf.IResolvable | PlanServerBackupcontentMacnumberofdatareaders[] | undefined;
    private _unixnumberofdatareaders;
    get unixnumberofdatareaders(): PlanServerBackupcontentUnixnumberofdatareadersList;
    putUnixnumberofdatareaders(value: PlanServerBackupcontentUnixnumberofdatareaders[] | cdktf.IResolvable): void;
    resetUnixnumberofdatareaders(): void;
    get unixnumberofdatareadersInput(): cdktf.IResolvable | PlanServerBackupcontentUnixnumberofdatareaders[] | undefined;
    private _windowsnumberofdatareaders;
    get windowsnumberofdatareaders(): PlanServerBackupcontentWindowsnumberofdatareadersList;
    putWindowsnumberofdatareaders(value: PlanServerBackupcontentWindowsnumberofdatareaders[] | cdktf.IResolvable): void;
    resetWindowsnumberofdatareaders(): void;
    get windowsnumberofdatareadersInput(): cdktf.IResolvable | PlanServerBackupcontentWindowsnumberofdatareaders[] | undefined;
}
export declare class PlanServerBackupcontentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupcontent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupcontentOutputReference;
}
export interface PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#isinfiniteretention PlanServer#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#retentionperioddays PlanServer#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#type PlanServer#type}
    */
    readonly type?: string;
}
export declare function planServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleToTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleToHclTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleOutputReference;
}
export interface PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#isinfiniteretention PlanServer#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#retentionperioddays PlanServer#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#type PlanServer#type}
    */
    readonly type?: string;
}
export declare function planServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleToTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleToHclTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleOutputReference;
}
export interface PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#isinfiniteretention PlanServer#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#retentionperioddays PlanServer#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#type PlanServer#type}
    */
    readonly type?: string;
}
export declare function planServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleToTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleToHclTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleOutputReference;
}
export interface PlanServerBackupdestinationsExtendedretentionrules {
    /**
    * firstextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#firstextendedretentionrule PlanServer#firstextendedretentionrule}
    */
    readonly firstextendedretentionrule?: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable;
    /**
    * secondextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#secondextendedretentionrule PlanServer#secondextendedretentionrule}
    */
    readonly secondextendedretentionrule?: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable;
    /**
    * thirdextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#thirdextendedretentionrule PlanServer#thirdextendedretentionrule}
    */
    readonly thirdextendedretentionrule?: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable;
}
export declare function planServerBackupdestinationsExtendedretentionrulesToTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrules | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsExtendedretentionrulesToHclTerraform(struct?: PlanServerBackupdestinationsExtendedretentionrules | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsExtendedretentionrulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsExtendedretentionrules | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsExtendedretentionrules | cdktf.IResolvable | undefined);
    private _firstextendedretentionrule;
    get firstextendedretentionrule(): PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionruleList;
    putFirstextendedretentionrule(value: PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable): void;
    resetFirstextendedretentionrule(): void;
    get firstextendedretentionruleInput(): cdktf.IResolvable | PlanServerBackupdestinationsExtendedretentionrulesFirstextendedretentionrule[] | undefined;
    private _secondextendedretentionrule;
    get secondextendedretentionrule(): PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionruleList;
    putSecondextendedretentionrule(value: PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable): void;
    resetSecondextendedretentionrule(): void;
    get secondextendedretentionruleInput(): cdktf.IResolvable | PlanServerBackupdestinationsExtendedretentionrulesSecondextendedretentionrule[] | undefined;
    private _thirdextendedretentionrule;
    get thirdextendedretentionrule(): PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionruleList;
    putThirdextendedretentionrule(value: PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable): void;
    resetThirdextendedretentionrule(): void;
    get thirdextendedretentionruleInput(): cdktf.IResolvable | PlanServerBackupdestinationsExtendedretentionrulesThirdextendedretentionrule[] | undefined;
}
export declare class PlanServerBackupdestinationsExtendedretentionrulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsExtendedretentionrules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsExtendedretentionrulesOutputReference;
}
export interface PlanServerBackupdestinationsMappingsSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsMappingsSourceToTerraform(struct?: PlanServerBackupdestinationsMappingsSource | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsMappingsSourceToHclTerraform(struct?: PlanServerBackupdestinationsMappingsSource | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsMappingsSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsMappingsSource | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsMappingsSource | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsMappingsSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsMappingsSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsMappingsSourceOutputReference;
}
export interface PlanServerBackupdestinationsMappingsSourcevendor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsMappingsSourcevendorToTerraform(struct?: PlanServerBackupdestinationsMappingsSourcevendor | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsMappingsSourcevendorToHclTerraform(struct?: PlanServerBackupdestinationsMappingsSourcevendor | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsMappingsSourcevendorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsMappingsSourcevendor | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsMappingsSourcevendor | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsMappingsSourcevendorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsMappingsSourcevendor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsMappingsSourcevendorOutputReference;
}
export interface PlanServerBackupdestinationsMappingsTarget {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsMappingsTargetToTerraform(struct?: PlanServerBackupdestinationsMappingsTarget | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsMappingsTargetToHclTerraform(struct?: PlanServerBackupdestinationsMappingsTarget | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsMappingsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsMappingsTarget | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsMappingsTarget | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsMappingsTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsMappingsTarget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsMappingsTargetOutputReference;
}
export interface PlanServerBackupdestinationsMappingsTargetvendor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsMappingsTargetvendorToTerraform(struct?: PlanServerBackupdestinationsMappingsTargetvendor | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsMappingsTargetvendorToHclTerraform(struct?: PlanServerBackupdestinationsMappingsTargetvendor | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsMappingsTargetvendorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsMappingsTargetvendor | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsMappingsTargetvendor | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsMappingsTargetvendorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsMappingsTargetvendor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsMappingsTargetvendorOutputReference;
}
export interface PlanServerBackupdestinationsMappings {
    /**
    * Snapshot vendors available for Snap Copy mappings [NETAPP, AMAZON, PURE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#vendor PlanServer#vendor}
    */
    readonly vendor?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#source PlanServer#source}
    */
    readonly source?: PlanServerBackupdestinationsMappingsSource[] | cdktf.IResolvable;
    /**
    * sourcevendor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#sourcevendor PlanServer#sourcevendor}
    */
    readonly sourcevendor?: PlanServerBackupdestinationsMappingsSourcevendor[] | cdktf.IResolvable;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#target PlanServer#target}
    */
    readonly target?: PlanServerBackupdestinationsMappingsTarget[] | cdktf.IResolvable;
    /**
    * targetvendor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#targetvendor PlanServer#targetvendor}
    */
    readonly targetvendor?: PlanServerBackupdestinationsMappingsTargetvendor[] | cdktf.IResolvable;
}
export declare function planServerBackupdestinationsMappingsToTerraform(struct?: PlanServerBackupdestinationsMappings | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsMappingsToHclTerraform(struct?: PlanServerBackupdestinationsMappings | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsMappings | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsMappings | cdktf.IResolvable | undefined);
    private _vendor?;
    get vendor(): string;
    set vendor(value: string);
    resetVendor(): void;
    get vendorInput(): string | undefined;
    private _source;
    get source(): PlanServerBackupdestinationsMappingsSourceList;
    putSource(value: PlanServerBackupdestinationsMappingsSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | PlanServerBackupdestinationsMappingsSource[] | undefined;
    private _sourcevendor;
    get sourcevendor(): PlanServerBackupdestinationsMappingsSourcevendorList;
    putSourcevendor(value: PlanServerBackupdestinationsMappingsSourcevendor[] | cdktf.IResolvable): void;
    resetSourcevendor(): void;
    get sourcevendorInput(): cdktf.IResolvable | PlanServerBackupdestinationsMappingsSourcevendor[] | undefined;
    private _target;
    get target(): PlanServerBackupdestinationsMappingsTargetList;
    putTarget(value: PlanServerBackupdestinationsMappingsTarget[] | cdktf.IResolvable): void;
    resetTarget(): void;
    get targetInput(): cdktf.IResolvable | PlanServerBackupdestinationsMappingsTarget[] | undefined;
    private _targetvendor;
    get targetvendor(): PlanServerBackupdestinationsMappingsTargetvendorList;
    putTargetvendor(value: PlanServerBackupdestinationsMappingsTargetvendor[] | cdktf.IResolvable): void;
    resetTargetvendor(): void;
    get targetvendorInput(): cdktf.IResolvable | PlanServerBackupdestinationsMappingsTargetvendor[] | undefined;
}
export declare class PlanServerBackupdestinationsMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsMappingsOutputReference;
}
export interface PlanServerBackupdestinationsRegion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsRegionToTerraform(struct?: PlanServerBackupdestinationsRegion | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsRegionToHclTerraform(struct?: PlanServerBackupdestinationsRegion | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsRegion | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsRegion | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsRegion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsRegionOutputReference;
}
export interface PlanServerBackupdestinationsSourcecopy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsSourcecopyToTerraform(struct?: PlanServerBackupdestinationsSourcecopy | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsSourcecopyToHclTerraform(struct?: PlanServerBackupdestinationsSourcecopy | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsSourcecopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsSourcecopy | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsSourcecopy | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsSourcecopyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsSourcecopy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsSourcecopyOutputReference;
}
export interface PlanServerBackupdestinationsStoragepool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerBackupdestinationsStoragepoolToTerraform(struct?: PlanServerBackupdestinationsStoragepool | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsStoragepoolToHclTerraform(struct?: PlanServerBackupdestinationsStoragepool | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsStoragepoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinationsStoragepool | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinationsStoragepool | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerBackupdestinationsStoragepoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinationsStoragepool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsStoragepoolOutputReference;
}
export interface PlanServerBackupdestinations {
    /**
    * Backup destination details. Enter the name during creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupdestinationname PlanServer#backupdestinationname}
    */
    readonly backupdestinationname?: string;
    /**
    * Backup start time in seconds. The time is provided in unix time format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupstarttime PlanServer#backupstarttime}
    */
    readonly backupstarttime?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupstocopy PlanServer#backupstocopy}
    */
    readonly backupstocopy?: string;
    /**
    * Which type of backup type should be copied for the given backup destination when backup type is not all jobs. Default is LAST while adding new backup destination. [FIRST, LAST]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#fullbackuptypestocopy PlanServer#fullbackuptypestocopy}
    */
    readonly fullbackuptypestocopy?: string;
    /**
    * Is this a mirror copy? Only considered when isSnapCopy is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#ismirrorcopy PlanServer#ismirrorcopy}
    */
    readonly ismirrorcopy?: string;
    /**
    * Is this a snap copy? If isMirrorCopy is not set, then default is Vault/Replica.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#issnapcopy PlanServer#issnapcopy}
    */
    readonly issnapcopy?: string;
    /**
    * Only for snap copy. Enabling this changes SVM Mapping  to NetApp cloud targets only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#netappcloudtarget PlanServer#netappcloudtarget}
    */
    readonly netappcloudtarget?: string;
    /**
    * Flag to specify if primary storage is copy data management enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#optimizeforinstantclone PlanServer#optimizeforinstantclone}
    */
    readonly optimizeforinstantclone?: string;
    /**
    * Tells if this copy should use storage pool retention period days or the retention defined for this copy. Set as true to use retention defined on this copy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#overrideretentionsettings PlanServer#overrideretentionsettings}
    */
    readonly overrideretentionsettings?: string;
    /**
    * Retention period in days. -1 can be specified for infinite retention. If this and snapRecoveryPoints both are not specified, this takes  precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#retentionperioddays PlanServer#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * Which type of retention rule should be used for the given backup destination [RETENTION_PERIOD, SNAP_RECOVERY_POINTS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#retentionruletype PlanServer#retentionruletype}
    */
    readonly retentionruletype?: string;
    /**
    * Number of snap recovery points for snap copy for retention. Can be specified instead of retention period in Days for snap copy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#snaprecoverypoints PlanServer#snaprecoverypoints}
    */
    readonly snaprecoverypoints?: number;
    /**
    * [ALL, DISK, CLOUD, HYPERSCALE, TAPE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#storagetype PlanServer#storagetype}
    */
    readonly storagetype?: string;
    /**
    * Use extended retention rules
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#useextendedretentionrules PlanServer#useextendedretentionrules}
    */
    readonly useextendedretentionrules?: string;
    /**
    * extendedretentionrules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#extendedretentionrules PlanServer#extendedretentionrules}
    */
    readonly extendedretentionrules?: PlanServerBackupdestinationsExtendedretentionrules[] | cdktf.IResolvable;
    /**
    * mappings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#mappings PlanServer#mappings}
    */
    readonly mappings?: PlanServerBackupdestinationsMappings[] | cdktf.IResolvable;
    /**
    * region block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#region PlanServer#region}
    */
    readonly region?: PlanServerBackupdestinationsRegion[] | cdktf.IResolvable;
    /**
    * sourcecopy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#sourcecopy PlanServer#sourcecopy}
    */
    readonly sourcecopy?: PlanServerBackupdestinationsSourcecopy[] | cdktf.IResolvable;
    /**
    * storagepool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#storagepool PlanServer#storagepool}
    */
    readonly storagepool: PlanServerBackupdestinationsStoragepool[] | cdktf.IResolvable;
}
export declare function planServerBackupdestinationsToTerraform(struct?: PlanServerBackupdestinations | cdktf.IResolvable): any;
export declare function planServerBackupdestinationsToHclTerraform(struct?: PlanServerBackupdestinations | cdktf.IResolvable): any;
export declare class PlanServerBackupdestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerBackupdestinations | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerBackupdestinations | cdktf.IResolvable | undefined);
    private _backupdestinationname?;
    get backupdestinationname(): string;
    set backupdestinationname(value: string);
    resetBackupdestinationname(): void;
    get backupdestinationnameInput(): string | undefined;
    private _backupstarttime?;
    get backupstarttime(): number;
    set backupstarttime(value: number);
    resetBackupstarttime(): void;
    get backupstarttimeInput(): number | undefined;
    private _backupstocopy?;
    get backupstocopy(): string;
    set backupstocopy(value: string);
    resetBackupstocopy(): void;
    get backupstocopyInput(): string | undefined;
    private _fullbackuptypestocopy?;
    get fullbackuptypestocopy(): string;
    set fullbackuptypestocopy(value: string);
    resetFullbackuptypestocopy(): void;
    get fullbackuptypestocopyInput(): string | undefined;
    private _ismirrorcopy?;
    get ismirrorcopy(): string;
    set ismirrorcopy(value: string);
    resetIsmirrorcopy(): void;
    get ismirrorcopyInput(): string | undefined;
    private _issnapcopy?;
    get issnapcopy(): string;
    set issnapcopy(value: string);
    resetIssnapcopy(): void;
    get issnapcopyInput(): string | undefined;
    private _netappcloudtarget?;
    get netappcloudtarget(): string;
    set netappcloudtarget(value: string);
    resetNetappcloudtarget(): void;
    get netappcloudtargetInput(): string | undefined;
    private _optimizeforinstantclone?;
    get optimizeforinstantclone(): string;
    set optimizeforinstantclone(value: string);
    resetOptimizeforinstantclone(): void;
    get optimizeforinstantcloneInput(): string | undefined;
    private _overrideretentionsettings?;
    get overrideretentionsettings(): string;
    set overrideretentionsettings(value: string);
    resetOverrideretentionsettings(): void;
    get overrideretentionsettingsInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _retentionruletype?;
    get retentionruletype(): string;
    set retentionruletype(value: string);
    resetRetentionruletype(): void;
    get retentionruletypeInput(): string | undefined;
    private _snaprecoverypoints?;
    get snaprecoverypoints(): number;
    set snaprecoverypoints(value: number);
    resetSnaprecoverypoints(): void;
    get snaprecoverypointsInput(): number | undefined;
    private _storagetype?;
    get storagetype(): string;
    set storagetype(value: string);
    resetStoragetype(): void;
    get storagetypeInput(): string | undefined;
    private _useextendedretentionrules?;
    get useextendedretentionrules(): string;
    set useextendedretentionrules(value: string);
    resetUseextendedretentionrules(): void;
    get useextendedretentionrulesInput(): string | undefined;
    private _extendedretentionrules;
    get extendedretentionrules(): PlanServerBackupdestinationsExtendedretentionrulesList;
    putExtendedretentionrules(value: PlanServerBackupdestinationsExtendedretentionrules[] | cdktf.IResolvable): void;
    resetExtendedretentionrules(): void;
    get extendedretentionrulesInput(): cdktf.IResolvable | PlanServerBackupdestinationsExtendedretentionrules[] | undefined;
    private _mappings;
    get mappings(): PlanServerBackupdestinationsMappingsList;
    putMappings(value: PlanServerBackupdestinationsMappings[] | cdktf.IResolvable): void;
    resetMappings(): void;
    get mappingsInput(): cdktf.IResolvable | PlanServerBackupdestinationsMappings[] | undefined;
    private _region;
    get region(): PlanServerBackupdestinationsRegionList;
    putRegion(value: PlanServerBackupdestinationsRegion[] | cdktf.IResolvable): void;
    resetRegion(): void;
    get regionInput(): cdktf.IResolvable | PlanServerBackupdestinationsRegion[] | undefined;
    private _sourcecopy;
    get sourcecopy(): PlanServerBackupdestinationsSourcecopyList;
    putSourcecopy(value: PlanServerBackupdestinationsSourcecopy[] | cdktf.IResolvable): void;
    resetSourcecopy(): void;
    get sourcecopyInput(): cdktf.IResolvable | PlanServerBackupdestinationsSourcecopy[] | undefined;
    private _storagepool;
    get storagepool(): PlanServerBackupdestinationsStoragepoolList;
    putStoragepool(value: PlanServerBackupdestinationsStoragepool[] | cdktf.IResolvable): void;
    get storagepoolInput(): cdktf.IResolvable | PlanServerBackupdestinationsStoragepool[] | undefined;
}
export declare class PlanServerBackupdestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerBackupdestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerBackupdestinationsOutputReference;
}
export interface PlanServerDatabaseoptions {
    /**
    * Commit frequency in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#commitfrequencyinhours PlanServer#commitfrequencyinhours}
    */
    readonly commitfrequencyinhours?: number;
    /**
    * Log backup RPO in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#logbackuprpomins PlanServer#logbackuprpomins}
    */
    readonly logbackuprpomins?: number;
    /**
    * Full backup frequency in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#runfullbackupevery PlanServer#runfullbackupevery}
    */
    readonly runfullbackupevery?: number;
    /**
    * Use disk cache for log backups
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#usediskcacheforlogbackups PlanServer#usediskcacheforlogbackups}
    */
    readonly usediskcacheforlogbackups?: string;
}
export declare function planServerDatabaseoptionsToTerraform(struct?: PlanServerDatabaseoptions | cdktf.IResolvable): any;
export declare function planServerDatabaseoptionsToHclTerraform(struct?: PlanServerDatabaseoptions | cdktf.IResolvable): any;
export declare class PlanServerDatabaseoptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerDatabaseoptions | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerDatabaseoptions | cdktf.IResolvable | undefined);
    private _commitfrequencyinhours?;
    get commitfrequencyinhours(): number;
    set commitfrequencyinhours(value: number);
    resetCommitfrequencyinhours(): void;
    get commitfrequencyinhoursInput(): number | undefined;
    private _logbackuprpomins?;
    get logbackuprpomins(): number;
    set logbackuprpomins(value: number);
    resetLogbackuprpomins(): void;
    get logbackuprpominsInput(): number | undefined;
    private _runfullbackupevery?;
    get runfullbackupevery(): number;
    set runfullbackupevery(value: number);
    resetRunfullbackupevery(): void;
    get runfullbackupeveryInput(): number | undefined;
    private _usediskcacheforlogbackups?;
    get usediskcacheforlogbackups(): string;
    set usediskcacheforlogbackups(value: string);
    resetUsediskcacheforlogbackups(): void;
    get usediskcacheforlogbackupsInput(): string | undefined;
}
export declare class PlanServerDatabaseoptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerDatabaseoptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerDatabaseoptionsOutputReference;
}
export interface PlanServerOverrideinheritsettings {
    /**
    * Flag to specify if parent or derived plan backupContent should be used when inherit mode is optional. True - derived, False - Base.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupcontent PlanServer#backupcontent}
    */
    readonly backupcontent?: string;
    /**
    * Flag to specify if parent or derived plan backupDestination should be used when inherit mode is optional. True - derived, False - Base.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupdestination PlanServer#backupdestination}
    */
    readonly backupdestination?: string;
    /**
    * Flag to specify if parent or derived plan rpo should be used when inherit mode is optional. True - derived, False - Base.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#rpo PlanServer#rpo}
    */
    readonly rpo?: string;
}
export declare function planServerOverrideinheritsettingsToTerraform(struct?: PlanServerOverrideinheritsettings | cdktf.IResolvable): any;
export declare function planServerOverrideinheritsettingsToHclTerraform(struct?: PlanServerOverrideinheritsettings | cdktf.IResolvable): any;
export declare class PlanServerOverrideinheritsettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerOverrideinheritsettings | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerOverrideinheritsettings | cdktf.IResolvable | undefined);
    private _backupcontent?;
    get backupcontent(): string;
    set backupcontent(value: string);
    resetBackupcontent(): void;
    get backupcontentInput(): string | undefined;
    private _backupdestination?;
    get backupdestination(): string;
    set backupdestination(value: string);
    resetBackupdestination(): void;
    get backupdestinationInput(): string | undefined;
    private _rpo?;
    get rpo(): string;
    set rpo(value: string);
    resetRpo(): void;
    get rpoInput(): string | undefined;
}
export declare class PlanServerOverrideinheritsettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerOverrideinheritsettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerOverrideinheritsettingsOutputReference;
}
export interface PlanServerOverriderestrictions {
    /**
    * [OPTIONAL, MUST, NOT_ALLOWED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupcontent PlanServer#backupcontent}
    */
    readonly backupcontent?: string;
    /**
    * [OPTIONAL, MUST, NOT_ALLOWED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#rpo PlanServer#rpo}
    */
    readonly rpo?: string;
    /**
    * [OPTIONAL, MUST, NOT_ALLOWED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#storagepool PlanServer#storagepool}
    */
    readonly storagepool?: string;
}
export declare function planServerOverriderestrictionsToTerraform(struct?: PlanServerOverriderestrictions | cdktf.IResolvable): any;
export declare function planServerOverriderestrictionsToHclTerraform(struct?: PlanServerOverriderestrictions | cdktf.IResolvable): any;
export declare class PlanServerOverriderestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerOverriderestrictions | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerOverriderestrictions | cdktf.IResolvable | undefined);
    private _backupcontent?;
    get backupcontent(): string;
    set backupcontent(value: string);
    resetBackupcontent(): void;
    get backupcontentInput(): string | undefined;
    private _rpo?;
    get rpo(): string;
    set rpo(value: string);
    resetRpo(): void;
    get rpoInput(): string | undefined;
    private _storagepool?;
    get storagepool(): string;
    set storagepool(value: string);
    resetStoragepool(): void;
    get storagepoolInput(): string | undefined;
}
export declare class PlanServerOverriderestrictionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerOverriderestrictions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerOverriderestrictionsOutputReference;
}
export interface PlanServerParentplan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerParentplanToTerraform(struct?: PlanServerParentplan | cdktf.IResolvable): any;
export declare function planServerParentplanToHclTerraform(struct?: PlanServerParentplan | cdktf.IResolvable): any;
export declare class PlanServerParentplanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerParentplan | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerParentplan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerParentplanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerParentplan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerParentplanOutputReference;
}
export interface PlanServerRegiontoconfigure {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerRegiontoconfigureToTerraform(struct?: PlanServerRegiontoconfigure | cdktf.IResolvable): any;
export declare function planServerRegiontoconfigureToHclTerraform(struct?: PlanServerRegiontoconfigure | cdktf.IResolvable): any;
export declare class PlanServerRegiontoconfigureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRegiontoconfigure | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRegiontoconfigure | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerRegiontoconfigureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRegiontoconfigure[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRegiontoconfigureOutputReference;
}
export interface PlanServerRpoBackupfrequencySchedulesScheduleoption {
    /**
    * Commit frequency in hours for disk cache backups from automatic schedules
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#commitfrequencyinhours PlanServer#commitfrequencyinhours}
    */
    readonly commitfrequencyinhours?: number;
    /**
    * Number of days between auto conversion of backup level applicable for databases on incremental and differential schedules of server plan
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#daysbetweenautoconvert PlanServer#daysbetweenautoconvert}
    */
    readonly daysbetweenautoconvert?: number;
    /**
    * total job running time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#jobrunningtimeinmins PlanServer#jobrunningtimeinmins}
    */
    readonly jobrunningtimeinmins?: number;
    /**
    * item backup option for O365 V2 backup jobs [SELECT_ALL, SELECT_NEVER_PROCESSED, SELECT_MEETING_SLA, SELECT_NOT_MEETING_SLA_PROCESSED_ATLEAST_ONCE, SELECT_FAILED_LAST_ATTEMPT, SELECT_PROCESSED_ATLEAST_ONCE, SELECT_NOT_MEETING_SLA, SELECT_MEETING_SLA_NOT_RECENTLY_BACKED_UP]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#o365itemselectionoption PlanServer#o365itemselectionoption}
    */
    readonly o365Itemselectionoption?: string;
    /**
    * Used to enable disk caching feature on databases for automatic schedules on server plan
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#usediskcacheforlogbackups PlanServer#usediskcacheforlogbackups}
    */
    readonly usediskcacheforlogbackups?: string;
}
export declare function planServerRpoBackupfrequencySchedulesScheduleoptionToTerraform(struct?: PlanServerRpoBackupfrequencySchedulesScheduleoption | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencySchedulesScheduleoptionToHclTerraform(struct?: PlanServerRpoBackupfrequencySchedulesScheduleoption | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencySchedulesScheduleoptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequencySchedulesScheduleoption | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequencySchedulesScheduleoption | cdktf.IResolvable | undefined);
    private _commitfrequencyinhours?;
    get commitfrequencyinhours(): number;
    set commitfrequencyinhours(value: number);
    resetCommitfrequencyinhours(): void;
    get commitfrequencyinhoursInput(): number | undefined;
    private _daysbetweenautoconvert?;
    get daysbetweenautoconvert(): number;
    set daysbetweenautoconvert(value: number);
    resetDaysbetweenautoconvert(): void;
    get daysbetweenautoconvertInput(): number | undefined;
    private _jobrunningtimeinmins?;
    get jobrunningtimeinmins(): number;
    set jobrunningtimeinmins(value: number);
    resetJobrunningtimeinmins(): void;
    get jobrunningtimeinminsInput(): number | undefined;
    private _o365Itemselectionoption?;
    get o365Itemselectionoption(): string;
    set o365Itemselectionoption(value: string);
    resetO365Itemselectionoption(): void;
    get o365ItemselectionoptionInput(): string | undefined;
    private _usediskcacheforlogbackups?;
    get usediskcacheforlogbackups(): string;
    set usediskcacheforlogbackups(value: string);
    resetUsediskcacheforlogbackups(): void;
    get usediskcacheforlogbackupsInput(): string | undefined;
}
export declare class PlanServerRpoBackupfrequencySchedulesScheduleoptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequencySchedulesScheduleoption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencySchedulesScheduleoptionOutputReference;
}
export interface PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions {
    /**
    * list of dates in a month. For ex: 1, 20
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#ondates PlanServer#ondates}
    */
    readonly ondates?: number[];
    /**
    * On which days, for ex: MONDAY, FRIDAY
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#ondayoftheweek PlanServer#ondayoftheweek}
    */
    readonly ondayoftheweek?: string[];
    /**
    * On which week of month, for ex: FIRST, LAST
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#onweekofthemonth PlanServer#onweekofthemonth}
    */
    readonly onweekofthemonth?: string[];
}
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternExceptionsToTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternExceptionsToHclTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions | cdktf.IResolvable | undefined);
    private _ondates?;
    get ondates(): number[];
    set ondates(value: number[]);
    resetOndates(): void;
    get ondatesInput(): number[] | undefined;
    private _ondayoftheweek?;
    get ondayoftheweek(): string[];
    set ondayoftheweek(value: string[]);
    resetOndayoftheweek(): void;
    get ondayoftheweekInput(): string[] | undefined;
    private _onweekofthemonth?;
    get onweekofthemonth(): string[];
    set onweekofthemonth(value: string[]);
    resetOnweekofthemonth(): void;
    get onweekofthemonthInput(): string[] | undefined;
}
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptionsOutputReference;
}
export interface PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#name PlanServer#name}
    */
    readonly name?: string;
}
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternTimezoneToTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternTimezoneToHclTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezoneOutputReference;
}
export interface PlanServerRpoBackupfrequencySchedulesSchedulepattern {
    /**
    * Day on which to run the schedule, applicable for monthly, yearly
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#dayofmonth PlanServer#dayofmonth}
    */
    readonly dayofmonth?: number;
    /**
    * [SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, DAY, WEEKDAY, WEEKEND_DAYS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#dayofweek PlanServer#dayofweek}
    */
    readonly dayofweek?: string;
    /**
    * No of days between two synthetic full jobs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#daysbetweensyntheticfulls PlanServer#daysbetweensyntheticfulls}
    */
    readonly daysbetweensyntheticfulls?: number;
    /**
    * Schedule end date in epoch format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#enddate PlanServer#enddate}
    */
    readonly enddate?: number;
    /**
    * Frequency of the schedule based on schedule frequency type eg. for Hours, value 2 is 2 hours, for Minutes, 30 is 30 minutes, for Daily, 2 is 2 days. for Monthly 2 is it repeats every 2 months
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#frequency PlanServer#frequency}
    */
    readonly frequency?: number;
    /**
    * The number of mins to force a backup on automatic schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#maxbackupintervalinmins PlanServer#maxbackupintervalinmins}
    */
    readonly maxbackupintervalinmins?: number;
    /**
    * [JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#monthofyear PlanServer#monthofyear}
    */
    readonly monthofyear?: string;
    /**
    * The number of times you want the schedule to run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#nooftimes PlanServer#nooftimes}
    */
    readonly nooftimes?: number;
    /**
    * How often in minutes in a day the schedule runs, applicable for daily, weekly, monthly and yearly frequency types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#repeatintervalinminutes PlanServer#repeatintervalinminutes}
    */
    readonly repeatintervalinminutes?: number;
    /**
    * Until what time to repeat the schedule in a day, requires repeatIntervalInMinutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#repeatuntiltime PlanServer#repeatuntiltime}
    */
    readonly repeatuntiltime?: number;
    /**
    * schedule frequency type [MINUTES, DAILY, WEEKLY, MONTHLY, YEARLY, AUTOMATIC]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#schedulefrequencytype PlanServer#schedulefrequencytype}
    */
    readonly schedulefrequencytype: string;
    /**
    * start date of schedule in epoch format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#startdate PlanServer#startdate}
    */
    readonly startdate?: number;
    /**
    * start time of schedule in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#starttime PlanServer#starttime}
    */
    readonly starttime?: number;
    /**
    * Days of the week for weekly frequency
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#weeklydays PlanServer#weeklydays}
    */
    readonly weeklydays?: string[];
    /**
    * Specific week of a month [FIRST, SECOND, THIRD, FOURTH, LAST]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#weekofmonth PlanServer#weekofmonth}
    */
    readonly weekofmonth?: string;
    /**
    * exceptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#exceptions PlanServer#exceptions}
    */
    readonly exceptions?: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions[] | cdktf.IResolvable;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#timezone PlanServer#timezone}
    */
    readonly timezone?: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone[] | cdktf.IResolvable;
}
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternToTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepattern | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencySchedulesSchedulepatternToHclTerraform(struct?: PlanServerRpoBackupfrequencySchedulesSchedulepattern | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequencySchedulesSchedulepattern | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequencySchedulesSchedulepattern | cdktf.IResolvable | undefined);
    private _dayofmonth?;
    get dayofmonth(): number;
    set dayofmonth(value: number);
    resetDayofmonth(): void;
    get dayofmonthInput(): number | undefined;
    private _dayofweek?;
    get dayofweek(): string;
    set dayofweek(value: string);
    resetDayofweek(): void;
    get dayofweekInput(): string | undefined;
    private _daysbetweensyntheticfulls?;
    get daysbetweensyntheticfulls(): number;
    set daysbetweensyntheticfulls(value: number);
    resetDaysbetweensyntheticfulls(): void;
    get daysbetweensyntheticfullsInput(): number | undefined;
    private _enddate?;
    get enddate(): number;
    set enddate(value: number);
    resetEnddate(): void;
    get enddateInput(): number | undefined;
    private _frequency?;
    get frequency(): number;
    set frequency(value: number);
    resetFrequency(): void;
    get frequencyInput(): number | undefined;
    private _maxbackupintervalinmins?;
    get maxbackupintervalinmins(): number;
    set maxbackupintervalinmins(value: number);
    resetMaxbackupintervalinmins(): void;
    get maxbackupintervalinminsInput(): number | undefined;
    private _monthofyear?;
    get monthofyear(): string;
    set monthofyear(value: string);
    resetMonthofyear(): void;
    get monthofyearInput(): string | undefined;
    private _nooftimes?;
    get nooftimes(): number;
    set nooftimes(value: number);
    resetNooftimes(): void;
    get nooftimesInput(): number | undefined;
    private _repeatintervalinminutes?;
    get repeatintervalinminutes(): number;
    set repeatintervalinminutes(value: number);
    resetRepeatintervalinminutes(): void;
    get repeatintervalinminutesInput(): number | undefined;
    private _repeatuntiltime?;
    get repeatuntiltime(): number;
    set repeatuntiltime(value: number);
    resetRepeatuntiltime(): void;
    get repeatuntiltimeInput(): number | undefined;
    private _schedulefrequencytype?;
    get schedulefrequencytype(): string;
    set schedulefrequencytype(value: string);
    get schedulefrequencytypeInput(): string | undefined;
    private _startdate?;
    get startdate(): number;
    set startdate(value: number);
    resetStartdate(): void;
    get startdateInput(): number | undefined;
    private _starttime?;
    get starttime(): number;
    set starttime(value: number);
    resetStarttime(): void;
    get starttimeInput(): number | undefined;
    private _weeklydays?;
    get weeklydays(): string[];
    set weeklydays(value: string[]);
    resetWeeklydays(): void;
    get weeklydaysInput(): string[] | undefined;
    private _weekofmonth?;
    get weekofmonth(): string;
    set weekofmonth(value: string);
    resetWeekofmonth(): void;
    get weekofmonthInput(): string | undefined;
    private _exceptions;
    get exceptions(): PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptionsList;
    putExceptions(value: PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions[] | cdktf.IResolvable): void;
    resetExceptions(): void;
    get exceptionsInput(): cdktf.IResolvable | PlanServerRpoBackupfrequencySchedulesSchedulepatternExceptions[] | undefined;
    private _timezone;
    get timezone(): PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezoneList;
    putTimezone(value: PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | PlanServerRpoBackupfrequencySchedulesSchedulepatternTimezone[] | undefined;
}
export declare class PlanServerRpoBackupfrequencySchedulesSchedulepatternList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequencySchedulesSchedulepattern[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencySchedulesSchedulepatternOutputReference;
}
export interface PlanServerRpoBackupfrequencySchedules {
    /**
    * Schedule Backup level [FULL, INCREMENTAL, DIFFERENTIAL, SYNTHETICFULL, TRANSACTIONLOG]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backuptype PlanServer#backuptype}
    */
    readonly backuptype: string;
    /**
    * Boolean to indicate if schedule is for database agents
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#fordatabasesonly PlanServer#fordatabasesonly}
    */
    readonly fordatabasesonly?: string;
    /**
    * Name of the schedule, for modify
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#schedulename PlanServer#schedulename}
    */
    readonly schedulename: string;
    /**
    * Type of DR operation (only applicable for Failover groups) [PLANNED_FAILOVER, TEST_BOOT]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#vmoperationtype PlanServer#vmoperationtype}
    */
    readonly vmoperationtype?: string;
    /**
    * scheduleoption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#scheduleoption PlanServer#scheduleoption}
    */
    readonly scheduleoption?: PlanServerRpoBackupfrequencySchedulesScheduleoption[] | cdktf.IResolvable;
    /**
    * schedulepattern block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#schedulepattern PlanServer#schedulepattern}
    */
    readonly schedulepattern: PlanServerRpoBackupfrequencySchedulesSchedulepattern[] | cdktf.IResolvable;
}
export declare function planServerRpoBackupfrequencySchedulesToTerraform(struct?: PlanServerRpoBackupfrequencySchedules | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencySchedulesToHclTerraform(struct?: PlanServerRpoBackupfrequencySchedules | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencySchedulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequencySchedules | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequencySchedules | cdktf.IResolvable | undefined);
    private _backuptype?;
    get backuptype(): string;
    set backuptype(value: string);
    get backuptypeInput(): string | undefined;
    private _fordatabasesonly?;
    get fordatabasesonly(): string;
    set fordatabasesonly(value: string);
    resetFordatabasesonly(): void;
    get fordatabasesonlyInput(): string | undefined;
    private _schedulename?;
    get schedulename(): string;
    set schedulename(value: string);
    get schedulenameInput(): string | undefined;
    private _vmoperationtype?;
    get vmoperationtype(): string;
    set vmoperationtype(value: string);
    resetVmoperationtype(): void;
    get vmoperationtypeInput(): string | undefined;
    private _scheduleoption;
    get scheduleoption(): PlanServerRpoBackupfrequencySchedulesScheduleoptionList;
    putScheduleoption(value: PlanServerRpoBackupfrequencySchedulesScheduleoption[] | cdktf.IResolvable): void;
    resetScheduleoption(): void;
    get scheduleoptionInput(): cdktf.IResolvable | PlanServerRpoBackupfrequencySchedulesScheduleoption[] | undefined;
    private _schedulepattern;
    get schedulepattern(): PlanServerRpoBackupfrequencySchedulesSchedulepatternList;
    putSchedulepattern(value: PlanServerRpoBackupfrequencySchedulesSchedulepattern[] | cdktf.IResolvable): void;
    get schedulepatternInput(): cdktf.IResolvable | PlanServerRpoBackupfrequencySchedulesSchedulepattern[] | undefined;
}
export declare class PlanServerRpoBackupfrequencySchedulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequencySchedules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencySchedulesOutputReference;
}
export interface PlanServerRpoBackupfrequency {
    /**
    * schedules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#schedules PlanServer#schedules}
    */
    readonly schedules?: PlanServerRpoBackupfrequencySchedules[] | cdktf.IResolvable;
}
export declare function planServerRpoBackupfrequencyToTerraform(struct?: PlanServerRpoBackupfrequency | cdktf.IResolvable): any;
export declare function planServerRpoBackupfrequencyToHclTerraform(struct?: PlanServerRpoBackupfrequency | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupfrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupfrequency | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupfrequency | cdktf.IResolvable | undefined);
    private _schedules;
    get schedules(): PlanServerRpoBackupfrequencySchedulesList;
    putSchedules(value: PlanServerRpoBackupfrequencySchedules[] | cdktf.IResolvable): void;
    resetSchedules(): void;
    get schedulesInput(): cdktf.IResolvable | PlanServerRpoBackupfrequencySchedules[] | undefined;
}
export declare class PlanServerRpoBackupfrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupfrequency[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupfrequencyOutputReference;
}
export interface PlanServerRpoBackupwindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#dayofweek PlanServer#dayofweek}
    */
    readonly dayofweek?: string[];
    /**
    * Time in seconds since the beginning of the day
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#endtime PlanServer#endtime}
    */
    readonly endtime?: number;
    /**
    * Time in seconds since the beginning of the day
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#starttime PlanServer#starttime}
    */
    readonly starttime?: number;
}
export declare function planServerRpoBackupwindowToTerraform(struct?: PlanServerRpoBackupwindow | cdktf.IResolvable): any;
export declare function planServerRpoBackupwindowToHclTerraform(struct?: PlanServerRpoBackupwindow | cdktf.IResolvable): any;
export declare class PlanServerRpoBackupwindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoBackupwindow | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoBackupwindow | cdktf.IResolvable | undefined);
    private _dayofweek?;
    get dayofweek(): string[];
    set dayofweek(value: string[]);
    resetDayofweek(): void;
    get dayofweekInput(): string[] | undefined;
    private _endtime?;
    get endtime(): number;
    set endtime(value: number);
    resetEndtime(): void;
    get endtimeInput(): number | undefined;
    private _starttime?;
    get starttime(): number;
    set starttime(value: number);
    resetStarttime(): void;
    get starttimeInput(): number | undefined;
}
export declare class PlanServerRpoBackupwindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoBackupwindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoBackupwindowOutputReference;
}
export interface PlanServerRpoFullbackupwindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#dayofweek PlanServer#dayofweek}
    */
    readonly dayofweek?: string[];
    /**
    * Time in seconds since the beginning of the day
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#endtime PlanServer#endtime}
    */
    readonly endtime?: number;
    /**
    * Time in seconds since the beginning of the day
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#starttime PlanServer#starttime}
    */
    readonly starttime?: number;
}
export declare function planServerRpoFullbackupwindowToTerraform(struct?: PlanServerRpoFullbackupwindow | cdktf.IResolvable): any;
export declare function planServerRpoFullbackupwindowToHclTerraform(struct?: PlanServerRpoFullbackupwindow | cdktf.IResolvable): any;
export declare class PlanServerRpoFullbackupwindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoFullbackupwindow | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoFullbackupwindow | cdktf.IResolvable | undefined);
    private _dayofweek?;
    get dayofweek(): string[];
    set dayofweek(value: string[]);
    resetDayofweek(): void;
    get dayofweekInput(): string[] | undefined;
    private _endtime?;
    get endtime(): number;
    set endtime(value: number);
    resetEndtime(): void;
    get endtimeInput(): number | undefined;
    private _starttime?;
    get starttime(): number;
    set starttime(value: number);
    resetStarttime(): void;
    get starttimeInput(): number | undefined;
}
export declare class PlanServerRpoFullbackupwindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoFullbackupwindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoFullbackupwindowOutputReference;
}
export interface PlanServerRpoSla {
    /**
    * Time provided in Unix format. Give 0 to reset any existing delay.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#enableafterdelay PlanServer#enableafterdelay}
    */
    readonly enableafterdelay?: number;
    /**
    * Flag to set to exclude plan from SLA
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#excludefromsla PlanServer#excludefromsla}
    */
    readonly excludefromsla?: string;
    /**
    * Reason for exclusion from SLA
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#exclusionreason PlanServer#exclusionreason}
    */
    readonly exclusionreason?: string;
    /**
    * SLA Period in Days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#slaperiod PlanServer#slaperiod}
    */
    readonly slaperiod?: number;
    /**
    * Flag to set to use System Default Service Level Agreement
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#usesystemdefaultsla PlanServer#usesystemdefaultsla}
    */
    readonly usesystemdefaultsla?: string;
}
export declare function planServerRpoSlaToTerraform(struct?: PlanServerRpoSla | cdktf.IResolvable): any;
export declare function planServerRpoSlaToHclTerraform(struct?: PlanServerRpoSla | cdktf.IResolvable): any;
export declare class PlanServerRpoSlaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpoSla | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpoSla | cdktf.IResolvable | undefined);
    private _enableafterdelay?;
    get enableafterdelay(): number;
    set enableafterdelay(value: number);
    resetEnableafterdelay(): void;
    get enableafterdelayInput(): number | undefined;
    private _excludefromsla?;
    get excludefromsla(): string;
    set excludefromsla(value: string);
    resetExcludefromsla(): void;
    get excludefromslaInput(): string | undefined;
    private _exclusionreason?;
    get exclusionreason(): string;
    set exclusionreason(value: string);
    resetExclusionreason(): void;
    get exclusionreasonInput(): string | undefined;
    private _slaperiod?;
    get slaperiod(): number;
    set slaperiod(value: number);
    resetSlaperiod(): void;
    get slaperiodInput(): number | undefined;
    private _usesystemdefaultsla?;
    get usesystemdefaultsla(): string;
    set usesystemdefaultsla(value: string);
    resetUsesystemdefaultsla(): void;
    get usesystemdefaultslaInput(): string | undefined;
}
export declare class PlanServerRpoSlaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpoSla[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoSlaOutputReference;
}
export interface PlanServerRpo {
    /**
    * backupfrequency block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupfrequency PlanServer#backupfrequency}
    */
    readonly backupfrequency?: PlanServerRpoBackupfrequency[] | cdktf.IResolvable;
    /**
    * backupwindow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupwindow PlanServer#backupwindow}
    */
    readonly backupwindow?: PlanServerRpoBackupwindow[] | cdktf.IResolvable;
    /**
    * fullbackupwindow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#fullbackupwindow PlanServer#fullbackupwindow}
    */
    readonly fullbackupwindow?: PlanServerRpoFullbackupwindow[] | cdktf.IResolvable;
    /**
    * sla block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#sla PlanServer#sla}
    */
    readonly sla?: PlanServerRpoSla[] | cdktf.IResolvable;
}
export declare function planServerRpoToTerraform(struct?: PlanServerRpo | cdktf.IResolvable): any;
export declare function planServerRpoToHclTerraform(struct?: PlanServerRpo | cdktf.IResolvable): any;
export declare class PlanServerRpoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerRpo | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerRpo | cdktf.IResolvable | undefined);
    private _backupfrequency;
    get backupfrequency(): PlanServerRpoBackupfrequencyList;
    putBackupfrequency(value: PlanServerRpoBackupfrequency[] | cdktf.IResolvable): void;
    resetBackupfrequency(): void;
    get backupfrequencyInput(): cdktf.IResolvable | PlanServerRpoBackupfrequency[] | undefined;
    private _backupwindow;
    get backupwindow(): PlanServerRpoBackupwindowList;
    putBackupwindow(value: PlanServerRpoBackupwindow[] | cdktf.IResolvable): void;
    resetBackupwindow(): void;
    get backupwindowInput(): cdktf.IResolvable | PlanServerRpoBackupwindow[] | undefined;
    private _fullbackupwindow;
    get fullbackupwindow(): PlanServerRpoFullbackupwindowList;
    putFullbackupwindow(value: PlanServerRpoFullbackupwindow[] | cdktf.IResolvable): void;
    resetFullbackupwindow(): void;
    get fullbackupwindowInput(): cdktf.IResolvable | PlanServerRpoFullbackupwindow[] | undefined;
    private _sla;
    get sla(): PlanServerRpoSlaList;
    putSla(value: PlanServerRpoSla[] | cdktf.IResolvable): void;
    resetSla(): void;
    get slaInput(): cdktf.IResolvable | PlanServerRpoSla[] | undefined;
}
export declare class PlanServerRpoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerRpo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerRpoOutputReference;
}
export interface PlanServerSettingsFilesearch {
    /**
    * Flag for enabling indexing
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#enabled PlanServer#enabled}
    */
    readonly enabled?: string;
    /**
    * Type of indexing status. [NOT_APPLICABLE, ENABLED, SETUP_IN_PROGRESS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#status PlanServer#status}
    */
    readonly status?: string;
    /**
    * Tells what is happening behind the scene, so that user can knows why indexing is not enabled or if its in progress
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#statusmessage PlanServer#statusmessage}
    */
    readonly statusmessage?: string;
}
export declare function planServerSettingsFilesearchToTerraform(struct?: PlanServerSettingsFilesearch | cdktf.IResolvable): any;
export declare function planServerSettingsFilesearchToHclTerraform(struct?: PlanServerSettingsFilesearch | cdktf.IResolvable): any;
export declare class PlanServerSettingsFilesearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerSettingsFilesearch | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerSettingsFilesearch | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _statusmessage?;
    get statusmessage(): string;
    set statusmessage(value: string);
    resetStatusmessage(): void;
    get statusmessageInput(): string | undefined;
}
export declare class PlanServerSettingsFilesearchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerSettingsFilesearch[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerSettingsFilesearchOutputReference;
}
export interface PlanServerSettings {
    /**
    * Setting to suggest plan has some advanced settings present. Setting is OEM specific and not applicable for all cases.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#enableadvancedview PlanServer#enableadvancedview}
    */
    readonly enableadvancedview?: string;
    /**
    * filesearch block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#filesearch PlanServer#filesearch}
    */
    readonly filesearch?: PlanServerSettingsFilesearch[] | cdktf.IResolvable;
}
export declare function planServerSettingsToTerraform(struct?: PlanServerSettings | cdktf.IResolvable): any;
export declare function planServerSettingsToHclTerraform(struct?: PlanServerSettings | cdktf.IResolvable): any;
export declare class PlanServerSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerSettings | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerSettings | cdktf.IResolvable | undefined);
    private _enableadvancedview?;
    get enableadvancedview(): string;
    set enableadvancedview(value: string);
    resetEnableadvancedview(): void;
    get enableadvancedviewInput(): string | undefined;
    private _filesearch;
    get filesearch(): PlanServerSettingsFilesearchList;
    putFilesearch(value: PlanServerSettingsFilesearch[] | cdktf.IResolvable): void;
    resetFilesearch(): void;
    get filesearchInput(): cdktf.IResolvable | PlanServerSettingsFilesearch[] | undefined;
}
export declare class PlanServerSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerSettingsOutputReference;
}
export interface PlanServerSnapshotoptions {
    /**
    * Backup copy RPO in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#backupcopyrpomins PlanServer#backupcopyrpomins}
    */
    readonly backupcopyrpomins?: number;
    /**
    * Flag to enable backup copy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#enablebackupcopy PlanServer#enablebackupcopy}
    */
    readonly enablebackupcopy?: string;
}
export declare function planServerSnapshotoptionsToTerraform(struct?: PlanServerSnapshotoptions | cdktf.IResolvable): any;
export declare function planServerSnapshotoptionsToHclTerraform(struct?: PlanServerSnapshotoptions | cdktf.IResolvable): any;
export declare class PlanServerSnapshotoptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerSnapshotoptions | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerSnapshotoptions | cdktf.IResolvable | undefined);
    private _backupcopyrpomins?;
    get backupcopyrpomins(): number;
    set backupcopyrpomins(value: number);
    resetBackupcopyrpomins(): void;
    get backupcopyrpominsInput(): number | undefined;
    private _enablebackupcopy?;
    get enablebackupcopy(): string;
    set enablebackupcopy(value: string);
    resetEnablebackupcopy(): void;
    get enablebackupcopyInput(): string | undefined;
}
export declare class PlanServerSnapshotoptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerSnapshotoptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerSnapshotoptionsOutputReference;
}
export interface PlanServerWorkloadSolutions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function planServerWorkloadSolutionsToTerraform(struct?: PlanServerWorkloadSolutions | cdktf.IResolvable): any;
export declare function planServerWorkloadSolutionsToHclTerraform(struct?: PlanServerWorkloadSolutions | cdktf.IResolvable): any;
export declare class PlanServerWorkloadSolutionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerWorkloadSolutions | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerWorkloadSolutions | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class PlanServerWorkloadSolutionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerWorkloadSolutions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerWorkloadSolutionsOutputReference;
}
export interface PlanServerWorkloadWorkloadtypes {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#id PlanServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function planServerWorkloadWorkloadtypesToTerraform(struct?: PlanServerWorkloadWorkloadtypes | cdktf.IResolvable): any;
export declare function planServerWorkloadWorkloadtypesToHclTerraform(struct?: PlanServerWorkloadWorkloadtypes | cdktf.IResolvable): any;
export declare class PlanServerWorkloadWorkloadtypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerWorkloadWorkloadtypes | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerWorkloadWorkloadtypes | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class PlanServerWorkloadWorkloadtypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerWorkloadWorkloadtypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerWorkloadWorkloadtypesOutputReference;
}
export interface PlanServerWorkload {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#workloadgrouptypes PlanServer#workloadgrouptypes}
    */
    readonly workloadgrouptypes?: string[];
    /**
    * solutions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#solutions PlanServer#solutions}
    */
    readonly solutions?: PlanServerWorkloadSolutions[] | cdktf.IResolvable;
    /**
    * workloadtypes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#workloadtypes PlanServer#workloadtypes}
    */
    readonly workloadtypes?: PlanServerWorkloadWorkloadtypes[] | cdktf.IResolvable;
}
export declare function planServerWorkloadToTerraform(struct?: PlanServerWorkload | cdktf.IResolvable): any;
export declare function planServerWorkloadToHclTerraform(struct?: PlanServerWorkload | cdktf.IResolvable): any;
export declare class PlanServerWorkloadOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanServerWorkload | cdktf.IResolvable | undefined;
    set internalValue(value: PlanServerWorkload | cdktf.IResolvable | undefined);
    private _workloadgrouptypes?;
    get workloadgrouptypes(): string[];
    set workloadgrouptypes(value: string[]);
    resetWorkloadgrouptypes(): void;
    get workloadgrouptypesInput(): string[] | undefined;
    private _solutions;
    get solutions(): PlanServerWorkloadSolutionsList;
    putSolutions(value: PlanServerWorkloadSolutions[] | cdktf.IResolvable): void;
    resetSolutions(): void;
    get solutionsInput(): cdktf.IResolvable | PlanServerWorkloadSolutions[] | undefined;
    private _workloadtypes;
    get workloadtypes(): PlanServerWorkloadWorkloadtypesList;
    putWorkloadtypes(value: PlanServerWorkloadWorkloadtypes[] | cdktf.IResolvable): void;
    resetWorkloadtypes(): void;
    get workloadtypesInput(): cdktf.IResolvable | PlanServerWorkloadWorkloadtypes[] | undefined;
}
export declare class PlanServerWorkloadList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanServerWorkload[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanServerWorkloadOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server commvault_plan_server}
*/
export declare class PlanServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_plan_server";
    /**
    * Generates CDKTF code for importing a PlanServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PlanServer to import
    * @param importFromId The id of the existing PlanServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PlanServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_server commvault_plan_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PlanServerConfig
    */
    constructor(scope: Construct, id: string, config: PlanServerConfig);
    private _allowplanoverride?;
    get allowplanoverride(): string;
    set allowplanoverride(value: string);
    resetAllowplanoverride(): void;
    get allowplanoverrideInput(): string | undefined;
    private _backupdestinationids?;
    get backupdestinationids(): number[];
    set backupdestinationids(value: number[]);
    resetBackupdestinationids(): void;
    get backupdestinationidsInput(): number[] | undefined;
    private _filesystemaddon?;
    get filesystemaddon(): string;
    set filesystemaddon(value: string);
    resetFilesystemaddon(): void;
    get filesystemaddonInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _planname?;
    get planname(): string;
    set planname(value: string);
    get plannameInput(): string | undefined;
    private _backupcontent;
    get backupcontent(): PlanServerBackupcontentList;
    putBackupcontent(value: PlanServerBackupcontent[] | cdktf.IResolvable): void;
    resetBackupcontent(): void;
    get backupcontentInput(): cdktf.IResolvable | PlanServerBackupcontent[] | undefined;
    private _backupdestinations;
    get backupdestinations(): PlanServerBackupdestinationsList;
    putBackupdestinations(value: PlanServerBackupdestinations[] | cdktf.IResolvable): void;
    resetBackupdestinations(): void;
    get backupdestinationsInput(): cdktf.IResolvable | PlanServerBackupdestinations[] | undefined;
    private _databaseoptions;
    get databaseoptions(): PlanServerDatabaseoptionsList;
    putDatabaseoptions(value: PlanServerDatabaseoptions[] | cdktf.IResolvable): void;
    resetDatabaseoptions(): void;
    get databaseoptionsInput(): cdktf.IResolvable | PlanServerDatabaseoptions[] | undefined;
    private _overrideinheritsettings;
    get overrideinheritsettings(): PlanServerOverrideinheritsettingsList;
    putOverrideinheritsettings(value: PlanServerOverrideinheritsettings[] | cdktf.IResolvable): void;
    resetOverrideinheritsettings(): void;
    get overrideinheritsettingsInput(): cdktf.IResolvable | PlanServerOverrideinheritsettings[] | undefined;
    private _overriderestrictions;
    get overriderestrictions(): PlanServerOverriderestrictionsList;
    putOverriderestrictions(value: PlanServerOverriderestrictions[] | cdktf.IResolvable): void;
    resetOverriderestrictions(): void;
    get overriderestrictionsInput(): cdktf.IResolvable | PlanServerOverriderestrictions[] | undefined;
    private _parentplan;
    get parentplan(): PlanServerParentplanList;
    putParentplan(value: PlanServerParentplan[] | cdktf.IResolvable): void;
    resetParentplan(): void;
    get parentplanInput(): cdktf.IResolvable | PlanServerParentplan[] | undefined;
    private _regiontoconfigure;
    get regiontoconfigure(): PlanServerRegiontoconfigureList;
    putRegiontoconfigure(value: PlanServerRegiontoconfigure[] | cdktf.IResolvable): void;
    resetRegiontoconfigure(): void;
    get regiontoconfigureInput(): cdktf.IResolvable | PlanServerRegiontoconfigure[] | undefined;
    private _rpo;
    get rpo(): PlanServerRpoList;
    putRpo(value: PlanServerRpo[] | cdktf.IResolvable): void;
    resetRpo(): void;
    get rpoInput(): cdktf.IResolvable | PlanServerRpo[] | undefined;
    private _settings;
    get settings(): PlanServerSettingsList;
    putSettings(value: PlanServerSettings[] | cdktf.IResolvable): void;
    resetSettings(): void;
    get settingsInput(): cdktf.IResolvable | PlanServerSettings[] | undefined;
    private _snapshotoptions;
    get snapshotoptions(): PlanServerSnapshotoptionsList;
    putSnapshotoptions(value: PlanServerSnapshotoptions[] | cdktf.IResolvable): void;
    resetSnapshotoptions(): void;
    get snapshotoptionsInput(): cdktf.IResolvable | PlanServerSnapshotoptions[] | undefined;
    private _workload;
    get workload(): PlanServerWorkloadList;
    putWorkload(value: PlanServerWorkload[] | cdktf.IResolvable): void;
    resetWorkload(): void;
    get workloadInput(): cdktf.IResolvable | PlanServerWorkload[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
