import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the destination name for the backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#backup_destination_name Plan#backup_destination_name}
    */
    readonly backupDestinationName: string;
    /**
    * Specifies the backup destination storage used for the plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#backup_destination_storage Plan#backup_destination_storage}
    */
    readonly backupDestinationStorage: string;
    /**
    * Specifies the companyid to which the created plan needs to be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#company_id Plan#company_id}
    */
    readonly companyId?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#id Plan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the Plan name used for creation of the plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#plan_name Plan#plan_name}
    */
    readonly planName: string;
    /**
    * Specifies the number of days that the software retains the data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#retention_period_days Plan#retention_period_days}
    */
    readonly retentionPeriodDays: number;
    /**
    * Specifies the rpo in Days for created plan
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#rpo_in_days Plan#rpo_in_days}
    */
    readonly rpoInDays?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan commvault_plan}
*/
export declare class Plan extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_plan";
    /**
    * Generates CDKTF code for importing a Plan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Plan to import
    * @param importFromId The id of the existing Plan that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Plan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan commvault_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PlanConfig
    */
    constructor(scope: Construct, id: string, config: PlanConfig);
    private _backupDestinationName?;
    get backupDestinationName(): string;
    set backupDestinationName(value: string);
    get backupDestinationNameInput(): string | undefined;
    private _backupDestinationStorage?;
    get backupDestinationStorage(): string;
    set backupDestinationStorage(value: string);
    get backupDestinationStorageInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _planName?;
    get planName(): string;
    set planName(value: string);
    get planNameInput(): string | undefined;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    get retentionPeriodDaysInput(): number | undefined;
    private _rpoInDays?;
    get rpoInDays(): number;
    set rpoInDays(value: number);
    resetRpoInDays(): void;
    get rpoInDaysInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
