import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the list of clients for association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association#client_list SecurityAssociation#client_list}
    */
    readonly clientList: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association#id SecurityAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the permission names list used for the association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association#permissions_list SecurityAssociation#permissions_list}
    */
    readonly permissionsList: string[];
    /**
    * Specifies the user group name used for association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association#user_group_name SecurityAssociation#user_group_name}
    */
    readonly userGroupName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association commvault_security_association}
*/
export declare class SecurityAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_security_association";
    /**
    * Generates CDKTF code for importing a SecurityAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityAssociation to import
    * @param importFromId The id of the existing SecurityAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association commvault_security_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SecurityAssociationConfig);
    private _clientList?;
    get clientList(): string[];
    set clientList(value: string[]);
    get clientListInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissionsList?;
    get permissionsList(): string[];
    set permissionsList(value: string[]);
    get permissionsListInput(): string[] | undefined;
    private _userGroupName?;
    get userGroupName(): string;
    set userGroupName(value: string);
    get userGroupNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
