import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageCloudAccesspathConfig extends cdktf.TerraformMetaArguments {
    /**
    * Id of Bucket
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#bucketid StorageCloudAccesspath#bucketid}
    */
    readonly bucketid: number;
    /**
    * Id of cloud Storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#cloudstorageid StorageCloudAccesspath#cloudstorageid}
    */
    readonly cloudstorageid: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#id StorageCloudAccesspath#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#mediaagent StorageCloudAccesspath#mediaagent}
    */
    readonly mediaagent?: StorageCloudAccesspathMediaagent[] | cdktf.IResolvable;
}
export interface StorageCloudAccesspathMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#id StorageCloudAccesspath#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#name StorageCloudAccesspath#name}
    */
    readonly name?: string;
}
export declare function storageCloudAccesspathMediaagentToTerraform(struct?: StorageCloudAccesspathMediaagent | cdktf.IResolvable): any;
export declare function storageCloudAccesspathMediaagentToHclTerraform(struct?: StorageCloudAccesspathMediaagent | cdktf.IResolvable): any;
export declare class StorageCloudAccesspathMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAccesspathMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAccesspathMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudAccesspathMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAccesspathMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAccesspathMediaagentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath commvault_storage_cloud_accesspath}
*/
export declare class StorageCloudAccesspath extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_cloud_accesspath";
    /**
    * Generates CDKTF code for importing a StorageCloudAccesspath resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageCloudAccesspath to import
    * @param importFromId The id of the existing StorageCloudAccesspath that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageCloudAccesspath to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_accesspath commvault_storage_cloud_accesspath} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageCloudAccesspathConfig
    */
    constructor(scope: Construct, id: string, config: StorageCloudAccesspathConfig);
    private _bucketid?;
    get bucketid(): number;
    set bucketid(value: number);
    get bucketidInput(): number | undefined;
    private _cloudstorageid?;
    get cloudstorageid(): number;
    set cloudstorageid(value: number);
    get cloudstorageidInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudAccesspathMediaagentList;
    putMediaagent(value: StorageCloudAccesspathMediaagent[] | cdktf.IResolvable): void;
    resetMediaagent(): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudAccesspathMediaagent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
