import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageCloudAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only for IAM VM and IAM AD
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#accountname StorageCloudAzure#accountname}
    */
    readonly accountname?: string;
    /**
    * Authentication type for the cloud storage server. Only Access & Account Name and IAM AD require credentials. [Access and secret keys, IAM VM role assignment, IAM AD application role assignment (Credential Manager)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#authentication StorageCloudAzure#authentication}
    */
    readonly authentication: string;
    /**
    * Name of container
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#container StorageCloudAzure#container}
    */
    readonly container: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the cloud storage library
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#name StorageCloudAzure#name}
    */
    readonly name: string;
    /**
    * IP address or fully qualified domain name or URL for the cloud library based on cloud vendor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#servicehost StorageCloudAzure#servicehost}
    */
    readonly servicehost?: string;
    /**
    * Appropriate storage class for your account [Container's default, Hot, Cool, Archive, Hot/Archive (Combined Storage Tiers), Cool/Archive (Combined Storage Tiers)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#storageclass StorageCloudAzure#storageclass}
    */
    readonly storageclass: string;
    /**
    * Enables or disables deduplication on the storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#usededuplication StorageCloudAzure#usededuplication}
    */
    readonly usededuplication?: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#credentials StorageCloudAzure#credentials}
    */
    readonly credentials?: StorageCloudAzureCredentials[] | cdktf.IResolvable;
    /**
    * deduplicationdblocation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#deduplicationdblocation StorageCloudAzure#deduplicationdblocation}
    */
    readonly deduplicationdblocation?: StorageCloudAzureDeduplicationdblocation[] | cdktf.IResolvable;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#encryption StorageCloudAzure#encryption}
    */
    readonly encryption?: StorageCloudAzureEncryption[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#mediaagent StorageCloudAzure#mediaagent}
    */
    readonly mediaagent: StorageCloudAzureMediaagent[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#security StorageCloudAzure#security}
    */
    readonly security?: StorageCloudAzureSecurity[] | cdktf.IResolvable;
}
export interface StorageCloudAzureCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#name StorageCloudAzure#name}
    */
    readonly name?: string;
}
export declare function storageCloudAzureCredentialsToTerraform(struct?: StorageCloudAzureCredentials | cdktf.IResolvable): any;
export declare function storageCloudAzureCredentialsToHclTerraform(struct?: StorageCloudAzureCredentials | cdktf.IResolvable): any;
export declare class StorageCloudAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureCredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudAzureCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureCredentialsOutputReference;
}
export interface StorageCloudAzureDeduplicationdblocationMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#name StorageCloudAzure#name}
    */
    readonly name?: string;
}
export declare function storageCloudAzureDeduplicationdblocationMediaagentToTerraform(struct?: StorageCloudAzureDeduplicationdblocationMediaagent | cdktf.IResolvable): any;
export declare function storageCloudAzureDeduplicationdblocationMediaagentToHclTerraform(struct?: StorageCloudAzureDeduplicationdblocationMediaagent | cdktf.IResolvable): any;
export declare class StorageCloudAzureDeduplicationdblocationMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureDeduplicationdblocationMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureDeduplicationdblocationMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudAzureDeduplicationdblocationMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureDeduplicationdblocationMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureDeduplicationdblocationMediaagentOutputReference;
}
export interface StorageCloudAzureDeduplicationdblocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#path StorageCloudAzure#path}
    */
    readonly path?: string;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#mediaagent StorageCloudAzure#mediaagent}
    */
    readonly mediaagent?: StorageCloudAzureDeduplicationdblocationMediaagent[] | cdktf.IResolvable;
}
export declare function storageCloudAzureDeduplicationdblocationToTerraform(struct?: StorageCloudAzureDeduplicationdblocation | cdktf.IResolvable): any;
export declare function storageCloudAzureDeduplicationdblocationToHclTerraform(struct?: StorageCloudAzureDeduplicationdblocation | cdktf.IResolvable): any;
export declare class StorageCloudAzureDeduplicationdblocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureDeduplicationdblocation | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureDeduplicationdblocation | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudAzureDeduplicationdblocationMediaagentList;
    putMediaagent(value: StorageCloudAzureDeduplicationdblocationMediaagent[] | cdktf.IResolvable): void;
    resetMediaagent(): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudAzureDeduplicationdblocationMediaagent[] | undefined;
}
export declare class StorageCloudAzureDeduplicationdblocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureDeduplicationdblocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureDeduplicationdblocationOutputReference;
}
export interface StorageCloudAzureEncryptionKeyprovider {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#name StorageCloudAzure#name}
    */
    readonly name?: string;
}
export declare function storageCloudAzureEncryptionKeyproviderToTerraform(struct?: StorageCloudAzureEncryptionKeyprovider | cdktf.IResolvable): any;
export declare function storageCloudAzureEncryptionKeyproviderToHclTerraform(struct?: StorageCloudAzureEncryptionKeyprovider | cdktf.IResolvable): any;
export declare class StorageCloudAzureEncryptionKeyproviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureEncryptionKeyprovider | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureEncryptionKeyprovider | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudAzureEncryptionKeyproviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureEncryptionKeyprovider[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureEncryptionKeyproviderOutputReference;
}
export interface StorageCloudAzureEncryption {
    /**
    * The different types of encryption keys that can be used for encrypting the data. The values are case sensitive [BlowFish, AES, DES3, GOST, Serpent, Twofish]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#cipher StorageCloudAzure#cipher}
    */
    readonly cipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#encrypt StorageCloudAzure#encrypt}
    */
    readonly encrypt?: string;
    /**
    * Different keylengths are present for different kinds of ciphers. Blowfish,Twofish,AES and Serpent all accept both 128 and 256. DES3 accepts only 192. GOST accepts only 256.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#keylength StorageCloudAzure#keylength}
    */
    readonly keylength?: number;
    /**
    * keyprovider block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#keyprovider StorageCloudAzure#keyprovider}
    */
    readonly keyprovider?: StorageCloudAzureEncryptionKeyprovider[] | cdktf.IResolvable;
}
export declare function storageCloudAzureEncryptionToTerraform(struct?: StorageCloudAzureEncryption | cdktf.IResolvable): any;
export declare function storageCloudAzureEncryptionToHclTerraform(struct?: StorageCloudAzureEncryption | cdktf.IResolvable): any;
export declare class StorageCloudAzureEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureEncryption | cdktf.IResolvable | undefined);
    private _cipher?;
    get cipher(): string;
    set cipher(value: string);
    resetCipher(): void;
    get cipherInput(): string | undefined;
    private _encrypt?;
    get encrypt(): string;
    set encrypt(value: string);
    resetEncrypt(): void;
    get encryptInput(): string | undefined;
    private _keylength?;
    get keylength(): number;
    set keylength(value: number);
    resetKeylength(): void;
    get keylengthInput(): number | undefined;
    private _keyprovider;
    get keyprovider(): StorageCloudAzureEncryptionKeyproviderList;
    putKeyprovider(value: StorageCloudAzureEncryptionKeyprovider[] | cdktf.IResolvable): void;
    resetKeyprovider(): void;
    get keyproviderInput(): cdktf.IResolvable | StorageCloudAzureEncryptionKeyprovider[] | undefined;
}
export declare class StorageCloudAzureEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureEncryptionOutputReference;
}
export interface StorageCloudAzureMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#name StorageCloudAzure#name}
    */
    readonly name?: string;
}
export declare function storageCloudAzureMediaagentToTerraform(struct?: StorageCloudAzureMediaagent | cdktf.IResolvable): any;
export declare function storageCloudAzureMediaagentToHclTerraform(struct?: StorageCloudAzureMediaagent | cdktf.IResolvable): any;
export declare class StorageCloudAzureMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudAzureMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureMediaagentOutputReference;
}
export interface StorageCloudAzureSecurityRole {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudAzureSecurityRoleToTerraform(struct?: StorageCloudAzureSecurityRole | cdktf.IResolvable): any;
export declare function storageCloudAzureSecurityRoleToHclTerraform(struct?: StorageCloudAzureSecurityRole | cdktf.IResolvable): any;
export declare class StorageCloudAzureSecurityRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureSecurityRole | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureSecurityRole | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudAzureSecurityRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureSecurityRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureSecurityRoleOutputReference;
}
export interface StorageCloudAzureSecurityUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudAzureSecurityUserToTerraform(struct?: StorageCloudAzureSecurityUser | cdktf.IResolvable): any;
export declare function storageCloudAzureSecurityUserToHclTerraform(struct?: StorageCloudAzureSecurityUser | cdktf.IResolvable): any;
export declare class StorageCloudAzureSecurityUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureSecurityUser | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureSecurityUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudAzureSecurityUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureSecurityUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureSecurityUserOutputReference;
}
export interface StorageCloudAzureSecurityUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#id StorageCloudAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudAzureSecurityUsergroupToTerraform(struct?: StorageCloudAzureSecurityUsergroup | cdktf.IResolvable): any;
export declare function storageCloudAzureSecurityUsergroupToHclTerraform(struct?: StorageCloudAzureSecurityUsergroup | cdktf.IResolvable): any;
export declare class StorageCloudAzureSecurityUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureSecurityUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureSecurityUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudAzureSecurityUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureSecurityUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureSecurityUsergroupOutputReference;
}
export interface StorageCloudAzureSecurity {
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#role StorageCloudAzure#role}
    */
    readonly role?: StorageCloudAzureSecurityRole[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#user StorageCloudAzure#user}
    */
    readonly user?: StorageCloudAzureSecurityUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#usergroup StorageCloudAzure#usergroup}
    */
    readonly usergroup?: StorageCloudAzureSecurityUsergroup[] | cdktf.IResolvable;
}
export declare function storageCloudAzureSecurityToTerraform(struct?: StorageCloudAzureSecurity | cdktf.IResolvable): any;
export declare function storageCloudAzureSecurityToHclTerraform(struct?: StorageCloudAzureSecurity | cdktf.IResolvable): any;
export declare class StorageCloudAzureSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudAzureSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudAzureSecurity | cdktf.IResolvable | undefined);
    private _role;
    get role(): StorageCloudAzureSecurityRoleList;
    putRole(value: StorageCloudAzureSecurityRole[] | cdktf.IResolvable): void;
    resetRole(): void;
    get roleInput(): cdktf.IResolvable | StorageCloudAzureSecurityRole[] | undefined;
    private _user;
    get user(): StorageCloudAzureSecurityUserList;
    putUser(value: StorageCloudAzureSecurityUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | StorageCloudAzureSecurityUser[] | undefined;
    private _usergroup;
    get usergroup(): StorageCloudAzureSecurityUsergroupList;
    putUsergroup(value: StorageCloudAzureSecurityUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | StorageCloudAzureSecurityUsergroup[] | undefined;
}
export declare class StorageCloudAzureSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudAzureSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudAzureSecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure commvault_storage_cloud_azure}
*/
export declare class StorageCloudAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_cloud_azure";
    /**
    * Generates CDKTF code for importing a StorageCloudAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageCloudAzure to import
    * @param importFromId The id of the existing StorageCloudAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageCloudAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_azure commvault_storage_cloud_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageCloudAzureConfig
    */
    constructor(scope: Construct, id: string, config: StorageCloudAzureConfig);
    private _accountname?;
    get accountname(): string;
    set accountname(value: string);
    resetAccountname(): void;
    get accountnameInput(): string | undefined;
    private _authentication?;
    get authentication(): string;
    set authentication(value: string);
    get authenticationInput(): string | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servicehost?;
    get servicehost(): string;
    set servicehost(value: string);
    resetServicehost(): void;
    get servicehostInput(): string | undefined;
    private _storageclass?;
    get storageclass(): string;
    set storageclass(value: string);
    get storageclassInput(): string | undefined;
    private _usededuplication?;
    get usededuplication(): string;
    set usededuplication(value: string);
    resetUsededuplication(): void;
    get usededuplicationInput(): string | undefined;
    private _credentials;
    get credentials(): StorageCloudAzureCredentialsList;
    putCredentials(value: StorageCloudAzureCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | StorageCloudAzureCredentials[] | undefined;
    private _deduplicationdblocation;
    get deduplicationdblocation(): StorageCloudAzureDeduplicationdblocationList;
    putDeduplicationdblocation(value: StorageCloudAzureDeduplicationdblocation[] | cdktf.IResolvable): void;
    resetDeduplicationdblocation(): void;
    get deduplicationdblocationInput(): cdktf.IResolvable | StorageCloudAzureDeduplicationdblocation[] | undefined;
    private _encryption;
    get encryption(): StorageCloudAzureEncryptionList;
    putEncryption(value: StorageCloudAzureEncryption[] | cdktf.IResolvable): void;
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | StorageCloudAzureEncryption[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudAzureMediaagentList;
    putMediaagent(value: StorageCloudAzureMediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudAzureMediaagent[] | undefined;
    private _security;
    get security(): StorageCloudAzureSecurityList;
    putSecurity(value: StorageCloudAzureSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | StorageCloudAzureSecurity[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
