import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageCloudBucketS3Config extends cdktf.TerraformMetaArguments {
    /**
    * The access type for the access path can be either read (writing to path not allowed) or read and write (writing to path allowed). [READ_AND_WRITE, READ]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#access StorageCloudBucketS3#access}
    */
    readonly access?: string;
    /**
    * Needed for AWS STS assume role and AWS STS assume role with IAM role policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#arnrole StorageCloudBucketS3#arnrole}
    */
    readonly arnrole?: string;
    /**
    * Authentication type for the cloud storage server [Access and secret keys, AWS IAM role policy, AWS STS assume role, AWS STS assume role with IAM role policy]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#authentication StorageCloudBucketS3#authentication}
    */
    readonly authentication: string;
    /**
    * Name of bucket
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#bucket StorageCloudBucketS3#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#cloudstorageid StorageCloudBucketS3#cloudstorageid}
    */
    readonly cloudstorageid: number;
    /**
    * Enable/Disable access of bucket to a media Agent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#enable StorageCloudBucketS3#enable}
    */
    readonly enable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#id StorageCloudBucketS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for proxy configuration (Should be in Base64 format)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#password StorageCloudBucketS3#password}
    */
    readonly password?: string;
    /**
    * Port for proxy configuration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#port StorageCloudBucketS3#port}
    */
    readonly port?: number;
    /**
    * If the MediaAgent accesses the mount path using a proxy then proxy server address needs to be provided. If you want to remove proxy information, pass empty string in proxyAddress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#proxyaddress StorageCloudBucketS3#proxyaddress}
    */
    readonly proxyaddress?: string;
    /**
    * IP address or fully qualified domain name or URL for the cloud library based on cloud vendor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#servicehost StorageCloudBucketS3#servicehost}
    */
    readonly servicehost: string;
    /**
    * Appropriate storage class for your account [Standard, Reduced Redundancy Storage, Standard - Infrequent access, One zone - Infrequent access, Intelligent tiering, S3 Glacier, Standard/Glacier (Combined Storage Tiers), Standard-IA/Glacier (Combined Storage Tiers), One Zone-IA/Glacier (Combined Storage Tiers), Intelligent-Tiering/Glacier (Combined Storage Tiers), S3 Glacier Deep Archive, Standard/Deep Archive (Combined Storage Tiers), Standard-IA/Deep Archive (Combined Storage Tiers), One Zone-IA/Deep Archive (Combined Storage Tiers), Intelligent-Tiering/Deep Archive (Combined Storage Tiers)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#storageclass StorageCloudBucketS3#storageclass}
    */
    readonly storageclass: string;
    /**
    * Username for proxy configuration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#username StorageCloudBucketS3#username}
    */
    readonly username?: string;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#configuration StorageCloudBucketS3#configuration}
    */
    readonly configuration?: StorageCloudBucketS3Configuration[] | cdktf.IResolvable;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#credentials StorageCloudBucketS3#credentials}
    */
    readonly credentials?: StorageCloudBucketS3Credentials[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#mediaagent StorageCloudBucketS3#mediaagent}
    */
    readonly mediaagent: StorageCloudBucketS3Mediaagent[] | cdktf.IResolvable;
}
export interface StorageCloudBucketS3ConfigurationStorageacceleratorcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#id StorageCloudBucketS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#name StorageCloudBucketS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudBucketS3ConfigurationStorageacceleratorcredentialsToTerraform(struct?: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials | cdktf.IResolvable): any;
export declare function storageCloudBucketS3ConfigurationStorageacceleratorcredentialsToHclTerraform(struct?: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials | cdktf.IResolvable): any;
export declare class StorageCloudBucketS3ConfigurationStorageacceleratorcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudBucketS3ConfigurationStorageacceleratorcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudBucketS3ConfigurationStorageacceleratorcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudBucketS3ConfigurationStorageacceleratorcredentialsOutputReference;
}
export interface StorageCloudBucketS3Configuration {
    /**
    * When true, prevents new data writes to backup location by changing number of writers to zero
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#disablebackuplocationforfuturebackups StorageCloudBucketS3#disablebackuplocationforfuturebackups}
    */
    readonly disablebackuplocationforfuturebackups?: string;
    /**
    * When true, means mount path is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#enable StorageCloudBucketS3#enable}
    */
    readonly enable?: string;
    /**
    * When true, the deduplicated blocks in the mount path will not be referenced when there are multiple mount paths in the library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#prepareforretirement StorageCloudBucketS3#prepareforretirement}
    */
    readonly prepareforretirement?: string;
    /**
    * storageacceleratorcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#storageacceleratorcredentials StorageCloudBucketS3#storageacceleratorcredentials}
    */
    readonly storageacceleratorcredentials?: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable;
}
export declare function storageCloudBucketS3ConfigurationToTerraform(struct?: StorageCloudBucketS3Configuration | cdktf.IResolvable): any;
export declare function storageCloudBucketS3ConfigurationToHclTerraform(struct?: StorageCloudBucketS3Configuration | cdktf.IResolvable): any;
export declare class StorageCloudBucketS3ConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudBucketS3Configuration | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudBucketS3Configuration | cdktf.IResolvable | undefined);
    private _disablebackuplocationforfuturebackups?;
    get disablebackuplocationforfuturebackups(): string;
    set disablebackuplocationforfuturebackups(value: string);
    resetDisablebackuplocationforfuturebackups(): void;
    get disablebackuplocationforfuturebackupsInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _prepareforretirement?;
    get prepareforretirement(): string;
    set prepareforretirement(value: string);
    resetPrepareforretirement(): void;
    get prepareforretirementInput(): string | undefined;
    private _storageacceleratorcredentials;
    get storageacceleratorcredentials(): StorageCloudBucketS3ConfigurationStorageacceleratorcredentialsList;
    putStorageacceleratorcredentials(value: StorageCloudBucketS3ConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable): void;
    resetStorageacceleratorcredentials(): void;
    get storageacceleratorcredentialsInput(): cdktf.IResolvable | StorageCloudBucketS3ConfigurationStorageacceleratorcredentials[] | undefined;
}
export declare class StorageCloudBucketS3ConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudBucketS3Configuration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudBucketS3ConfigurationOutputReference;
}
export interface StorageCloudBucketS3Credentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#id StorageCloudBucketS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#name StorageCloudBucketS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudBucketS3CredentialsToTerraform(struct?: StorageCloudBucketS3Credentials | cdktf.IResolvable): any;
export declare function storageCloudBucketS3CredentialsToHclTerraform(struct?: StorageCloudBucketS3Credentials | cdktf.IResolvable): any;
export declare class StorageCloudBucketS3CredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudBucketS3Credentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudBucketS3Credentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudBucketS3CredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudBucketS3Credentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudBucketS3CredentialsOutputReference;
}
export interface StorageCloudBucketS3Mediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#id StorageCloudBucketS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#name StorageCloudBucketS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudBucketS3MediaagentToTerraform(struct?: StorageCloudBucketS3Mediaagent | cdktf.IResolvable): any;
export declare function storageCloudBucketS3MediaagentToHclTerraform(struct?: StorageCloudBucketS3Mediaagent | cdktf.IResolvable): any;
export declare class StorageCloudBucketS3MediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudBucketS3Mediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudBucketS3Mediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudBucketS3MediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudBucketS3Mediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudBucketS3MediaagentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3 commvault_storage_cloud_bucket_s3}
*/
export declare class StorageCloudBucketS3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_cloud_bucket_s3";
    /**
    * Generates CDKTF code for importing a StorageCloudBucketS3 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageCloudBucketS3 to import
    * @param importFromId The id of the existing StorageCloudBucketS3 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageCloudBucketS3 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_bucket_s3 commvault_storage_cloud_bucket_s3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageCloudBucketS3Config
    */
    constructor(scope: Construct, id: string, config: StorageCloudBucketS3Config);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _arnrole?;
    get arnrole(): string;
    set arnrole(value: string);
    resetArnrole(): void;
    get arnroleInput(): string | undefined;
    private _authentication?;
    get authentication(): string;
    set authentication(value: string);
    get authenticationInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _cloudstorageid?;
    get cloudstorageid(): number;
    set cloudstorageid(value: number);
    get cloudstorageidInput(): number | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _proxyaddress?;
    get proxyaddress(): string;
    set proxyaddress(value: string);
    resetProxyaddress(): void;
    get proxyaddressInput(): string | undefined;
    private _servicehost?;
    get servicehost(): string;
    set servicehost(value: string);
    get servicehostInput(): string | undefined;
    private _storageclass?;
    get storageclass(): string;
    set storageclass(value: string);
    get storageclassInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _configuration;
    get configuration(): StorageCloudBucketS3ConfigurationList;
    putConfiguration(value: StorageCloudBucketS3Configuration[] | cdktf.IResolvable): void;
    resetConfiguration(): void;
    get configurationInput(): cdktf.IResolvable | StorageCloudBucketS3Configuration[] | undefined;
    private _credentials;
    get credentials(): StorageCloudBucketS3CredentialsList;
    putCredentials(value: StorageCloudBucketS3Credentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | StorageCloudBucketS3Credentials[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudBucketS3MediaagentList;
    putMediaagent(value: StorageCloudBucketS3Mediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudBucketS3Mediaagent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
