import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageContainerAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access type for the access path can be either read (writing to path not allowed) or read and write (writing to path allowed). [READ_AND_WRITE, READ]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#access StorageContainerAzure#access}
    */
    readonly access?: string;
    /**
    * Only for IAM VM and IAM AD
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#accountname StorageContainerAzure#accountname}
    */
    readonly accountname?: string;
    /**
    * Authentication type for the cloud storage server. Only Access & Account Name and IAM AD require credentials. [Access and secret keys, IAM VM role assignment, IAM AD application role assignment (Credential Manager)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#authentication StorageContainerAzure#authentication}
    */
    readonly authentication: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#cloudstorageid StorageContainerAzure#cloudstorageid}
    */
    readonly cloudstorageid: number;
    /**
    * Name of container
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#container StorageContainerAzure#container}
    */
    readonly container: string;
    /**
    * Enable/Disable access of bucket to a media Agent
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#enable StorageContainerAzure#enable}
    */
    readonly enable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#id StorageContainerAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for proxy configuration (Should be in Base64 format)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#password StorageContainerAzure#password}
    */
    readonly password?: string;
    /**
    * Port for proxy configuration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#port StorageContainerAzure#port}
    */
    readonly port?: number;
    /**
    * If the MediaAgent accesses the mount path using a proxy then proxy server address needs to be provided. If you want to remove proxy information, pass empty string in proxyAddress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#proxyaddress StorageContainerAzure#proxyaddress}
    */
    readonly proxyaddress?: string;
    /**
    * IP address or fully qualified domain name or URL for the cloud library based on cloud vendor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#servicehost StorageContainerAzure#servicehost}
    */
    readonly servicehost?: string;
    /**
    * Appropriate storage class for your account [Container's default, Hot, Cool, Archive, Hot/Archive (Combined Storage Tiers), Cool/Archive (Combined Storage Tiers)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#storageclass StorageContainerAzure#storageclass}
    */
    readonly storageclass: string;
    /**
    * Username for proxy configuration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#username StorageContainerAzure#username}
    */
    readonly username?: string;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#configuration StorageContainerAzure#configuration}
    */
    readonly configuration?: StorageContainerAzureConfiguration[] | cdktf.IResolvable;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#credentials StorageContainerAzure#credentials}
    */
    readonly credentials: StorageContainerAzureCredentials[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#mediaagent StorageContainerAzure#mediaagent}
    */
    readonly mediaagent: StorageContainerAzureMediaagent[] | cdktf.IResolvable;
}
export interface StorageContainerAzureConfigurationStorageacceleratorcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#id StorageContainerAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#name StorageContainerAzure#name}
    */
    readonly name?: string;
}
export declare function storageContainerAzureConfigurationStorageacceleratorcredentialsToTerraform(struct?: StorageContainerAzureConfigurationStorageacceleratorcredentials | cdktf.IResolvable): any;
export declare function storageContainerAzureConfigurationStorageacceleratorcredentialsToHclTerraform(struct?: StorageContainerAzureConfigurationStorageacceleratorcredentials | cdktf.IResolvable): any;
export declare class StorageContainerAzureConfigurationStorageacceleratorcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageContainerAzureConfigurationStorageacceleratorcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageContainerAzureConfigurationStorageacceleratorcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageContainerAzureConfigurationStorageacceleratorcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageContainerAzureConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageContainerAzureConfigurationStorageacceleratorcredentialsOutputReference;
}
export interface StorageContainerAzureConfiguration {
    /**
    * When true, prevents new data writes to backup location by changing number of writers to zero
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#disablebackuplocationforfuturebackups StorageContainerAzure#disablebackuplocationforfuturebackups}
    */
    readonly disablebackuplocationforfuturebackups?: string;
    /**
    * When true, means mount path is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#enable StorageContainerAzure#enable}
    */
    readonly enable?: string;
    /**
    * When true, the deduplicated blocks in the mount path will not be referenced when there are multiple mount paths in the library.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#prepareforretirement StorageContainerAzure#prepareforretirement}
    */
    readonly prepareforretirement?: string;
    /**
    * storageacceleratorcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#storageacceleratorcredentials StorageContainerAzure#storageacceleratorcredentials}
    */
    readonly storageacceleratorcredentials?: StorageContainerAzureConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable;
}
export declare function storageContainerAzureConfigurationToTerraform(struct?: StorageContainerAzureConfiguration | cdktf.IResolvable): any;
export declare function storageContainerAzureConfigurationToHclTerraform(struct?: StorageContainerAzureConfiguration | cdktf.IResolvable): any;
export declare class StorageContainerAzureConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageContainerAzureConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: StorageContainerAzureConfiguration | cdktf.IResolvable | undefined);
    private _disablebackuplocationforfuturebackups?;
    get disablebackuplocationforfuturebackups(): string;
    set disablebackuplocationforfuturebackups(value: string);
    resetDisablebackuplocationforfuturebackups(): void;
    get disablebackuplocationforfuturebackupsInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _prepareforretirement?;
    get prepareforretirement(): string;
    set prepareforretirement(value: string);
    resetPrepareforretirement(): void;
    get prepareforretirementInput(): string | undefined;
    private _storageacceleratorcredentials;
    get storageacceleratorcredentials(): StorageContainerAzureConfigurationStorageacceleratorcredentialsList;
    putStorageacceleratorcredentials(value: StorageContainerAzureConfigurationStorageacceleratorcredentials[] | cdktf.IResolvable): void;
    resetStorageacceleratorcredentials(): void;
    get storageacceleratorcredentialsInput(): cdktf.IResolvable | StorageContainerAzureConfigurationStorageacceleratorcredentials[] | undefined;
}
export declare class StorageContainerAzureConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageContainerAzureConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageContainerAzureConfigurationOutputReference;
}
export interface StorageContainerAzureCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#id StorageContainerAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#name StorageContainerAzure#name}
    */
    readonly name?: string;
}
export declare function storageContainerAzureCredentialsToTerraform(struct?: StorageContainerAzureCredentials | cdktf.IResolvable): any;
export declare function storageContainerAzureCredentialsToHclTerraform(struct?: StorageContainerAzureCredentials | cdktf.IResolvable): any;
export declare class StorageContainerAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageContainerAzureCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageContainerAzureCredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageContainerAzureCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageContainerAzureCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageContainerAzureCredentialsOutputReference;
}
export interface StorageContainerAzureMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#id StorageContainerAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#name StorageContainerAzure#name}
    */
    readonly name?: string;
}
export declare function storageContainerAzureMediaagentToTerraform(struct?: StorageContainerAzureMediaagent | cdktf.IResolvable): any;
export declare function storageContainerAzureMediaagentToHclTerraform(struct?: StorageContainerAzureMediaagent | cdktf.IResolvable): any;
export declare class StorageContainerAzureMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageContainerAzureMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageContainerAzureMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageContainerAzureMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageContainerAzureMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageContainerAzureMediaagentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure commvault_storage_container_azure}
*/
export declare class StorageContainerAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_container_azure";
    /**
    * Generates CDKTF code for importing a StorageContainerAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageContainerAzure to import
    * @param importFromId The id of the existing StorageContainerAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageContainerAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_container_azure commvault_storage_container_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageContainerAzureConfig
    */
    constructor(scope: Construct, id: string, config: StorageContainerAzureConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _accountname?;
    get accountname(): string;
    set accountname(value: string);
    resetAccountname(): void;
    get accountnameInput(): string | undefined;
    private _authentication?;
    get authentication(): string;
    set authentication(value: string);
    get authenticationInput(): string | undefined;
    private _cloudstorageid?;
    get cloudstorageid(): number;
    set cloudstorageid(value: number);
    get cloudstorageidInput(): number | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _proxyaddress?;
    get proxyaddress(): string;
    set proxyaddress(value: string);
    resetProxyaddress(): void;
    get proxyaddressInput(): string | undefined;
    private _servicehost?;
    get servicehost(): string;
    set servicehost(value: string);
    resetServicehost(): void;
    get servicehostInput(): string | undefined;
    private _storageclass?;
    get storageclass(): string;
    set storageclass(value: string);
    get storageclassInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _configuration;
    get configuration(): StorageContainerAzureConfigurationList;
    putConfiguration(value: StorageContainerAzureConfiguration[] | cdktf.IResolvable): void;
    resetConfiguration(): void;
    get configurationInput(): cdktf.IResolvable | StorageContainerAzureConfiguration[] | undefined;
    private _credentials;
    get credentials(): StorageContainerAzureCredentialsList;
    putCredentials(value: StorageContainerAzureCredentials[] | cdktf.IResolvable): void;
    get credentialsInput(): cdktf.IResolvable | StorageContainerAzureCredentials[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageContainerAzureMediaagentList;
    putMediaagent(value: StorageContainerAzureMediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageContainerAzureMediaagent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
