import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDiskBackupLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access type for the access path can be either read (writing to path not allowed) or read and write (writing to path allowed). [READ_AND_WRITE, READ]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#access StorageDiskBackupLocation#access}
    */
    readonly access?: string;
    /**
    * The mount path on the media agent where the data is to be backed up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#backuplocation StorageDiskBackupLocation#backuplocation}
    */
    readonly backuplocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#enabled StorageDiskBackupLocation#enabled}
    */
    readonly enabled?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#id StorageDiskBackupLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Id of the disk storage to update
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#storagepoolid StorageDiskBackupLocation#storagepoolid}
    */
    readonly storagepoolid: number;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#configuration StorageDiskBackupLocation#configuration}
    */
    readonly configuration?: StorageDiskBackupLocationConfiguration[] | cdktf.IResolvable;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#credentials StorageDiskBackupLocation#credentials}
    */
    readonly credentials?: StorageDiskBackupLocationCredentials[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#mediaagent StorageDiskBackupLocation#mediaagent}
    */
    readonly mediaagent: StorageDiskBackupLocationMediaagent[] | cdktf.IResolvable;
    /**
    * savedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#savedcredentials StorageDiskBackupLocation#savedcredentials}
    */
    readonly savedcredentials?: StorageDiskBackupLocationSavedcredentials[] | cdktf.IResolvable;
}
export interface StorageDiskBackupLocationConfiguration {
    /**
    * Used to determine if backup location has to be disabled or enabled for future backups
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#disablebackuplocationforfuturebackups StorageDiskBackupLocation#disablebackuplocationforfuturebackups}
    */
    readonly disablebackuplocationforfuturebackups?: string;
    /**
    * Used to enable or disable backup location
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#enablebackuplocation StorageDiskBackupLocation#enablebackuplocation}
    */
    readonly enablebackuplocation?: string;
    /**
    * Used to determine if the backup location has to be prepared for retirement
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#prepareforretirement StorageDiskBackupLocation#prepareforretirement}
    */
    readonly prepareforretirement?: string;
}
export declare function storageDiskBackupLocationConfigurationToTerraform(struct?: StorageDiskBackupLocationConfiguration | cdktf.IResolvable): any;
export declare function storageDiskBackupLocationConfigurationToHclTerraform(struct?: StorageDiskBackupLocationConfiguration | cdktf.IResolvable): any;
export declare class StorageDiskBackupLocationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskBackupLocationConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskBackupLocationConfiguration | cdktf.IResolvable | undefined);
    private _disablebackuplocationforfuturebackups?;
    get disablebackuplocationforfuturebackups(): string;
    set disablebackuplocationforfuturebackups(value: string);
    resetDisablebackuplocationforfuturebackups(): void;
    get disablebackuplocationforfuturebackupsInput(): string | undefined;
    private _enablebackuplocation?;
    get enablebackuplocation(): string;
    set enablebackuplocation(value: string);
    resetEnablebackuplocation(): void;
    get enablebackuplocationInput(): string | undefined;
    private _prepareforretirement?;
    get prepareforretirement(): string;
    set prepareforretirement(value: string);
    resetPrepareforretirement(): void;
    get prepareforretirementInput(): string | undefined;
}
export declare class StorageDiskBackupLocationConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskBackupLocationConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskBackupLocationConfigurationOutputReference;
}
export interface StorageDiskBackupLocationCredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#name StorageDiskBackupLocation#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#password StorageDiskBackupLocation#password}
    */
    readonly password?: string;
}
export declare function storageDiskBackupLocationCredentialsToTerraform(struct?: StorageDiskBackupLocationCredentials | cdktf.IResolvable): any;
export declare function storageDiskBackupLocationCredentialsToHclTerraform(struct?: StorageDiskBackupLocationCredentials | cdktf.IResolvable): any;
export declare class StorageDiskBackupLocationCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskBackupLocationCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskBackupLocationCredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class StorageDiskBackupLocationCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskBackupLocationCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskBackupLocationCredentialsOutputReference;
}
export interface StorageDiskBackupLocationMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#id StorageDiskBackupLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#name StorageDiskBackupLocation#name}
    */
    readonly name?: string;
}
export declare function storageDiskBackupLocationMediaagentToTerraform(struct?: StorageDiskBackupLocationMediaagent | cdktf.IResolvable): any;
export declare function storageDiskBackupLocationMediaagentToHclTerraform(struct?: StorageDiskBackupLocationMediaagent | cdktf.IResolvable): any;
export declare class StorageDiskBackupLocationMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskBackupLocationMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskBackupLocationMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskBackupLocationMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskBackupLocationMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskBackupLocationMediaagentOutputReference;
}
export interface StorageDiskBackupLocationSavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#id StorageDiskBackupLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#name StorageDiskBackupLocation#name}
    */
    readonly name?: string;
}
export declare function storageDiskBackupLocationSavedcredentialsToTerraform(struct?: StorageDiskBackupLocationSavedcredentials | cdktf.IResolvable): any;
export declare function storageDiskBackupLocationSavedcredentialsToHclTerraform(struct?: StorageDiskBackupLocationSavedcredentials | cdktf.IResolvable): any;
export declare class StorageDiskBackupLocationSavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskBackupLocationSavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskBackupLocationSavedcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskBackupLocationSavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskBackupLocationSavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskBackupLocationSavedcredentialsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location commvault_storage_disk_backup_location}
*/
export declare class StorageDiskBackupLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_disk_backup_location";
    /**
    * Generates CDKTF code for importing a StorageDiskBackupLocation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageDiskBackupLocation to import
    * @param importFromId The id of the existing StorageDiskBackupLocation that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageDiskBackupLocation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk_backup_location commvault_storage_disk_backup_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDiskBackupLocationConfig
    */
    constructor(scope: Construct, id: string, config: StorageDiskBackupLocationConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _backuplocation?;
    get backuplocation(): string;
    set backuplocation(value: string);
    get backuplocationInput(): string | undefined;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storagepoolid?;
    get storagepoolid(): number;
    set storagepoolid(value: number);
    get storagepoolidInput(): number | undefined;
    private _configuration;
    get configuration(): StorageDiskBackupLocationConfigurationList;
    putConfiguration(value: StorageDiskBackupLocationConfiguration[] | cdktf.IResolvable): void;
    resetConfiguration(): void;
    get configurationInput(): cdktf.IResolvable | StorageDiskBackupLocationConfiguration[] | undefined;
    private _credentials;
    get credentials(): StorageDiskBackupLocationCredentialsList;
    putCredentials(value: StorageDiskBackupLocationCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | StorageDiskBackupLocationCredentials[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageDiskBackupLocationMediaagentList;
    putMediaagent(value: StorageDiskBackupLocationMediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageDiskBackupLocationMediaagent[] | undefined;
    private _savedcredentials;
    get savedcredentials(): StorageDiskBackupLocationSavedcredentialsList;
    putSavedcredentials(value: StorageDiskBackupLocationSavedcredentials[] | cdktf.IResolvable): void;
    resetSavedcredentials(): void;
    get savedcredentialsInput(): cdktf.IResolvable | StorageDiskBackupLocationSavedcredentials[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
