import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Change the current authentication method of user. SAML user association can be removed using this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#authenticationmethod UserV2#authenticationmethod}
    */
    readonly authenticationmethod?: string;
    /**
    * Used to provide an email-id to the new user. This email-id is used for logging in the user. Please note that email ids are compulsory for company and local users and optional for external users.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#email UserV2#email}
    */
    readonly email: string;
    /**
    * enable or disable the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#enabled UserV2#enabled}
    */
    readonly enabled?: string;
    /**
    * Used to provide a name to the new user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#fullname UserV2#fullname}
    */
    readonly fullname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#id UserV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User will receive an email to install backup software package on their device if this is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#inviteuser UserV2#inviteuser}
    */
    readonly inviteuser?: string;
    /**
    * Used to provide the new user with a username. This username can be used for logging in the user instead of email-id when duplicate email-ids are present. For external user, it is necessary to provide the domain name along with the username (domainName\\username). To create a company user, the company id or name needs to be provided in the company entity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#name UserV2#name}
    */
    readonly name?: string;
    /**
    * Used to provide a password to the user being created. This will be accepted when the useSystemGeneratePassword tag is false. The password has to be provided in Base64 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#password UserV2#password}
    */
    readonly password?: string;
    /**
    * Change User Principal Name(UPN) for existing user. This User Principal Name can be used for logging-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#userprincipalname UserV2#userprincipalname}
    */
    readonly userprincipalname?: string;
    /**
    * Choose to provide a system generated password to the user instead of providing your own password. An email will be sent to the user to reset the password. If it is set to true, password tag need not be provided. If it is set to false, password needs to be provided in the password tag in Base64 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#usesystemgeneratepassword UserV2#usesystemgeneratepassword}
    */
    readonly usesystemgeneratepassword?: string;
    /**
    * company block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#company UserV2#company}
    */
    readonly company?: UserV2Company[] | cdktf.IResolvable;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#plan UserV2#plan}
    */
    readonly plan?: UserV2Plan[] | cdktf.IResolvable;
}
export interface UserV2Company {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#id UserV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#name UserV2#name}
    */
    readonly name?: string;
}
export declare function userV2CompanyToTerraform(struct?: UserV2Company | cdktf.IResolvable): any;
export declare function userV2CompanyToHclTerraform(struct?: UserV2Company | cdktf.IResolvable): any;
export declare class UserV2CompanyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserV2Company | cdktf.IResolvable | undefined;
    set internalValue(value: UserV2Company | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class UserV2CompanyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserV2Company[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserV2CompanyOutputReference;
}
export interface UserV2Plan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#id UserV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#name UserV2#name}
    */
    readonly name?: string;
}
export declare function userV2PlanToTerraform(struct?: UserV2Plan | cdktf.IResolvable): any;
export declare function userV2PlanToHclTerraform(struct?: UserV2Plan | cdktf.IResolvable): any;
export declare class UserV2PlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserV2Plan | cdktf.IResolvable | undefined;
    set internalValue(value: UserV2Plan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class UserV2PlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserV2Plan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserV2PlanOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2 commvault_user_v2}
*/
export declare class UserV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_user_v2";
    /**
    * Generates CDKTF code for importing a UserV2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the UserV2 to import
    * @param importFromId The id of the existing UserV2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the UserV2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/user_v2 commvault_user_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserV2Config
    */
    constructor(scope: Construct, id: string, config: UserV2Config);
    private _authenticationmethod?;
    get authenticationmethod(): string;
    set authenticationmethod(value: string);
    resetAuthenticationmethod(): void;
    get authenticationmethodInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _fullname?;
    get fullname(): string;
    set fullname(value: string);
    resetFullname(): void;
    get fullnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inviteuser?;
    get inviteuser(): string;
    set inviteuser(value: string);
    resetInviteuser(): void;
    get inviteuserInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _userprincipalname?;
    get userprincipalname(): string;
    set userprincipalname(value: string);
    resetUserprincipalname(): void;
    get userprincipalnameInput(): string | undefined;
    private _usesystemgeneratepassword?;
    get usesystemgeneratepassword(): string;
    set usesystemgeneratepassword(value: string);
    resetUsesystemgeneratepassword(): void;
    get usesystemgeneratepasswordInput(): string | undefined;
    private _company;
    get company(): UserV2CompanyList;
    putCompany(value: UserV2Company[] | cdktf.IResolvable): void;
    resetCompany(): void;
    get companyInput(): cdktf.IResolvable | UserV2Company[] | undefined;
    private _plan;
    get plan(): UserV2PlanList;
    putPlan(value: UserV2Plan[] | cdktf.IResolvable): void;
    resetPlan(): void;
    get planInput(): cdktf.IResolvable | UserV2Plan[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
