import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UsergroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * This property can be used to allow addition of users/groups from child companies. Only applicable for commcell and reseller company group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#allowmultiplecompanymembers Usergroup#allowmultiplecompanymembers}
    */
    readonly allowmultiplecompanymembers?: string;
    /**
    * Azure Object ID used to link this user group to Azure AD group and manage group membership of the user during SAML login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#azureguid Usergroup#azureguid}
    */
    readonly azureguid?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#description Usergroup#description}
    */
    readonly description?: string;
    /**
    * Option to not inherit the RestrictConsoleTypes from the parent. By default the value is false, parent RestrictConsoleTypes will be inherited.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#donotinheritrestrictconsoletypes Usergroup#donotinheritrestrictconsoletypes}
    */
    readonly donotinheritrestrictconsoletypes?: string;
    /**
    * allows the enabling/disabling of the user group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#enabled Usergroup#enabled}
    */
    readonly enabled?: string;
    /**
    * Allows two-factor authentication to be enabled for the specific types of usergroups. it can be turned on or off based on user preferences. There will be usergroups that will not have this option. [ON, OFF, DISABLED_AT_COMPANY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#enablelocalauthentication Usergroup#enablelocalauthentication}
    */
    readonly enablelocalauthentication?: string;
    /**
    * Allows two-factor authentication to be enabled for the specific types of usergroups. it can be turned on or off based on user preferences. There will be usergroups that will not have this option. [ON, OFF, DISABLED_AT_COMPANY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#enabletwofactorauthentication Usergroup#enabletwofactorauthentication}
    */
    readonly enabletwofactorauthentication?: string;
    /**
    * Used to determine if a backup data limit will be set for the user group being created
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#enforcefsquota Usergroup#enforcefsquota}
    */
    readonly enforcefsquota?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#id Usergroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When set to true, users in this group cannot activate or be set as server owner
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#laptopadmins Usergroup#laptopadmins}
    */
    readonly laptopadmins?: string;
    /**
    * To create an active directory usergroup, the domain name should be mentioned along with the usergroup name (domainName\\usergroupName) and localUserGroup value must be given.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#name Usergroup#name}
    */
    readonly name: string;
    /**
    * determines if an existing user has to be added to the user group or removed from the user group [ADD, DELETE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#planoperationtype Usergroup#planoperationtype}
    */
    readonly planoperationtype?: string;
    /**
    * if enforceFSQuota is set to true, the quota limit can be set in GBs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#quotalimitingb Usergroup#quotalimitingb}
    */
    readonly quotalimitingb?: number;
    /**
    * associatedexternalgroups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#associatedexternalgroups Usergroup#associatedexternalgroups}
    */
    readonly associatedexternalgroups?: UsergroupAssociatedexternalgroups[] | cdktf.IResolvable;
    /**
    * restrictconsoletypes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#restrictconsoletypes Usergroup#restrictconsoletypes}
    */
    readonly restrictconsoletypes?: UsergroupRestrictconsoletypes[] | cdktf.IResolvable;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#users Usergroup#users}
    */
    readonly users?: UsergroupUsers[] | cdktf.IResolvable;
}
export interface UsergroupAssociatedexternalgroups {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#id Usergroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function usergroupAssociatedexternalgroupsToTerraform(struct?: UsergroupAssociatedexternalgroups | cdktf.IResolvable): any;
export declare function usergroupAssociatedexternalgroupsToHclTerraform(struct?: UsergroupAssociatedexternalgroups | cdktf.IResolvable): any;
export declare class UsergroupAssociatedexternalgroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UsergroupAssociatedexternalgroups | cdktf.IResolvable | undefined;
    set internalValue(value: UsergroupAssociatedexternalgroups | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class UsergroupAssociatedexternalgroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UsergroupAssociatedexternalgroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UsergroupAssociatedexternalgroupsOutputReference;
}
export interface UsergroupRestrictconsoletypes {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#consoletype Usergroup#consoletype}
    */
    readonly consoletype?: string[];
}
export declare function usergroupRestrictconsoletypesToTerraform(struct?: UsergroupRestrictconsoletypes | cdktf.IResolvable): any;
export declare function usergroupRestrictconsoletypesToHclTerraform(struct?: UsergroupRestrictconsoletypes | cdktf.IResolvable): any;
export declare class UsergroupRestrictconsoletypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UsergroupRestrictconsoletypes | cdktf.IResolvable | undefined;
    set internalValue(value: UsergroupRestrictconsoletypes | cdktf.IResolvable | undefined);
    private _consoletype?;
    get consoletype(): string[];
    set consoletype(value: string[]);
    resetConsoletype(): void;
    get consoletypeInput(): string[] | undefined;
}
export declare class UsergroupRestrictconsoletypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UsergroupRestrictconsoletypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UsergroupRestrictconsoletypesOutputReference;
}
export interface UsergroupUsers {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#id Usergroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function usergroupUsersToTerraform(struct?: UsergroupUsers | cdktf.IResolvable): any;
export declare function usergroupUsersToHclTerraform(struct?: UsergroupUsers | cdktf.IResolvable): any;
export declare class UsergroupUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UsergroupUsers | cdktf.IResolvable | undefined;
    set internalValue(value: UsergroupUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class UsergroupUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UsergroupUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UsergroupUsersOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup commvault_usergroup}
*/
export declare class Usergroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_usergroup";
    /**
    * Generates CDKTF code for importing a Usergroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Usergroup to import
    * @param importFromId The id of the existing Usergroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Usergroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/usergroup commvault_usergroup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UsergroupConfig
    */
    constructor(scope: Construct, id: string, config: UsergroupConfig);
    private _allowmultiplecompanymembers?;
    get allowmultiplecompanymembers(): string;
    set allowmultiplecompanymembers(value: string);
    resetAllowmultiplecompanymembers(): void;
    get allowmultiplecompanymembersInput(): string | undefined;
    private _azureguid?;
    get azureguid(): string;
    set azureguid(value: string);
    resetAzureguid(): void;
    get azureguidInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _donotinheritrestrictconsoletypes?;
    get donotinheritrestrictconsoletypes(): string;
    set donotinheritrestrictconsoletypes(value: string);
    resetDonotinheritrestrictconsoletypes(): void;
    get donotinheritrestrictconsoletypesInput(): string | undefined;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _enablelocalauthentication?;
    get enablelocalauthentication(): string;
    set enablelocalauthentication(value: string);
    resetEnablelocalauthentication(): void;
    get enablelocalauthenticationInput(): string | undefined;
    private _enabletwofactorauthentication?;
    get enabletwofactorauthentication(): string;
    set enabletwofactorauthentication(value: string);
    resetEnabletwofactorauthentication(): void;
    get enabletwofactorauthenticationInput(): string | undefined;
    private _enforcefsquota?;
    get enforcefsquota(): string;
    set enforcefsquota(value: string);
    resetEnforcefsquota(): void;
    get enforcefsquotaInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _laptopadmins?;
    get laptopadmins(): string;
    set laptopadmins(value: string);
    resetLaptopadmins(): void;
    get laptopadminsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _planoperationtype?;
    get planoperationtype(): string;
    set planoperationtype(value: string);
    resetPlanoperationtype(): void;
    get planoperationtypeInput(): string | undefined;
    private _quotalimitingb?;
    get quotalimitingb(): number;
    set quotalimitingb(value: number);
    resetQuotalimitingb(): void;
    get quotalimitingbInput(): number | undefined;
    private _associatedexternalgroups;
    get associatedexternalgroups(): UsergroupAssociatedexternalgroupsList;
    putAssociatedexternalgroups(value: UsergroupAssociatedexternalgroups[] | cdktf.IResolvable): void;
    resetAssociatedexternalgroups(): void;
    get associatedexternalgroupsInput(): cdktf.IResolvable | UsergroupAssociatedexternalgroups[] | undefined;
    private _restrictconsoletypes;
    get restrictconsoletypes(): UsergroupRestrictconsoletypesList;
    putRestrictconsoletypes(value: UsergroupRestrictconsoletypes[] | cdktf.IResolvable): void;
    resetRestrictconsoletypes(): void;
    get restrictconsoletypesInput(): cdktf.IResolvable | UsergroupRestrictconsoletypes[] | undefined;
    private _users;
    get users(): UsergroupUsersList;
    putUsers(value: UsergroupUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | UsergroupUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
