import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies The ID of the hypervisor client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#client_id VmGroup#client_id}
    */
    readonly clientId: number;
    /**
    * Specifies the company id to which the vm group should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#company_id VmGroup#company_id}
    */
    readonly companyId?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#id VmGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies The ID of the plan that you want to associate with the VM group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#plan_id VmGroup#plan_id}
    */
    readonly planId: number;
    /**
    * Specifies The Tags that you want to back up in a VM group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#tags VmGroup#tags}
    */
    readonly tags?: string[];
    /**
    * Specifies The name of the VM group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#vm_group_name VmGroup#vm_group_name}
    */
    readonly vmGroupName: string;
    /**
    * Specifies The VMs that you want to back up in a VM group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#vms VmGroup#vms}
    */
    readonly vms?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group commvault_vm_group}
*/
export declare class VmGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_vm_group";
    /**
    * Generates CDKTF code for importing a VmGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmGroup to import
    * @param importFromId The id of the existing VmGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vm_group commvault_vm_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmGroupConfig
    */
    constructor(scope: Construct, id: string, config: VmGroupConfig);
    private _clientId?;
    get clientId(): number;
    set clientId(value: number);
    get clientIdInput(): number | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _planId?;
    get planId(): number;
    set planId(value: number);
    get planIdInput(): number | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _vmGroupName?;
    get vmGroupName(): string;
    set vmGroupName(value: string);
    get vmGroupNameInput(): string | undefined;
    private _vms?;
    get vms(): string[];
    set vms(value: string[]);
    resetVms(): void;
    get vmsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
