import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmgroupV2Config extends cdktf.TerraformMetaArguments {
    /**
    * True if file indexing needs to be enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablefileindexing VmgroupV2#enablefileindexing}
    */
    readonly enablefileindexing?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * subclient name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name: string;
    /**
    * accessnode block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#accessnode VmgroupV2#accessnode}
    */
    readonly accessnode?: VmgroupV2Accessnode[] | cdktf.IResolvable;
    /**
    * activitycontrol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitycontrol VmgroupV2#activitycontrol}
    */
    readonly activitycontrol?: VmgroupV2Activitycontrol[] | cdktf.IResolvable;
    /**
    * applicationvalidation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#applicationvalidation VmgroupV2#applicationvalidation}
    */
    readonly applicationvalidation?: VmgroupV2Applicationvalidation[] | cdktf.IResolvable;
    /**
    * content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#content VmgroupV2#content}
    */
    readonly content: VmgroupV2Content[] | cdktf.IResolvable;
    /**
    * diskfilters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#diskfilters VmgroupV2#diskfilters}
    */
    readonly diskfilters?: VmgroupV2Diskfilters[] | cdktf.IResolvable;
    /**
    * filters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filters VmgroupV2#filters}
    */
    readonly filters?: VmgroupV2Filters[] | cdktf.IResolvable;
    /**
    * hypervisor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#hypervisor VmgroupV2#hypervisor}
    */
    readonly hypervisor: VmgroupV2Hypervisor[] | cdktf.IResolvable;
    /**
    * meditech block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditech VmgroupV2#meditech}
    */
    readonly meditech?: VmgroupV2Meditech[] | cdktf.IResolvable;
    /**
    * meditechsystems block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditechsystems VmgroupV2#meditechsystems}
    */
    readonly meditechsystems?: VmgroupV2Meditechsystems[] | cdktf.IResolvable;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#plan VmgroupV2#plan}
    */
    readonly plan: VmgroupV2Plan[] | cdktf.IResolvable;
    /**
    * securityassociations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#securityassociations VmgroupV2#securityassociations}
    */
    readonly securityassociations?: VmgroupV2Securityassociations[] | cdktf.IResolvable;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#settings VmgroupV2#settings}
    */
    readonly settings?: VmgroupV2Settings[] | cdktf.IResolvable;
    /**
    * snapshotmanagement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapshotmanagement VmgroupV2#snapshotmanagement}
    */
    readonly snapshotmanagement?: VmgroupV2Snapshotmanagement[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#storage VmgroupV2#storage}
    */
    readonly storage?: VmgroupV2Storage[] | cdktf.IResolvable;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
    */
    readonly timezone?: VmgroupV2Timezone[] | cdktf.IResolvable;
}
export interface VmgroupV2Accessnode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function vmgroupV2AccessnodeToTerraform(struct?: VmgroupV2Accessnode | cdktf.IResolvable): any;
export declare function vmgroupV2AccessnodeToHclTerraform(struct?: VmgroupV2Accessnode | cdktf.IResolvable): any;
export declare class VmgroupV2AccessnodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Accessnode | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Accessnode | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class VmgroupV2AccessnodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Accessnode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2AccessnodeOutputReference;
}
export interface VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
    */
    readonly timezone?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeToTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeToHclTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference;
}
export interface VmgroupV2ActivitycontrolBackupactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
    */
    readonly delaytime?: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsToTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolBackupactivitycontroloptionsToHclTerraform(struct?: VmgroupV2ActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList;
    putDelaytime(value: VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime[] | undefined;
}
export declare class VmgroupV2ActivitycontrolBackupactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference;
}
export interface VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
    */
    readonly timezone?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeToTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeToHclTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference;
}
export interface VmgroupV2ActivitycontrolRestoreactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
    */
    readonly delaytime?: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsToTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolRestoreactivitycontroloptionsToHclTerraform(struct?: VmgroupV2ActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList;
    putDelaytime(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime[] | undefined;
}
export declare class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference;
}
export interface VmgroupV2Activitycontrol {
    /**
    * true if Backup is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablebackup VmgroupV2#enablebackup}
    */
    readonly enablebackup?: string;
    /**
    * true if Restore is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablerestore VmgroupV2#enablerestore}
    */
    readonly enablerestore?: string;
    /**
    * backupactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupactivitycontroloptions VmgroupV2#backupactivitycontroloptions}
    */
    readonly backupactivitycontroloptions?: VmgroupV2ActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * restoreactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#restoreactivitycontroloptions VmgroupV2#restoreactivitycontroloptions}
    */
    readonly restoreactivitycontroloptions?: VmgroupV2ActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
}
export declare function vmgroupV2ActivitycontrolToTerraform(struct?: VmgroupV2Activitycontrol | cdktf.IResolvable): any;
export declare function vmgroupV2ActivitycontrolToHclTerraform(struct?: VmgroupV2Activitycontrol | cdktf.IResolvable): any;
export declare class VmgroupV2ActivitycontrolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Activitycontrol | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Activitycontrol | cdktf.IResolvable | undefined);
    private _enablebackup?;
    get enablebackup(): string;
    set enablebackup(value: string);
    resetEnablebackup(): void;
    get enablebackupInput(): string | undefined;
    private _enablerestore?;
    get enablerestore(): string;
    set enablerestore(value: string);
    resetEnablerestore(): void;
    get enablerestoreInput(): string | undefined;
    private _backupactivitycontroloptions;
    get backupactivitycontroloptions(): VmgroupV2ActivitycontrolBackupactivitycontroloptionsList;
    putBackupactivitycontroloptions(value: VmgroupV2ActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable): void;
    resetBackupactivitycontroloptions(): void;
    get backupactivitycontroloptionsInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolBackupactivitycontroloptions[] | undefined;
    private _restoreactivitycontroloptions;
    get restoreactivitycontroloptions(): VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList;
    putRestoreactivitycontroloptions(value: VmgroupV2ActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable): void;
    resetRestoreactivitycontroloptions(): void;
    get restoreactivitycontroloptionsInput(): cdktf.IResolvable | VmgroupV2ActivitycontrolRestoreactivitycontroloptions[] | undefined;
}
export declare class VmgroupV2ActivitycontrolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Activitycontrol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ActivitycontrolOutputReference;
}
export interface VmgroupV2ApplicationvalidationCopyBackupdestination {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ApplicationvalidationCopyBackupdestinationToTerraform(struct?: VmgroupV2ApplicationvalidationCopyBackupdestination | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCopyBackupdestinationToHclTerraform(struct?: VmgroupV2ApplicationvalidationCopyBackupdestination | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCopyBackupdestination | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCopyBackupdestination | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationCopyBackupdestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCopyBackupdestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference;
}
export interface VmgroupV2ApplicationvalidationCopy {
    /**
    * Order of backup destinaion copy created in storage policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copyprecedence VmgroupV2#copyprecedence}
    */
    readonly copyprecedence?: number;
    /**
    * Id of the source copy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Is this an active backup destination?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isactive VmgroupV2#isactive}
    */
    readonly isactive?: string;
    /**
    * Is this a snap copy?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#issnapcopy VmgroupV2#issnapcopy}
    */
    readonly issnapcopy?: string;
    /**
    * Name of the source copy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * backupdestination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupdestination VmgroupV2#backupdestination}
    */
    readonly backupdestination?: VmgroupV2ApplicationvalidationCopyBackupdestination[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationCopyToTerraform(struct?: VmgroupV2ApplicationvalidationCopy | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCopyToHclTerraform(struct?: VmgroupV2ApplicationvalidationCopy | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCopy | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCopy | cdktf.IResolvable | undefined);
    private _copyprecedence?;
    get copyprecedence(): number;
    set copyprecedence(value: number);
    resetCopyprecedence(): void;
    get copyprecedenceInput(): number | undefined;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _isactive?;
    get isactive(): string;
    set isactive(value: string);
    resetIsactive(): void;
    get isactiveInput(): string | undefined;
    private _issnapcopy?;
    get issnapcopy(): string;
    set issnapcopy(value: string);
    resetIssnapcopy(): void;
    get issnapcopyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _backupdestination;
    get backupdestination(): VmgroupV2ApplicationvalidationCopyBackupdestinationList;
    putBackupdestination(value: VmgroupV2ApplicationvalidationCopyBackupdestination[] | cdktf.IResolvable): void;
    resetBackupdestination(): void;
    get backupdestinationInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCopyBackupdestination[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationCopyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCopy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCopyOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptUnix {
    /**
    * Arguments for the script
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
    */
    readonly arguments?: string;
    /**
    * Is the script disabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
    */
    readonly isdisabled?: string;
    /**
    * True if the script is local
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
    */
    readonly islocal?: string;
    /**
    * Path for the validation script
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
    */
    readonly path?: string;
    /**
    * unccredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
    */
    readonly unccredentials?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials[] | cdktf.IResolvable;
    /**
    * uncsavedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
    */
    readonly uncsavedcredentials?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptUnixToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnix | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix | cdktf.IResolvable | undefined);
    private _arguments?;
    get arguments(): string;
    set arguments(value: string);
    resetArguments(): void;
    get argumentsInput(): string | undefined;
    private _isdisabled?;
    get isdisabled(): string;
    set isdisabled(value: string);
    resetIsdisabled(): void;
    get isdisabledInput(): string | undefined;
    private _islocal?;
    get islocal(): string;
    set islocal(value: string);
    resetIslocal(): void;
    get islocalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _unccredentials;
    get unccredentials(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList;
    putUnccredentials(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials[] | cdktf.IResolvable): void;
    resetUnccredentials(): void;
    get unccredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials[] | undefined;
    private _uncsavedcredentials;
    get uncsavedcredentials(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList;
    putUncsavedcredentials(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials[] | cdktf.IResolvable): void;
    resetUncsavedcredentials(): void;
    get uncsavedcredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscriptWindows {
    /**
    * Arguments for the script
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
    */
    readonly arguments?: string;
    /**
    * Is the script disabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
    */
    readonly isdisabled?: string;
    /**
    * True if the script is local
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
    */
    readonly islocal?: string;
    /**
    * Path for the validation script
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
    */
    readonly path?: string;
    /**
    * unccredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
    */
    readonly unccredentials?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials[] | cdktf.IResolvable;
    /**
    * uncsavedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
    */
    readonly uncsavedcredentials?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptWindowsToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindows | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows | cdktf.IResolvable | undefined);
    private _arguments?;
    get arguments(): string;
    set arguments(value: string);
    resetArguments(): void;
    get argumentsInput(): string | undefined;
    private _isdisabled?;
    get isdisabled(): string;
    set isdisabled(value: string);
    resetIsdisabled(): void;
    get isdisabledInput(): string | undefined;
    private _islocal?;
    get islocal(): string;
    set islocal(value: string);
    resetIslocal(): void;
    get islocalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _unccredentials;
    get unccredentials(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList;
    putUnccredentials(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials[] | cdktf.IResolvable): void;
    resetUnccredentials(): void;
    get unccredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials[] | undefined;
    private _uncsavedcredentials;
    get uncsavedcredentials(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList;
    putUncsavedcredentials(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials[] | cdktf.IResolvable): void;
    resetUncsavedcredentials(): void;
    get uncsavedcredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference;
}
export interface VmgroupV2ApplicationvalidationCustomvalidationscript {
    /**
    * unix block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unix VmgroupV2#unix}
    */
    readonly unix?: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix[] | cdktf.IResolvable;
    /**
    * windows block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#windows VmgroupV2#windows}
    */
    readonly windows?: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptToTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscript | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationCustomvalidationscriptToHclTerraform(struct?: VmgroupV2ApplicationvalidationCustomvalidationscript | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationCustomvalidationscript | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationCustomvalidationscript | cdktf.IResolvable | undefined);
    private _unix;
    get unix(): VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList;
    putUnix(value: VmgroupV2ApplicationvalidationCustomvalidationscriptUnix[] | cdktf.IResolvable): void;
    resetUnix(): void;
    get unixInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptUnix[] | undefined;
    private _windows;
    get windows(): VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList;
    putWindows(value: VmgroupV2ApplicationvalidationCustomvalidationscriptWindows[] | cdktf.IResolvable): void;
    resetWindows(): void;
    get windowsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscriptWindows[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationCustomvalidationscriptList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationCustomvalidationscript[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference;
}
export interface VmgroupV2ApplicationvalidationGuestcredentialsCredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2ApplicationvalidationGuestcredentialsCredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentialsCredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationGuestcredentialsCredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentialsCredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationGuestcredentialsCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationGuestcredentialsCredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationGuestcredentialsCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationGuestcredentials {
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
    */
    readonly credentials?: VmgroupV2ApplicationvalidationGuestcredentialsCredentials[] | cdktf.IResolvable;
    /**
    * savedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
    */
    readonly savedcredentials?: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationGuestcredentialsToTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationGuestcredentialsToHclTerraform(struct?: VmgroupV2ApplicationvalidationGuestcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationGuestcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationGuestcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationGuestcredentials | cdktf.IResolvable | undefined);
    private _credentials;
    get credentials(): VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList;
    putCredentials(value: VmgroupV2ApplicationvalidationGuestcredentialsCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationGuestcredentialsCredentials[] | undefined;
    private _savedcredentials;
    get savedcredentials(): VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList;
    putSavedcredentials(value: VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials[] | cdktf.IResolvable): void;
    resetSavedcredentials(): void;
    get savedcredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationGuestcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationGuestcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationGuestcredentialsOutputReference;
}
export interface VmgroupV2ApplicationvalidationRecoverytarget {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2ApplicationvalidationRecoverytargetToTerraform(struct?: VmgroupV2ApplicationvalidationRecoverytarget | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationRecoverytargetToHclTerraform(struct?: VmgroupV2ApplicationvalidationRecoverytarget | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationRecoverytargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationRecoverytarget | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationRecoverytarget | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2ApplicationvalidationRecoverytargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationRecoverytarget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationRecoverytargetOutputReference;
}
export interface VmgroupV2ApplicationvalidationSchedule {
    /**
    * Description for validation schedule
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#description VmgroupV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * True if application validation schedule is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isscheduleenabled VmgroupV2#isscheduleenabled}
    */
    readonly isscheduleenabled?: string;
    /**
    * Job Id for the application validation task. 0 if schedule is disabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#taskid VmgroupV2#taskid}
    */
    readonly taskid?: number;
}
export declare function vmgroupV2ApplicationvalidationScheduleToTerraform(struct?: VmgroupV2ApplicationvalidationSchedule | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationScheduleToHclTerraform(struct?: VmgroupV2ApplicationvalidationSchedule | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ApplicationvalidationSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ApplicationvalidationSchedule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _isscheduleenabled?;
    get isscheduleenabled(): string;
    set isscheduleenabled(value: string);
    resetIsscheduleenabled(): void;
    get isscheduleenabledInput(): string | undefined;
    private _taskid?;
    get taskid(): number;
    set taskid(value: number);
    resetTaskid(): void;
    get taskidInput(): number | undefined;
}
export declare class VmgroupV2ApplicationvalidationScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ApplicationvalidationSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationScheduleOutputReference;
}
export interface VmgroupV2Applicationvalidation {
    /**
    * If true then validated VMs will be available until expiration time set on the recovery target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#keepvalidatedvmsrunning VmgroupV2#keepvalidatedvmsrunning}
    */
    readonly keepvalidatedvmsrunning?: string;
    /**
    * Number of backup Validation Threads
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#maximumnoofthreads VmgroupV2#maximumnoofthreads}
    */
    readonly maximumnoofthreads?: number;
    /**
    * Use Source VM ESX To Mount
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usesourcevmesxtomount VmgroupV2#usesourcevmesxtomount}
    */
    readonly usesourcevmesxtomount?: string;
    /**
    * True if VM Backup validation is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#validatevmbackups VmgroupV2#validatevmbackups}
    */
    readonly validatevmbackups?: string;
    /**
    * copy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copy VmgroupV2#copy}
    */
    readonly copy?: VmgroupV2ApplicationvalidationCopy[] | cdktf.IResolvable;
    /**
    * customvalidationscript block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customvalidationscript VmgroupV2#customvalidationscript}
    */
    readonly customvalidationscript?: VmgroupV2ApplicationvalidationCustomvalidationscript[] | cdktf.IResolvable;
    /**
    * guestcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
    */
    readonly guestcredentials?: VmgroupV2ApplicationvalidationGuestcredentials[] | cdktf.IResolvable;
    /**
    * recoverytarget block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#recoverytarget VmgroupV2#recoverytarget}
    */
    readonly recoverytarget?: VmgroupV2ApplicationvalidationRecoverytarget[] | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#schedule VmgroupV2#schedule}
    */
    readonly schedule?: VmgroupV2ApplicationvalidationSchedule[] | cdktf.IResolvable;
}
export declare function vmgroupV2ApplicationvalidationToTerraform(struct?: VmgroupV2Applicationvalidation | cdktf.IResolvable): any;
export declare function vmgroupV2ApplicationvalidationToHclTerraform(struct?: VmgroupV2Applicationvalidation | cdktf.IResolvable): any;
export declare class VmgroupV2ApplicationvalidationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Applicationvalidation | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Applicationvalidation | cdktf.IResolvable | undefined);
    private _keepvalidatedvmsrunning?;
    get keepvalidatedvmsrunning(): string;
    set keepvalidatedvmsrunning(value: string);
    resetKeepvalidatedvmsrunning(): void;
    get keepvalidatedvmsrunningInput(): string | undefined;
    private _maximumnoofthreads?;
    get maximumnoofthreads(): number;
    set maximumnoofthreads(value: number);
    resetMaximumnoofthreads(): void;
    get maximumnoofthreadsInput(): number | undefined;
    private _usesourcevmesxtomount?;
    get usesourcevmesxtomount(): string;
    set usesourcevmesxtomount(value: string);
    resetUsesourcevmesxtomount(): void;
    get usesourcevmesxtomountInput(): string | undefined;
    private _validatevmbackups?;
    get validatevmbackups(): string;
    set validatevmbackups(value: string);
    resetValidatevmbackups(): void;
    get validatevmbackupsInput(): string | undefined;
    private _copy;
    get copy(): VmgroupV2ApplicationvalidationCopyList;
    putCopy(value: VmgroupV2ApplicationvalidationCopy[] | cdktf.IResolvable): void;
    resetCopy(): void;
    get copyInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCopy[] | undefined;
    private _customvalidationscript;
    get customvalidationscript(): VmgroupV2ApplicationvalidationCustomvalidationscriptList;
    putCustomvalidationscript(value: VmgroupV2ApplicationvalidationCustomvalidationscript[] | cdktf.IResolvable): void;
    resetCustomvalidationscript(): void;
    get customvalidationscriptInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationCustomvalidationscript[] | undefined;
    private _guestcredentials;
    get guestcredentials(): VmgroupV2ApplicationvalidationGuestcredentialsList;
    putGuestcredentials(value: VmgroupV2ApplicationvalidationGuestcredentials[] | cdktf.IResolvable): void;
    resetGuestcredentials(): void;
    get guestcredentialsInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationGuestcredentials[] | undefined;
    private _recoverytarget;
    get recoverytarget(): VmgroupV2ApplicationvalidationRecoverytargetList;
    putRecoverytarget(value: VmgroupV2ApplicationvalidationRecoverytarget[] | cdktf.IResolvable): void;
    resetRecoverytarget(): void;
    get recoverytargetInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationRecoverytarget[] | undefined;
    private _schedule;
    get schedule(): VmgroupV2ApplicationvalidationScheduleList;
    putSchedule(value: VmgroupV2ApplicationvalidationSchedule[] | cdktf.IResolvable): void;
    resetSchedule(): void;
    get scheduleInput(): cdktf.IResolvable | VmgroupV2ApplicationvalidationSchedule[] | undefined;
}
export declare class VmgroupV2ApplicationvalidationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Applicationvalidation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ApplicationvalidationOutputReference;
}
export interface VmgroupV2ContentRulegroupsRules {
    /**
    * Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
    */
    readonly condition?: string;
    /**
    * name of the VM to be added as content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * [NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
    */
    readonly type?: string;
}
export declare function vmgroupV2ContentRulegroupsRulesToTerraform(struct?: VmgroupV2ContentRulegroupsRules | cdktf.IResolvable): any;
export declare function vmgroupV2ContentRulegroupsRulesToHclTerraform(struct?: VmgroupV2ContentRulegroupsRules | cdktf.IResolvable): any;
export declare class VmgroupV2ContentRulegroupsRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ContentRulegroupsRules | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ContentRulegroupsRules | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class VmgroupV2ContentRulegroupsRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ContentRulegroupsRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ContentRulegroupsRulesOutputReference;
}
export interface VmgroupV2ContentRulegroups {
    /**
    * Enum which specifies the whether to match all rules or any of the rules [ALL, ANY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
    */
    readonly matchrule?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
    */
    readonly rules?: VmgroupV2ContentRulegroupsRules[] | cdktf.IResolvable;
}
export declare function vmgroupV2ContentRulegroupsToTerraform(struct?: VmgroupV2ContentRulegroups | cdktf.IResolvable): any;
export declare function vmgroupV2ContentRulegroupsToHclTerraform(struct?: VmgroupV2ContentRulegroups | cdktf.IResolvable): any;
export declare class VmgroupV2ContentRulegroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2ContentRulegroups | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2ContentRulegroups | cdktf.IResolvable | undefined);
    private _matchrule?;
    get matchrule(): string;
    set matchrule(value: string);
    resetMatchrule(): void;
    get matchruleInput(): string | undefined;
    private _rules;
    get rules(): VmgroupV2ContentRulegroupsRulesList;
    putRules(value: VmgroupV2ContentRulegroupsRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | VmgroupV2ContentRulegroupsRules[] | undefined;
}
export declare class VmgroupV2ContentRulegroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2ContentRulegroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ContentRulegroupsOutputReference;
}
export interface VmgroupV2Content {
    /**
    * True if content in vmgroup has to be overwritten, by default it will append the content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
    */
    readonly overwrite?: string;
    /**
    * rulegroups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
    */
    readonly rulegroups?: VmgroupV2ContentRulegroups[] | cdktf.IResolvable;
}
export declare function vmgroupV2ContentToTerraform(struct?: VmgroupV2Content | cdktf.IResolvable): any;
export declare function vmgroupV2ContentToHclTerraform(struct?: VmgroupV2Content | cdktf.IResolvable): any;
export declare class VmgroupV2ContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Content | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Content | cdktf.IResolvable | undefined);
    private _overwrite?;
    get overwrite(): string;
    set overwrite(value: string);
    resetOverwrite(): void;
    get overwriteInput(): string | undefined;
    private _rulegroups;
    get rulegroups(): VmgroupV2ContentRulegroupsList;
    putRulegroups(value: VmgroupV2ContentRulegroups[] | cdktf.IResolvable): void;
    resetRulegroups(): void;
    get rulegroupsInput(): cdktf.IResolvable | VmgroupV2ContentRulegroups[] | undefined;
}
export declare class VmgroupV2ContentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Content[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2ContentOutputReference;
}
export interface VmgroupV2DiskfiltersRules {
    /**
    * Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
    */
    readonly condition?: string;
    /**
    * [NONE, DISK_PATH, DISK_PATTERN, DISK_VIRTUAL_DEVICE_NODE, DISK_DATASTORE, DISK_LABEL, DISK_TYPE, DISK_ADDRESS, CONTAINER_PATTERN, DISK_TAG]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filtertype VmgroupV2#filtertype}
    */
    readonly filtertype?: string;
    /**
    * The string to be filtered
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * True if disk filter in vmgroup has to be overwritten, by default it will append the content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
    */
    readonly overwrite?: string;
    /**
    * The value string to be filtered, in case of disk tag , value of tag to be filtered
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
    */
    readonly value?: string;
    /**
    * VM Guid of the Virtual Machine whose disk has to be filtered . This is optional. if not given, all disks of name and type from all Vms added in content will be filtered
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmguid VmgroupV2#vmguid}
    */
    readonly vmguid?: string;
    /**
    * VM Name of the Virtual Machine whose disk has to be filtered . This is optional. if not given, all disks of name and type from all Vms added in content will be filtered
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmname VmgroupV2#vmname}
    */
    readonly vmname?: string;
}
export declare function vmgroupV2DiskfiltersRulesToTerraform(struct?: VmgroupV2DiskfiltersRules | cdktf.IResolvable): any;
export declare function vmgroupV2DiskfiltersRulesToHclTerraform(struct?: VmgroupV2DiskfiltersRules | cdktf.IResolvable): any;
export declare class VmgroupV2DiskfiltersRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2DiskfiltersRules | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2DiskfiltersRules | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _filtertype?;
    get filtertype(): string;
    set filtertype(value: string);
    resetFiltertype(): void;
    get filtertypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _overwrite?;
    get overwrite(): string;
    set overwrite(value: string);
    resetOverwrite(): void;
    get overwriteInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _vmguid?;
    get vmguid(): string;
    set vmguid(value: string);
    resetVmguid(): void;
    get vmguidInput(): string | undefined;
    private _vmname?;
    get vmname(): string;
    set vmname(value: string);
    resetVmname(): void;
    get vmnameInput(): string | undefined;
}
export declare class VmgroupV2DiskfiltersRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2DiskfiltersRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2DiskfiltersRulesOutputReference;
}
export interface VmgroupV2Diskfilters {
    /**
    * True if content in vmgroup has to be overwritten, by default it will append the content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
    */
    readonly overwrite?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
    */
    readonly rules?: VmgroupV2DiskfiltersRules[] | cdktf.IResolvable;
}
export declare function vmgroupV2DiskfiltersToTerraform(struct?: VmgroupV2Diskfilters | cdktf.IResolvable): any;
export declare function vmgroupV2DiskfiltersToHclTerraform(struct?: VmgroupV2Diskfilters | cdktf.IResolvable): any;
export declare class VmgroupV2DiskfiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Diskfilters | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Diskfilters | cdktf.IResolvable | undefined);
    private _overwrite?;
    get overwrite(): string;
    set overwrite(value: string);
    resetOverwrite(): void;
    get overwriteInput(): string | undefined;
    private _rules;
    get rules(): VmgroupV2DiskfiltersRulesList;
    putRules(value: VmgroupV2DiskfiltersRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | VmgroupV2DiskfiltersRules[] | undefined;
}
export declare class VmgroupV2DiskfiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Diskfilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2DiskfiltersOutputReference;
}
export interface VmgroupV2FiltersRulegroupsRules {
    /**
    * Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
    */
    readonly condition?: string;
    /**
    * name of the VM to be added as content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * [NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
    */
    readonly type?: string;
}
export declare function vmgroupV2FiltersRulegroupsRulesToTerraform(struct?: VmgroupV2FiltersRulegroupsRules | cdktf.IResolvable): any;
export declare function vmgroupV2FiltersRulegroupsRulesToHclTerraform(struct?: VmgroupV2FiltersRulegroupsRules | cdktf.IResolvable): any;
export declare class VmgroupV2FiltersRulegroupsRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2FiltersRulegroupsRules | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2FiltersRulegroupsRules | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class VmgroupV2FiltersRulegroupsRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2FiltersRulegroupsRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2FiltersRulegroupsRulesOutputReference;
}
export interface VmgroupV2FiltersRulegroups {
    /**
    * Enum which specifies the whether to match all rules or any of the rules [ALL, ANY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
    */
    readonly matchrule?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
    */
    readonly rules?: VmgroupV2FiltersRulegroupsRules[] | cdktf.IResolvable;
}
export declare function vmgroupV2FiltersRulegroupsToTerraform(struct?: VmgroupV2FiltersRulegroups | cdktf.IResolvable): any;
export declare function vmgroupV2FiltersRulegroupsToHclTerraform(struct?: VmgroupV2FiltersRulegroups | cdktf.IResolvable): any;
export declare class VmgroupV2FiltersRulegroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2FiltersRulegroups | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2FiltersRulegroups | cdktf.IResolvable | undefined);
    private _matchrule?;
    get matchrule(): string;
    set matchrule(value: string);
    resetMatchrule(): void;
    get matchruleInput(): string | undefined;
    private _rules;
    get rules(): VmgroupV2FiltersRulegroupsRulesList;
    putRules(value: VmgroupV2FiltersRulegroupsRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | VmgroupV2FiltersRulegroupsRules[] | undefined;
}
export declare class VmgroupV2FiltersRulegroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2FiltersRulegroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2FiltersRulegroupsOutputReference;
}
export interface VmgroupV2Filters {
    /**
    * True if content in vmgroup has to be overwritten, by default it will append the content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
    */
    readonly overwrite?: string;
    /**
    * rulegroups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
    */
    readonly rulegroups?: VmgroupV2FiltersRulegroups[] | cdktf.IResolvable;
}
export declare function vmgroupV2FiltersToTerraform(struct?: VmgroupV2Filters | cdktf.IResolvable): any;
export declare function vmgroupV2FiltersToHclTerraform(struct?: VmgroupV2Filters | cdktf.IResolvable): any;
export declare class VmgroupV2FiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Filters | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Filters | cdktf.IResolvable | undefined);
    private _overwrite?;
    get overwrite(): string;
    set overwrite(value: string);
    resetOverwrite(): void;
    get overwriteInput(): string | undefined;
    private _rulegroups;
    get rulegroups(): VmgroupV2FiltersRulegroupsList;
    putRulegroups(value: VmgroupV2FiltersRulegroups[] | cdktf.IResolvable): void;
    resetRulegroups(): void;
    get rulegroupsInput(): cdktf.IResolvable | VmgroupV2FiltersRulegroups[] | undefined;
}
export declare class VmgroupV2FiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Filters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2FiltersOutputReference;
}
export interface VmgroupV2Hypervisor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2HypervisorToTerraform(struct?: VmgroupV2Hypervisor | cdktf.IResolvable): any;
export declare function vmgroupV2HypervisorToHclTerraform(struct?: VmgroupV2Hypervisor | cdktf.IResolvable): any;
export declare class VmgroupV2HypervisorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Hypervisor | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Hypervisor | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2HypervisorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Hypervisor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2HypervisorOutputReference;
}
export interface VmgroupV2MeditechUseraccount {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2MeditechUseraccountToTerraform(struct?: VmgroupV2MeditechUseraccount | cdktf.IResolvable): any;
export declare function vmgroupV2MeditechUseraccountToHclTerraform(struct?: VmgroupV2MeditechUseraccount | cdktf.IResolvable): any;
export declare class VmgroupV2MeditechUseraccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2MeditechUseraccount | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2MeditechUseraccount | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2MeditechUseraccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2MeditechUseraccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2MeditechUseraccountOutputReference;
}
export interface VmgroupV2Meditech {
    /**
    * Meditech Listener IP of FQDN name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
    */
    readonly listenerip?: string;
    /**
    * Meditech Listener Port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
    */
    readonly listenerport?: number;
    /**
    * MBF timeout (in seconds)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
    */
    readonly mbftimeout?: number;
    /**
    * Meditech system name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
    */
    readonly systemname?: string;
    /**
    * useraccount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
    */
    readonly useraccount?: VmgroupV2MeditechUseraccount[] | cdktf.IResolvable;
}
export declare function vmgroupV2MeditechToTerraform(struct?: VmgroupV2Meditech | cdktf.IResolvable): any;
export declare function vmgroupV2MeditechToHclTerraform(struct?: VmgroupV2Meditech | cdktf.IResolvable): any;
export declare class VmgroupV2MeditechOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Meditech | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Meditech | cdktf.IResolvable | undefined);
    private _listenerip?;
    get listenerip(): string;
    set listenerip(value: string);
    resetListenerip(): void;
    get listeneripInput(): string | undefined;
    private _listenerport?;
    get listenerport(): number;
    set listenerport(value: number);
    resetListenerport(): void;
    get listenerportInput(): number | undefined;
    private _mbftimeout?;
    get mbftimeout(): number;
    set mbftimeout(value: number);
    resetMbftimeout(): void;
    get mbftimeoutInput(): number | undefined;
    private _systemname?;
    get systemname(): string;
    set systemname(value: string);
    resetSystemname(): void;
    get systemnameInput(): string | undefined;
    private _useraccount;
    get useraccount(): VmgroupV2MeditechUseraccountList;
    putUseraccount(value: VmgroupV2MeditechUseraccount[] | cdktf.IResolvable): void;
    resetUseraccount(): void;
    get useraccountInput(): cdktf.IResolvable | VmgroupV2MeditechUseraccount[] | undefined;
}
export declare class VmgroupV2MeditechList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Meditech[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2MeditechOutputReference;
}
export interface VmgroupV2MeditechsystemsUseraccount {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2MeditechsystemsUseraccountToTerraform(struct?: VmgroupV2MeditechsystemsUseraccount | cdktf.IResolvable): any;
export declare function vmgroupV2MeditechsystemsUseraccountToHclTerraform(struct?: VmgroupV2MeditechsystemsUseraccount | cdktf.IResolvable): any;
export declare class VmgroupV2MeditechsystemsUseraccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2MeditechsystemsUseraccount | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2MeditechsystemsUseraccount | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2MeditechsystemsUseraccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2MeditechsystemsUseraccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2MeditechsystemsUseraccountOutputReference;
}
export interface VmgroupV2Meditechsystems {
    /**
    * Meditech Listener IP of FQDN name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
    */
    readonly listenerip?: string;
    /**
    * Meditech Listener Port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
    */
    readonly listenerport?: number;
    /**
    * MBF timeout (in seconds)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
    */
    readonly mbftimeout?: number;
    /**
    * Meditech system name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
    */
    readonly systemname?: string;
    /**
    * useraccount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
    */
    readonly useraccount?: VmgroupV2MeditechsystemsUseraccount[] | cdktf.IResolvable;
}
export declare function vmgroupV2MeditechsystemsToTerraform(struct?: VmgroupV2Meditechsystems | cdktf.IResolvable): any;
export declare function vmgroupV2MeditechsystemsToHclTerraform(struct?: VmgroupV2Meditechsystems | cdktf.IResolvable): any;
export declare class VmgroupV2MeditechsystemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Meditechsystems | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Meditechsystems | cdktf.IResolvable | undefined);
    private _listenerip?;
    get listenerip(): string;
    set listenerip(value: string);
    resetListenerip(): void;
    get listeneripInput(): string | undefined;
    private _listenerport?;
    get listenerport(): number;
    set listenerport(value: number);
    resetListenerport(): void;
    get listenerportInput(): number | undefined;
    private _mbftimeout?;
    get mbftimeout(): number;
    set mbftimeout(value: number);
    resetMbftimeout(): void;
    get mbftimeoutInput(): number | undefined;
    private _systemname?;
    get systemname(): string;
    set systemname(value: string);
    resetSystemname(): void;
    get systemnameInput(): string | undefined;
    private _useraccount;
    get useraccount(): VmgroupV2MeditechsystemsUseraccountList;
    putUseraccount(value: VmgroupV2MeditechsystemsUseraccount[] | cdktf.IResolvable): void;
    resetUseraccount(): void;
    get useraccountInput(): cdktf.IResolvable | VmgroupV2MeditechsystemsUseraccount[] | undefined;
}
export declare class VmgroupV2MeditechsystemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Meditechsystems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2MeditechsystemsOutputReference;
}
export interface VmgroupV2Plan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2PlanToTerraform(struct?: VmgroupV2Plan | cdktf.IResolvable): any;
export declare function vmgroupV2PlanToHclTerraform(struct?: VmgroupV2Plan | cdktf.IResolvable): any;
export declare class VmgroupV2PlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Plan | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Plan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2PlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Plan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2PlanOutputReference;
}
export interface VmgroupV2SecurityassociationsExternalusergroup {
    /**
    * User Group Id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * External Group Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * Provider id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providerid VmgroupV2#providerid}
    */
    readonly providerid?: number;
    /**
    * Provider Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providername VmgroupV2#providername}
    */
    readonly providername?: string;
}
export declare function vmgroupV2SecurityassociationsExternalusergroupToTerraform(struct?: VmgroupV2SecurityassociationsExternalusergroup | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsExternalusergroupToHclTerraform(struct?: VmgroupV2SecurityassociationsExternalusergroup | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsExternalusergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SecurityassociationsExternalusergroup | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SecurityassociationsExternalusergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _providerid?;
    get providerid(): number;
    set providerid(value: number);
    resetProviderid(): void;
    get provideridInput(): number | undefined;
    private _providername?;
    get providername(): string;
    set providername(value: string);
    resetProvidername(): void;
    get providernameInput(): string | undefined;
}
export declare class VmgroupV2SecurityassociationsExternalusergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SecurityassociationsExternalusergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsExternalusergroupOutputReference;
}
export interface VmgroupV2SecurityassociationsPermissionlistStruct {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryid VmgroupV2#categoryid}
    */
    readonly categoryid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryname VmgroupV2#categoryname}
    */
    readonly categoryname?: string;
    /**
    * Flag to specify if this is included permission or excluded permission.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#exclude VmgroupV2#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionid VmgroupV2#permissionid}
    */
    readonly permissionid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionname VmgroupV2#permissionname}
    */
    readonly permissionname?: string;
    /**
    * Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
    */
    readonly type?: string;
}
export declare function vmgroupV2SecurityassociationsPermissionlistStructToTerraform(struct?: VmgroupV2SecurityassociationsPermissionlistStruct | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsPermissionlistStructToHclTerraform(struct?: VmgroupV2SecurityassociationsPermissionlistStruct | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsPermissionlistStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SecurityassociationsPermissionlistStruct | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SecurityassociationsPermissionlistStruct | cdktf.IResolvable | undefined);
    private _categoryid?;
    get categoryid(): number;
    set categoryid(value: number);
    resetCategoryid(): void;
    get categoryidInput(): number | undefined;
    private _categoryname?;
    get categoryname(): string;
    set categoryname(value: string);
    resetCategoryname(): void;
    get categorynameInput(): string | undefined;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _permissionid?;
    get permissionid(): number;
    set permissionid(value: number);
    resetPermissionid(): void;
    get permissionidInput(): number | undefined;
    private _permissionname?;
    get permissionname(): string;
    set permissionname(value: string);
    resetPermissionname(): void;
    get permissionnameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class VmgroupV2SecurityassociationsPermissionlistStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SecurityassociationsPermissionlistStruct[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsPermissionlistStructOutputReference;
}
export interface VmgroupV2SecurityassociationsRole {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SecurityassociationsRoleToTerraform(struct?: VmgroupV2SecurityassociationsRole | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsRoleToHclTerraform(struct?: VmgroupV2SecurityassociationsRole | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SecurityassociationsRole | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SecurityassociationsRole | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SecurityassociationsRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SecurityassociationsRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsRoleOutputReference;
}
export interface VmgroupV2SecurityassociationsUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SecurityassociationsUserToTerraform(struct?: VmgroupV2SecurityassociationsUser | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsUserToHclTerraform(struct?: VmgroupV2SecurityassociationsUser | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SecurityassociationsUser | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SecurityassociationsUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SecurityassociationsUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SecurityassociationsUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsUserOutputReference;
}
export interface VmgroupV2SecurityassociationsUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SecurityassociationsUsergroupToTerraform(struct?: VmgroupV2SecurityassociationsUsergroup | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsUsergroupToHclTerraform(struct?: VmgroupV2SecurityassociationsUsergroup | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SecurityassociationsUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SecurityassociationsUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SecurityassociationsUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SecurityassociationsUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsUsergroupOutputReference;
}
export interface VmgroupV2Securityassociations {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#iscreatorassociation VmgroupV2#iscreatorassociation}
    */
    readonly iscreatorassociation?: string;
    /**
    * externalusergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#externalusergroup VmgroupV2#externalusergroup}
    */
    readonly externalusergroup?: VmgroupV2SecurityassociationsExternalusergroup[] | cdktf.IResolvable;
    /**
    * permissionlist block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionlist VmgroupV2#permissionlist}
    */
    readonly permissionlist?: VmgroupV2SecurityassociationsPermissionlistStruct[] | cdktf.IResolvable;
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#role VmgroupV2#role}
    */
    readonly role?: VmgroupV2SecurityassociationsRole[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#user VmgroupV2#user}
    */
    readonly user?: VmgroupV2SecurityassociationsUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usergroup VmgroupV2#usergroup}
    */
    readonly usergroup?: VmgroupV2SecurityassociationsUsergroup[] | cdktf.IResolvable;
}
export declare function vmgroupV2SecurityassociationsToTerraform(struct?: VmgroupV2Securityassociations | cdktf.IResolvable): any;
export declare function vmgroupV2SecurityassociationsToHclTerraform(struct?: VmgroupV2Securityassociations | cdktf.IResolvable): any;
export declare class VmgroupV2SecurityassociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Securityassociations | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Securityassociations | cdktf.IResolvable | undefined);
    private _iscreatorassociation?;
    get iscreatorassociation(): string;
    set iscreatorassociation(value: string);
    resetIscreatorassociation(): void;
    get iscreatorassociationInput(): string | undefined;
    private _externalusergroup;
    get externalusergroup(): VmgroupV2SecurityassociationsExternalusergroupList;
    putExternalusergroup(value: VmgroupV2SecurityassociationsExternalusergroup[] | cdktf.IResolvable): void;
    resetExternalusergroup(): void;
    get externalusergroupInput(): cdktf.IResolvable | VmgroupV2SecurityassociationsExternalusergroup[] | undefined;
    private _permissionlist;
    get permissionlist(): VmgroupV2SecurityassociationsPermissionlistStructList;
    putPermissionlist(value: VmgroupV2SecurityassociationsPermissionlistStruct[] | cdktf.IResolvable): void;
    resetPermissionlist(): void;
    get permissionlistInput(): cdktf.IResolvable | VmgroupV2SecurityassociationsPermissionlistStruct[] | undefined;
    private _role;
    get role(): VmgroupV2SecurityassociationsRoleList;
    putRole(value: VmgroupV2SecurityassociationsRole[] | cdktf.IResolvable): void;
    resetRole(): void;
    get roleInput(): cdktf.IResolvable | VmgroupV2SecurityassociationsRole[] | undefined;
    private _user;
    get user(): VmgroupV2SecurityassociationsUserList;
    putUser(value: VmgroupV2SecurityassociationsUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | VmgroupV2SecurityassociationsUser[] | undefined;
    private _usergroup;
    get usergroup(): VmgroupV2SecurityassociationsUsergroupList;
    putUsergroup(value: VmgroupV2SecurityassociationsUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | VmgroupV2SecurityassociationsUsergroup[] | undefined;
}
export declare class VmgroupV2SecurityassociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Securityassociations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SecurityassociationsOutputReference;
}
export interface VmgroupV2SettingsCrossaccountDestinationaccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SettingsCrossaccountDestinationaccountToTerraform(struct?: VmgroupV2SettingsCrossaccountDestinationaccount | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsCrossaccountDestinationaccountToHclTerraform(struct?: VmgroupV2SettingsCrossaccountDestinationaccount | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsCrossaccountDestinationaccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsCrossaccountDestinationaccount | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsCrossaccountDestinationaccount | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SettingsCrossaccountDestinationaccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsCrossaccountDestinationaccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsCrossaccountDestinationaccountOutputReference;
}
export interface VmgroupV2SettingsCrossaccount {
    /**
    * True if full copy of amazon snapshot to different amazon account is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#fullcopy VmgroupV2#fullcopy}
    */
    readonly fullcopy?: string;
    /**
    * True if replicate and copy or sharing of amazon snapshot to different amazon account in same or different geographic location is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#shareonly VmgroupV2#shareonly}
    */
    readonly shareonly?: string;
    /**
    * destinationaccount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#destinationaccount VmgroupV2#destinationaccount}
    */
    readonly destinationaccount?: VmgroupV2SettingsCrossaccountDestinationaccount[] | cdktf.IResolvable;
}
export declare function vmgroupV2SettingsCrossaccountToTerraform(struct?: VmgroupV2SettingsCrossaccount | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsCrossaccountToHclTerraform(struct?: VmgroupV2SettingsCrossaccount | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsCrossaccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsCrossaccount | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsCrossaccount | cdktf.IResolvable | undefined);
    private _fullcopy?;
    get fullcopy(): string;
    set fullcopy(value: string);
    resetFullcopy(): void;
    get fullcopyInput(): string | undefined;
    private _shareonly?;
    get shareonly(): string;
    set shareonly(value: string);
    resetShareonly(): void;
    get shareonlyInput(): string | undefined;
    private _destinationaccount;
    get destinationaccount(): VmgroupV2SettingsCrossaccountDestinationaccountList;
    putDestinationaccount(value: VmgroupV2SettingsCrossaccountDestinationaccount[] | cdktf.IResolvable): void;
    resetDestinationaccount(): void;
    get destinationaccountInput(): cdktf.IResolvable | VmgroupV2SettingsCrossaccountDestinationaccount[] | undefined;
}
export declare class VmgroupV2SettingsCrossaccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsCrossaccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsCrossaccountOutputReference;
}
export interface VmgroupV2SettingsCustomsnapshottags {
    /**
    * represents name of the tag
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * represents value of the tag
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
    */
    readonly value?: string;
}
export declare function vmgroupV2SettingsCustomsnapshottagsToTerraform(struct?: VmgroupV2SettingsCustomsnapshottags | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsCustomsnapshottagsToHclTerraform(struct?: VmgroupV2SettingsCustomsnapshottags | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsCustomsnapshottagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsCustomsnapshottags | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsCustomsnapshottags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class VmgroupV2SettingsCustomsnapshottagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsCustomsnapshottags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsCustomsnapshottagsOutputReference;
}
export interface VmgroupV2SettingsGuestcredentialsCredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
    */
    readonly password?: string;
}
export declare function vmgroupV2SettingsGuestcredentialsCredentialsToTerraform(struct?: VmgroupV2SettingsGuestcredentialsCredentials | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsGuestcredentialsCredentialsToHclTerraform(struct?: VmgroupV2SettingsGuestcredentialsCredentials | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsGuestcredentialsCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsGuestcredentialsCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsGuestcredentialsCredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class VmgroupV2SettingsGuestcredentialsCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsGuestcredentialsCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsGuestcredentialsCredentialsOutputReference;
}
export interface VmgroupV2SettingsGuestcredentialsSavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SettingsGuestcredentialsSavedcredentialsToTerraform(struct?: VmgroupV2SettingsGuestcredentialsSavedcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsGuestcredentialsSavedcredentialsToHclTerraform(struct?: VmgroupV2SettingsGuestcredentialsSavedcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsGuestcredentialsSavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsGuestcredentialsSavedcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SettingsGuestcredentialsSavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsGuestcredentialsSavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference;
}
export interface VmgroupV2SettingsGuestcredentials {
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
    */
    readonly credentials?: VmgroupV2SettingsGuestcredentialsCredentials[] | cdktf.IResolvable;
    /**
    * savedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
    */
    readonly savedcredentials?: VmgroupV2SettingsGuestcredentialsSavedcredentials[] | cdktf.IResolvable;
}
export declare function vmgroupV2SettingsGuestcredentialsToTerraform(struct?: VmgroupV2SettingsGuestcredentials | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsGuestcredentialsToHclTerraform(struct?: VmgroupV2SettingsGuestcredentials | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsGuestcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SettingsGuestcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SettingsGuestcredentials | cdktf.IResolvable | undefined);
    private _credentials;
    get credentials(): VmgroupV2SettingsGuestcredentialsCredentialsList;
    putCredentials(value: VmgroupV2SettingsGuestcredentialsCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | VmgroupV2SettingsGuestcredentialsCredentials[] | undefined;
    private _savedcredentials;
    get savedcredentials(): VmgroupV2SettingsGuestcredentialsSavedcredentialsList;
    putSavedcredentials(value: VmgroupV2SettingsGuestcredentialsSavedcredentials[] | cdktf.IResolvable): void;
    resetSavedcredentials(): void;
    get savedcredentialsInput(): cdktf.IResolvable | VmgroupV2SettingsGuestcredentialsSavedcredentials[] | undefined;
}
export declare class VmgroupV2SettingsGuestcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SettingsGuestcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsGuestcredentialsOutputReference;
}
export interface VmgroupV2Settings {
    /**
    * True if empty subclient is allowed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#allowemptysubclient VmgroupV2#allowemptysubclient}
    */
    readonly allowemptysubclient?: string;
    /**
    * True if auto detect VM Owner enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#autodetectvmowner VmgroupV2#autodetectvmowner}
    */
    readonly autodetectvmowner?: string;
    /**
    * True if metadata collection is enabled. Only applicable for Indexing v1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsforgranularrecovery VmgroupV2#collectfiledetailsforgranularrecovery}
    */
    readonly collectfiledetailsforgranularrecovery?: string;
    /**
    * True if metadata collection is enabled for intellisnap jobs. Only applicable for Indexing v1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsfromsnapshotcopy VmgroupV2#collectfiledetailsfromsnapshotcopy}
    */
    readonly collectfiledetailsfromsnapshotcopy?: string;
    /**
    * Custom snapshot resource group name for Azure
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshotresourcegroup VmgroupV2#customsnapshotresourcegroup}
    */
    readonly customsnapshotresourcegroup?: string;
    /**
    * True if Datastore Free space check is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacecheck VmgroupV2#datastorefreespacecheck}
    */
    readonly datastorefreespacecheck?: string;
    /**
    * precentage of datastore free space check value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacerequired VmgroupV2#datastorefreespacerequired}
    */
    readonly datastorefreespacerequired?: number;
    /**
    * Is the VM App Aware
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isapplicationaware VmgroupV2#isapplicationaware}
    */
    readonly isapplicationaware?: string;
    /**
    * Is VM group disk filters included in VM instance disk filters
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isvmgroupdiskfiltersincluded VmgroupV2#isvmgroupdiskfiltersincluded}
    */
    readonly isvmgroupdiskfiltersincluded?: string;
    /**
    * Start Time for the VM Group Job
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#jobstarttime VmgroupV2#jobstarttime}
    */
    readonly jobstarttime?: number;
    /**
    * Number of readers for backup
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#noofreaders VmgroupV2#noofreaders}
    */
    readonly noofreaders?: number;
    /**
    * True when snapshot storage location is regional
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#regionalsnapshot VmgroupV2#regionalsnapshot}
    */
    readonly regionalsnapshot?: string;
    /**
    * transport mode based on environment. Values are case sensitive [AUTO, SAN, HOT_ADD, NAS, NBD_SSL, NBD]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#transportmode VmgroupV2#transportmode}
    */
    readonly transportmode?: string;
    /**
    * True if Changed Block Tracking is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usechangedblocktrackingonvm VmgroupV2#usechangedblocktrackingonvm}
    */
    readonly usechangedblocktrackingonvm?: string;
    /**
    * True if use VM CheckPoint setting is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usevmcheckpointsetting VmgroupV2#usevmcheckpointsetting}
    */
    readonly usevmcheckpointsetting?: string;
    /**
    * [APPLICATION_AWARE, FILE_SYSTEM_AND_APPLICATION_CONSISTENT, CRASH_CONSISTENT, APP_BASED_BACKUP, INHERITED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmbackuptype VmgroupV2#vmbackuptype}
    */
    readonly vmbackuptype?: string;
    /**
    * crossaccount block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#crossaccount VmgroupV2#crossaccount}
    */
    readonly crossaccount?: VmgroupV2SettingsCrossaccount[] | cdktf.IResolvable;
    /**
    * customsnapshottags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshottags VmgroupV2#customsnapshottags}
    */
    readonly customsnapshottags?: VmgroupV2SettingsCustomsnapshottags[] | cdktf.IResolvable;
    /**
    * guestcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
    */
    readonly guestcredentials?: VmgroupV2SettingsGuestcredentials[] | cdktf.IResolvable;
}
export declare function vmgroupV2SettingsToTerraform(struct?: VmgroupV2Settings | cdktf.IResolvable): any;
export declare function vmgroupV2SettingsToHclTerraform(struct?: VmgroupV2Settings | cdktf.IResolvable): any;
export declare class VmgroupV2SettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Settings | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Settings | cdktf.IResolvable | undefined);
    private _allowemptysubclient?;
    get allowemptysubclient(): string;
    set allowemptysubclient(value: string);
    resetAllowemptysubclient(): void;
    get allowemptysubclientInput(): string | undefined;
    private _autodetectvmowner?;
    get autodetectvmowner(): string;
    set autodetectvmowner(value: string);
    resetAutodetectvmowner(): void;
    get autodetectvmownerInput(): string | undefined;
    private _collectfiledetailsforgranularrecovery?;
    get collectfiledetailsforgranularrecovery(): string;
    set collectfiledetailsforgranularrecovery(value: string);
    resetCollectfiledetailsforgranularrecovery(): void;
    get collectfiledetailsforgranularrecoveryInput(): string | undefined;
    private _collectfiledetailsfromsnapshotcopy?;
    get collectfiledetailsfromsnapshotcopy(): string;
    set collectfiledetailsfromsnapshotcopy(value: string);
    resetCollectfiledetailsfromsnapshotcopy(): void;
    get collectfiledetailsfromsnapshotcopyInput(): string | undefined;
    private _customsnapshotresourcegroup?;
    get customsnapshotresourcegroup(): string;
    set customsnapshotresourcegroup(value: string);
    resetCustomsnapshotresourcegroup(): void;
    get customsnapshotresourcegroupInput(): string | undefined;
    private _datastorefreespacecheck?;
    get datastorefreespacecheck(): string;
    set datastorefreespacecheck(value: string);
    resetDatastorefreespacecheck(): void;
    get datastorefreespacecheckInput(): string | undefined;
    private _datastorefreespacerequired?;
    get datastorefreespacerequired(): number;
    set datastorefreespacerequired(value: number);
    resetDatastorefreespacerequired(): void;
    get datastorefreespacerequiredInput(): number | undefined;
    private _isapplicationaware?;
    get isapplicationaware(): string;
    set isapplicationaware(value: string);
    resetIsapplicationaware(): void;
    get isapplicationawareInput(): string | undefined;
    private _isvmgroupdiskfiltersincluded?;
    get isvmgroupdiskfiltersincluded(): string;
    set isvmgroupdiskfiltersincluded(value: string);
    resetIsvmgroupdiskfiltersincluded(): void;
    get isvmgroupdiskfiltersincludedInput(): string | undefined;
    private _jobstarttime?;
    get jobstarttime(): number;
    set jobstarttime(value: number);
    resetJobstarttime(): void;
    get jobstarttimeInput(): number | undefined;
    private _noofreaders?;
    get noofreaders(): number;
    set noofreaders(value: number);
    resetNoofreaders(): void;
    get noofreadersInput(): number | undefined;
    private _regionalsnapshot?;
    get regionalsnapshot(): string;
    set regionalsnapshot(value: string);
    resetRegionalsnapshot(): void;
    get regionalsnapshotInput(): string | undefined;
    private _transportmode?;
    get transportmode(): string;
    set transportmode(value: string);
    resetTransportmode(): void;
    get transportmodeInput(): string | undefined;
    private _usechangedblocktrackingonvm?;
    get usechangedblocktrackingonvm(): string;
    set usechangedblocktrackingonvm(value: string);
    resetUsechangedblocktrackingonvm(): void;
    get usechangedblocktrackingonvmInput(): string | undefined;
    private _usevmcheckpointsetting?;
    get usevmcheckpointsetting(): string;
    set usevmcheckpointsetting(value: string);
    resetUsevmcheckpointsetting(): void;
    get usevmcheckpointsettingInput(): string | undefined;
    private _vmbackuptype?;
    get vmbackuptype(): string;
    set vmbackuptype(value: string);
    resetVmbackuptype(): void;
    get vmbackuptypeInput(): string | undefined;
    private _crossaccount;
    get crossaccount(): VmgroupV2SettingsCrossaccountList;
    putCrossaccount(value: VmgroupV2SettingsCrossaccount[] | cdktf.IResolvable): void;
    resetCrossaccount(): void;
    get crossaccountInput(): cdktf.IResolvable | VmgroupV2SettingsCrossaccount[] | undefined;
    private _customsnapshottags;
    get customsnapshottags(): VmgroupV2SettingsCustomsnapshottagsList;
    putCustomsnapshottags(value: VmgroupV2SettingsCustomsnapshottags[] | cdktf.IResolvable): void;
    resetCustomsnapshottags(): void;
    get customsnapshottagsInput(): cdktf.IResolvable | VmgroupV2SettingsCustomsnapshottags[] | undefined;
    private _guestcredentials;
    get guestcredentials(): VmgroupV2SettingsGuestcredentialsList;
    putGuestcredentials(value: VmgroupV2SettingsGuestcredentials[] | cdktf.IResolvable): void;
    resetGuestcredentials(): void;
    get guestcredentialsInput(): cdktf.IResolvable | VmgroupV2SettingsGuestcredentials[] | undefined;
}
export declare class VmgroupV2SettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Settings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SettingsOutputReference;
}
export interface VmgroupV2SnapshotmanagementSnapengine {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SnapshotmanagementSnapengineToTerraform(struct?: VmgroupV2SnapshotmanagementSnapengine | cdktf.IResolvable): any;
export declare function vmgroupV2SnapshotmanagementSnapengineToHclTerraform(struct?: VmgroupV2SnapshotmanagementSnapengine | cdktf.IResolvable): any;
export declare class VmgroupV2SnapshotmanagementSnapengineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SnapshotmanagementSnapengine | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SnapshotmanagementSnapengine | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SnapshotmanagementSnapengineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SnapshotmanagementSnapengine[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SnapshotmanagementSnapengineOutputReference;
}
export interface VmgroupV2SnapshotmanagementSnapmountproxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2SnapshotmanagementSnapmountproxyToTerraform(struct?: VmgroupV2SnapshotmanagementSnapmountproxy | cdktf.IResolvable): any;
export declare function vmgroupV2SnapshotmanagementSnapmountproxyToHclTerraform(struct?: VmgroupV2SnapshotmanagementSnapmountproxy | cdktf.IResolvable): any;
export declare class VmgroupV2SnapshotmanagementSnapmountproxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2SnapshotmanagementSnapmountproxy | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2SnapshotmanagementSnapmountproxy | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2SnapshotmanagementSnapmountproxyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2SnapshotmanagementSnapmountproxy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SnapshotmanagementSnapmountproxyOutputReference;
}
export interface VmgroupV2Snapshotmanagement {
    /**
    * [FILE_SYSTEM, RMAN, VOLUME_COPY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupcopyinterface VmgroupV2#backupcopyinterface}
    */
    readonly backupcopyinterface?: string;
    /**
    * True if hardware snapshot is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablehardwaresnapshot VmgroupV2#enablehardwaresnapshot}
    */
    readonly enablehardwaresnapshot?: string;
    /**
    * True if independent disk option is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isindependentdisksenabled VmgroupV2#isindependentdisksenabled}
    */
    readonly isindependentdisksenabled?: string;
    /**
    * True if raw device maps option is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#israwdevicemapsenabled VmgroupV2#israwdevicemapsenabled}
    */
    readonly israwdevicemapsenabled?: string;
    /**
    * Name of ESX Host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountesxhost VmgroupV2#snapmountesxhost}
    */
    readonly snapmountesxhost?: string;
    /**
    * True if separate proxy client is used for snap to tape
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useseparateproxyforsnaptotape VmgroupV2#useseparateproxyforsnaptotape}
    */
    readonly useseparateproxyforsnaptotape?: string;
    /**
    * Virtual machine application user name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmapplicationusername VmgroupV2#vmapplicationusername}
    */
    readonly vmapplicationusername?: string;
    /**
    * snapengine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapengine VmgroupV2#snapengine}
    */
    readonly snapengine?: VmgroupV2SnapshotmanagementSnapengine[] | cdktf.IResolvable;
    /**
    * snapmountproxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountproxy VmgroupV2#snapmountproxy}
    */
    readonly snapmountproxy?: VmgroupV2SnapshotmanagementSnapmountproxy[] | cdktf.IResolvable;
}
export declare function vmgroupV2SnapshotmanagementToTerraform(struct?: VmgroupV2Snapshotmanagement | cdktf.IResolvable): any;
export declare function vmgroupV2SnapshotmanagementToHclTerraform(struct?: VmgroupV2Snapshotmanagement | cdktf.IResolvable): any;
export declare class VmgroupV2SnapshotmanagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Snapshotmanagement | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Snapshotmanagement | cdktf.IResolvable | undefined);
    private _backupcopyinterface?;
    get backupcopyinterface(): string;
    set backupcopyinterface(value: string);
    resetBackupcopyinterface(): void;
    get backupcopyinterfaceInput(): string | undefined;
    private _enablehardwaresnapshot?;
    get enablehardwaresnapshot(): string;
    set enablehardwaresnapshot(value: string);
    resetEnablehardwaresnapshot(): void;
    get enablehardwaresnapshotInput(): string | undefined;
    private _isindependentdisksenabled?;
    get isindependentdisksenabled(): string;
    set isindependentdisksenabled(value: string);
    resetIsindependentdisksenabled(): void;
    get isindependentdisksenabledInput(): string | undefined;
    private _israwdevicemapsenabled?;
    get israwdevicemapsenabled(): string;
    set israwdevicemapsenabled(value: string);
    resetIsrawdevicemapsenabled(): void;
    get israwdevicemapsenabledInput(): string | undefined;
    private _snapmountesxhost?;
    get snapmountesxhost(): string;
    set snapmountesxhost(value: string);
    resetSnapmountesxhost(): void;
    get snapmountesxhostInput(): string | undefined;
    private _useseparateproxyforsnaptotape?;
    get useseparateproxyforsnaptotape(): string;
    set useseparateproxyforsnaptotape(value: string);
    resetUseseparateproxyforsnaptotape(): void;
    get useseparateproxyforsnaptotapeInput(): string | undefined;
    private _vmapplicationusername?;
    get vmapplicationusername(): string;
    set vmapplicationusername(value: string);
    resetVmapplicationusername(): void;
    get vmapplicationusernameInput(): string | undefined;
    private _snapengine;
    get snapengine(): VmgroupV2SnapshotmanagementSnapengineList;
    putSnapengine(value: VmgroupV2SnapshotmanagementSnapengine[] | cdktf.IResolvable): void;
    resetSnapengine(): void;
    get snapengineInput(): cdktf.IResolvable | VmgroupV2SnapshotmanagementSnapengine[] | undefined;
    private _snapmountproxy;
    get snapmountproxy(): VmgroupV2SnapshotmanagementSnapmountproxyList;
    putSnapmountproxy(value: VmgroupV2SnapshotmanagementSnapmountproxy[] | cdktf.IResolvable): void;
    resetSnapmountproxy(): void;
    get snapmountproxyInput(): cdktf.IResolvable | VmgroupV2SnapshotmanagementSnapmountproxy[] | undefined;
}
export declare class VmgroupV2SnapshotmanagementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Snapshotmanagement[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2SnapshotmanagementOutputReference;
}
export interface VmgroupV2Storage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2StorageToTerraform(struct?: VmgroupV2Storage | cdktf.IResolvable): any;
export declare function vmgroupV2StorageToHclTerraform(struct?: VmgroupV2Storage | cdktf.IResolvable): any;
export declare class VmgroupV2StorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Storage | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Storage | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2StorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Storage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2StorageOutputReference;
}
export interface VmgroupV2Timezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
    */
    readonly name?: string;
}
export declare function vmgroupV2TimezoneToTerraform(struct?: VmgroupV2Timezone | cdktf.IResolvable): any;
export declare function vmgroupV2TimezoneToHclTerraform(struct?: VmgroupV2Timezone | cdktf.IResolvable): any;
export declare class VmgroupV2TimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmgroupV2Timezone | cdktf.IResolvable | undefined;
    set internalValue(value: VmgroupV2Timezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class VmgroupV2TimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmgroupV2Timezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmgroupV2TimezoneOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2 commvault_vmgroup_v2}
*/
export declare class VmgroupV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_vmgroup_v2";
    /**
    * Generates CDKTF code for importing a VmgroupV2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmgroupV2 to import
    * @param importFromId The id of the existing VmgroupV2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmgroupV2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2 commvault_vmgroup_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmgroupV2Config
    */
    constructor(scope: Construct, id: string, config: VmgroupV2Config);
    private _enablefileindexing?;
    get enablefileindexing(): string;
    set enablefileindexing(value: string);
    resetEnablefileindexing(): void;
    get enablefileindexingInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _accessnode;
    get accessnode(): VmgroupV2AccessnodeList;
    putAccessnode(value: VmgroupV2Accessnode[] | cdktf.IResolvable): void;
    resetAccessnode(): void;
    get accessnodeInput(): cdktf.IResolvable | VmgroupV2Accessnode[] | undefined;
    private _activitycontrol;
    get activitycontrol(): VmgroupV2ActivitycontrolList;
    putActivitycontrol(value: VmgroupV2Activitycontrol[] | cdktf.IResolvable): void;
    resetActivitycontrol(): void;
    get activitycontrolInput(): cdktf.IResolvable | VmgroupV2Activitycontrol[] | undefined;
    private _applicationvalidation;
    get applicationvalidation(): VmgroupV2ApplicationvalidationList;
    putApplicationvalidation(value: VmgroupV2Applicationvalidation[] | cdktf.IResolvable): void;
    resetApplicationvalidation(): void;
    get applicationvalidationInput(): cdktf.IResolvable | VmgroupV2Applicationvalidation[] | undefined;
    private _content;
    get content(): VmgroupV2ContentList;
    putContent(value: VmgroupV2Content[] | cdktf.IResolvable): void;
    get contentInput(): cdktf.IResolvable | VmgroupV2Content[] | undefined;
    private _diskfilters;
    get diskfilters(): VmgroupV2DiskfiltersList;
    putDiskfilters(value: VmgroupV2Diskfilters[] | cdktf.IResolvable): void;
    resetDiskfilters(): void;
    get diskfiltersInput(): cdktf.IResolvable | VmgroupV2Diskfilters[] | undefined;
    private _filters;
    get filters(): VmgroupV2FiltersList;
    putFilters(value: VmgroupV2Filters[] | cdktf.IResolvable): void;
    resetFilters(): void;
    get filtersInput(): cdktf.IResolvable | VmgroupV2Filters[] | undefined;
    private _hypervisor;
    get hypervisor(): VmgroupV2HypervisorList;
    putHypervisor(value: VmgroupV2Hypervisor[] | cdktf.IResolvable): void;
    get hypervisorInput(): cdktf.IResolvable | VmgroupV2Hypervisor[] | undefined;
    private _meditech;
    get meditech(): VmgroupV2MeditechList;
    putMeditech(value: VmgroupV2Meditech[] | cdktf.IResolvable): void;
    resetMeditech(): void;
    get meditechInput(): cdktf.IResolvable | VmgroupV2Meditech[] | undefined;
    private _meditechsystems;
    get meditechsystems(): VmgroupV2MeditechsystemsList;
    putMeditechsystems(value: VmgroupV2Meditechsystems[] | cdktf.IResolvable): void;
    resetMeditechsystems(): void;
    get meditechsystemsInput(): cdktf.IResolvable | VmgroupV2Meditechsystems[] | undefined;
    private _plan;
    get plan(): VmgroupV2PlanList;
    putPlan(value: VmgroupV2Plan[] | cdktf.IResolvable): void;
    get planInput(): cdktf.IResolvable | VmgroupV2Plan[] | undefined;
    private _securityassociations;
    get securityassociations(): VmgroupV2SecurityassociationsList;
    putSecurityassociations(value: VmgroupV2Securityassociations[] | cdktf.IResolvable): void;
    resetSecurityassociations(): void;
    get securityassociationsInput(): cdktf.IResolvable | VmgroupV2Securityassociations[] | undefined;
    private _settings;
    get settings(): VmgroupV2SettingsList;
    putSettings(value: VmgroupV2Settings[] | cdktf.IResolvable): void;
    resetSettings(): void;
    get settingsInput(): cdktf.IResolvable | VmgroupV2Settings[] | undefined;
    private _snapshotmanagement;
    get snapshotmanagement(): VmgroupV2SnapshotmanagementList;
    putSnapshotmanagement(value: VmgroupV2Snapshotmanagement[] | cdktf.IResolvable): void;
    resetSnapshotmanagement(): void;
    get snapshotmanagementInput(): cdktf.IResolvable | VmgroupV2Snapshotmanagement[] | undefined;
    private _storage;
    get storage(): VmgroupV2StorageList;
    putStorage(value: VmgroupV2Storage[] | cdktf.IResolvable): void;
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | VmgroupV2Storage[] | undefined;
    private _timezone;
    get timezone(): VmgroupV2TimezoneList;
    putTimezone(value: VmgroupV2Timezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | VmgroupV2Timezone[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
