import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AmazonHypervisorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies The access key ID for your Amazon account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#access_key AmazonHypervisor#access_key}
    */
    readonly accessKey?: string;
    /**
    * Specifies The clients that have the VSA package installed and that act as proxy clients for Amazon hypervisors.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#access_nodes AmazonHypervisor#access_nodes}
    */
    readonly accessNodes: string;
    /**
    * Specifies The name of the Amazon hypervisor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#client_name AmazonHypervisor#client_name}
    */
    readonly clientName: string;
    /**
    * Specifies the company id to which the Amazon Hypervisor should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#company_id AmazonHypervisor#company_id}
    */
    readonly companyId?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#id AmazonHypervisor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the regions used for the Hypervisor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#regions AmazonHypervisor#regions}
    */
    readonly regions?: string;
    /**
    * Specifies The secret key ID for your Amazon account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#secret_key AmazonHypervisor#secret_key}
    */
    readonly secretKey?: string;
    /**
    * Specifies whether you want to use IAM role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#use_iam_role AmazonHypervisor#use_iam_role}
    */
    readonly useIamRole: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor commvault_amazon_hypervisor}
*/
export declare class AmazonHypervisor extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_amazon_hypervisor";
    /**
    * Generates CDKTF code for importing a AmazonHypervisor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AmazonHypervisor to import
    * @param importFromId The id of the existing AmazonHypervisor that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AmazonHypervisor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/amazon_hypervisor commvault_amazon_hypervisor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AmazonHypervisorConfig
    */
    constructor(scope: Construct, id: string, config: AmazonHypervisorConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _accessNodes?;
    get accessNodes(): string;
    set accessNodes(value: string);
    get accessNodesInput(): string | undefined;
    private _clientName?;
    get clientName(): string;
    set clientName(value: string);
    get clientNameInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _regions?;
    get regions(): string;
    set regions(value: string);
    resetRegions(): void;
    get regionsInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _useIamRole?;
    get useIamRole(): boolean | cdktf.IResolvable;
    set useIamRole(value: boolean | cdktf.IResolvable);
    get useIamRoleInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
