import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialAwswithrolearnConfig extends cdktf.TerraformMetaArguments {
    /**
    * [WINDOWSACCOUNT, LINUXACCOUNT, STORAGE_ARRAY_ACCOUNT, CLOUD_ACCOUNT]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#accounttype CredentialAwswithrolearn#accounttype}
    */
    readonly accounttype?: string;
    /**
    * Description of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#description CredentialAwswithrolearn#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#id CredentialAwswithrolearn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#name CredentialAwswithrolearn#name}
    */
    readonly name: string;
    /**
    * Role ARN of credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#password CredentialAwswithrolearn#password}
    */
    readonly password?: string;
    /**
    * Role ARN of credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#rolearn CredentialAwswithrolearn#rolearn}
    */
    readonly rolearn: string;
    /**
    * Cloud vendor types appilcable only for Cloud Account type [ALICLOUD_OSS, AMAZON_GLACIER, AMAZON, ATT_SYNAPTIC, REVERA_VAULT, CEPH_OBJECT_GATEWAY_S3, CMCC_ONEST, CLOUDIAN_HYPERSTORE, DELL_EMC_ECS_S3, EMC_ATMOS, FUJITSU_STORAGE_ETERNUS, GOOGLE_CLOUD, HDS_HCP, HITACHI_VANTARA_HCP_S3, HUAWEI_OSS, IBM_CLOUD, IBM_CLOUD_S3, INSPUR_CLOUD, IRON_MOUNTAIN_CLOUD, KINGSOFT_KS3, MICROSOFT_AZURE_TYPE, NETAPP_STORAGEGRID, NUTANIX_BUCKETS, OPENSTACK, AMPLIDATA, RACKSPACE_CLOUD_FILES, S3_COMPATIBLE, SALESFORCE_CONNECTED_APP, SCALITY_RING, TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE, VERIZON_CLOUD, WASABI_HOT_CLOUD_STORAGE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#vendortype CredentialAwswithrolearn#vendortype}
    */
    readonly vendortype?: string;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#security CredentialAwswithrolearn#security}
    */
    readonly security?: CredentialAwswithrolearnSecurity[] | cdktf.IResolvable;
}
export interface CredentialAwswithrolearnSecurityAssociationsPermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#categoryid CredentialAwswithrolearn#categoryid}
    */
    readonly categoryid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#categoryname CredentialAwswithrolearn#categoryname}
    */
    readonly categoryname?: string;
    /**
    * Flag to specify if this is included permission or excluded permission.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#exclude CredentialAwswithrolearn#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#permissionid CredentialAwswithrolearn#permissionid}
    */
    readonly permissionid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#permissionname CredentialAwswithrolearn#permissionname}
    */
    readonly permissionname?: string;
    /**
    * Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#type CredentialAwswithrolearn#type}
    */
    readonly type?: string;
}
export declare function credentialAwswithrolearnSecurityAssociationsPermissionsToTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityAssociationsPermissionsToHclTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityAssociationsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityAssociationsPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityAssociationsPermissions | cdktf.IResolvable | undefined);
    private _categoryid?;
    get categoryid(): number;
    set categoryid(value: number);
    resetCategoryid(): void;
    get categoryidInput(): number | undefined;
    private _categoryname?;
    get categoryname(): string;
    set categoryname(value: string);
    resetCategoryname(): void;
    get categorynameInput(): string | undefined;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _permissionid?;
    get permissionid(): number;
    set permissionid(value: number);
    resetPermissionid(): void;
    get permissionidInput(): number | undefined;
    private _permissionname?;
    get permissionname(): string;
    set permissionname(value: string);
    resetPermissionname(): void;
    get permissionnameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class CredentialAwswithrolearnSecurityAssociationsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityAssociationsPermissionsOutputReference;
}
export interface CredentialAwswithrolearnSecurityAssociationsUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#id CredentialAwswithrolearn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAwswithrolearnSecurityAssociationsUserToTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsUser | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityAssociationsUserToHclTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsUser | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityAssociationsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityAssociationsUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityAssociationsUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAwswithrolearnSecurityAssociationsUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityAssociationsUserOutputReference;
}
export interface CredentialAwswithrolearnSecurityAssociationsUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#id CredentialAwswithrolearn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAwswithrolearnSecurityAssociationsUsergroupToTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityAssociationsUsergroupToHclTerraform(struct?: CredentialAwswithrolearnSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityAssociationsUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityAssociationsUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityAssociationsUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAwswithrolearnSecurityAssociationsUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityAssociationsUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityAssociationsUsergroupOutputReference;
}
export interface CredentialAwswithrolearnSecurityAssociations {
    /**
    * To check if the user/user group associated is the owner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#iscreatorassociation CredentialAwswithrolearn#iscreatorassociation}
    */
    readonly iscreatorassociation?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#permissions CredentialAwswithrolearn#permissions}
    */
    readonly permissions?: CredentialAwswithrolearnSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#user CredentialAwswithrolearn#user}
    */
    readonly user?: CredentialAwswithrolearnSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#usergroup CredentialAwswithrolearn#usergroup}
    */
    readonly usergroup?: CredentialAwswithrolearnSecurityAssociationsUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAwswithrolearnSecurityAssociationsToTerraform(struct?: CredentialAwswithrolearnSecurityAssociations | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityAssociationsToHclTerraform(struct?: CredentialAwswithrolearnSecurityAssociations | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityAssociations | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityAssociations | cdktf.IResolvable | undefined);
    private _iscreatorassociation?;
    get iscreatorassociation(): string;
    set iscreatorassociation(value: string);
    resetIscreatorassociation(): void;
    get iscreatorassociationInput(): string | undefined;
    private _permissions;
    get permissions(): CredentialAwswithrolearnSecurityAssociationsPermissionsList;
    putPermissions(value: CredentialAwswithrolearnSecurityAssociationsPermissions[] | cdktf.IResolvable): void;
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityAssociationsPermissions[] | undefined;
    private _user;
    get user(): CredentialAwswithrolearnSecurityAssociationsUserList;
    putUser(value: CredentialAwswithrolearnSecurityAssociationsUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityAssociationsUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAwswithrolearnSecurityAssociationsUsergroupList;
    putUsergroup(value: CredentialAwswithrolearnSecurityAssociationsUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityAssociationsUsergroup[] | undefined;
}
export declare class CredentialAwswithrolearnSecurityAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityAssociations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityAssociationsOutputReference;
}
export interface CredentialAwswithrolearnSecurityOwnerUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#id CredentialAwswithrolearn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#name CredentialAwswithrolearn#name}
    */
    readonly name?: string;
}
export declare function credentialAwswithrolearnSecurityOwnerUserToTerraform(struct?: CredentialAwswithrolearnSecurityOwnerUser | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityOwnerUserToHclTerraform(struct?: CredentialAwswithrolearnSecurityOwnerUser | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityOwnerUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityOwnerUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityOwnerUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAwswithrolearnSecurityOwnerUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityOwnerUserOutputReference;
}
export interface CredentialAwswithrolearnSecurityOwnerUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#id CredentialAwswithrolearn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#name CredentialAwswithrolearn#name}
    */
    readonly name?: string;
}
export declare function credentialAwswithrolearnSecurityOwnerUsergroupToTerraform(struct?: CredentialAwswithrolearnSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityOwnerUsergroupToHclTerraform(struct?: CredentialAwswithrolearnSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityOwnerUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityOwnerUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityOwnerUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAwswithrolearnSecurityOwnerUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityOwnerUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityOwnerUsergroupOutputReference;
}
export interface CredentialAwswithrolearnSecurityOwner {
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#user CredentialAwswithrolearn#user}
    */
    readonly user?: CredentialAwswithrolearnSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#usergroup CredentialAwswithrolearn#usergroup}
    */
    readonly usergroup?: CredentialAwswithrolearnSecurityOwnerUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAwswithrolearnSecurityOwnerToTerraform(struct?: CredentialAwswithrolearnSecurityOwner | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityOwnerToHclTerraform(struct?: CredentialAwswithrolearnSecurityOwner | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurityOwner | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurityOwner | cdktf.IResolvable | undefined);
    private _user;
    get user(): CredentialAwswithrolearnSecurityOwnerUserList;
    putUser(value: CredentialAwswithrolearnSecurityOwnerUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityOwnerUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAwswithrolearnSecurityOwnerUsergroupList;
    putUsergroup(value: CredentialAwswithrolearnSecurityOwnerUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityOwnerUsergroup[] | undefined;
}
export declare class CredentialAwswithrolearnSecurityOwnerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurityOwner[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityOwnerOutputReference;
}
export interface CredentialAwswithrolearnSecurity {
    /**
    * associations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#associations CredentialAwswithrolearn#associations}
    */
    readonly associations?: CredentialAwswithrolearnSecurityAssociations[] | cdktf.IResolvable;
    /**
    * owner block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#owner CredentialAwswithrolearn#owner}
    */
    readonly owner?: CredentialAwswithrolearnSecurityOwner[] | cdktf.IResolvable;
}
export declare function credentialAwswithrolearnSecurityToTerraform(struct?: CredentialAwswithrolearnSecurity | cdktf.IResolvable): any;
export declare function credentialAwswithrolearnSecurityToHclTerraform(struct?: CredentialAwswithrolearnSecurity | cdktf.IResolvable): any;
export declare class CredentialAwswithrolearnSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAwswithrolearnSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAwswithrolearnSecurity | cdktf.IResolvable | undefined);
    private _associations;
    get associations(): CredentialAwswithrolearnSecurityAssociationsList;
    putAssociations(value: CredentialAwswithrolearnSecurityAssociations[] | cdktf.IResolvable): void;
    resetAssociations(): void;
    get associationsInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityAssociations[] | undefined;
    private _owner;
    get owner(): CredentialAwswithrolearnSecurityOwnerList;
    putOwner(value: CredentialAwswithrolearnSecurityOwner[] | cdktf.IResolvable): void;
    resetOwner(): void;
    get ownerInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurityOwner[] | undefined;
}
export declare class CredentialAwswithrolearnSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAwswithrolearnSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAwswithrolearnSecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn commvault_credential_awswithrolearn}
*/
export declare class CredentialAwswithrolearn extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_credential_awswithrolearn";
    /**
    * Generates CDKTF code for importing a CredentialAwswithrolearn resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialAwswithrolearn to import
    * @param importFromId The id of the existing CredentialAwswithrolearn that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialAwswithrolearn to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_awswithrolearn commvault_credential_awswithrolearn} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialAwswithrolearnConfig
    */
    constructor(scope: Construct, id: string, config: CredentialAwswithrolearnConfig);
    private _accounttype?;
    get accounttype(): string;
    set accounttype(value: string);
    resetAccounttype(): void;
    get accounttypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _rolearn?;
    get rolearn(): string;
    set rolearn(value: string);
    get rolearnInput(): string | undefined;
    private _vendortype?;
    get vendortype(): string;
    set vendortype(value: string);
    resetVendortype(): void;
    get vendortypeInput(): string | undefined;
    private _security;
    get security(): CredentialAwswithrolearnSecurityList;
    putSecurity(value: CredentialAwswithrolearnSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | CredentialAwswithrolearnSecurity[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
