import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access key ID of Credential, applicable only if authType is Access Secret Key and must be in base64 encoded format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#accesskeyid CredentialAzure#accesskeyid}
    */
    readonly accesskeyid: string;
    /**
    * Account name of Credential, applicable only if authType is Access Key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#accountname CredentialAzure#accountname}
    */
    readonly accountname: string;
    /**
    * [WINDOWSACCOUNT, LINUXACCOUNT, STORAGE_ARRAY_ACCOUNT, CLOUD_ACCOUNT]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#accounttype CredentialAzure#accounttype}
    */
    readonly accounttype?: string;
    /**
    * Description of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#description CredentialAzure#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#id CredentialAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of Credential
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#name CredentialAzure#name}
    */
    readonly name: string;
    /**
    * Cloud vendor types appilcable only for Cloud Account type [ALICLOUD_OSS, AMAZON_GLACIER, AMAZON, ATT_SYNAPTIC, REVERA_VAULT, CEPH_OBJECT_GATEWAY_S3, CMCC_ONEST, CLOUDIAN_HYPERSTORE, DELL_EMC_ECS_S3, EMC_ATMOS, FUJITSU_STORAGE_ETERNUS, GOOGLE_CLOUD, HDS_HCP, HITACHI_VANTARA_HCP_S3, HUAWEI_OSS, IBM_CLOUD, IBM_CLOUD_S3, INSPUR_CLOUD, IRON_MOUNTAIN_CLOUD, KINGSOFT_KS3, MICROSOFT_AZURE_TYPE, NETAPP_STORAGEGRID, NUTANIX_BUCKETS, OPENSTACK, AMPLIDATA, RACKSPACE_CLOUD_FILES, S3_COMPATIBLE, SALESFORCE_CONNECTED_APP, SCALITY_RING, TELEFONICA_OPEN_CLOUD_OBJECT_STORAGE, VERIZON_CLOUD, WASABI_HOT_CLOUD_STORAGE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#vendortype CredentialAzure#vendortype}
    */
    readonly vendortype?: string;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#security CredentialAzure#security}
    */
    readonly security?: CredentialAzureSecurity[] | cdktf.IResolvable;
}
export interface CredentialAzureSecurityAssociationsPermissions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#categoryid CredentialAzure#categoryid}
    */
    readonly categoryid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#categoryname CredentialAzure#categoryname}
    */
    readonly categoryname?: string;
    /**
    * Flag to specify if this is included permission or excluded permission.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#exclude CredentialAzure#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#permissionid CredentialAzure#permissionid}
    */
    readonly permissionid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#permissionname CredentialAzure#permissionname}
    */
    readonly permissionname?: string;
    /**
    * Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#type CredentialAzure#type}
    */
    readonly type?: string;
}
export declare function credentialAzureSecurityAssociationsPermissionsToTerraform(struct?: CredentialAzureSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare function credentialAzureSecurityAssociationsPermissionsToHclTerraform(struct?: CredentialAzureSecurityAssociationsPermissions | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityAssociationsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityAssociationsPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityAssociationsPermissions | cdktf.IResolvable | undefined);
    private _categoryid?;
    get categoryid(): number;
    set categoryid(value: number);
    resetCategoryid(): void;
    get categoryidInput(): number | undefined;
    private _categoryname?;
    get categoryname(): string;
    set categoryname(value: string);
    resetCategoryname(): void;
    get categorynameInput(): string | undefined;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _permissionid?;
    get permissionid(): number;
    set permissionid(value: number);
    resetPermissionid(): void;
    get permissionidInput(): number | undefined;
    private _permissionname?;
    get permissionname(): string;
    set permissionname(value: string);
    resetPermissionname(): void;
    get permissionnameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class CredentialAzureSecurityAssociationsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityAssociationsPermissionsOutputReference;
}
export interface CredentialAzureSecurityAssociationsUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#id CredentialAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAzureSecurityAssociationsUserToTerraform(struct?: CredentialAzureSecurityAssociationsUser | cdktf.IResolvable): any;
export declare function credentialAzureSecurityAssociationsUserToHclTerraform(struct?: CredentialAzureSecurityAssociationsUser | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityAssociationsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityAssociationsUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityAssociationsUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAzureSecurityAssociationsUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityAssociationsUserOutputReference;
}
export interface CredentialAzureSecurityAssociationsUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#id CredentialAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function credentialAzureSecurityAssociationsUsergroupToTerraform(struct?: CredentialAzureSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare function credentialAzureSecurityAssociationsUsergroupToHclTerraform(struct?: CredentialAzureSecurityAssociationsUsergroup | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityAssociationsUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityAssociationsUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityAssociationsUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class CredentialAzureSecurityAssociationsUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityAssociationsUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityAssociationsUsergroupOutputReference;
}
export interface CredentialAzureSecurityAssociations {
    /**
    * To check if the user/user group associated is the owner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#iscreatorassociation CredentialAzure#iscreatorassociation}
    */
    readonly iscreatorassociation?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#permissions CredentialAzure#permissions}
    */
    readonly permissions?: CredentialAzureSecurityAssociationsPermissions[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#user CredentialAzure#user}
    */
    readonly user?: CredentialAzureSecurityAssociationsUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#usergroup CredentialAzure#usergroup}
    */
    readonly usergroup?: CredentialAzureSecurityAssociationsUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAzureSecurityAssociationsToTerraform(struct?: CredentialAzureSecurityAssociations | cdktf.IResolvable): any;
export declare function credentialAzureSecurityAssociationsToHclTerraform(struct?: CredentialAzureSecurityAssociations | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityAssociations | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityAssociations | cdktf.IResolvable | undefined);
    private _iscreatorassociation?;
    get iscreatorassociation(): string;
    set iscreatorassociation(value: string);
    resetIscreatorassociation(): void;
    get iscreatorassociationInput(): string | undefined;
    private _permissions;
    get permissions(): CredentialAzureSecurityAssociationsPermissionsList;
    putPermissions(value: CredentialAzureSecurityAssociationsPermissions[] | cdktf.IResolvable): void;
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | CredentialAzureSecurityAssociationsPermissions[] | undefined;
    private _user;
    get user(): CredentialAzureSecurityAssociationsUserList;
    putUser(value: CredentialAzureSecurityAssociationsUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAzureSecurityAssociationsUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAzureSecurityAssociationsUsergroupList;
    putUsergroup(value: CredentialAzureSecurityAssociationsUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAzureSecurityAssociationsUsergroup[] | undefined;
}
export declare class CredentialAzureSecurityAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityAssociations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityAssociationsOutputReference;
}
export interface CredentialAzureSecurityOwnerUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#id CredentialAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#name CredentialAzure#name}
    */
    readonly name?: string;
}
export declare function credentialAzureSecurityOwnerUserToTerraform(struct?: CredentialAzureSecurityOwnerUser | cdktf.IResolvable): any;
export declare function credentialAzureSecurityOwnerUserToHclTerraform(struct?: CredentialAzureSecurityOwnerUser | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityOwnerUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityOwnerUser | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityOwnerUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAzureSecurityOwnerUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityOwnerUserOutputReference;
}
export interface CredentialAzureSecurityOwnerUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#id CredentialAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#name CredentialAzure#name}
    */
    readonly name?: string;
}
export declare function credentialAzureSecurityOwnerUsergroupToTerraform(struct?: CredentialAzureSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare function credentialAzureSecurityOwnerUsergroupToHclTerraform(struct?: CredentialAzureSecurityOwnerUsergroup | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityOwnerUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityOwnerUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityOwnerUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CredentialAzureSecurityOwnerUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityOwnerUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityOwnerUsergroupOutputReference;
}
export interface CredentialAzureSecurityOwner {
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#user CredentialAzure#user}
    */
    readonly user?: CredentialAzureSecurityOwnerUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#usergroup CredentialAzure#usergroup}
    */
    readonly usergroup?: CredentialAzureSecurityOwnerUsergroup[] | cdktf.IResolvable;
}
export declare function credentialAzureSecurityOwnerToTerraform(struct?: CredentialAzureSecurityOwner | cdktf.IResolvable): any;
export declare function credentialAzureSecurityOwnerToHclTerraform(struct?: CredentialAzureSecurityOwner | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurityOwner | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurityOwner | cdktf.IResolvable | undefined);
    private _user;
    get user(): CredentialAzureSecurityOwnerUserList;
    putUser(value: CredentialAzureSecurityOwnerUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | CredentialAzureSecurityOwnerUser[] | undefined;
    private _usergroup;
    get usergroup(): CredentialAzureSecurityOwnerUsergroupList;
    putUsergroup(value: CredentialAzureSecurityOwnerUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | CredentialAzureSecurityOwnerUsergroup[] | undefined;
}
export declare class CredentialAzureSecurityOwnerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurityOwner[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityOwnerOutputReference;
}
export interface CredentialAzureSecurity {
    /**
    * associations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#associations CredentialAzure#associations}
    */
    readonly associations?: CredentialAzureSecurityAssociations[] | cdktf.IResolvable;
    /**
    * owner block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#owner CredentialAzure#owner}
    */
    readonly owner?: CredentialAzureSecurityOwner[] | cdktf.IResolvable;
}
export declare function credentialAzureSecurityToTerraform(struct?: CredentialAzureSecurity | cdktf.IResolvable): any;
export declare function credentialAzureSecurityToHclTerraform(struct?: CredentialAzureSecurity | cdktf.IResolvable): any;
export declare class CredentialAzureSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CredentialAzureSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: CredentialAzureSecurity | cdktf.IResolvable | undefined);
    private _associations;
    get associations(): CredentialAzureSecurityAssociationsList;
    putAssociations(value: CredentialAzureSecurityAssociations[] | cdktf.IResolvable): void;
    resetAssociations(): void;
    get associationsInput(): cdktf.IResolvable | CredentialAzureSecurityAssociations[] | undefined;
    private _owner;
    get owner(): CredentialAzureSecurityOwnerList;
    putOwner(value: CredentialAzureSecurityOwner[] | cdktf.IResolvable): void;
    resetOwner(): void;
    get ownerInput(): cdktf.IResolvable | CredentialAzureSecurityOwner[] | undefined;
}
export declare class CredentialAzureSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CredentialAzureSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CredentialAzureSecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure commvault_credential_azure}
*/
export declare class CredentialAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_credential_azure";
    /**
    * Generates CDKTF code for importing a CredentialAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CredentialAzure to import
    * @param importFromId The id of the existing CredentialAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CredentialAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/credential_azure commvault_credential_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialAzureConfig
    */
    constructor(scope: Construct, id: string, config: CredentialAzureConfig);
    private _accesskeyid?;
    get accesskeyid(): string;
    set accesskeyid(value: string);
    get accesskeyidInput(): string | undefined;
    private _accountname?;
    get accountname(): string;
    set accountname(value: string);
    get accountnameInput(): string | undefined;
    private _accounttype?;
    get accounttype(): string;
    set accounttype(value: string);
    resetAccounttype(): void;
    get accounttypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vendortype?;
    get vendortype(): string;
    set vendortype(value: string);
    resetVendortype(): void;
    get vendortypeInput(): string | undefined;
    private _security;
    get security(): CredentialAzureSecurityList;
    putSecurity(value: CredentialAzureSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | CredentialAzureSecurity[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
