import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskAccesspathConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access type for the access path can be either read (writing to path not allowed) or read and write (writing to path allowed). [READ_AND_WRITE, READ]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#access DiskAccesspath#access}
    */
    readonly access?: string;
    /**
    * Id of the backup location whose details have to be fetched to add a new access path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#backuplocationid DiskAccesspath#backuplocationid}
    */
    readonly backuplocationid: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#enabled DiskAccesspath#enabled}
    */
    readonly enabled?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#id DiskAccesspath#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Id of the disk storage pool whose details have to be fetched to add a new access path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#storagepoolid DiskAccesspath#storagepoolid}
    */
    readonly storagepoolid: number;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#mediaagent DiskAccesspath#mediaagent}
    */
    readonly mediaagent: DiskAccesspathMediaagent[] | cdktf.IResolvable;
}
export interface DiskAccesspathMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#id DiskAccesspath#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function diskAccesspathMediaagentToTerraform(struct?: DiskAccesspathMediaagent | cdktf.IResolvable): any;
export declare function diskAccesspathMediaagentToHclTerraform(struct?: DiskAccesspathMediaagent | cdktf.IResolvable): any;
export declare class DiskAccesspathMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DiskAccesspathMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: DiskAccesspathMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class DiskAccesspathMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DiskAccesspathMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DiskAccesspathMediaagentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath commvault_disk_accesspath}
*/
export declare class DiskAccesspath extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_disk_accesspath";
    /**
    * Generates CDKTF code for importing a DiskAccesspath resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DiskAccesspath to import
    * @param importFromId The id of the existing DiskAccesspath that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DiskAccesspath to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_accesspath commvault_disk_accesspath} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskAccesspathConfig
    */
    constructor(scope: Construct, id: string, config: DiskAccesspathConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _backuplocationid?;
    get backuplocationid(): number;
    set backuplocationid(value: number);
    get backuplocationidInput(): number | undefined;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storagepoolid?;
    get storagepoolid(): number;
    set storagepoolid(value: number);
    get storagepoolidInput(): number | undefined;
    private _mediaagent;
    get mediaagent(): DiskAccesspathMediaagentList;
    putMediaagent(value: DiskAccesspathMediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | DiskAccesspathMediaagent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
