import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the full path to the storage location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#backup_location DiskStorage#backup_location}
    */
    readonly backupLocation: string;
    /**
    * Specifies the company id to which the created disk storage should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#company_id DiskStorage#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies the Deduplication path for the storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#ddb_location DiskStorage#ddb_location}
    */
    readonly ddbLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#id DiskStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the Media agent used for the Disk Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#mediaagent DiskStorage#mediaagent}
    */
    readonly mediaagent: string;
    /**
    * Specifies the Name of the Disk Storage.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#storage_name DiskStorage#storage_name}
    */
    readonly storageName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage commvault_disk_storage}
*/
export declare class DiskStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_disk_storage";
    /**
    * Generates CDKTF code for importing a DiskStorage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DiskStorage to import
    * @param importFromId The id of the existing DiskStorage that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DiskStorage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/disk_storage commvault_disk_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskStorageConfig
    */
    constructor(scope: Construct, id: string, config: DiskStorageConfig);
    private _backupLocation?;
    get backupLocation(): string;
    set backupLocation(value: string);
    get backupLocationInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _ddbLocation?;
    get ddbLocation(): string;
    set ddbLocation(value: string);
    resetDdbLocation(): void;
    get ddbLocationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaagent?;
    get mediaagent(): string;
    set mediaagent(value: string);
    get mediaagentInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    get storageNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
