import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HypervisorAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access Key of Amazon login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#accesskey HypervisorAws#accesskey}
    */
    readonly accesskey: string;
    /**
    * The name of the hypervisor that has to be changed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#displayname HypervisorAws#displayname}
    */
    readonly displayname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enableawsadminaccount HypervisorAws#enableawsadminaccount}
    */
    readonly enableawsadminaccount?: string;
    /**
    * [Amazon]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#hypervisortype HypervisorAws#hypervisortype}
    */
    readonly hypervisortype?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the hypervisor group being created
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name: string;
    /**
    * AWS region if Iam role is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#region HypervisorAws#region}
    */
    readonly region?: string;
    /**
    * Role ARN for STS assume role with IAM policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#rolearn HypervisorAws#rolearn}
    */
    readonly rolearn?: string;
    /**
    * secret Key of Amazon login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#secretkey HypervisorAws#secretkey}
    */
    readonly secretkey: string;
    /**
    * if credential validation has to be skipped.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#skipcredentialvalidation HypervisorAws#skipcredentialvalidation}
    */
    readonly skipcredentialvalidation?: string;
    /**
    * if Iam Role is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#useiamrole HypervisorAws#useiamrole}
    */
    readonly useiamrole: string;
    /**
    * Clientname to be used as Admin Account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#useserviceaccount HypervisorAws#useserviceaccount}
    */
    readonly useserviceaccount?: string;
    /**
    * accessnodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#accessnodes HypervisorAws#accessnodes}
    */
    readonly accessnodes?: HypervisorAwsAccessnodes[] | cdktf.IResolvable;
    /**
    * activitycontrol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#activitycontrol HypervisorAws#activitycontrol}
    */
    readonly activitycontrol?: HypervisorAwsActivitycontrol[] | cdktf.IResolvable;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#credentials HypervisorAws#credentials}
    */
    readonly credentials?: HypervisorAwsCredentials[] | cdktf.IResolvable;
    /**
    * etcdprotection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#etcdprotection HypervisorAws#etcdprotection}
    */
    readonly etcdprotection?: HypervisorAwsEtcdprotection[] | cdktf.IResolvable;
    /**
    * fbrunixmediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#fbrunixmediaagent HypervisorAws#fbrunixmediaagent}
    */
    readonly fbrunixmediaagent?: HypervisorAwsFbrunixmediaagent[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#security HypervisorAws#security}
    */
    readonly security?: HypervisorAwsSecurity[] | cdktf.IResolvable;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#settings HypervisorAws#settings}
    */
    readonly settings?: HypervisorAwsSettings[] | cdktf.IResolvable;
}
export interface HypervisorAwsAccessnodes {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Type of access node , Ex: 3 - access Node , 28 - Access Node Groups
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#type HypervisorAws#type}
    */
    readonly type?: number;
}
export declare function hypervisorAwsAccessnodesToTerraform(struct?: HypervisorAwsAccessnodes | cdktf.IResolvable): any;
export declare function hypervisorAwsAccessnodesToHclTerraform(struct?: HypervisorAwsAccessnodes | cdktf.IResolvable): any;
export declare class HypervisorAwsAccessnodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsAccessnodes | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsAccessnodes | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _type?;
    get type(): number;
    set type(value: number);
    resetType(): void;
    get typeInput(): number | undefined;
}
export declare class HypervisorAwsAccessnodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsAccessnodes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsAccessnodesOutputReference;
}
export interface HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#time HypervisorAws#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#value HypervisorAws#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#timezone HypervisorAws#timezone}
    */
    readonly timezone?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeToTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeToHclTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference;
}
export interface HypervisorAwsActivitycontrolBackupactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#activitytype HypervisorAws#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enableactivitytype HypervisorAws#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enableafteradelay HypervisorAws#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#delaytime HypervisorAws#delaytime}
    */
    readonly delaytime?: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsToTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolBackupactivitycontroloptionsToHclTerraform(struct?: HypervisorAwsActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolBackupactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytimeList;
    putDelaytime(value: HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolBackupactivitycontroloptionsDelaytime[] | undefined;
}
export declare class HypervisorAwsActivitycontrolBackupactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolBackupactivitycontroloptionsOutputReference;
}
export interface HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneToHclTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference;
}
export interface HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime {
    /**
    * delay time in unix timestamp
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#time HypervisorAws#time}
    */
    readonly time?: number;
    /**
    * actual delay time value in string format according to the timezone
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#value HypervisorAws#value}
    */
    readonly value?: string;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#timezone HypervisorAws#timezone}
    */
    readonly timezone?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeToTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeToHclTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime | cdktf.IResolvable | undefined);
    private _time?;
    get time(): number;
    set time(value: number);
    resetTime(): void;
    get timeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _timezone;
    get timezone(): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList;
    putTimezone(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone[] | undefined;
}
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference;
}
export interface HypervisorAwsActivitycontrolRestoreactivitycontroloptions {
    /**
    * denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#activitytype HypervisorAws#activitytype}
    */
    readonly activitytype?: string;
    /**
    * True if the activity type is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enableactivitytype HypervisorAws#enableactivitytype}
    */
    readonly enableactivitytype?: string;
    /**
    * True if the activity will be enabled after a delay time interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enableafteradelay HypervisorAws#enableafteradelay}
    */
    readonly enableafteradelay?: string;
    /**
    * delaytime block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#delaytime HypervisorAws#delaytime}
    */
    readonly delaytime?: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable;
}
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsToTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolRestoreactivitycontroloptionsToHclTerraform(struct?: HypervisorAwsActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptions | cdktf.IResolvable | undefined);
    private _activitytype?;
    get activitytype(): string;
    set activitytype(value: string);
    resetActivitytype(): void;
    get activitytypeInput(): string | undefined;
    private _enableactivitytype?;
    get enableactivitytype(): string;
    set enableactivitytype(value: string);
    resetEnableactivitytype(): void;
    get enableactivitytypeInput(): string | undefined;
    private _enableafteradelay?;
    get enableafteradelay(): string;
    set enableafteradelay(value: string);
    resetEnableafteradelay(): void;
    get enableafteradelayInput(): string | undefined;
    private _delaytime;
    get delaytime(): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytimeList;
    putDelaytime(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime[] | cdktf.IResolvable): void;
    resetDelaytime(): void;
    get delaytimeInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolRestoreactivitycontroloptionsDelaytime[] | undefined;
}
export declare class HypervisorAwsActivitycontrolRestoreactivitycontroloptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsOutputReference;
}
export interface HypervisorAwsActivitycontrol {
    /**
    * true if Backup is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enablebackup HypervisorAws#enablebackup}
    */
    readonly enablebackup?: string;
    /**
    * true if Restore is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enablerestore HypervisorAws#enablerestore}
    */
    readonly enablerestore?: string;
    /**
    * backupactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#backupactivitycontroloptions HypervisorAws#backupactivitycontroloptions}
    */
    readonly backupactivitycontroloptions?: HypervisorAwsActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable;
    /**
    * restoreactivitycontroloptions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#restoreactivitycontroloptions HypervisorAws#restoreactivitycontroloptions}
    */
    readonly restoreactivitycontroloptions?: HypervisorAwsActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable;
}
export declare function hypervisorAwsActivitycontrolToTerraform(struct?: HypervisorAwsActivitycontrol | cdktf.IResolvable): any;
export declare function hypervisorAwsActivitycontrolToHclTerraform(struct?: HypervisorAwsActivitycontrol | cdktf.IResolvable): any;
export declare class HypervisorAwsActivitycontrolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsActivitycontrol | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsActivitycontrol | cdktf.IResolvable | undefined);
    private _enablebackup?;
    get enablebackup(): string;
    set enablebackup(value: string);
    resetEnablebackup(): void;
    get enablebackupInput(): string | undefined;
    private _enablerestore?;
    get enablerestore(): string;
    set enablerestore(value: string);
    resetEnablerestore(): void;
    get enablerestoreInput(): string | undefined;
    private _backupactivitycontroloptions;
    get backupactivitycontroloptions(): HypervisorAwsActivitycontrolBackupactivitycontroloptionsList;
    putBackupactivitycontroloptions(value: HypervisorAwsActivitycontrolBackupactivitycontroloptions[] | cdktf.IResolvable): void;
    resetBackupactivitycontroloptions(): void;
    get backupactivitycontroloptionsInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolBackupactivitycontroloptions[] | undefined;
    private _restoreactivitycontroloptions;
    get restoreactivitycontroloptions(): HypervisorAwsActivitycontrolRestoreactivitycontroloptionsList;
    putRestoreactivitycontroloptions(value: HypervisorAwsActivitycontrolRestoreactivitycontroloptions[] | cdktf.IResolvable): void;
    resetRestoreactivitycontroloptions(): void;
    get restoreactivitycontroloptionsInput(): cdktf.IResolvable | HypervisorAwsActivitycontrolRestoreactivitycontroloptions[] | undefined;
}
export declare class HypervisorAwsActivitycontrolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsActivitycontrol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsActivitycontrolOutputReference;
}
export interface HypervisorAwsCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsCredentialsToTerraform(struct?: HypervisorAwsCredentials | cdktf.IResolvable): any;
export declare function hypervisorAwsCredentialsToHclTerraform(struct?: HypervisorAwsCredentials | cdktf.IResolvable): any;
export declare class HypervisorAwsCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsCredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsCredentialsOutputReference;
}
export interface HypervisorAwsEtcdprotectionPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsEtcdprotectionPlanToTerraform(struct?: HypervisorAwsEtcdprotectionPlan | cdktf.IResolvable): any;
export declare function hypervisorAwsEtcdprotectionPlanToHclTerraform(struct?: HypervisorAwsEtcdprotectionPlan | cdktf.IResolvable): any;
export declare class HypervisorAwsEtcdprotectionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsEtcdprotectionPlan | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsEtcdprotectionPlan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsEtcdprotectionPlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsEtcdprotectionPlan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsEtcdprotectionPlanOutputReference;
}
export interface HypervisorAwsEtcdprotection {
    /**
    * Denote if etcd protection is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#enabled HypervisorAws#enabled}
    */
    readonly enabled?: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#plan HypervisorAws#plan}
    */
    readonly plan?: HypervisorAwsEtcdprotectionPlan[] | cdktf.IResolvable;
}
export declare function hypervisorAwsEtcdprotectionToTerraform(struct?: HypervisorAwsEtcdprotection | cdktf.IResolvable): any;
export declare function hypervisorAwsEtcdprotectionToHclTerraform(struct?: HypervisorAwsEtcdprotection | cdktf.IResolvable): any;
export declare class HypervisorAwsEtcdprotectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsEtcdprotection | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsEtcdprotection | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _plan;
    get plan(): HypervisorAwsEtcdprotectionPlanList;
    putPlan(value: HypervisorAwsEtcdprotectionPlan[] | cdktf.IResolvable): void;
    resetPlan(): void;
    get planInput(): cdktf.IResolvable | HypervisorAwsEtcdprotectionPlan[] | undefined;
}
export declare class HypervisorAwsEtcdprotectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsEtcdprotection[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsEtcdprotectionOutputReference;
}
export interface HypervisorAwsFbrunixmediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsFbrunixmediaagentToTerraform(struct?: HypervisorAwsFbrunixmediaagent | cdktf.IResolvable): any;
export declare function hypervisorAwsFbrunixmediaagentToHclTerraform(struct?: HypervisorAwsFbrunixmediaagent | cdktf.IResolvable): any;
export declare class HypervisorAwsFbrunixmediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsFbrunixmediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsFbrunixmediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsFbrunixmediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsFbrunixmediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsFbrunixmediaagentOutputReference;
}
export interface HypervisorAwsSecurityAssociatedusergroups {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function hypervisorAwsSecurityAssociatedusergroupsToTerraform(struct?: HypervisorAwsSecurityAssociatedusergroups | cdktf.IResolvable): any;
export declare function hypervisorAwsSecurityAssociatedusergroupsToHclTerraform(struct?: HypervisorAwsSecurityAssociatedusergroups | cdktf.IResolvable): any;
export declare class HypervisorAwsSecurityAssociatedusergroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSecurityAssociatedusergroups | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSecurityAssociatedusergroups | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class HypervisorAwsSecurityAssociatedusergroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSecurityAssociatedusergroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSecurityAssociatedusergroupsOutputReference;
}
export interface HypervisorAwsSecurity {
    /**
    * Client owners for the Hypervisor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#clientowners HypervisorAws#clientowners}
    */
    readonly clientowners?: string;
    /**
    * associatedusergroups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#associatedusergroups HypervisorAws#associatedusergroups}
    */
    readonly associatedusergroups?: HypervisorAwsSecurityAssociatedusergroups[] | cdktf.IResolvable;
}
export declare function hypervisorAwsSecurityToTerraform(struct?: HypervisorAwsSecurity | cdktf.IResolvable): any;
export declare function hypervisorAwsSecurityToHclTerraform(struct?: HypervisorAwsSecurity | cdktf.IResolvable): any;
export declare class HypervisorAwsSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSecurity | cdktf.IResolvable | undefined);
    private _clientowners?;
    get clientowners(): string;
    set clientowners(value: string);
    resetClientowners(): void;
    get clientownersInput(): string | undefined;
    private _associatedusergroups;
    get associatedusergroups(): HypervisorAwsSecurityAssociatedusergroupsList;
    putAssociatedusergroups(value: HypervisorAwsSecurityAssociatedusergroups[] | cdktf.IResolvable): void;
    resetAssociatedusergroups(): void;
    get associatedusergroupsInput(): cdktf.IResolvable | HypervisorAwsSecurityAssociatedusergroups[] | undefined;
}
export declare class HypervisorAwsSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSecurityOutputReference;
}
export interface HypervisorAwsSettingsApplicationcredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#password HypervisorAws#password}
    */
    readonly password?: string;
}
export declare function hypervisorAwsSettingsApplicationcredentialsToTerraform(struct?: HypervisorAwsSettingsApplicationcredentials | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsApplicationcredentialsToHclTerraform(struct?: HypervisorAwsSettingsApplicationcredentials | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsApplicationcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsApplicationcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsApplicationcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class HypervisorAwsSettingsApplicationcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsApplicationcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsApplicationcredentialsOutputReference;
}
export interface HypervisorAwsSettingsCustomattributes {
    /**
    * client custom attribute type . Ex- 3 - For client 8- For clientGroup
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#type HypervisorAws#type}
    */
    readonly type?: number;
    /**
    * client/Client Group custom attribute value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#value HypervisorAws#value}
    */
    readonly value?: string;
}
export declare function hypervisorAwsSettingsCustomattributesToTerraform(struct?: HypervisorAwsSettingsCustomattributes | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsCustomattributesToHclTerraform(struct?: HypervisorAwsSettingsCustomattributes | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsCustomattributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsCustomattributes | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsCustomattributes | cdktf.IResolvable | undefined);
    private _type?;
    get type(): number;
    set type(value: number);
    resetType(): void;
    get typeInput(): number | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class HypervisorAwsSettingsCustomattributesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsCustomattributes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsCustomattributesOutputReference;
}
export interface HypervisorAwsSettingsGuestcredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#password HypervisorAws#password}
    */
    readonly password?: string;
}
export declare function hypervisorAwsSettingsGuestcredentialsToTerraform(struct?: HypervisorAwsSettingsGuestcredentials | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsGuestcredentialsToHclTerraform(struct?: HypervisorAwsSettingsGuestcredentials | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsGuestcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsGuestcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsGuestcredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class HypervisorAwsSettingsGuestcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsGuestcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsGuestcredentialsOutputReference;
}
export interface HypervisorAwsSettingsMetricsmonitoringpolicy {
    /**
    * Metrics Moitoring PolicyId
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * True if Metrics Monioring policy is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#isenabled HypervisorAws#isenabled}
    */
    readonly isenabled?: string;
    /**
    * Metrics Moitoring Policy Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsSettingsMetricsmonitoringpolicyToTerraform(struct?: HypervisorAwsSettingsMetricsmonitoringpolicy | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsMetricsmonitoringpolicyToHclTerraform(struct?: HypervisorAwsSettingsMetricsmonitoringpolicy | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsMetricsmonitoringpolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsMetricsmonitoringpolicy | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsMetricsmonitoringpolicy | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _isenabled?;
    get isenabled(): string;
    set isenabled(value: string);
    resetIsenabled(): void;
    get isenabledInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsSettingsMetricsmonitoringpolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsMetricsmonitoringpolicyOutputReference;
}
export interface HypervisorAwsSettingsMountaccessnode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsSettingsMountaccessnodeToTerraform(struct?: HypervisorAwsSettingsMountaccessnode | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsMountaccessnodeToHclTerraform(struct?: HypervisorAwsSettingsMountaccessnode | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsMountaccessnodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsMountaccessnode | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsMountaccessnode | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsSettingsMountaccessnodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsMountaccessnode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsMountaccessnodeOutputReference;
}
export interface HypervisorAwsSettingsRegioninfo {
    /**
    * Display Name of Region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#displayname HypervisorAws#displayname}
    */
    readonly displayname?: string;
    /**
    * Region Id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Geolocation Latitude
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#latitude HypervisorAws#latitude}
    */
    readonly latitude?: string;
    /**
    * Geolocation Longitude
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#longitude HypervisorAws#longitude}
    */
    readonly longitude?: string;
    /**
    * Region Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsSettingsRegioninfoToTerraform(struct?: HypervisorAwsSettingsRegioninfo | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsRegioninfoToHclTerraform(struct?: HypervisorAwsSettingsRegioninfo | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsRegioninfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsRegioninfo | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsRegioninfo | cdktf.IResolvable | undefined);
    private _displayname?;
    get displayname(): string;
    set displayname(value: string);
    resetDisplayname(): void;
    get displaynameInput(): string | undefined;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _latitude?;
    get latitude(): string;
    set latitude(value: string);
    resetLatitude(): void;
    get latitudeInput(): string | undefined;
    private _longitude?;
    get longitude(): string;
    set longitude(value: string);
    resetLongitude(): void;
    get longitudeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsSettingsRegioninfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsRegioninfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsRegioninfoOutputReference;
}
export interface HypervisorAwsSettingsTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#id HypervisorAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#name HypervisorAws#name}
    */
    readonly name?: string;
}
export declare function hypervisorAwsSettingsTimezoneToTerraform(struct?: HypervisorAwsSettingsTimezone | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsTimezoneToHclTerraform(struct?: HypervisorAwsSettingsTimezone | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettingsTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettingsTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class HypervisorAwsSettingsTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettingsTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsTimezoneOutputReference;
}
export interface HypervisorAwsSettings {
    /**
    * applicationcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#applicationcredentials HypervisorAws#applicationcredentials}
    */
    readonly applicationcredentials?: HypervisorAwsSettingsApplicationcredentials[] | cdktf.IResolvable;
    /**
    * customattributes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#customattributes HypervisorAws#customattributes}
    */
    readonly customattributes?: HypervisorAwsSettingsCustomattributes[] | cdktf.IResolvable;
    /**
    * guestcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#guestcredentials HypervisorAws#guestcredentials}
    */
    readonly guestcredentials?: HypervisorAwsSettingsGuestcredentials[] | cdktf.IResolvable;
    /**
    * metricsmonitoringpolicy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#metricsmonitoringpolicy HypervisorAws#metricsmonitoringpolicy}
    */
    readonly metricsmonitoringpolicy?: HypervisorAwsSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable;
    /**
    * mountaccessnode block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#mountaccessnode HypervisorAws#mountaccessnode}
    */
    readonly mountaccessnode?: HypervisorAwsSettingsMountaccessnode[] | cdktf.IResolvable;
    /**
    * regioninfo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#regioninfo HypervisorAws#regioninfo}
    */
    readonly regioninfo?: HypervisorAwsSettingsRegioninfo[] | cdktf.IResolvable;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#timezone HypervisorAws#timezone}
    */
    readonly timezone?: HypervisorAwsSettingsTimezone[] | cdktf.IResolvable;
}
export declare function hypervisorAwsSettingsToTerraform(struct?: HypervisorAwsSettings | cdktf.IResolvable): any;
export declare function hypervisorAwsSettingsToHclTerraform(struct?: HypervisorAwsSettings | cdktf.IResolvable): any;
export declare class HypervisorAwsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HypervisorAwsSettings | cdktf.IResolvable | undefined;
    set internalValue(value: HypervisorAwsSettings | cdktf.IResolvable | undefined);
    private _applicationcredentials;
    get applicationcredentials(): HypervisorAwsSettingsApplicationcredentialsList;
    putApplicationcredentials(value: HypervisorAwsSettingsApplicationcredentials[] | cdktf.IResolvable): void;
    resetApplicationcredentials(): void;
    get applicationcredentialsInput(): cdktf.IResolvable | HypervisorAwsSettingsApplicationcredentials[] | undefined;
    private _customattributes;
    get customattributes(): HypervisorAwsSettingsCustomattributesList;
    putCustomattributes(value: HypervisorAwsSettingsCustomattributes[] | cdktf.IResolvable): void;
    resetCustomattributes(): void;
    get customattributesInput(): cdktf.IResolvable | HypervisorAwsSettingsCustomattributes[] | undefined;
    private _guestcredentials;
    get guestcredentials(): HypervisorAwsSettingsGuestcredentialsList;
    putGuestcredentials(value: HypervisorAwsSettingsGuestcredentials[] | cdktf.IResolvable): void;
    resetGuestcredentials(): void;
    get guestcredentialsInput(): cdktf.IResolvable | HypervisorAwsSettingsGuestcredentials[] | undefined;
    private _metricsmonitoringpolicy;
    get metricsmonitoringpolicy(): HypervisorAwsSettingsMetricsmonitoringpolicyList;
    putMetricsmonitoringpolicy(value: HypervisorAwsSettingsMetricsmonitoringpolicy[] | cdktf.IResolvable): void;
    resetMetricsmonitoringpolicy(): void;
    get metricsmonitoringpolicyInput(): cdktf.IResolvable | HypervisorAwsSettingsMetricsmonitoringpolicy[] | undefined;
    private _mountaccessnode;
    get mountaccessnode(): HypervisorAwsSettingsMountaccessnodeList;
    putMountaccessnode(value: HypervisorAwsSettingsMountaccessnode[] | cdktf.IResolvable): void;
    resetMountaccessnode(): void;
    get mountaccessnodeInput(): cdktf.IResolvable | HypervisorAwsSettingsMountaccessnode[] | undefined;
    private _regioninfo;
    get regioninfo(): HypervisorAwsSettingsRegioninfoList;
    putRegioninfo(value: HypervisorAwsSettingsRegioninfo[] | cdktf.IResolvable): void;
    resetRegioninfo(): void;
    get regioninfoInput(): cdktf.IResolvable | HypervisorAwsSettingsRegioninfo[] | undefined;
    private _timezone;
    get timezone(): HypervisorAwsSettingsTimezoneList;
    putTimezone(value: HypervisorAwsSettingsTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | HypervisorAwsSettingsTimezone[] | undefined;
}
export declare class HypervisorAwsSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HypervisorAwsSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HypervisorAwsSettingsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws commvault_hypervisor_aws}
*/
export declare class HypervisorAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_hypervisor_aws";
    /**
    * Generates CDKTF code for importing a HypervisorAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HypervisorAws to import
    * @param importFromId The id of the existing HypervisorAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HypervisorAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/hypervisor_aws commvault_hypervisor_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HypervisorAwsConfig
    */
    constructor(scope: Construct, id: string, config: HypervisorAwsConfig);
    private _accesskey?;
    get accesskey(): string;
    set accesskey(value: string);
    get accesskeyInput(): string | undefined;
    private _displayname?;
    get displayname(): string;
    set displayname(value: string);
    resetDisplayname(): void;
    get displaynameInput(): string | undefined;
    private _enableawsadminaccount?;
    get enableawsadminaccount(): string;
    set enableawsadminaccount(value: string);
    resetEnableawsadminaccount(): void;
    get enableawsadminaccountInput(): string | undefined;
    private _hypervisortype?;
    get hypervisortype(): string;
    set hypervisortype(value: string);
    resetHypervisortype(): void;
    get hypervisortypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rolearn?;
    get rolearn(): string;
    set rolearn(value: string);
    resetRolearn(): void;
    get rolearnInput(): string | undefined;
    private _secretkey?;
    get secretkey(): string;
    set secretkey(value: string);
    get secretkeyInput(): string | undefined;
    private _skipcredentialvalidation?;
    get skipcredentialvalidation(): string;
    set skipcredentialvalidation(value: string);
    resetSkipcredentialvalidation(): void;
    get skipcredentialvalidationInput(): string | undefined;
    private _useiamrole?;
    get useiamrole(): string;
    set useiamrole(value: string);
    get useiamroleInput(): string | undefined;
    private _useserviceaccount?;
    get useserviceaccount(): string;
    set useserviceaccount(value: string);
    resetUseserviceaccount(): void;
    get useserviceaccountInput(): string | undefined;
    private _accessnodes;
    get accessnodes(): HypervisorAwsAccessnodesList;
    putAccessnodes(value: HypervisorAwsAccessnodes[] | cdktf.IResolvable): void;
    resetAccessnodes(): void;
    get accessnodesInput(): cdktf.IResolvable | HypervisorAwsAccessnodes[] | undefined;
    private _activitycontrol;
    get activitycontrol(): HypervisorAwsActivitycontrolList;
    putActivitycontrol(value: HypervisorAwsActivitycontrol[] | cdktf.IResolvable): void;
    resetActivitycontrol(): void;
    get activitycontrolInput(): cdktf.IResolvable | HypervisorAwsActivitycontrol[] | undefined;
    private _credentials;
    get credentials(): HypervisorAwsCredentialsList;
    putCredentials(value: HypervisorAwsCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | HypervisorAwsCredentials[] | undefined;
    private _etcdprotection;
    get etcdprotection(): HypervisorAwsEtcdprotectionList;
    putEtcdprotection(value: HypervisorAwsEtcdprotection[] | cdktf.IResolvable): void;
    resetEtcdprotection(): void;
    get etcdprotectionInput(): cdktf.IResolvable | HypervisorAwsEtcdprotection[] | undefined;
    private _fbrunixmediaagent;
    get fbrunixmediaagent(): HypervisorAwsFbrunixmediaagentList;
    putFbrunixmediaagent(value: HypervisorAwsFbrunixmediaagent[] | cdktf.IResolvable): void;
    resetFbrunixmediaagent(): void;
    get fbrunixmediaagentInput(): cdktf.IResolvable | HypervisorAwsFbrunixmediaagent[] | undefined;
    private _security;
    get security(): HypervisorAwsSecurityList;
    putSecurity(value: HypervisorAwsSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | HypervisorAwsSecurity[] | undefined;
    private _settings;
    get settings(): HypervisorAwsSettingsList;
    putSettings(value: HypervisorAwsSettings[] | cdktf.IResolvable): void;
    resetSettings(): void;
    get settingsInput(): cdktf.IResolvable | HypervisorAwsSettings[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
