import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesAppgroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#id KubernetesAppgroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specify new name to rename an Application Group
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
    /**
    * activitycontrol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#activitycontrol KubernetesAppgroup#activitycontrol}
    */
    readonly activitycontrol?: KubernetesAppgroupActivitycontrol[] | cdktf.IResolvable;
    /**
    * cluster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#cluster KubernetesAppgroup#cluster}
    */
    readonly cluster?: KubernetesAppgroupCluster[] | cdktf.IResolvable;
    /**
    * content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#content KubernetesAppgroup#content}
    */
    readonly content?: KubernetesAppgroupContent[] | cdktf.IResolvable;
    /**
    * filters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#filters KubernetesAppgroup#filters}
    */
    readonly filters?: KubernetesAppgroupFilters[] | cdktf.IResolvable;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#options KubernetesAppgroup#options}
    */
    readonly options?: KubernetesAppgroupOptions[] | cdktf.IResolvable;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#plan KubernetesAppgroup#plan}
    */
    readonly plan?: KubernetesAppgroupPlan[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#tags KubernetesAppgroup#tags}
    */
    readonly tags?: KubernetesAppgroupTags[] | cdktf.IResolvable;
    /**
    * timezone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#timezone KubernetesAppgroup#timezone}
    */
    readonly timezone?: KubernetesAppgroupTimezone[] | cdktf.IResolvable;
}
export interface KubernetesAppgroupActivitycontrol {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#enablebackup KubernetesAppgroup#enablebackup}
    */
    readonly enablebackup?: string;
}
export declare function kubernetesAppgroupActivitycontrolToTerraform(struct?: KubernetesAppgroupActivitycontrol | cdktf.IResolvable): any;
export declare function kubernetesAppgroupActivitycontrolToHclTerraform(struct?: KubernetesAppgroupActivitycontrol | cdktf.IResolvable): any;
export declare class KubernetesAppgroupActivitycontrolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupActivitycontrol | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupActivitycontrol | cdktf.IResolvable | undefined);
    private _enablebackup?;
    get enablebackup(): string;
    set enablebackup(value: string);
    resetEnablebackup(): void;
    get enablebackupInput(): string | undefined;
}
export declare class KubernetesAppgroupActivitycontrolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupActivitycontrol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupActivitycontrolOutputReference;
}
export interface KubernetesAppgroupCluster {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#id KubernetesAppgroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
}
export declare function kubernetesAppgroupClusterToTerraform(struct?: KubernetesAppgroupCluster | cdktf.IResolvable): any;
export declare function kubernetesAppgroupClusterToHclTerraform(struct?: KubernetesAppgroupCluster | cdktf.IResolvable): any;
export declare class KubernetesAppgroupClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupCluster | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupCluster | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class KubernetesAppgroupClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupClusterOutputReference;
}
export interface KubernetesAppgroupContentApplications {
    /**
    * GUID value of the Kubernetes Application to be associated as content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#guid KubernetesAppgroup#guid}
    */
    readonly guid: string;
    /**
    * Name of the application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
    /**
    * Type of the Kubernetes application [NAMESPACE, APPLICATION, PVC, LABELS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#type KubernetesAppgroup#type}
    */
    readonly type: string;
}
export declare function kubernetesAppgroupContentApplicationsToTerraform(struct?: KubernetesAppgroupContentApplications | cdktf.IResolvable): any;
export declare function kubernetesAppgroupContentApplicationsToHclTerraform(struct?: KubernetesAppgroupContentApplications | cdktf.IResolvable): any;
export declare class KubernetesAppgroupContentApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupContentApplications | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupContentApplications | cdktf.IResolvable | undefined);
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class KubernetesAppgroupContentApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupContentApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupContentApplicationsOutputReference;
}
export interface KubernetesAppgroupContentLabelselectors {
    /**
    * Selector level of the label selector [Application, Volumes, Namespace]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#selectorlevel KubernetesAppgroup#selectorlevel}
    */
    readonly selectorlevel: string;
    /**
    * Value of the label selector in key=value format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#selectorvalue KubernetesAppgroup#selectorvalue}
    */
    readonly selectorvalue: string;
}
export declare function kubernetesAppgroupContentLabelselectorsToTerraform(struct?: KubernetesAppgroupContentLabelselectors | cdktf.IResolvable): any;
export declare function kubernetesAppgroupContentLabelselectorsToHclTerraform(struct?: KubernetesAppgroupContentLabelselectors | cdktf.IResolvable): any;
export declare class KubernetesAppgroupContentLabelselectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupContentLabelselectors | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupContentLabelselectors | cdktf.IResolvable | undefined);
    private _selectorlevel?;
    get selectorlevel(): string;
    set selectorlevel(value: string);
    get selectorlevelInput(): string | undefined;
    private _selectorvalue?;
    get selectorvalue(): string;
    set selectorvalue(value: string);
    get selectorvalueInput(): string | undefined;
}
export declare class KubernetesAppgroupContentLabelselectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupContentLabelselectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupContentLabelselectorsOutputReference;
}
export interface KubernetesAppgroupContent {
    /**
    * applications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#applications KubernetesAppgroup#applications}
    */
    readonly applications?: KubernetesAppgroupContentApplications[] | cdktf.IResolvable;
    /**
    * labelselectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#labelselectors KubernetesAppgroup#labelselectors}
    */
    readonly labelselectors?: KubernetesAppgroupContentLabelselectors[] | cdktf.IResolvable;
}
export declare function kubernetesAppgroupContentToTerraform(struct?: KubernetesAppgroupContent | cdktf.IResolvable): any;
export declare function kubernetesAppgroupContentToHclTerraform(struct?: KubernetesAppgroupContent | cdktf.IResolvable): any;
export declare class KubernetesAppgroupContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupContent | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupContent | cdktf.IResolvable | undefined);
    private _applications;
    get applications(): KubernetesAppgroupContentApplicationsList;
    putApplications(value: KubernetesAppgroupContentApplications[] | cdktf.IResolvable): void;
    resetApplications(): void;
    get applicationsInput(): cdktf.IResolvable | KubernetesAppgroupContentApplications[] | undefined;
    private _labelselectors;
    get labelselectors(): KubernetesAppgroupContentLabelselectorsList;
    putLabelselectors(value: KubernetesAppgroupContentLabelselectors[] | cdktf.IResolvable): void;
    resetLabelselectors(): void;
    get labelselectorsInput(): cdktf.IResolvable | KubernetesAppgroupContentLabelselectors[] | undefined;
}
export declare class KubernetesAppgroupContentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupContent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupContentOutputReference;
}
export interface KubernetesAppgroupFiltersApplications {
    /**
    * GUID value of the Kubernetes Application to be associated as content
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#guid KubernetesAppgroup#guid}
    */
    readonly guid: string;
    /**
    * Name of the application
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
    /**
    * Type of the Kubernetes application [NAMESPACE, APPLICATION, PVC, LABELS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#type KubernetesAppgroup#type}
    */
    readonly type: string;
}
export declare function kubernetesAppgroupFiltersApplicationsToTerraform(struct?: KubernetesAppgroupFiltersApplications | cdktf.IResolvable): any;
export declare function kubernetesAppgroupFiltersApplicationsToHclTerraform(struct?: KubernetesAppgroupFiltersApplications | cdktf.IResolvable): any;
export declare class KubernetesAppgroupFiltersApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupFiltersApplications | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupFiltersApplications | cdktf.IResolvable | undefined);
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class KubernetesAppgroupFiltersApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupFiltersApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupFiltersApplicationsOutputReference;
}
export interface KubernetesAppgroupFiltersLabelselectors {
    /**
    * Selector level of the label selector [Application, Volumes, Namespace]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#selectorlevel KubernetesAppgroup#selectorlevel}
    */
    readonly selectorlevel: string;
    /**
    * Value of the label selector in key=value format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#selectorvalue KubernetesAppgroup#selectorvalue}
    */
    readonly selectorvalue: string;
}
export declare function kubernetesAppgroupFiltersLabelselectorsToTerraform(struct?: KubernetesAppgroupFiltersLabelselectors | cdktf.IResolvable): any;
export declare function kubernetesAppgroupFiltersLabelselectorsToHclTerraform(struct?: KubernetesAppgroupFiltersLabelselectors | cdktf.IResolvable): any;
export declare class KubernetesAppgroupFiltersLabelselectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupFiltersLabelselectors | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupFiltersLabelselectors | cdktf.IResolvable | undefined);
    private _selectorlevel?;
    get selectorlevel(): string;
    set selectorlevel(value: string);
    get selectorlevelInput(): string | undefined;
    private _selectorvalue?;
    get selectorvalue(): string;
    set selectorvalue(value: string);
    get selectorvalueInput(): string | undefined;
}
export declare class KubernetesAppgroupFiltersLabelselectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupFiltersLabelselectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupFiltersLabelselectorsOutputReference;
}
export interface KubernetesAppgroupFilters {
    /**
    * Specify whether to skip backup of stateless applications
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#skipstatelessapps KubernetesAppgroup#skipstatelessapps}
    */
    readonly skipstatelessapps?: string;
    /**
    * applications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#applications KubernetesAppgroup#applications}
    */
    readonly applications?: KubernetesAppgroupFiltersApplications[] | cdktf.IResolvable;
    /**
    * labelselectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#labelselectors KubernetesAppgroup#labelselectors}
    */
    readonly labelselectors?: KubernetesAppgroupFiltersLabelselectors[] | cdktf.IResolvable;
}
export declare function kubernetesAppgroupFiltersToTerraform(struct?: KubernetesAppgroupFilters | cdktf.IResolvable): any;
export declare function kubernetesAppgroupFiltersToHclTerraform(struct?: KubernetesAppgroupFilters | cdktf.IResolvable): any;
export declare class KubernetesAppgroupFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupFilters | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupFilters | cdktf.IResolvable | undefined);
    private _skipstatelessapps?;
    get skipstatelessapps(): string;
    set skipstatelessapps(value: string);
    resetSkipstatelessapps(): void;
    get skipstatelessappsInput(): string | undefined;
    private _applications;
    get applications(): KubernetesAppgroupFiltersApplicationsList;
    putApplications(value: KubernetesAppgroupFiltersApplications[] | cdktf.IResolvable): void;
    resetApplications(): void;
    get applicationsInput(): cdktf.IResolvable | KubernetesAppgroupFiltersApplications[] | undefined;
    private _labelselectors;
    get labelselectors(): KubernetesAppgroupFiltersLabelselectorsList;
    putLabelselectors(value: KubernetesAppgroupFiltersLabelselectors[] | cdktf.IResolvable): void;
    resetLabelselectors(): void;
    get labelselectorsInput(): cdktf.IResolvable | KubernetesAppgroupFiltersLabelselectors[] | undefined;
}
export declare class KubernetesAppgroupFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupFiltersOutputReference;
}
export interface KubernetesAppgroupOptionsWorkerresources {
    /**
    * Define limits.cpu to set on the worker Pod
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#cpulimits KubernetesAppgroup#cpulimits}
    */
    readonly cpulimits?: string;
    /**
    * Define requests.cpu to set on the worker Pod
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#cpurequests KubernetesAppgroup#cpurequests}
    */
    readonly cpurequests?: string;
    /**
    * Define limits.memory to set on the worker Pod
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#memorylimits KubernetesAppgroup#memorylimits}
    */
    readonly memorylimits?: string;
    /**
    * Define requests.memory to set on the worker Pod
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#memoryrequests KubernetesAppgroup#memoryrequests}
    */
    readonly memoryrequests?: string;
}
export declare function kubernetesAppgroupOptionsWorkerresourcesToTerraform(struct?: KubernetesAppgroupOptionsWorkerresources | cdktf.IResolvable): any;
export declare function kubernetesAppgroupOptionsWorkerresourcesToHclTerraform(struct?: KubernetesAppgroupOptionsWorkerresources | cdktf.IResolvable): any;
export declare class KubernetesAppgroupOptionsWorkerresourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupOptionsWorkerresources | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupOptionsWorkerresources | cdktf.IResolvable | undefined);
    private _cpulimits?;
    get cpulimits(): string;
    set cpulimits(value: string);
    resetCpulimits(): void;
    get cpulimitsInput(): string | undefined;
    private _cpurequests?;
    get cpurequests(): string;
    set cpurequests(value: string);
    resetCpurequests(): void;
    get cpurequestsInput(): string | undefined;
    private _memorylimits?;
    get memorylimits(): string;
    set memorylimits(value: string);
    resetMemorylimits(): void;
    get memorylimitsInput(): string | undefined;
    private _memoryrequests?;
    get memoryrequests(): string;
    set memoryrequests(value: string);
    resetMemoryrequests(): void;
    get memoryrequestsInput(): string | undefined;
}
export declare class KubernetesAppgroupOptionsWorkerresourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupOptionsWorkerresources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupOptionsWorkerresourcesOutputReference;
}
export interface KubernetesAppgroupOptions {
    /**
    * Define number of parallel data readers
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#backupstreams KubernetesAppgroup#backupstreams}
    */
    readonly backupstreams?: number;
    /**
    * Define setting to enable scheduling worker Pods to CV Namespace for CSI-Snapshot enabled backups
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#cvnamespacescheduling KubernetesAppgroup#cvnamespacescheduling}
    */
    readonly cvnamespacescheduling?: string;
    /**
    * Define the backup job start time in epochs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#jobstarttime KubernetesAppgroup#jobstarttime}
    */
    readonly jobstarttime?: number;
    /**
    * Define setting to enable fallback to live volume backup in case of snap failure
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#snapfallbacktolivevolumebackup KubernetesAppgroup#snapfallbacktolivevolumebackup}
    */
    readonly snapfallbacktolivevolumebackup?: string;
    /**
    * workerresources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#workerresources KubernetesAppgroup#workerresources}
    */
    readonly workerresources?: KubernetesAppgroupOptionsWorkerresources[] | cdktf.IResolvable;
}
export declare function kubernetesAppgroupOptionsToTerraform(struct?: KubernetesAppgroupOptions | cdktf.IResolvable): any;
export declare function kubernetesAppgroupOptionsToHclTerraform(struct?: KubernetesAppgroupOptions | cdktf.IResolvable): any;
export declare class KubernetesAppgroupOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupOptions | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupOptions | cdktf.IResolvable | undefined);
    private _backupstreams?;
    get backupstreams(): number;
    set backupstreams(value: number);
    resetBackupstreams(): void;
    get backupstreamsInput(): number | undefined;
    private _cvnamespacescheduling?;
    get cvnamespacescheduling(): string;
    set cvnamespacescheduling(value: string);
    resetCvnamespacescheduling(): void;
    get cvnamespaceschedulingInput(): string | undefined;
    private _jobstarttime?;
    get jobstarttime(): number;
    set jobstarttime(value: number);
    resetJobstarttime(): void;
    get jobstarttimeInput(): number | undefined;
    private _snapfallbacktolivevolumebackup?;
    get snapfallbacktolivevolumebackup(): string;
    set snapfallbacktolivevolumebackup(value: string);
    resetSnapfallbacktolivevolumebackup(): void;
    get snapfallbacktolivevolumebackupInput(): string | undefined;
    private _workerresources;
    get workerresources(): KubernetesAppgroupOptionsWorkerresourcesList;
    putWorkerresources(value: KubernetesAppgroupOptionsWorkerresources[] | cdktf.IResolvable): void;
    resetWorkerresources(): void;
    get workerresourcesInput(): cdktf.IResolvable | KubernetesAppgroupOptionsWorkerresources[] | undefined;
}
export declare class KubernetesAppgroupOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupOptionsOutputReference;
}
export interface KubernetesAppgroupPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#id KubernetesAppgroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
}
export declare function kubernetesAppgroupPlanToTerraform(struct?: KubernetesAppgroupPlan | cdktf.IResolvable): any;
export declare function kubernetesAppgroupPlanToHclTerraform(struct?: KubernetesAppgroupPlan | cdktf.IResolvable): any;
export declare class KubernetesAppgroupPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupPlan | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupPlan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class KubernetesAppgroupPlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupPlan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupPlanOutputReference;
}
export interface KubernetesAppgroupTags {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#value KubernetesAppgroup#value}
    */
    readonly value?: string;
}
export declare function kubernetesAppgroupTagsToTerraform(struct?: KubernetesAppgroupTags | cdktf.IResolvable): any;
export declare function kubernetesAppgroupTagsToHclTerraform(struct?: KubernetesAppgroupTags | cdktf.IResolvable): any;
export declare class KubernetesAppgroupTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupTags | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class KubernetesAppgroupTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupTagsOutputReference;
}
export interface KubernetesAppgroupTimezone {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#id KubernetesAppgroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#name KubernetesAppgroup#name}
    */
    readonly name?: string;
}
export declare function kubernetesAppgroupTimezoneToTerraform(struct?: KubernetesAppgroupTimezone | cdktf.IResolvable): any;
export declare function kubernetesAppgroupTimezoneToHclTerraform(struct?: KubernetesAppgroupTimezone | cdktf.IResolvable): any;
export declare class KubernetesAppgroupTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesAppgroupTimezone | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesAppgroupTimezone | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class KubernetesAppgroupTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesAppgroupTimezone[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesAppgroupTimezoneOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup commvault_kubernetes_appgroup}
*/
export declare class KubernetesAppgroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_kubernetes_appgroup";
    /**
    * Generates CDKTF code for importing a KubernetesAppgroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesAppgroup to import
    * @param importFromId The id of the existing KubernetesAppgroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesAppgroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_appgroup commvault_kubernetes_appgroup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesAppgroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: KubernetesAppgroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _activitycontrol;
    get activitycontrol(): KubernetesAppgroupActivitycontrolList;
    putActivitycontrol(value: KubernetesAppgroupActivitycontrol[] | cdktf.IResolvable): void;
    resetActivitycontrol(): void;
    get activitycontrolInput(): cdktf.IResolvable | KubernetesAppgroupActivitycontrol[] | undefined;
    private _cluster;
    get cluster(): KubernetesAppgroupClusterList;
    putCluster(value: KubernetesAppgroupCluster[] | cdktf.IResolvable): void;
    resetCluster(): void;
    get clusterInput(): cdktf.IResolvable | KubernetesAppgroupCluster[] | undefined;
    private _content;
    get content(): KubernetesAppgroupContentList;
    putContent(value: KubernetesAppgroupContent[] | cdktf.IResolvable): void;
    resetContent(): void;
    get contentInput(): cdktf.IResolvable | KubernetesAppgroupContent[] | undefined;
    private _filters;
    get filters(): KubernetesAppgroupFiltersList;
    putFilters(value: KubernetesAppgroupFilters[] | cdktf.IResolvable): void;
    resetFilters(): void;
    get filtersInput(): cdktf.IResolvable | KubernetesAppgroupFilters[] | undefined;
    private _options;
    get options(): KubernetesAppgroupOptionsList;
    putOptions(value: KubernetesAppgroupOptions[] | cdktf.IResolvable): void;
    resetOptions(): void;
    get optionsInput(): cdktf.IResolvable | KubernetesAppgroupOptions[] | undefined;
    private _plan;
    get plan(): KubernetesAppgroupPlanList;
    putPlan(value: KubernetesAppgroupPlan[] | cdktf.IResolvable): void;
    resetPlan(): void;
    get planInput(): cdktf.IResolvable | KubernetesAppgroupPlan[] | undefined;
    private _tags;
    get tags(): KubernetesAppgroupTagsList;
    putTags(value: KubernetesAppgroupTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | KubernetesAppgroupTags[] | undefined;
    private _timezone;
    get timezone(): KubernetesAppgroupTimezoneList;
    putTimezone(value: KubernetesAppgroupTimezone[] | cdktf.IResolvable): void;
    resetTimezone(): void;
    get timezoneInput(): cdktf.IResolvable | KubernetesAppgroupTimezone[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
