import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * API Server Endpoint of the cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#apiserver KubernetesCluster#apiserver}
    */
    readonly apiserver?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Kubernetes Cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name?: string;
    /**
    * Name of the Service Account to authenticate with the cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#serviceaccount KubernetesCluster#serviceaccount}
    */
    readonly serviceaccount?: string;
    /**
    * Secret token to authenticate with the cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#servicetoken KubernetesCluster#servicetoken}
    */
    readonly servicetoken?: string;
    /**
    * The Service Type of the Kubernetes cluster [ONPREM, AKS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#servicetype KubernetesCluster#servicetype}
    */
    readonly servicetype?: string;
    /**
    * accessnodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#accessnodes KubernetesCluster#accessnodes}
    */
    readonly accessnodes?: KubernetesClusterAccessnodes[] | cdktf.IResolvable;
    /**
    * activitycontrol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#activitycontrol KubernetesCluster#activitycontrol}
    */
    readonly activitycontrol?: KubernetesClusterActivitycontrol[] | cdktf.IResolvable;
    /**
    * etcdprotection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#etcdprotection KubernetesCluster#etcdprotection}
    */
    readonly etcdprotection?: KubernetesClusterEtcdprotection[] | cdktf.IResolvable;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#options KubernetesCluster#options}
    */
    readonly options?: KubernetesClusterOptions[] | cdktf.IResolvable;
    /**
    * region block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#region KubernetesCluster#region}
    */
    readonly region?: KubernetesClusterRegion[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#tags KubernetesCluster#tags}
    */
    readonly tags?: KubernetesClusterTags[] | cdktf.IResolvable;
}
export interface KubernetesClusterAccessnodes {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#type KubernetesCluster#type}
    */
    readonly type?: string;
}
export declare function kubernetesClusterAccessnodesToTerraform(struct?: KubernetesClusterAccessnodes | cdktf.IResolvable): any;
export declare function kubernetesClusterAccessnodesToHclTerraform(struct?: KubernetesClusterAccessnodes | cdktf.IResolvable): any;
export declare class KubernetesClusterAccessnodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterAccessnodes | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterAccessnodes | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class KubernetesClusterAccessnodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterAccessnodes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterAccessnodesOutputReference;
}
export interface KubernetesClusterActivitycontrol {
    /**
    * Enable or disable backup for cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#enablebackup KubernetesCluster#enablebackup}
    */
    readonly enablebackup?: string;
    /**
    * Enabling backup after a delay. Provide UTC Time in Unix format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#enablebackupafteradelay KubernetesCluster#enablebackupafteradelay}
    */
    readonly enablebackupafteradelay?: number;
    /**
    * Enable or disable restore for cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#enablerestore KubernetesCluster#enablerestore}
    */
    readonly enablerestore?: string;
    /**
    * Enabling restore after a delay. Provide UTC Time in Unix format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#enablerestoreafteradelay KubernetesCluster#enablerestoreafteradelay}
    */
    readonly enablerestoreafteradelay?: number;
}
export declare function kubernetesClusterActivitycontrolToTerraform(struct?: KubernetesClusterActivitycontrol | cdktf.IResolvable): any;
export declare function kubernetesClusterActivitycontrolToHclTerraform(struct?: KubernetesClusterActivitycontrol | cdktf.IResolvable): any;
export declare class KubernetesClusterActivitycontrolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterActivitycontrol | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterActivitycontrol | cdktf.IResolvable | undefined);
    private _enablebackup?;
    get enablebackup(): string;
    set enablebackup(value: string);
    resetEnablebackup(): void;
    get enablebackupInput(): string | undefined;
    private _enablebackupafteradelay?;
    get enablebackupafteradelay(): number;
    set enablebackupafteradelay(value: number);
    resetEnablebackupafteradelay(): void;
    get enablebackupafteradelayInput(): number | undefined;
    private _enablerestore?;
    get enablerestore(): string;
    set enablerestore(value: string);
    resetEnablerestore(): void;
    get enablerestoreInput(): string | undefined;
    private _enablerestoreafteradelay?;
    get enablerestoreafteradelay(): number;
    set enablerestoreafteradelay(value: number);
    resetEnablerestoreafteradelay(): void;
    get enablerestoreafteradelayInput(): number | undefined;
}
export declare class KubernetesClusterActivitycontrolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterActivitycontrol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterActivitycontrolOutputReference;
}
export interface KubernetesClusterEtcdprotectionPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name?: string;
}
export declare function kubernetesClusterEtcdprotectionPlanToTerraform(struct?: KubernetesClusterEtcdprotectionPlan | cdktf.IResolvable): any;
export declare function kubernetesClusterEtcdprotectionPlanToHclTerraform(struct?: KubernetesClusterEtcdprotectionPlan | cdktf.IResolvable): any;
export declare class KubernetesClusterEtcdprotectionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterEtcdprotectionPlan | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterEtcdprotectionPlan | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class KubernetesClusterEtcdprotectionPlanList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterEtcdprotectionPlan[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterEtcdprotectionPlanOutputReference;
}
export interface KubernetesClusterEtcdprotection {
    /**
    * Denote if etcd protection is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#enabled KubernetesCluster#enabled}
    */
    readonly enabled?: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#plan KubernetesCluster#plan}
    */
    readonly plan?: KubernetesClusterEtcdprotectionPlan[] | cdktf.IResolvable;
}
export declare function kubernetesClusterEtcdprotectionToTerraform(struct?: KubernetesClusterEtcdprotection | cdktf.IResolvable): any;
export declare function kubernetesClusterEtcdprotectionToHclTerraform(struct?: KubernetesClusterEtcdprotection | cdktf.IResolvable): any;
export declare class KubernetesClusterEtcdprotectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterEtcdprotection | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterEtcdprotection | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    private _plan;
    get plan(): KubernetesClusterEtcdprotectionPlanList;
    putPlan(value: KubernetesClusterEtcdprotectionPlan[] | cdktf.IResolvable): void;
    resetPlan(): void;
    get planInput(): cdktf.IResolvable | KubernetesClusterEtcdprotectionPlan[] | undefined;
}
export declare class KubernetesClusterEtcdprotectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterEtcdprotection[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterEtcdprotectionOutputReference;
}
export interface KubernetesClusterOptionsImageregistry {
    /**
    * Specify image pull secret to authenticate with the image repository
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#imagepullsecret KubernetesCluster#imagepullsecret}
    */
    readonly imagepullsecret?: string;
    /**
    * Specify image registry URL for internal image repository
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#registryurl KubernetesCluster#registryurl}
    */
    readonly registryurl?: string;
}
export declare function kubernetesClusterOptionsImageregistryToTerraform(struct?: KubernetesClusterOptionsImageregistry | cdktf.IResolvable): any;
export declare function kubernetesClusterOptionsImageregistryToHclTerraform(struct?: KubernetesClusterOptionsImageregistry | cdktf.IResolvable): any;
export declare class KubernetesClusterOptionsImageregistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterOptionsImageregistry | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterOptionsImageregistry | cdktf.IResolvable | undefined);
    private _imagepullsecret?;
    get imagepullsecret(): string;
    set imagepullsecret(value: string);
    resetImagepullsecret(): void;
    get imagepullsecretInput(): string | undefined;
    private _registryurl?;
    get registryurl(): string;
    set registryurl(value: string);
    resetRegistryurl(): void;
    get registryurlInput(): string | undefined;
}
export declare class KubernetesClusterOptionsImageregistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterOptionsImageregistry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterOptionsImageregistryOutputReference;
}
export interface KubernetesClusterOptions {
    /**
    * imageregistry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#imageregistry KubernetesCluster#imageregistry}
    */
    readonly imageregistry?: KubernetesClusterOptionsImageregistry[] | cdktf.IResolvable;
}
export declare function kubernetesClusterOptionsToTerraform(struct?: KubernetesClusterOptions | cdktf.IResolvable): any;
export declare function kubernetesClusterOptionsToHclTerraform(struct?: KubernetesClusterOptions | cdktf.IResolvable): any;
export declare class KubernetesClusterOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterOptions | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterOptions | cdktf.IResolvable | undefined);
    private _imageregistry;
    get imageregistry(): KubernetesClusterOptionsImageregistryList;
    putImageregistry(value: KubernetesClusterOptionsImageregistry[] | cdktf.IResolvable): void;
    resetImageregistry(): void;
    get imageregistryInput(): cdktf.IResolvable | KubernetesClusterOptionsImageregistry[] | undefined;
}
export declare class KubernetesClusterOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterOptionsOutputReference;
}
export interface KubernetesClusterRegion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name?: string;
}
export declare function kubernetesClusterRegionToTerraform(struct?: KubernetesClusterRegion | cdktf.IResolvable): any;
export declare function kubernetesClusterRegionToHclTerraform(struct?: KubernetesClusterRegion | cdktf.IResolvable): any;
export declare class KubernetesClusterRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterRegion | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterRegion | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class KubernetesClusterRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterRegion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterRegionOutputReference;
}
export interface KubernetesClusterTags {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#value KubernetesCluster#value}
    */
    readonly value?: string;
}
export declare function kubernetesClusterTagsToTerraform(struct?: KubernetesClusterTags | cdktf.IResolvable): any;
export declare function kubernetesClusterTagsToHclTerraform(struct?: KubernetesClusterTags | cdktf.IResolvable): any;
export declare class KubernetesClusterTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterTags | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class KubernetesClusterTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterTagsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster commvault_kubernetes_cluster}
*/
export declare class KubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a KubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesCluster to import
    * @param importFromId The id of the existing KubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/kubernetes_cluster commvault_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: KubernetesClusterConfig);
    private _apiserver?;
    get apiserver(): string;
    set apiserver(value: string);
    resetApiserver(): void;
    get apiserverInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _serviceaccount?;
    get serviceaccount(): string;
    set serviceaccount(value: string);
    resetServiceaccount(): void;
    get serviceaccountInput(): string | undefined;
    private _servicetoken?;
    get servicetoken(): string;
    set servicetoken(value: string);
    resetServicetoken(): void;
    get servicetokenInput(): string | undefined;
    private _servicetype?;
    get servicetype(): string;
    set servicetype(value: string);
    resetServicetype(): void;
    get servicetypeInput(): string | undefined;
    private _accessnodes;
    get accessnodes(): KubernetesClusterAccessnodesList;
    putAccessnodes(value: KubernetesClusterAccessnodes[] | cdktf.IResolvable): void;
    resetAccessnodes(): void;
    get accessnodesInput(): cdktf.IResolvable | KubernetesClusterAccessnodes[] | undefined;
    private _activitycontrol;
    get activitycontrol(): KubernetesClusterActivitycontrolList;
    putActivitycontrol(value: KubernetesClusterActivitycontrol[] | cdktf.IResolvable): void;
    resetActivitycontrol(): void;
    get activitycontrolInput(): cdktf.IResolvable | KubernetesClusterActivitycontrol[] | undefined;
    private _etcdprotection;
    get etcdprotection(): KubernetesClusterEtcdprotectionList;
    putEtcdprotection(value: KubernetesClusterEtcdprotection[] | cdktf.IResolvable): void;
    resetEtcdprotection(): void;
    get etcdprotectionInput(): cdktf.IResolvable | KubernetesClusterEtcdprotection[] | undefined;
    private _options;
    get options(): KubernetesClusterOptionsList;
    putOptions(value: KubernetesClusterOptions[] | cdktf.IResolvable): void;
    resetOptions(): void;
    get optionsInput(): cdktf.IResolvable | KubernetesClusterOptions[] | undefined;
    private _region;
    get region(): KubernetesClusterRegionList;
    putRegion(value: KubernetesClusterRegion[] | cdktf.IResolvable): void;
    resetRegion(): void;
    get regionInput(): cdktf.IResolvable | KubernetesClusterRegion[] | undefined;
    private _tags;
    get tags(): KubernetesClusterTagsList;
    putTags(value: KubernetesClusterTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | KubernetesClusterTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
