import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PlanBackupdestinationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Backup start time in seconds. The time is provided in unix time format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#backupstarttime PlanBackupdestination#backupstarttime}
    */
    readonly backupstarttime?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#backupstocopy PlanBackupdestination#backupstocopy}
    */
    readonly backupstocopy?: string;
    /**
    * Tells if this copy has data aging enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#enabledataaging PlanBackupdestination#enabledataaging}
    */
    readonly enabledataaging?: string;
    /**
    * Which type of backup type should be copied for the given backup destination when backup type is not all jobs. Default is LAST while adding new backup destination. [FIRST, LAST]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#fullbackuptypestocopy PlanBackupdestination#fullbackuptypestocopy}
    */
    readonly fullbackuptypestocopy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Is this a mirror copy? Only considered when isSnapCopy is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#ismirrorcopy PlanBackupdestination#ismirrorcopy}
    */
    readonly ismirrorcopy?: string;
    /**
    * Is this a snap copy? If isMirrorCopy is not set, then default is Vault/Replica.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#issnapcopy PlanBackupdestination#issnapcopy}
    */
    readonly issnapcopy?: string;
    /**
    * Name of backup destination
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
    /**
    * Only for snap copy. Enabling this changes SVM Mapping  to NetApp cloud targets only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#netappcloudtarget PlanBackupdestination#netappcloudtarget}
    */
    readonly netappcloudtarget?: string;
    /**
    * Flag to specify if primary storage is copy data management enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#optimizeforinstantclone PlanBackupdestination#optimizeforinstantclone}
    */
    readonly optimizeforinstantclone?: string;
    /**
    * Tells if this copy should use storage pool retention period days or the retention defined for this copy. Set as true to use retention defined on this copy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#overrideretentionsettings PlanBackupdestination#overrideretentionsettings}
    */
    readonly overrideretentionsettings?: string;
    /**
    * Retention period in days. -1 can be specified for infinite retention. If this and snapRecoveryPoints both are not specified, this takes  precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#retentionperioddays PlanBackupdestination#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * Which type of retention rule should be used for the given backup destination [RETENTION_PERIOD, SNAP_RECOVERY_POINTS]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#retentionruletype PlanBackupdestination#retentionruletype}
    */
    readonly retentionruletype?: string;
    /**
    * Number of snap recovery points for snap copy for retention. Can be specified instead of retention period in Days for snap copy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#snaprecoverypoints PlanBackupdestination#snaprecoverypoints}
    */
    readonly snaprecoverypoints?: number;
    /**
    * [ALL, DISK, CLOUD, HYPERSCALE, TAPE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#storagetype PlanBackupdestination#storagetype}
    */
    readonly storagetype?: string;
    /**
    * Use extended retention rules
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#useextendedretentionrules PlanBackupdestination#useextendedretentionrules}
    */
    readonly useextendedretentionrules?: string;
    /**
    * extendedretentionrules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#extendedretentionrules PlanBackupdestination#extendedretentionrules}
    */
    readonly extendedretentionrules?: PlanBackupdestinationExtendedretentionrules[] | cdktf.IResolvable;
    /**
    * mappings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#mappings PlanBackupdestination#mappings}
    */
    readonly mappings?: PlanBackupdestinationMappings[] | cdktf.IResolvable;
    /**
    * region block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#region PlanBackupdestination#region}
    */
    readonly region?: PlanBackupdestinationRegion[] | cdktf.IResolvable;
    /**
    * sourcecopy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#sourcecopy PlanBackupdestination#sourcecopy}
    */
    readonly sourcecopy?: PlanBackupdestinationSourcecopy[] | cdktf.IResolvable;
    /**
    * storagepool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#storagepool PlanBackupdestination#storagepool}
    */
    readonly storagepool: PlanBackupdestinationStoragepool[] | cdktf.IResolvable;
}
export interface PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#isinfiniteretention PlanBackupdestination#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#retentionperioddays PlanBackupdestination#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#type PlanBackupdestination#type}
    */
    readonly type?: string;
}
export declare function planBackupdestinationExtendedretentionrulesFirstextendedretentionruleToTerraform(struct?: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable): any;
export declare function planBackupdestinationExtendedretentionrulesFirstextendedretentionruleToHclTerraform(struct?: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanBackupdestinationExtendedretentionrulesFirstextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanBackupdestinationExtendedretentionrulesFirstextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationExtendedretentionrulesFirstextendedretentionruleOutputReference;
}
export interface PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#isinfiniteretention PlanBackupdestination#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#retentionperioddays PlanBackupdestination#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#type PlanBackupdestination#type}
    */
    readonly type?: string;
}
export declare function planBackupdestinationExtendedretentionrulesSecondextendedretentionruleToTerraform(struct?: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable): any;
export declare function planBackupdestinationExtendedretentionrulesSecondextendedretentionruleToHclTerraform(struct?: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanBackupdestinationExtendedretentionrulesSecondextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanBackupdestinationExtendedretentionrulesSecondextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationExtendedretentionrulesSecondextendedretentionruleOutputReference;
}
export interface PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule {
    /**
    * If this is set as true, no need to specify retentionPeriodDays.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#isinfiniteretention PlanBackupdestination#isinfiniteretention}
    */
    readonly isinfiniteretention?: string;
    /**
    * If this is set, no need to specify isInfiniteRetention as false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#retentionperioddays PlanBackupdestination#retentionperioddays}
    */
    readonly retentionperioddays?: number;
    /**
    * All_JOBS means SYNCHRONOUS copy type, others are applicable for SELECTIVE copy Type only. [All_JOBS, ALL_FULLS, HOURLY_FULLS, DAILY_FULLS, WEEKLY_FULLS, MONTHLY_FULLS, QUARTERLY_FULLS, HALF_YEARLY_FULLS, YEARLY_FULLS, ADVANCED]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#type PlanBackupdestination#type}
    */
    readonly type?: string;
}
export declare function planBackupdestinationExtendedretentionrulesThirdextendedretentionruleToTerraform(struct?: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable): any;
export declare function planBackupdestinationExtendedretentionrulesThirdextendedretentionruleToHclTerraform(struct?: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable): any;
export declare class PlanBackupdestinationExtendedretentionrulesThirdextendedretentionruleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule | cdktf.IResolvable | undefined);
    private _isinfiniteretention?;
    get isinfiniteretention(): string;
    set isinfiniteretention(value: string);
    resetIsinfiniteretention(): void;
    get isinfiniteretentionInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PlanBackupdestinationExtendedretentionrulesThirdextendedretentionruleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationExtendedretentionrulesThirdextendedretentionruleOutputReference;
}
export interface PlanBackupdestinationExtendedretentionrules {
    /**
    * firstextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#firstextendedretentionrule PlanBackupdestination#firstextendedretentionrule}
    */
    readonly firstextendedretentionrule?: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable;
    /**
    * secondextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#secondextendedretentionrule PlanBackupdestination#secondextendedretentionrule}
    */
    readonly secondextendedretentionrule?: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable;
    /**
    * thirdextendedretentionrule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#thirdextendedretentionrule PlanBackupdestination#thirdextendedretentionrule}
    */
    readonly thirdextendedretentionrule?: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable;
}
export declare function planBackupdestinationExtendedretentionrulesToTerraform(struct?: PlanBackupdestinationExtendedretentionrules | cdktf.IResolvable): any;
export declare function planBackupdestinationExtendedretentionrulesToHclTerraform(struct?: PlanBackupdestinationExtendedretentionrules | cdktf.IResolvable): any;
export declare class PlanBackupdestinationExtendedretentionrulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationExtendedretentionrules | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationExtendedretentionrules | cdktf.IResolvable | undefined);
    private _firstextendedretentionrule;
    get firstextendedretentionrule(): PlanBackupdestinationExtendedretentionrulesFirstextendedretentionruleList;
    putFirstextendedretentionrule(value: PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule[] | cdktf.IResolvable): void;
    resetFirstextendedretentionrule(): void;
    get firstextendedretentionruleInput(): cdktf.IResolvable | PlanBackupdestinationExtendedretentionrulesFirstextendedretentionrule[] | undefined;
    private _secondextendedretentionrule;
    get secondextendedretentionrule(): PlanBackupdestinationExtendedretentionrulesSecondextendedretentionruleList;
    putSecondextendedretentionrule(value: PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule[] | cdktf.IResolvable): void;
    resetSecondextendedretentionrule(): void;
    get secondextendedretentionruleInput(): cdktf.IResolvable | PlanBackupdestinationExtendedretentionrulesSecondextendedretentionrule[] | undefined;
    private _thirdextendedretentionrule;
    get thirdextendedretentionrule(): PlanBackupdestinationExtendedretentionrulesThirdextendedretentionruleList;
    putThirdextendedretentionrule(value: PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule[] | cdktf.IResolvable): void;
    resetThirdextendedretentionrule(): void;
    get thirdextendedretentionruleInput(): cdktf.IResolvable | PlanBackupdestinationExtendedretentionrulesThirdextendedretentionrule[] | undefined;
}
export declare class PlanBackupdestinationExtendedretentionrulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationExtendedretentionrules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationExtendedretentionrulesOutputReference;
}
export interface PlanBackupdestinationMappingsSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationMappingsSourceToTerraform(struct?: PlanBackupdestinationMappingsSource | cdktf.IResolvable): any;
export declare function planBackupdestinationMappingsSourceToHclTerraform(struct?: PlanBackupdestinationMappingsSource | cdktf.IResolvable): any;
export declare class PlanBackupdestinationMappingsSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationMappingsSource | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationMappingsSource | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationMappingsSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationMappingsSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationMappingsSourceOutputReference;
}
export interface PlanBackupdestinationMappingsSourcevendor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationMappingsSourcevendorToTerraform(struct?: PlanBackupdestinationMappingsSourcevendor | cdktf.IResolvable): any;
export declare function planBackupdestinationMappingsSourcevendorToHclTerraform(struct?: PlanBackupdestinationMappingsSourcevendor | cdktf.IResolvable): any;
export declare class PlanBackupdestinationMappingsSourcevendorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationMappingsSourcevendor | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationMappingsSourcevendor | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationMappingsSourcevendorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationMappingsSourcevendor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationMappingsSourcevendorOutputReference;
}
export interface PlanBackupdestinationMappingsTarget {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationMappingsTargetToTerraform(struct?: PlanBackupdestinationMappingsTarget | cdktf.IResolvable): any;
export declare function planBackupdestinationMappingsTargetToHclTerraform(struct?: PlanBackupdestinationMappingsTarget | cdktf.IResolvable): any;
export declare class PlanBackupdestinationMappingsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationMappingsTarget | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationMappingsTarget | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationMappingsTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationMappingsTarget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationMappingsTargetOutputReference;
}
export interface PlanBackupdestinationMappingsTargetvendor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationMappingsTargetvendorToTerraform(struct?: PlanBackupdestinationMappingsTargetvendor | cdktf.IResolvable): any;
export declare function planBackupdestinationMappingsTargetvendorToHclTerraform(struct?: PlanBackupdestinationMappingsTargetvendor | cdktf.IResolvable): any;
export declare class PlanBackupdestinationMappingsTargetvendorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationMappingsTargetvendor | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationMappingsTargetvendor | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationMappingsTargetvendorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationMappingsTargetvendor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationMappingsTargetvendorOutputReference;
}
export interface PlanBackupdestinationMappings {
    /**
    * Snapshot vendors available for Snap Copy mappings [NETAPP, AMAZON, PURE]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#vendor PlanBackupdestination#vendor}
    */
    readonly vendor?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#source PlanBackupdestination#source}
    */
    readonly source?: PlanBackupdestinationMappingsSource[] | cdktf.IResolvable;
    /**
    * sourcevendor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#sourcevendor PlanBackupdestination#sourcevendor}
    */
    readonly sourcevendor?: PlanBackupdestinationMappingsSourcevendor[] | cdktf.IResolvable;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#target PlanBackupdestination#target}
    */
    readonly target?: PlanBackupdestinationMappingsTarget[] | cdktf.IResolvable;
    /**
    * targetvendor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#targetvendor PlanBackupdestination#targetvendor}
    */
    readonly targetvendor?: PlanBackupdestinationMappingsTargetvendor[] | cdktf.IResolvable;
}
export declare function planBackupdestinationMappingsToTerraform(struct?: PlanBackupdestinationMappings | cdktf.IResolvable): any;
export declare function planBackupdestinationMappingsToHclTerraform(struct?: PlanBackupdestinationMappings | cdktf.IResolvable): any;
export declare class PlanBackupdestinationMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationMappings | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationMappings | cdktf.IResolvable | undefined);
    private _vendor?;
    get vendor(): string;
    set vendor(value: string);
    resetVendor(): void;
    get vendorInput(): string | undefined;
    private _source;
    get source(): PlanBackupdestinationMappingsSourceList;
    putSource(value: PlanBackupdestinationMappingsSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | PlanBackupdestinationMappingsSource[] | undefined;
    private _sourcevendor;
    get sourcevendor(): PlanBackupdestinationMappingsSourcevendorList;
    putSourcevendor(value: PlanBackupdestinationMappingsSourcevendor[] | cdktf.IResolvable): void;
    resetSourcevendor(): void;
    get sourcevendorInput(): cdktf.IResolvable | PlanBackupdestinationMappingsSourcevendor[] | undefined;
    private _target;
    get target(): PlanBackupdestinationMappingsTargetList;
    putTarget(value: PlanBackupdestinationMappingsTarget[] | cdktf.IResolvable): void;
    resetTarget(): void;
    get targetInput(): cdktf.IResolvable | PlanBackupdestinationMappingsTarget[] | undefined;
    private _targetvendor;
    get targetvendor(): PlanBackupdestinationMappingsTargetvendorList;
    putTargetvendor(value: PlanBackupdestinationMappingsTargetvendor[] | cdktf.IResolvable): void;
    resetTargetvendor(): void;
    get targetvendorInput(): cdktf.IResolvable | PlanBackupdestinationMappingsTargetvendor[] | undefined;
}
export declare class PlanBackupdestinationMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationMappingsOutputReference;
}
export interface PlanBackupdestinationRegion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationRegionToTerraform(struct?: PlanBackupdestinationRegion | cdktf.IResolvable): any;
export declare function planBackupdestinationRegionToHclTerraform(struct?: PlanBackupdestinationRegion | cdktf.IResolvable): any;
export declare class PlanBackupdestinationRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationRegion | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationRegion | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationRegion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationRegionOutputReference;
}
export interface PlanBackupdestinationSourcecopy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationSourcecopyToTerraform(struct?: PlanBackupdestinationSourcecopy | cdktf.IResolvable): any;
export declare function planBackupdestinationSourcecopyToHclTerraform(struct?: PlanBackupdestinationSourcecopy | cdktf.IResolvable): any;
export declare class PlanBackupdestinationSourcecopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationSourcecopy | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationSourcecopy | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationSourcecopyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationSourcecopy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationSourcecopyOutputReference;
}
export interface PlanBackupdestinationStoragepool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#id PlanBackupdestination#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#name PlanBackupdestination#name}
    */
    readonly name?: string;
}
export declare function planBackupdestinationStoragepoolToTerraform(struct?: PlanBackupdestinationStoragepool | cdktf.IResolvable): any;
export declare function planBackupdestinationStoragepoolToHclTerraform(struct?: PlanBackupdestinationStoragepool | cdktf.IResolvable): any;
export declare class PlanBackupdestinationStoragepoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PlanBackupdestinationStoragepool | cdktf.IResolvable | undefined;
    set internalValue(value: PlanBackupdestinationStoragepool | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class PlanBackupdestinationStoragepoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PlanBackupdestinationStoragepool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PlanBackupdestinationStoragepoolOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination commvault_plan_backupdestination}
*/
export declare class PlanBackupdestination extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_plan_backupdestination";
    /**
    * Generates CDKTF code for importing a PlanBackupdestination resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PlanBackupdestination to import
    * @param importFromId The id of the existing PlanBackupdestination that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PlanBackupdestination to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_backupdestination commvault_plan_backupdestination} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PlanBackupdestinationConfig
    */
    constructor(scope: Construct, id: string, config: PlanBackupdestinationConfig);
    private _backupstarttime?;
    get backupstarttime(): number;
    set backupstarttime(value: number);
    resetBackupstarttime(): void;
    get backupstarttimeInput(): number | undefined;
    private _backupstocopy?;
    get backupstocopy(): string;
    set backupstocopy(value: string);
    resetBackupstocopy(): void;
    get backupstocopyInput(): string | undefined;
    private _enabledataaging?;
    get enabledataaging(): string;
    set enabledataaging(value: string);
    resetEnabledataaging(): void;
    get enabledataagingInput(): string | undefined;
    private _fullbackuptypestocopy?;
    get fullbackuptypestocopy(): string;
    set fullbackuptypestocopy(value: string);
    resetFullbackuptypestocopy(): void;
    get fullbackuptypestocopyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ismirrorcopy?;
    get ismirrorcopy(): string;
    set ismirrorcopy(value: string);
    resetIsmirrorcopy(): void;
    get ismirrorcopyInput(): string | undefined;
    private _issnapcopy?;
    get issnapcopy(): string;
    set issnapcopy(value: string);
    resetIssnapcopy(): void;
    get issnapcopyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _netappcloudtarget?;
    get netappcloudtarget(): string;
    set netappcloudtarget(value: string);
    resetNetappcloudtarget(): void;
    get netappcloudtargetInput(): string | undefined;
    private _optimizeforinstantclone?;
    get optimizeforinstantclone(): string;
    set optimizeforinstantclone(value: string);
    resetOptimizeforinstantclone(): void;
    get optimizeforinstantcloneInput(): string | undefined;
    private _overrideretentionsettings?;
    get overrideretentionsettings(): string;
    set overrideretentionsettings(value: string);
    resetOverrideretentionsettings(): void;
    get overrideretentionsettingsInput(): string | undefined;
    private _retentionperioddays?;
    get retentionperioddays(): number;
    set retentionperioddays(value: number);
    resetRetentionperioddays(): void;
    get retentionperioddaysInput(): number | undefined;
    private _retentionruletype?;
    get retentionruletype(): string;
    set retentionruletype(value: string);
    resetRetentionruletype(): void;
    get retentionruletypeInput(): string | undefined;
    private _snaprecoverypoints?;
    get snaprecoverypoints(): number;
    set snaprecoverypoints(value: number);
    resetSnaprecoverypoints(): void;
    get snaprecoverypointsInput(): number | undefined;
    private _storagetype?;
    get storagetype(): string;
    set storagetype(value: string);
    resetStoragetype(): void;
    get storagetypeInput(): string | undefined;
    private _useextendedretentionrules?;
    get useextendedretentionrules(): string;
    set useextendedretentionrules(value: string);
    resetUseextendedretentionrules(): void;
    get useextendedretentionrulesInput(): string | undefined;
    private _extendedretentionrules;
    get extendedretentionrules(): PlanBackupdestinationExtendedretentionrulesList;
    putExtendedretentionrules(value: PlanBackupdestinationExtendedretentionrules[] | cdktf.IResolvable): void;
    resetExtendedretentionrules(): void;
    get extendedretentionrulesInput(): cdktf.IResolvable | PlanBackupdestinationExtendedretentionrules[] | undefined;
    private _mappings;
    get mappings(): PlanBackupdestinationMappingsList;
    putMappings(value: PlanBackupdestinationMappings[] | cdktf.IResolvable): void;
    resetMappings(): void;
    get mappingsInput(): cdktf.IResolvable | PlanBackupdestinationMappings[] | undefined;
    private _region;
    get region(): PlanBackupdestinationRegionList;
    putRegion(value: PlanBackupdestinationRegion[] | cdktf.IResolvable): void;
    resetRegion(): void;
    get regionInput(): cdktf.IResolvable | PlanBackupdestinationRegion[] | undefined;
    private _sourcecopy;
    get sourcecopy(): PlanBackupdestinationSourcecopyList;
    putSourcecopy(value: PlanBackupdestinationSourcecopy[] | cdktf.IResolvable): void;
    resetSourcecopy(): void;
    get sourcecopyInput(): cdktf.IResolvable | PlanBackupdestinationSourcecopy[] | undefined;
    private _storagepool;
    get storagepool(): PlanBackupdestinationStoragepoolList;
    putStoragepool(value: PlanBackupdestinationStoragepool[] | cdktf.IResolvable): void;
    get storagepoolInput(): cdktf.IResolvable | PlanBackupdestinationStoragepool[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
