import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PlanToVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm#id PlanToVm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the new plan name for association
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm#new_plan PlanToVm#new_plan}
    */
    readonly newPlan?: string;
    /**
    * Specifies the plan name to associate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm#plan PlanToVm#plan}
    */
    readonly plan: string;
    /**
    * Specifies the vm name to associate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm#vm_name PlanToVm#vm_name}
    */
    readonly vmName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm commvault_plan_to_vm}
*/
export declare class PlanToVm extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_plan_to_vm";
    /**
    * Generates CDKTF code for importing a PlanToVm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PlanToVm to import
    * @param importFromId The id of the existing PlanToVm that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PlanToVm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/plan_to_vm commvault_plan_to_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PlanToVmConfig
    */
    constructor(scope: Construct, id: string, config: PlanToVmConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _newPlan?;
    get newPlan(): string;
    set newPlan(value: string);
    resetNewPlan(): void;
    get newPlanInput(): string | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _vmName?;
    get vmName(): string;
    set vmName(value: string);
    get vmNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
