import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CommvaultProviderConfig {
    /**
    * Specifies the encrypted token for the user to authentication to Web Server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#api_token CommvaultProvider#api_token}
    */
    readonly apiToken?: string;
    /**
    * ignore certificate warnings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#ignore_cert CommvaultProvider#ignore_cert}
    */
    readonly ignoreCert?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#logging CommvaultProvider#logging}
    */
    readonly logging?: boolean | cdktf.IResolvable;
    /**
    * Specifies the Password for the user name to authentication to Web Server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#password CommvaultProvider#password}
    */
    readonly password?: string;
    /**
    * Specifies if the connection should be secured https or non secured http
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#secured CommvaultProvider#secured}
    */
    readonly secured?: boolean | cdktf.IResolvable;
    /**
    * Specifies the User name used for authentication to Web Server
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#user_name CommvaultProvider#user_name}
    */
    readonly userName?: string;
    /**
    * Specifies the Web Server URL of the commserver for performing Terraform Operations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#web_service_url CommvaultProvider#web_service_url}
    */
    readonly webServiceUrl?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#alias CommvaultProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs commvault}
*/
export declare class CommvaultProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "commvault";
    /**
    * Generates CDKTF code for importing a CommvaultProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CommvaultProvider to import
    * @param importFromId The id of the existing CommvaultProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CommvaultProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs commvault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CommvaultProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: CommvaultProviderConfig);
    private _apiToken?;
    get apiToken(): string | undefined;
    set apiToken(value: string | undefined);
    resetApiToken(): void;
    get apiTokenInput(): string | undefined;
    private _ignoreCert?;
    get ignoreCert(): boolean | cdktf.IResolvable | undefined;
    set ignoreCert(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreCert(): void;
    get ignoreCertInput(): boolean | cdktf.IResolvable | undefined;
    private _logging?;
    get logging(): boolean | cdktf.IResolvable | undefined;
    set logging(value: boolean | cdktf.IResolvable | undefined);
    resetLogging(): void;
    get loggingInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _secured?;
    get secured(): boolean | cdktf.IResolvable | undefined;
    set secured(value: boolean | cdktf.IResolvable | undefined);
    resetSecured(): void;
    get securedInput(): boolean | cdktf.IResolvable | undefined;
    private _userName?;
    get userName(): string | undefined;
    set userName(value: string | undefined);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _webServiceUrl?;
    get webServiceUrl(): string | undefined;
    set webServiceUrl(value: string | undefined);
    resetWebServiceUrl(): void;
    get webServiceUrlInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
