import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityAssociationV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#id SecurityAssociationV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * entity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#entity SecurityAssociationV2#entity}
    */
    readonly entity: SecurityAssociationV2Entity[] | cdktf.IResolvable;
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#role SecurityAssociationV2#role}
    */
    readonly role: SecurityAssociationV2Role[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#usergroup SecurityAssociationV2#usergroup}
    */
    readonly usergroup: SecurityAssociationV2Usergroup[] | cdktf.IResolvable;
}
export interface SecurityAssociationV2Entity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#id SecurityAssociationV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#name SecurityAssociationV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#typeid SecurityAssociationV2#typeid}
    */
    readonly typeid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#typename SecurityAssociationV2#typename}
    */
    readonly typename?: string;
}
export declare function securityAssociationV2EntityToTerraform(struct?: SecurityAssociationV2Entity | cdktf.IResolvable): any;
export declare function securityAssociationV2EntityToHclTerraform(struct?: SecurityAssociationV2Entity | cdktf.IResolvable): any;
export declare class SecurityAssociationV2EntityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityAssociationV2Entity | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityAssociationV2Entity | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _typeid?;
    get typeid(): number;
    set typeid(value: number);
    resetTypeid(): void;
    get typeidInput(): number | undefined;
    private _typename?;
    get typename(): string;
    set typename(value: string);
    resetTypename(): void;
    get typenameInput(): string | undefined;
}
export declare class SecurityAssociationV2EntityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityAssociationV2Entity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityAssociationV2EntityOutputReference;
}
export interface SecurityAssociationV2Role {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#id SecurityAssociationV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#name SecurityAssociationV2#name}
    */
    readonly name?: string;
}
export declare function securityAssociationV2RoleToTerraform(struct?: SecurityAssociationV2Role | cdktf.IResolvable): any;
export declare function securityAssociationV2RoleToHclTerraform(struct?: SecurityAssociationV2Role | cdktf.IResolvable): any;
export declare class SecurityAssociationV2RoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityAssociationV2Role | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityAssociationV2Role | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class SecurityAssociationV2RoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityAssociationV2Role[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityAssociationV2RoleOutputReference;
}
export interface SecurityAssociationV2Usergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#id SecurityAssociationV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#name SecurityAssociationV2#name}
    */
    readonly name?: string;
}
export declare function securityAssociationV2UsergroupToTerraform(struct?: SecurityAssociationV2Usergroup | cdktf.IResolvable): any;
export declare function securityAssociationV2UsergroupToHclTerraform(struct?: SecurityAssociationV2Usergroup | cdktf.IResolvable): any;
export declare class SecurityAssociationV2UsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityAssociationV2Usergroup | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityAssociationV2Usergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class SecurityAssociationV2UsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityAssociationV2Usergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityAssociationV2UsergroupOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2 commvault_security_association_v2}
*/
export declare class SecurityAssociationV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_security_association_v2";
    /**
    * Generates CDKTF code for importing a SecurityAssociationV2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityAssociationV2 to import
    * @param importFromId The id of the existing SecurityAssociationV2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityAssociationV2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/security_association_v2 commvault_security_association_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityAssociationV2Config
    */
    constructor(scope: Construct, id: string, config: SecurityAssociationV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _entity;
    get entity(): SecurityAssociationV2EntityList;
    putEntity(value: SecurityAssociationV2Entity[] | cdktf.IResolvable): void;
    get entityInput(): cdktf.IResolvable | SecurityAssociationV2Entity[] | undefined;
    private _role;
    get role(): SecurityAssociationV2RoleList;
    putRole(value: SecurityAssociationV2Role[] | cdktf.IResolvable): void;
    get roleInput(): cdktf.IResolvable | SecurityAssociationV2Role[] | undefined;
    private _usergroup;
    get usergroup(): SecurityAssociationV2UsergroupList;
    putUsergroup(value: SecurityAssociationV2Usergroup[] | cdktf.IResolvable): void;
    get usergroupInput(): cdktf.IResolvable | SecurityAssociationV2Usergroup[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
