import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageCloudS3Config extends cdktf.TerraformMetaArguments {
    /**
    * Needed for AWS STS assume role and AWS STS assume role with IAM role policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#arnrole StorageCloudS3#arnrole}
    */
    readonly arnrole?: string;
    /**
    * Authentication type for the cloud storage server [Access and secret keys, AWS IAM role policy, AWS STS assume role, AWS STS assume role with IAM role policy]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#authentication StorageCloudS3#authentication}
    */
    readonly authentication: string;
    /**
    * Name of bucket
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#bucket StorageCloudS3#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the cloud storage library
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#name StorageCloudS3#name}
    */
    readonly name: string;
    /**
    * IP address or fully qualified domain name or URL for the cloud library based on cloud vendor
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#servicehost StorageCloudS3#servicehost}
    */
    readonly servicehost: string;
    /**
    * Appropriate storage class for your account [Standard, Reduced Redundancy Storage, Standard - Infrequent access, One zone - Infrequent access, Intelligent tiering, S3 Glacier, Standard/Glacier (Combined Storage Tiers), Standard-IA/Glacier (Combined Storage Tiers), One Zone-IA/Glacier (Combined Storage Tiers), Intelligent-Tiering/Glacier (Combined Storage Tiers), S3 Glacier Deep Archive, Standard/Deep Archive (Combined Storage Tiers), Standard-IA/Deep Archive (Combined Storage Tiers), One Zone-IA/Deep Archive (Combined Storage Tiers), Intelligent-Tiering/Deep Archive (Combined Storage Tiers)]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#storageclass StorageCloudS3#storageclass}
    */
    readonly storageclass: string;
    /**
    * Enables or disables deduplication on the storage
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#usededuplication StorageCloudS3#usededuplication}
    */
    readonly usededuplication?: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#credentials StorageCloudS3#credentials}
    */
    readonly credentials?: StorageCloudS3Credentials[] | cdktf.IResolvable;
    /**
    * deduplicationdblocation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#deduplicationdblocation StorageCloudS3#deduplicationdblocation}
    */
    readonly deduplicationdblocation?: StorageCloudS3Deduplicationdblocation[] | cdktf.IResolvable;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#encryption StorageCloudS3#encryption}
    */
    readonly encryption?: StorageCloudS3Encryption[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#mediaagent StorageCloudS3#mediaagent}
    */
    readonly mediaagent: StorageCloudS3Mediaagent[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#security StorageCloudS3#security}
    */
    readonly security?: StorageCloudS3Security[] | cdktf.IResolvable;
}
export interface StorageCloudS3Credentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#name StorageCloudS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudS3CredentialsToTerraform(struct?: StorageCloudS3Credentials | cdktf.IResolvable): any;
export declare function storageCloudS3CredentialsToHclTerraform(struct?: StorageCloudS3Credentials | cdktf.IResolvable): any;
export declare class StorageCloudS3CredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3Credentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3Credentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudS3CredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3Credentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3CredentialsOutputReference;
}
export interface StorageCloudS3DeduplicationdblocationMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#name StorageCloudS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudS3DeduplicationdblocationMediaagentToTerraform(struct?: StorageCloudS3DeduplicationdblocationMediaagent | cdktf.IResolvable): any;
export declare function storageCloudS3DeduplicationdblocationMediaagentToHclTerraform(struct?: StorageCloudS3DeduplicationdblocationMediaagent | cdktf.IResolvable): any;
export declare class StorageCloudS3DeduplicationdblocationMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3DeduplicationdblocationMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3DeduplicationdblocationMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudS3DeduplicationdblocationMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3DeduplicationdblocationMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3DeduplicationdblocationMediaagentOutputReference;
}
export interface StorageCloudS3Deduplicationdblocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#path StorageCloudS3#path}
    */
    readonly path?: string;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#mediaagent StorageCloudS3#mediaagent}
    */
    readonly mediaagent?: StorageCloudS3DeduplicationdblocationMediaagent[] | cdktf.IResolvable;
}
export declare function storageCloudS3DeduplicationdblocationToTerraform(struct?: StorageCloudS3Deduplicationdblocation | cdktf.IResolvable): any;
export declare function storageCloudS3DeduplicationdblocationToHclTerraform(struct?: StorageCloudS3Deduplicationdblocation | cdktf.IResolvable): any;
export declare class StorageCloudS3DeduplicationdblocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3Deduplicationdblocation | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3Deduplicationdblocation | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudS3DeduplicationdblocationMediaagentList;
    putMediaagent(value: StorageCloudS3DeduplicationdblocationMediaagent[] | cdktf.IResolvable): void;
    resetMediaagent(): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudS3DeduplicationdblocationMediaagent[] | undefined;
}
export declare class StorageCloudS3DeduplicationdblocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3Deduplicationdblocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3DeduplicationdblocationOutputReference;
}
export interface StorageCloudS3EncryptionKeyprovider {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#name StorageCloudS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudS3EncryptionKeyproviderToTerraform(struct?: StorageCloudS3EncryptionKeyprovider | cdktf.IResolvable): any;
export declare function storageCloudS3EncryptionKeyproviderToHclTerraform(struct?: StorageCloudS3EncryptionKeyprovider | cdktf.IResolvable): any;
export declare class StorageCloudS3EncryptionKeyproviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3EncryptionKeyprovider | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3EncryptionKeyprovider | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudS3EncryptionKeyproviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3EncryptionKeyprovider[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3EncryptionKeyproviderOutputReference;
}
export interface StorageCloudS3Encryption {
    /**
    * The different types of encryption keys that can be used for encrypting the data. The values are case sensitive [BlowFish, AES, DES3, GOST, Serpent, Twofish]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#cipher StorageCloudS3#cipher}
    */
    readonly cipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#encrypt StorageCloudS3#encrypt}
    */
    readonly encrypt?: string;
    /**
    * Different keylengths are present for different kinds of ciphers. Blowfish,Twofish,AES and Serpent all accept both 128 and 256. DES3 accepts only 192. GOST accepts only 256.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#keylength StorageCloudS3#keylength}
    */
    readonly keylength?: number;
    /**
    * keyprovider block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#keyprovider StorageCloudS3#keyprovider}
    */
    readonly keyprovider?: StorageCloudS3EncryptionKeyprovider[] | cdktf.IResolvable;
}
export declare function storageCloudS3EncryptionToTerraform(struct?: StorageCloudS3Encryption | cdktf.IResolvable): any;
export declare function storageCloudS3EncryptionToHclTerraform(struct?: StorageCloudS3Encryption | cdktf.IResolvable): any;
export declare class StorageCloudS3EncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3Encryption | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3Encryption | cdktf.IResolvable | undefined);
    private _cipher?;
    get cipher(): string;
    set cipher(value: string);
    resetCipher(): void;
    get cipherInput(): string | undefined;
    private _encrypt?;
    get encrypt(): string;
    set encrypt(value: string);
    resetEncrypt(): void;
    get encryptInput(): string | undefined;
    private _keylength?;
    get keylength(): number;
    set keylength(value: number);
    resetKeylength(): void;
    get keylengthInput(): number | undefined;
    private _keyprovider;
    get keyprovider(): StorageCloudS3EncryptionKeyproviderList;
    putKeyprovider(value: StorageCloudS3EncryptionKeyprovider[] | cdktf.IResolvable): void;
    resetKeyprovider(): void;
    get keyproviderInput(): cdktf.IResolvable | StorageCloudS3EncryptionKeyprovider[] | undefined;
}
export declare class StorageCloudS3EncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3Encryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3EncryptionOutputReference;
}
export interface StorageCloudS3Mediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#name StorageCloudS3#name}
    */
    readonly name?: string;
}
export declare function storageCloudS3MediaagentToTerraform(struct?: StorageCloudS3Mediaagent | cdktf.IResolvable): any;
export declare function storageCloudS3MediaagentToHclTerraform(struct?: StorageCloudS3Mediaagent | cdktf.IResolvable): any;
export declare class StorageCloudS3MediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3Mediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3Mediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageCloudS3MediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3Mediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3MediaagentOutputReference;
}
export interface StorageCloudS3SecurityRole {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudS3SecurityRoleToTerraform(struct?: StorageCloudS3SecurityRole | cdktf.IResolvable): any;
export declare function storageCloudS3SecurityRoleToHclTerraform(struct?: StorageCloudS3SecurityRole | cdktf.IResolvable): any;
export declare class StorageCloudS3SecurityRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3SecurityRole | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3SecurityRole | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudS3SecurityRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3SecurityRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3SecurityRoleOutputReference;
}
export interface StorageCloudS3SecurityUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudS3SecurityUserToTerraform(struct?: StorageCloudS3SecurityUser | cdktf.IResolvable): any;
export declare function storageCloudS3SecurityUserToHclTerraform(struct?: StorageCloudS3SecurityUser | cdktf.IResolvable): any;
export declare class StorageCloudS3SecurityUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3SecurityUser | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3SecurityUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudS3SecurityUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3SecurityUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3SecurityUserOutputReference;
}
export interface StorageCloudS3SecurityUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#id StorageCloudS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageCloudS3SecurityUsergroupToTerraform(struct?: StorageCloudS3SecurityUsergroup | cdktf.IResolvable): any;
export declare function storageCloudS3SecurityUsergroupToHclTerraform(struct?: StorageCloudS3SecurityUsergroup | cdktf.IResolvable): any;
export declare class StorageCloudS3SecurityUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3SecurityUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3SecurityUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageCloudS3SecurityUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3SecurityUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3SecurityUsergroupOutputReference;
}
export interface StorageCloudS3Security {
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#role StorageCloudS3#role}
    */
    readonly role?: StorageCloudS3SecurityRole[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#user StorageCloudS3#user}
    */
    readonly user?: StorageCloudS3SecurityUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#usergroup StorageCloudS3#usergroup}
    */
    readonly usergroup?: StorageCloudS3SecurityUsergroup[] | cdktf.IResolvable;
}
export declare function storageCloudS3SecurityToTerraform(struct?: StorageCloudS3Security | cdktf.IResolvable): any;
export declare function storageCloudS3SecurityToHclTerraform(struct?: StorageCloudS3Security | cdktf.IResolvable): any;
export declare class StorageCloudS3SecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageCloudS3Security | cdktf.IResolvable | undefined;
    set internalValue(value: StorageCloudS3Security | cdktf.IResolvable | undefined);
    private _role;
    get role(): StorageCloudS3SecurityRoleList;
    putRole(value: StorageCloudS3SecurityRole[] | cdktf.IResolvable): void;
    resetRole(): void;
    get roleInput(): cdktf.IResolvable | StorageCloudS3SecurityRole[] | undefined;
    private _user;
    get user(): StorageCloudS3SecurityUserList;
    putUser(value: StorageCloudS3SecurityUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | StorageCloudS3SecurityUser[] | undefined;
    private _usergroup;
    get usergroup(): StorageCloudS3SecurityUsergroupList;
    putUsergroup(value: StorageCloudS3SecurityUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | StorageCloudS3SecurityUsergroup[] | undefined;
}
export declare class StorageCloudS3SecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageCloudS3Security[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageCloudS3SecurityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3 commvault_storage_cloud_s3}
*/
export declare class StorageCloudS3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_cloud_s3";
    /**
    * Generates CDKTF code for importing a StorageCloudS3 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageCloudS3 to import
    * @param importFromId The id of the existing StorageCloudS3 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageCloudS3 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_cloud_s3 commvault_storage_cloud_s3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageCloudS3Config
    */
    constructor(scope: Construct, id: string, config: StorageCloudS3Config);
    private _arnrole?;
    get arnrole(): string;
    set arnrole(value: string);
    resetArnrole(): void;
    get arnroleInput(): string | undefined;
    private _authentication?;
    get authentication(): string;
    set authentication(value: string);
    get authenticationInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servicehost?;
    get servicehost(): string;
    set servicehost(value: string);
    get servicehostInput(): string | undefined;
    private _storageclass?;
    get storageclass(): string;
    set storageclass(value: string);
    get storageclassInput(): string | undefined;
    private _usededuplication?;
    get usededuplication(): string;
    set usededuplication(value: string);
    resetUsededuplication(): void;
    get usededuplicationInput(): string | undefined;
    private _credentials;
    get credentials(): StorageCloudS3CredentialsList;
    putCredentials(value: StorageCloudS3Credentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | StorageCloudS3Credentials[] | undefined;
    private _deduplicationdblocation;
    get deduplicationdblocation(): StorageCloudS3DeduplicationdblocationList;
    putDeduplicationdblocation(value: StorageCloudS3Deduplicationdblocation[] | cdktf.IResolvable): void;
    resetDeduplicationdblocation(): void;
    get deduplicationdblocationInput(): cdktf.IResolvable | StorageCloudS3Deduplicationdblocation[] | undefined;
    private _encryption;
    get encryption(): StorageCloudS3EncryptionList;
    putEncryption(value: StorageCloudS3Encryption[] | cdktf.IResolvable): void;
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | StorageCloudS3Encryption[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageCloudS3MediaagentList;
    putMediaagent(value: StorageCloudS3Mediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageCloudS3Mediaagent[] | undefined;
    private _security;
    get security(): StorageCloudS3SecurityList;
    putSecurity(value: StorageCloudS3Security[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | StorageCloudS3Security[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
