import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * enables or disables deduplication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#enablededuplication StorageDisk#enablededuplication}
    */
    readonly enablededuplication: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Disk Storage to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name: string;
    /**
    * dataencryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#dataencryption StorageDisk#dataencryption}
    */
    readonly dataencryption?: StorageDiskDataencryption[] | cdktf.IResolvable;
    /**
    * deduplicationdbstorage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#deduplicationdbstorage StorageDisk#deduplicationdbstorage}
    */
    readonly deduplicationdbstorage?: StorageDiskDeduplicationdbstorage[] | cdktf.IResolvable;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#security StorageDisk#security}
    */
    readonly security?: StorageDiskSecurity[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#storage StorageDisk#storage}
    */
    readonly storage: StorageDiskStorage[] | cdktf.IResolvable;
}
export interface StorageDiskDataencryptionKeyprovider {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name?: string;
}
export declare function storageDiskDataencryptionKeyproviderToTerraform(struct?: StorageDiskDataencryptionKeyprovider | cdktf.IResolvable): any;
export declare function storageDiskDataencryptionKeyproviderToHclTerraform(struct?: StorageDiskDataencryptionKeyprovider | cdktf.IResolvable): any;
export declare class StorageDiskDataencryptionKeyproviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskDataencryptionKeyprovider | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskDataencryptionKeyprovider | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskDataencryptionKeyproviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskDataencryptionKeyprovider[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskDataencryptionKeyproviderOutputReference;
}
export interface StorageDiskDataencryption {
    /**
    * The different types of encryption keys that can be used for encrypting the data. The values are case sensitive [BlowFish, AES, DES3, GOST, Serpent, Twofish]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#cipher StorageDisk#cipher}
    */
    readonly cipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#encrypt StorageDisk#encrypt}
    */
    readonly encrypt?: string;
    /**
    * Different keylengths are present for different kinds of ciphers. Blowfish,Twofish,AES and Serpent all accept both 128 and 256. DES3 accepts only 192. GOST accepts only 256.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#keylength StorageDisk#keylength}
    */
    readonly keylength?: number;
    /**
    * keyprovider block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#keyprovider StorageDisk#keyprovider}
    */
    readonly keyprovider?: StorageDiskDataencryptionKeyprovider[] | cdktf.IResolvable;
}
export declare function storageDiskDataencryptionToTerraform(struct?: StorageDiskDataencryption | cdktf.IResolvable): any;
export declare function storageDiskDataencryptionToHclTerraform(struct?: StorageDiskDataencryption | cdktf.IResolvable): any;
export declare class StorageDiskDataencryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskDataencryption | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskDataencryption | cdktf.IResolvable | undefined);
    private _cipher?;
    get cipher(): string;
    set cipher(value: string);
    resetCipher(): void;
    get cipherInput(): string | undefined;
    private _encrypt?;
    get encrypt(): string;
    set encrypt(value: string);
    resetEncrypt(): void;
    get encryptInput(): string | undefined;
    private _keylength?;
    get keylength(): number;
    set keylength(value: number);
    resetKeylength(): void;
    get keylengthInput(): number | undefined;
    private _keyprovider;
    get keyprovider(): StorageDiskDataencryptionKeyproviderList;
    putKeyprovider(value: StorageDiskDataencryptionKeyprovider[] | cdktf.IResolvable): void;
    resetKeyprovider(): void;
    get keyproviderInput(): cdktf.IResolvable | StorageDiskDataencryptionKeyprovider[] | undefined;
}
export declare class StorageDiskDataencryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskDataencryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskDataencryptionOutputReference;
}
export interface StorageDiskDeduplicationdbstorageMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name?: string;
}
export declare function storageDiskDeduplicationdbstorageMediaagentToTerraform(struct?: StorageDiskDeduplicationdbstorageMediaagent | cdktf.IResolvable): any;
export declare function storageDiskDeduplicationdbstorageMediaagentToHclTerraform(struct?: StorageDiskDeduplicationdbstorageMediaagent | cdktf.IResolvable): any;
export declare class StorageDiskDeduplicationdbstorageMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskDeduplicationdbstorageMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskDeduplicationdbstorageMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskDeduplicationdbstorageMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskDeduplicationdbstorageMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskDeduplicationdbstorageMediaagentOutputReference;
}
export interface StorageDiskDeduplicationdbstorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#path StorageDisk#path}
    */
    readonly path?: string;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#mediaagent StorageDisk#mediaagent}
    */
    readonly mediaagent?: StorageDiskDeduplicationdbstorageMediaagent[] | cdktf.IResolvable;
}
export declare function storageDiskDeduplicationdbstorageToTerraform(struct?: StorageDiskDeduplicationdbstorage | cdktf.IResolvable): any;
export declare function storageDiskDeduplicationdbstorageToHclTerraform(struct?: StorageDiskDeduplicationdbstorage | cdktf.IResolvable): any;
export declare class StorageDiskDeduplicationdbstorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskDeduplicationdbstorage | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskDeduplicationdbstorage | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _mediaagent;
    get mediaagent(): StorageDiskDeduplicationdbstorageMediaagentList;
    putMediaagent(value: StorageDiskDeduplicationdbstorageMediaagent[] | cdktf.IResolvable): void;
    resetMediaagent(): void;
    get mediaagentInput(): cdktf.IResolvable | StorageDiskDeduplicationdbstorageMediaagent[] | undefined;
}
export declare class StorageDiskDeduplicationdbstorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskDeduplicationdbstorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskDeduplicationdbstorageOutputReference;
}
export interface StorageDiskSecurityRole {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageDiskSecurityRoleToTerraform(struct?: StorageDiskSecurityRole | cdktf.IResolvable): any;
export declare function storageDiskSecurityRoleToHclTerraform(struct?: StorageDiskSecurityRole | cdktf.IResolvable): any;
export declare class StorageDiskSecurityRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskSecurityRole | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskSecurityRole | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageDiskSecurityRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskSecurityRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskSecurityRoleOutputReference;
}
export interface StorageDiskSecurityUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageDiskSecurityUserToTerraform(struct?: StorageDiskSecurityUser | cdktf.IResolvable): any;
export declare function storageDiskSecurityUserToHclTerraform(struct?: StorageDiskSecurityUser | cdktf.IResolvable): any;
export declare class StorageDiskSecurityUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskSecurityUser | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskSecurityUser | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageDiskSecurityUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskSecurityUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskSecurityUserOutputReference;
}
export interface StorageDiskSecurityUsergroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
}
export declare function storageDiskSecurityUsergroupToTerraform(struct?: StorageDiskSecurityUsergroup | cdktf.IResolvable): any;
export declare function storageDiskSecurityUsergroupToHclTerraform(struct?: StorageDiskSecurityUsergroup | cdktf.IResolvable): any;
export declare class StorageDiskSecurityUsergroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskSecurityUsergroup | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskSecurityUsergroup | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
}
export declare class StorageDiskSecurityUsergroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskSecurityUsergroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskSecurityUsergroupOutputReference;
}
export interface StorageDiskSecurity {
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#role StorageDisk#role}
    */
    readonly role?: StorageDiskSecurityRole[] | cdktf.IResolvable;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#user StorageDisk#user}
    */
    readonly user?: StorageDiskSecurityUser[] | cdktf.IResolvable;
    /**
    * usergroup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#usergroup StorageDisk#usergroup}
    */
    readonly usergroup?: StorageDiskSecurityUsergroup[] | cdktf.IResolvable;
}
export declare function storageDiskSecurityToTerraform(struct?: StorageDiskSecurity | cdktf.IResolvable): any;
export declare function storageDiskSecurityToHclTerraform(struct?: StorageDiskSecurity | cdktf.IResolvable): any;
export declare class StorageDiskSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskSecurity | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskSecurity | cdktf.IResolvable | undefined);
    private _role;
    get role(): StorageDiskSecurityRoleList;
    putRole(value: StorageDiskSecurityRole[] | cdktf.IResolvable): void;
    resetRole(): void;
    get roleInput(): cdktf.IResolvable | StorageDiskSecurityRole[] | undefined;
    private _user;
    get user(): StorageDiskSecurityUserList;
    putUser(value: StorageDiskSecurityUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | StorageDiskSecurityUser[] | undefined;
    private _usergroup;
    get usergroup(): StorageDiskSecurityUsergroupList;
    putUsergroup(value: StorageDiskSecurityUsergroup[] | cdktf.IResolvable): void;
    resetUsergroup(): void;
    get usergroupInput(): cdktf.IResolvable | StorageDiskSecurityUsergroup[] | undefined;
}
export declare class StorageDiskSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskSecurity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskSecurityOutputReference;
}
export interface StorageDiskStorageCredentials {
    /**
    * username to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name?: string;
    /**
    * password to access the network path
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#password StorageDisk#password}
    */
    readonly password?: string;
}
export declare function storageDiskStorageCredentialsToTerraform(struct?: StorageDiskStorageCredentials | cdktf.IResolvable): any;
export declare function storageDiskStorageCredentialsToHclTerraform(struct?: StorageDiskStorageCredentials | cdktf.IResolvable): any;
export declare class StorageDiskStorageCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskStorageCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskStorageCredentials | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
}
export declare class StorageDiskStorageCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskStorageCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskStorageCredentialsOutputReference;
}
export interface StorageDiskStorageMediaagent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name?: string;
}
export declare function storageDiskStorageMediaagentToTerraform(struct?: StorageDiskStorageMediaagent | cdktf.IResolvable): any;
export declare function storageDiskStorageMediaagentToHclTerraform(struct?: StorageDiskStorageMediaagent | cdktf.IResolvable): any;
export declare class StorageDiskStorageMediaagentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskStorageMediaagent | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskStorageMediaagent | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskStorageMediaagentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskStorageMediaagent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskStorageMediaagentOutputReference;
}
export interface StorageDiskStorageSavedcredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#id StorageDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#name StorageDisk#name}
    */
    readonly name?: string;
}
export declare function storageDiskStorageSavedcredentialsToTerraform(struct?: StorageDiskStorageSavedcredentials | cdktf.IResolvable): any;
export declare function storageDiskStorageSavedcredentialsToHclTerraform(struct?: StorageDiskStorageSavedcredentials | cdktf.IResolvable): any;
export declare class StorageDiskStorageSavedcredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskStorageSavedcredentials | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskStorageSavedcredentials | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class StorageDiskStorageSavedcredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskStorageSavedcredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskStorageSavedcredentialsOutputReference;
}
export interface StorageDiskStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#backuplocation StorageDisk#backuplocation}
    */
    readonly backuplocation?: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#credentials StorageDisk#credentials}
    */
    readonly credentials?: StorageDiskStorageCredentials[] | cdktf.IResolvable;
    /**
    * mediaagent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#mediaagent StorageDisk#mediaagent}
    */
    readonly mediaagent: StorageDiskStorageMediaagent[] | cdktf.IResolvable;
    /**
    * savedcredentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#savedcredentials StorageDisk#savedcredentials}
    */
    readonly savedcredentials?: StorageDiskStorageSavedcredentials[] | cdktf.IResolvable;
}
export declare function storageDiskStorageToTerraform(struct?: StorageDiskStorage | cdktf.IResolvable): any;
export declare function storageDiskStorageToHclTerraform(struct?: StorageDiskStorage | cdktf.IResolvable): any;
export declare class StorageDiskStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageDiskStorage | cdktf.IResolvable | undefined;
    set internalValue(value: StorageDiskStorage | cdktf.IResolvable | undefined);
    private _backuplocation?;
    get backuplocation(): string;
    set backuplocation(value: string);
    resetBackuplocation(): void;
    get backuplocationInput(): string | undefined;
    private _credentials;
    get credentials(): StorageDiskStorageCredentialsList;
    putCredentials(value: StorageDiskStorageCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | StorageDiskStorageCredentials[] | undefined;
    private _mediaagent;
    get mediaagent(): StorageDiskStorageMediaagentList;
    putMediaagent(value: StorageDiskStorageMediaagent[] | cdktf.IResolvable): void;
    get mediaagentInput(): cdktf.IResolvable | StorageDiskStorageMediaagent[] | undefined;
    private _savedcredentials;
    get savedcredentials(): StorageDiskStorageSavedcredentialsList;
    putSavedcredentials(value: StorageDiskStorageSavedcredentials[] | cdktf.IResolvable): void;
    resetSavedcredentials(): void;
    get savedcredentialsInput(): cdktf.IResolvable | StorageDiskStorageSavedcredentials[] | undefined;
}
export declare class StorageDiskStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageDiskStorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageDiskStorageOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk commvault_storage_disk}
*/
export declare class StorageDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_storage_disk";
    /**
    * Generates CDKTF code for importing a StorageDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageDisk to import
    * @param importFromId The id of the existing StorageDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/storage_disk commvault_storage_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDiskConfig
    */
    constructor(scope: Construct, id: string, config: StorageDiskConfig);
    private _enablededuplication?;
    get enablededuplication(): string;
    set enablededuplication(value: string);
    get enablededuplicationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataencryption;
    get dataencryption(): StorageDiskDataencryptionList;
    putDataencryption(value: StorageDiskDataencryption[] | cdktf.IResolvable): void;
    resetDataencryption(): void;
    get dataencryptionInput(): cdktf.IResolvable | StorageDiskDataencryption[] | undefined;
    private _deduplicationdbstorage;
    get deduplicationdbstorage(): StorageDiskDeduplicationdbstorageList;
    putDeduplicationdbstorage(value: StorageDiskDeduplicationdbstorage[] | cdktf.IResolvable): void;
    resetDeduplicationdbstorage(): void;
    get deduplicationdbstorageInput(): cdktf.IResolvable | StorageDiskDeduplicationdbstorage[] | undefined;
    private _security;
    get security(): StorageDiskSecurityList;
    putSecurity(value: StorageDiskSecurity[] | cdktf.IResolvable): void;
    resetSecurity(): void;
    get securityInput(): cdktf.IResolvable | StorageDiskSecurity[] | undefined;
    private _storage;
    get storage(): StorageDiskStorageList;
    putStorage(value: StorageDiskStorage[] | cdktf.IResolvable): void;
    get storageInput(): cdktf.IResolvable | StorageDiskStorage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
