import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmwareHypervisorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies The clients that have the VSA package installed and that act as proxy clients for hypervisors.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#access_nodes VmwareHypervisor#access_nodes}
    */
    readonly accessNodes: string;
    /**
    * Specifies the company id to which the Vmware Hypervisor should be associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#company_id VmwareHypervisor#company_id}
    */
    readonly companyId?: number;
    /**
    * Specifies The display name of the hypervisor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#display_name VmwareHypervisor#display_name}
    */
    readonly displayName: string;
    /**
    * Specifies The host name of the hypervisor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#host_name VmwareHypervisor#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#id VmwareHypervisor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies The password for the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#password VmwareHypervisor#password}
    */
    readonly password: string;
    /**
    * Specifies The user name for the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#user_name VmwareHypervisor#user_name}
    */
    readonly userName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor commvault_vmware_hypervisor}
*/
export declare class VmwareHypervisor extends cdktf.TerraformResource {
    static readonly tfResourceType = "commvault_vmware_hypervisor";
    /**
    * Generates CDKTF code for importing a VmwareHypervisor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmwareHypervisor to import
    * @param importFromId The id of the existing VmwareHypervisor that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmwareHypervisor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmware_hypervisor commvault_vmware_hypervisor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmwareHypervisorConfig
    */
    constructor(scope: Construct, id: string, config: VmwareHypervisorConfig);
    private _accessNodes?;
    get accessNodes(): string;
    set accessNodes(value: string);
    get accessNodesInput(): string | undefined;
    private _companyId?;
    get companyId(): number;
    set companyId(value: number);
    resetCompanyId(): void;
    get companyIdInput(): number | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
