'''
# `commvault_vmgroup_v2`

Refer to the Terraform Registry for docs: [`commvault_vmgroup_v2`](https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class VmgroupV2(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2",
):
    '''Represents a {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2 commvault_vmgroup_v2}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        content: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Content", typing.Dict[builtins.str, typing.Any]]]],
        hypervisor: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Hypervisor", typing.Dict[builtins.str, typing.Any]]]],
        name: builtins.str,
        plan: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Plan", typing.Dict[builtins.str, typing.Any]]]],
        accessnode: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Accessnode", typing.Dict[builtins.str, typing.Any]]]]] = None,
        activitycontrol: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Activitycontrol", typing.Dict[builtins.str, typing.Any]]]]] = None,
        applicationvalidation: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Applicationvalidation", typing.Dict[builtins.str, typing.Any]]]]] = None,
        diskfilters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Diskfilters", typing.Dict[builtins.str, typing.Any]]]]] = None,
        enablefileindexing: typing.Optional[builtins.str] = None,
        filters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Filters", typing.Dict[builtins.str, typing.Any]]]]] = None,
        id: typing.Optional[builtins.str] = None,
        meditech: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditech", typing.Dict[builtins.str, typing.Any]]]]] = None,
        meditechsystems: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditechsystems", typing.Dict[builtins.str, typing.Any]]]]] = None,
        securityassociations: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Securityassociations", typing.Dict[builtins.str, typing.Any]]]]] = None,
        settings: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Settings", typing.Dict[builtins.str, typing.Any]]]]] = None,
        snapshotmanagement: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Snapshotmanagement", typing.Dict[builtins.str, typing.Any]]]]] = None,
        storage: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Storage", typing.Dict[builtins.str, typing.Any]]]]] = None,
        timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Timezone", typing.Dict[builtins.str, typing.Any]]]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, _cdktf_9a9027ec.TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2 commvault_vmgroup_v2} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param content: content block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#content VmgroupV2#content}
        :param hypervisor: hypervisor block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#hypervisor VmgroupV2#hypervisor}
        :param name: subclient name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param plan: plan block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#plan VmgroupV2#plan}
        :param accessnode: accessnode block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#accessnode VmgroupV2#accessnode}
        :param activitycontrol: activitycontrol block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitycontrol VmgroupV2#activitycontrol}
        :param applicationvalidation: applicationvalidation block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#applicationvalidation VmgroupV2#applicationvalidation}
        :param diskfilters: diskfilters block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#diskfilters VmgroupV2#diskfilters}
        :param enablefileindexing: True if file indexing needs to be enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablefileindexing VmgroupV2#enablefileindexing}
        :param filters: filters block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filters VmgroupV2#filters}
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param meditech: meditech block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditech VmgroupV2#meditech}
        :param meditechsystems: meditechsystems block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditechsystems VmgroupV2#meditechsystems}
        :param securityassociations: securityassociations block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#securityassociations VmgroupV2#securityassociations}
        :param settings: settings block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#settings VmgroupV2#settings}
        :param snapshotmanagement: snapshotmanagement block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapshotmanagement VmgroupV2#snapshotmanagement}
        :param storage: storage block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#storage VmgroupV2#storage}
        :param timezone: timezone block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__37f8686b27db69ccf4a9c75cc4e306a6fa34217590ee2a747bcd13c77299dc24)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = VmgroupV2Config(
            content=content,
            hypervisor=hypervisor,
            name=name,
            plan=plan,
            accessnode=accessnode,
            activitycontrol=activitycontrol,
            applicationvalidation=applicationvalidation,
            diskfilters=diskfilters,
            enablefileindexing=enablefileindexing,
            filters=filters,
            id=id,
            meditech=meditech,
            meditechsystems=meditechsystems,
            securityassociations=securityassociations,
            settings=settings,
            snapshotmanagement=snapshotmanagement,
            storage=storage,
            timezone=timezone,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="generateConfigForImport")
    @builtins.classmethod
    def generate_config_for_import(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        import_to_id: builtins.str,
        import_from_id: builtins.str,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    ) -> _cdktf_9a9027ec.ImportableResource:
        '''Generates CDKTF code for importing a VmgroupV2 resource upon running "cdktf plan ".

        :param scope: The scope in which to define this construct.
        :param import_to_id: The construct id used in the generated config for the VmgroupV2 to import.
        :param import_from_id: The id of the existing VmgroupV2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#import import section} in the documentation of this resource for the id to use
        :param provider: ? Optional instance of the provider where the VmgroupV2 to import is found.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b92a1c6faa6348dd8d32fc7dcbbd70487bd403887cef60b32c92a4752b0473d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument import_to_id", value=import_to_id, expected_type=type_hints["import_to_id"])
            check_type(argname="argument import_from_id", value=import_from_id, expected_type=type_hints["import_from_id"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
        return typing.cast(_cdktf_9a9027ec.ImportableResource, jsii.sinvoke(cls, "generateConfigForImport", [scope, import_to_id, import_from_id, provider]))

    @jsii.member(jsii_name="putAccessnode")
    def put_accessnode(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Accessnode", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d80223f10a76b45b99f876fbf444d0fd5d64d74464dc885feba3058c5a5ee77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putAccessnode", [value]))

    @jsii.member(jsii_name="putActivitycontrol")
    def put_activitycontrol(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Activitycontrol", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff6053e9067b9bb89ac526f90d362fd6211980292544206e1311692c39f37ab2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putActivitycontrol", [value]))

    @jsii.member(jsii_name="putApplicationvalidation")
    def put_applicationvalidation(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Applicationvalidation", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__753961f606f2b6bba9cff98228e8ed2df17e6e4dcbbd2167753d280b32e4e138)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putApplicationvalidation", [value]))

    @jsii.member(jsii_name="putContent")
    def put_content(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Content", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b2c9158fc817c51fbb447ea3b2dae8672bfaea29c064b24cd6fa8ef218bdd2a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putContent", [value]))

    @jsii.member(jsii_name="putDiskfilters")
    def put_diskfilters(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Diskfilters", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a182d700ef600ef2fc6566854e9f31272f9792dab242fdd1c027f26492c05f8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putDiskfilters", [value]))

    @jsii.member(jsii_name="putFilters")
    def put_filters(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Filters", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa9a5a282af6cebc91d5a6cb8b9d8e15ae30ce8dd075adf485990a64c58a8c2c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putFilters", [value]))

    @jsii.member(jsii_name="putHypervisor")
    def put_hypervisor(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Hypervisor", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cd2b1833c9ad713c152e3e091980b1802404039ec3dbf90e5ad5b878de6d723)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putHypervisor", [value]))

    @jsii.member(jsii_name="putMeditech")
    def put_meditech(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditech", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__112bd8d484aa27423bfa6c48b7c0daf6e493d5594c70a43b762fe78f3b099cbd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMeditech", [value]))

    @jsii.member(jsii_name="putMeditechsystems")
    def put_meditechsystems(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditechsystems", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72180c9927a72ff716282ba22cc004ceb74d364df24319f2d1dac7915bfdfff5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putMeditechsystems", [value]))

    @jsii.member(jsii_name="putPlan")
    def put_plan(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Plan", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__187275d9b4f5a865bd88fb4716e7d8eea971162b87f1398e6fc39fc17c8b72a1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putPlan", [value]))

    @jsii.member(jsii_name="putSecurityassociations")
    def put_securityassociations(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Securityassociations", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7a54790337e37f469349af23628609c752c92aca940855090b75ccd1f09cea5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSecurityassociations", [value]))

    @jsii.member(jsii_name="putSettings")
    def put_settings(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Settings", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ac221b8ca6689717ab46174f09e24242cc1fffd3d77126eadf79a762c34ac15)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSettings", [value]))

    @jsii.member(jsii_name="putSnapshotmanagement")
    def put_snapshotmanagement(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Snapshotmanagement", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__40daf0a59c796ff6b64d6c666f9f3cc502f593aa4aa5b1cf6e0aff85b9ac2ded)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSnapshotmanagement", [value]))

    @jsii.member(jsii_name="putStorage")
    def put_storage(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Storage", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a26d41d7d315c346e29f5f14a62851d9e9dbe2f8b43fc3ab6b87e57cfd1a0035)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putStorage", [value]))

    @jsii.member(jsii_name="putTimezone")
    def put_timezone(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Timezone", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76e8bf18a4fe8e38195fa088cd9fc370c55c1ae91437ed22aef71be3882076ee)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTimezone", [value]))

    @jsii.member(jsii_name="resetAccessnode")
    def reset_accessnode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAccessnode", []))

    @jsii.member(jsii_name="resetActivitycontrol")
    def reset_activitycontrol(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetActivitycontrol", []))

    @jsii.member(jsii_name="resetApplicationvalidation")
    def reset_applicationvalidation(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetApplicationvalidation", []))

    @jsii.member(jsii_name="resetDiskfilters")
    def reset_diskfilters(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDiskfilters", []))

    @jsii.member(jsii_name="resetEnablefileindexing")
    def reset_enablefileindexing(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnablefileindexing", []))

    @jsii.member(jsii_name="resetFilters")
    def reset_filters(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFilters", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetMeditech")
    def reset_meditech(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMeditech", []))

    @jsii.member(jsii_name="resetMeditechsystems")
    def reset_meditechsystems(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMeditechsystems", []))

    @jsii.member(jsii_name="resetSecurityassociations")
    def reset_securityassociations(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSecurityassociations", []))

    @jsii.member(jsii_name="resetSettings")
    def reset_settings(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSettings", []))

    @jsii.member(jsii_name="resetSnapshotmanagement")
    def reset_snapshotmanagement(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSnapshotmanagement", []))

    @jsii.member(jsii_name="resetStorage")
    def reset_storage(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetStorage", []))

    @jsii.member(jsii_name="resetTimezone")
    def reset_timezone(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimezone", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="synthesizeHclAttributes")
    def _synthesize_hcl_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeHclAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="accessnode")
    def accessnode(self) -> "VmgroupV2AccessnodeList":
        return typing.cast("VmgroupV2AccessnodeList", jsii.get(self, "accessnode"))

    @builtins.property
    @jsii.member(jsii_name="activitycontrol")
    def activitycontrol(self) -> "VmgroupV2ActivitycontrolList":
        return typing.cast("VmgroupV2ActivitycontrolList", jsii.get(self, "activitycontrol"))

    @builtins.property
    @jsii.member(jsii_name="applicationvalidation")
    def applicationvalidation(self) -> "VmgroupV2ApplicationvalidationList":
        return typing.cast("VmgroupV2ApplicationvalidationList", jsii.get(self, "applicationvalidation"))

    @builtins.property
    @jsii.member(jsii_name="content")
    def content(self) -> "VmgroupV2ContentList":
        return typing.cast("VmgroupV2ContentList", jsii.get(self, "content"))

    @builtins.property
    @jsii.member(jsii_name="diskfilters")
    def diskfilters(self) -> "VmgroupV2DiskfiltersList":
        return typing.cast("VmgroupV2DiskfiltersList", jsii.get(self, "diskfilters"))

    @builtins.property
    @jsii.member(jsii_name="filters")
    def filters(self) -> "VmgroupV2FiltersList":
        return typing.cast("VmgroupV2FiltersList", jsii.get(self, "filters"))

    @builtins.property
    @jsii.member(jsii_name="hypervisor")
    def hypervisor(self) -> "VmgroupV2HypervisorList":
        return typing.cast("VmgroupV2HypervisorList", jsii.get(self, "hypervisor"))

    @builtins.property
    @jsii.member(jsii_name="meditech")
    def meditech(self) -> "VmgroupV2MeditechList":
        return typing.cast("VmgroupV2MeditechList", jsii.get(self, "meditech"))

    @builtins.property
    @jsii.member(jsii_name="meditechsystems")
    def meditechsystems(self) -> "VmgroupV2MeditechsystemsList":
        return typing.cast("VmgroupV2MeditechsystemsList", jsii.get(self, "meditechsystems"))

    @builtins.property
    @jsii.member(jsii_name="plan")
    def plan(self) -> "VmgroupV2PlanList":
        return typing.cast("VmgroupV2PlanList", jsii.get(self, "plan"))

    @builtins.property
    @jsii.member(jsii_name="securityassociations")
    def securityassociations(self) -> "VmgroupV2SecurityassociationsList":
        return typing.cast("VmgroupV2SecurityassociationsList", jsii.get(self, "securityassociations"))

    @builtins.property
    @jsii.member(jsii_name="settings")
    def settings(self) -> "VmgroupV2SettingsList":
        return typing.cast("VmgroupV2SettingsList", jsii.get(self, "settings"))

    @builtins.property
    @jsii.member(jsii_name="snapshotmanagement")
    def snapshotmanagement(self) -> "VmgroupV2SnapshotmanagementList":
        return typing.cast("VmgroupV2SnapshotmanagementList", jsii.get(self, "snapshotmanagement"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> "VmgroupV2StorageList":
        return typing.cast("VmgroupV2StorageList", jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="timezone")
    def timezone(self) -> "VmgroupV2TimezoneList":
        return typing.cast("VmgroupV2TimezoneList", jsii.get(self, "timezone"))

    @builtins.property
    @jsii.member(jsii_name="accessnodeInput")
    def accessnode_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Accessnode"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Accessnode"]]], jsii.get(self, "accessnodeInput"))

    @builtins.property
    @jsii.member(jsii_name="activitycontrolInput")
    def activitycontrol_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Activitycontrol"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Activitycontrol"]]], jsii.get(self, "activitycontrolInput"))

    @builtins.property
    @jsii.member(jsii_name="applicationvalidationInput")
    def applicationvalidation_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Applicationvalidation"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Applicationvalidation"]]], jsii.get(self, "applicationvalidationInput"))

    @builtins.property
    @jsii.member(jsii_name="contentInput")
    def content_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Content"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Content"]]], jsii.get(self, "contentInput"))

    @builtins.property
    @jsii.member(jsii_name="diskfiltersInput")
    def diskfilters_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Diskfilters"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Diskfilters"]]], jsii.get(self, "diskfiltersInput"))

    @builtins.property
    @jsii.member(jsii_name="enablefileindexingInput")
    def enablefileindexing_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enablefileindexingInput"))

    @builtins.property
    @jsii.member(jsii_name="filtersInput")
    def filters_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Filters"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Filters"]]], jsii.get(self, "filtersInput"))

    @builtins.property
    @jsii.member(jsii_name="hypervisorInput")
    def hypervisor_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Hypervisor"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Hypervisor"]]], jsii.get(self, "hypervisorInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="meditechInput")
    def meditech_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditech"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditech"]]], jsii.get(self, "meditechInput"))

    @builtins.property
    @jsii.member(jsii_name="meditechsystemsInput")
    def meditechsystems_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditechsystems"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditechsystems"]]], jsii.get(self, "meditechsystemsInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="planInput")
    def plan_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Plan"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Plan"]]], jsii.get(self, "planInput"))

    @builtins.property
    @jsii.member(jsii_name="securityassociationsInput")
    def securityassociations_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Securityassociations"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Securityassociations"]]], jsii.get(self, "securityassociationsInput"))

    @builtins.property
    @jsii.member(jsii_name="settingsInput")
    def settings_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Settings"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Settings"]]], jsii.get(self, "settingsInput"))

    @builtins.property
    @jsii.member(jsii_name="snapshotmanagementInput")
    def snapshotmanagement_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Snapshotmanagement"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Snapshotmanagement"]]], jsii.get(self, "snapshotmanagementInput"))

    @builtins.property
    @jsii.member(jsii_name="storageInput")
    def storage_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Storage"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Storage"]]], jsii.get(self, "storageInput"))

    @builtins.property
    @jsii.member(jsii_name="timezoneInput")
    def timezone_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Timezone"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Timezone"]]], jsii.get(self, "timezoneInput"))

    @builtins.property
    @jsii.member(jsii_name="enablefileindexing")
    def enablefileindexing(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enablefileindexing"))

    @enablefileindexing.setter
    def enablefileindexing(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e7ad0ea0b76691c55438abe260cd280487e3116534ad3833e1fed0a5149d03e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enablefileindexing", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fdb0f16d99a6f0c8e9e99c6c986a0479c3ce2def30d7020ff21f73fa587ba25)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9677a28bb6ddbf1bd7e29aee422dccea7fdf8eb330fb57dc26a34b6471d4abbf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Accessnode",
    jsii_struct_bases=[],
    name_mapping={"id": "id"},
)
class VmgroupV2Accessnode:
    def __init__(self, *, id: typing.Optional[jsii.Number] = None) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dbad56d18a9e0a0882fef1a434a93a2f84626bd1c296b0068faf9c5cca58efb3)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Accessnode(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2AccessnodeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2AccessnodeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60b7eb2b9da769741675a8317b558dfbdeb36642e0f721a59a2ae61387b16ca4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2AccessnodeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__746e1291b2aa71004ecf67f202125a3f122c935bc4f8c4389c76de12104d3674)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2AccessnodeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ccc03573b528ade0dc6c0857cf4de4a2f0fbd38c3e6f26a75549da8a1c13371)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b46e8501b435b6973761a8693aaf108c4aaed19ab8e59dc92926bdc8162914db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__defbed6cbc7bdcf1b6fd429d94b4bb4c00b643247f7a3718b02cde8ae39a9f9f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bf5db4cf036191aedc02cfdf7a60a663665b5c9a7201ccb61ad4a22e30c37c3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2AccessnodeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2AccessnodeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e4b10749c6e8cbc67da9b59b5a51208394a42074a641c567f3f7c0f927930ad)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7adee0993cefb8cf9391693c07456fa02e0308f714b5f89978559112677bb7b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Accessnode]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Accessnode]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Accessnode]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__970b4ee34ec7a09675d397f364a21bee73f54fefc28bcee1e302455e76e14c0f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Activitycontrol",
    jsii_struct_bases=[],
    name_mapping={
        "backupactivitycontroloptions": "backupactivitycontroloptions",
        "enablebackup": "enablebackup",
        "enablerestore": "enablerestore",
        "restoreactivitycontroloptions": "restoreactivitycontroloptions",
    },
)
class VmgroupV2Activitycontrol:
    def __init__(
        self,
        *,
        backupactivitycontroloptions: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolBackupactivitycontroloptions", typing.Dict[builtins.str, typing.Any]]]]] = None,
        enablebackup: typing.Optional[builtins.str] = None,
        enablerestore: typing.Optional[builtins.str] = None,
        restoreactivitycontroloptions: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolRestoreactivitycontroloptions", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param backupactivitycontroloptions: backupactivitycontroloptions block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupactivitycontroloptions VmgroupV2#backupactivitycontroloptions}
        :param enablebackup: true if Backup is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablebackup VmgroupV2#enablebackup}
        :param enablerestore: true if Restore is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablerestore VmgroupV2#enablerestore}
        :param restoreactivitycontroloptions: restoreactivitycontroloptions block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#restoreactivitycontroloptions VmgroupV2#restoreactivitycontroloptions}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dbbba5ba4cf426ee2508e80cd881f18194f8591ccdbffc2a30dfdf646a4edc1a)
            check_type(argname="argument backupactivitycontroloptions", value=backupactivitycontroloptions, expected_type=type_hints["backupactivitycontroloptions"])
            check_type(argname="argument enablebackup", value=enablebackup, expected_type=type_hints["enablebackup"])
            check_type(argname="argument enablerestore", value=enablerestore, expected_type=type_hints["enablerestore"])
            check_type(argname="argument restoreactivitycontroloptions", value=restoreactivitycontroloptions, expected_type=type_hints["restoreactivitycontroloptions"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if backupactivitycontroloptions is not None:
            self._values["backupactivitycontroloptions"] = backupactivitycontroloptions
        if enablebackup is not None:
            self._values["enablebackup"] = enablebackup
        if enablerestore is not None:
            self._values["enablerestore"] = enablerestore
        if restoreactivitycontroloptions is not None:
            self._values["restoreactivitycontroloptions"] = restoreactivitycontroloptions

    @builtins.property
    def backupactivitycontroloptions(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptions"]]]:
        '''backupactivitycontroloptions block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupactivitycontroloptions VmgroupV2#backupactivitycontroloptions}
        '''
        result = self._values.get("backupactivitycontroloptions")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptions"]]], result)

    @builtins.property
    def enablebackup(self) -> typing.Optional[builtins.str]:
        '''true if Backup is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablebackup VmgroupV2#enablebackup}
        '''
        result = self._values.get("enablebackup")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enablerestore(self) -> typing.Optional[builtins.str]:
        '''true if Restore is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablerestore VmgroupV2#enablerestore}
        '''
        result = self._values.get("enablerestore")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def restoreactivitycontroloptions(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptions"]]]:
        '''restoreactivitycontroloptions block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#restoreactivitycontroloptions VmgroupV2#restoreactivitycontroloptions}
        '''
        result = self._values.get("restoreactivitycontroloptions")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptions"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Activitycontrol(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptions",
    jsii_struct_bases=[],
    name_mapping={
        "activitytype": "activitytype",
        "delaytime": "delaytime",
        "enableactivitytype": "enableactivitytype",
        "enableafteradelay": "enableafteradelay",
    },
)
class VmgroupV2ActivitycontrolBackupactivitycontroloptions:
    def __init__(
        self,
        *,
        activitytype: typing.Optional[builtins.str] = None,
        delaytime: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime", typing.Dict[builtins.str, typing.Any]]]]] = None,
        enableactivitytype: typing.Optional[builtins.str] = None,
        enableafteradelay: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param activitytype: denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
        :param delaytime: delaytime block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
        :param enableactivitytype: True if the activity type is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
        :param enableafteradelay: True if the activity will be enabled after a delay time interval. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bda6ba63d6e7838760826431d515ea8e3709c9cdd30aee4cbfc08a14ea8d6e50)
            check_type(argname="argument activitytype", value=activitytype, expected_type=type_hints["activitytype"])
            check_type(argname="argument delaytime", value=delaytime, expected_type=type_hints["delaytime"])
            check_type(argname="argument enableactivitytype", value=enableactivitytype, expected_type=type_hints["enableactivitytype"])
            check_type(argname="argument enableafteradelay", value=enableafteradelay, expected_type=type_hints["enableafteradelay"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if activitytype is not None:
            self._values["activitytype"] = activitytype
        if delaytime is not None:
            self._values["delaytime"] = delaytime
        if enableactivitytype is not None:
            self._values["enableactivitytype"] = enableactivitytype
        if enableafteradelay is not None:
            self._values["enableafteradelay"] = enableafteradelay

    @builtins.property
    def activitytype(self) -> typing.Optional[builtins.str]:
        '''denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
        '''
        result = self._values.get("activitytype")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def delaytime(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime"]]]:
        '''delaytime block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
        '''
        result = self._values.get("delaytime")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime"]]], result)

    @builtins.property
    def enableactivitytype(self) -> typing.Optional[builtins.str]:
        '''True if the activity type is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
        '''
        result = self._values.get("enableactivitytype")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enableafteradelay(self) -> typing.Optional[builtins.str]:
        '''True if the activity will be enabled after a delay time interval.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
        '''
        result = self._values.get("enableafteradelay")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolBackupactivitycontroloptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime",
    jsii_struct_bases=[],
    name_mapping={"time": "time", "timezone": "timezone", "value": "value"},
)
class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime:
    def __init__(
        self,
        *,
        time: typing.Optional[jsii.Number] = None,
        timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone", typing.Dict[builtins.str, typing.Any]]]]] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param time: delay time in unix timestamp. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
        :param timezone: timezone block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        :param value: actual delay time value in string format according to the timezone. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b78dcb50f3d5878d50febc5e23acb603092564d4865a11e6077a8258eea44ba5)
            check_type(argname="argument time", value=time, expected_type=type_hints["time"])
            check_type(argname="argument timezone", value=timezone, expected_type=type_hints["timezone"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if time is not None:
            self._values["time"] = time
        if timezone is not None:
            self._values["timezone"] = timezone
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def time(self) -> typing.Optional[jsii.Number]:
        '''delay time in unix timestamp.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
        '''
        result = self._values.get("time")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timezone(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone"]]]:
        '''timezone block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        '''
        result = self._values.get("timezone")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone"]]], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''actual delay time value in string format according to the timezone.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08f1c18e7cb1e2a96355717799937bd3450d0d3712aa1d8aac5c2f3c0bd77723)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cae5d1e763b6831b6001c9649488558e03784523a3eee77c5daf323ea0d8ca3b)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__866a0ef4449978f81c19f92ba9184145feb2a7c4a3990d0390c9fa13ac768f06)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17a9dd4cfd5e08950561e39b6af60039b7c176f8bba64f6062bef852182607fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c1b6a7eba48569d534089522962f313e750df017bdfe3730b89a07552c54675)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c807f665407624ece5e7fee41b587f42866a66fec056e6f4c3516f6dc1297e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__309557685e43e654cb68657381e4277e422e1a3a24f2a6f5ea23743d948e45d5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putTimezone")
    def put_timezone(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9f55566e673efc80463cd4d1dc56ce967ebe44b3cfc2dfaf9f8345458cced804)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTimezone", [value]))

    @jsii.member(jsii_name="resetTime")
    def reset_time(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTime", []))

    @jsii.member(jsii_name="resetTimezone")
    def reset_timezone(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimezone", []))

    @jsii.member(jsii_name="resetValue")
    def reset_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValue", []))

    @builtins.property
    @jsii.member(jsii_name="timezone")
    def timezone(
        self,
    ) -> "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList":
        return typing.cast("VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList", jsii.get(self, "timezone"))

    @builtins.property
    @jsii.member(jsii_name="timeInput")
    def time_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "timeInput"))

    @builtins.property
    @jsii.member(jsii_name="timezoneInput")
    def timezone_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone"]]], jsii.get(self, "timezoneInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="time")
    def time(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "time"))

    @time.setter
    def time(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43e0ddd47e4dfaffc110bf69db9e17e91d105702e9e33f3eca2e8b6a52b9a188)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "time", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "value"))

    @value.setter
    def value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9e15f7eac5b6224a8a9e50cf773a0ba3fc79a331b9ccb3dff6137c8050b48aa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b10ff9573b947784a2334dd69b9973357c5e7dc5809f47c892c8e0a6aa0ccb9d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67dac461c88fa1e5bba5daebaefa172ea350a4143375521ab1bbb901bc4eff0a)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae47f1eb93e8cf57d35828f6cb422ccca16e3f3c7f20424f45e2866d0acca318)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c30aee612ba7a2aa28baa85067200f3dee7ccc17fc554b32cc6b09c40c14e90)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bc76891b9cdeb2a9934cce645ff40606b1d118603710adb99dccaddb11aa148)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e519df2aca11493f40edaee6f30c74d115b53d30e1e4189cc83bb0e8b364c7cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3e2827783d0b63d6a22ae7ea769533c096408bd550f4d85258de9bac44e63cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__456e0a53d63054cb6215fa918367c96eeacf01912fb936fbfbad47381519c968)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc7a40b3d4760514c85f47ebc87fc01cdc160b62a3f079c74eb2eab8783c9594)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4337cd18e38c2a55b49ee83c126f4e56fa7da7d77121583ee33b0140c4d2dcc7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9d6678fa237377b731e0aa07474cf5e205685279585c4100cc924a92f8080c8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b61d553fdd904fc4a08e444d3b69744e95ef8264012fd46406de0154e99f0af7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61fa32feaf0c13a78cb198acf02f528332006fad075e705b143502af92c935d1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__660810a486612f9a60ef5c131cc87feb203e023ba1865b3da094678e471e0a5d)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9dd713edfccc9aa376103542418b9c415e9cbccbaa758a7722fbee7127e17a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__afa1ba2255334c916405dfc388e39ac1a9b22d6c88d217bd836a3cf33e92df22)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__959fb4d7c672eb67c368bcd07bead2bbd17cceb215eaa6e3d484b363304e6b8e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a15a139957830e9f3fd1533aa9e188ffb217862797990cb14c0b72b233c7429)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6582cac8d25cf965bcbdc6a84a2f79e4aebb715cb2541d40c63065062ffa8e3)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putDelaytime")
    def put_delaytime(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5861de0e25fb2711572e90e21335ae805442ca2019610847a45498158270c95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putDelaytime", [value]))

    @jsii.member(jsii_name="resetActivitytype")
    def reset_activitytype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetActivitytype", []))

    @jsii.member(jsii_name="resetDelaytime")
    def reset_delaytime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDelaytime", []))

    @jsii.member(jsii_name="resetEnableactivitytype")
    def reset_enableactivitytype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnableactivitytype", []))

    @jsii.member(jsii_name="resetEnableafteradelay")
    def reset_enableafteradelay(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnableafteradelay", []))

    @builtins.property
    @jsii.member(jsii_name="delaytime")
    def delaytime(
        self,
    ) -> VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList:
        return typing.cast(VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList, jsii.get(self, "delaytime"))

    @builtins.property
    @jsii.member(jsii_name="activitytypeInput")
    def activitytype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "activitytypeInput"))

    @builtins.property
    @jsii.member(jsii_name="delaytimeInput")
    def delaytime_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]], jsii.get(self, "delaytimeInput"))

    @builtins.property
    @jsii.member(jsii_name="enableactivitytypeInput")
    def enableactivitytype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enableactivitytypeInput"))

    @builtins.property
    @jsii.member(jsii_name="enableafteradelayInput")
    def enableafteradelay_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enableafteradelayInput"))

    @builtins.property
    @jsii.member(jsii_name="activitytype")
    def activitytype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "activitytype"))

    @activitytype.setter
    def activitytype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__022c76fb2959e45352a13fea579aefff2610985f7c57923ed9b1634902f55c62)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "activitytype", value)

    @builtins.property
    @jsii.member(jsii_name="enableactivitytype")
    def enableactivitytype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enableactivitytype"))

    @enableactivitytype.setter
    def enableactivitytype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8627c79ee0da1edc59c70033093f2421abca703c59f543d9fe78b0a300bec85)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableactivitytype", value)

    @builtins.property
    @jsii.member(jsii_name="enableafteradelay")
    def enableafteradelay(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enableafteradelay"))

    @enableafteradelay.setter
    def enableafteradelay(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db942ddc22cd6d26a8eb3320baa2962aa2e6710ef2c00011e041805ac1b479bc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableafteradelay", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptions]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptions]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptions]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67139cbb727145b454d9d179645971c5df16bbdbc8dd0bc0c68f0df223aa2a8c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c25934448fdbe08cb546162c16f60b6943b48df41dbd37601d12c67335a8fea5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2ActivitycontrolOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a84e66aac620767ffdd6cf75f8b6cca6eda56bc9468411b7dd95237e4fbd6d3f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19caab2bb68ce238809692fcf63044662538dc30223135a3962fad0d17621427)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c92c9d8c29d94f94ba91e494f04950bc14d52da5e4e153a8de2e75d8b7222914)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11239f57245dfeeb6494317a56748b385d8efaabc7faa3e0bc6c3f54f5c38828)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91a710c4f4447dfae3adc611e455cde5463766bffe5c7e9ebe7eccaef3b497db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d22350133a05e32d4667f75d4d57e08d381a3545e0123523b21a8aad3172ea94)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putBackupactivitycontroloptions")
    def put_backupactivitycontroloptions(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptions, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e7306976c58f1f07691367beae6532ce9927fe79228358d9d8845cc0baf1341e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putBackupactivitycontroloptions", [value]))

    @jsii.member(jsii_name="putRestoreactivitycontroloptions")
    def put_restoreactivitycontroloptions(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolRestoreactivitycontroloptions", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbe8262f67e9940e8891c3aee317766001aa29afb9b67f278f1b8e5a4d2f9bde)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRestoreactivitycontroloptions", [value]))

    @jsii.member(jsii_name="resetBackupactivitycontroloptions")
    def reset_backupactivitycontroloptions(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBackupactivitycontroloptions", []))

    @jsii.member(jsii_name="resetEnablebackup")
    def reset_enablebackup(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnablebackup", []))

    @jsii.member(jsii_name="resetEnablerestore")
    def reset_enablerestore(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnablerestore", []))

    @jsii.member(jsii_name="resetRestoreactivitycontroloptions")
    def reset_restoreactivitycontroloptions(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRestoreactivitycontroloptions", []))

    @builtins.property
    @jsii.member(jsii_name="backupactivitycontroloptions")
    def backupactivitycontroloptions(
        self,
    ) -> VmgroupV2ActivitycontrolBackupactivitycontroloptionsList:
        return typing.cast(VmgroupV2ActivitycontrolBackupactivitycontroloptionsList, jsii.get(self, "backupactivitycontroloptions"))

    @builtins.property
    @jsii.member(jsii_name="restoreactivitycontroloptions")
    def restoreactivitycontroloptions(
        self,
    ) -> "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList":
        return typing.cast("VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList", jsii.get(self, "restoreactivitycontroloptions"))

    @builtins.property
    @jsii.member(jsii_name="backupactivitycontroloptionsInput")
    def backupactivitycontroloptions_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]], jsii.get(self, "backupactivitycontroloptionsInput"))

    @builtins.property
    @jsii.member(jsii_name="enablebackupInput")
    def enablebackup_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enablebackupInput"))

    @builtins.property
    @jsii.member(jsii_name="enablerestoreInput")
    def enablerestore_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enablerestoreInput"))

    @builtins.property
    @jsii.member(jsii_name="restoreactivitycontroloptionsInput")
    def restoreactivitycontroloptions_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptions"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptions"]]], jsii.get(self, "restoreactivitycontroloptionsInput"))

    @builtins.property
    @jsii.member(jsii_name="enablebackup")
    def enablebackup(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enablebackup"))

    @enablebackup.setter
    def enablebackup(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54a2bb16753b5d113dcd4bc09376416fcd4bec4b4f5aaa3db5ec7d8e793e03a6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enablebackup", value)

    @builtins.property
    @jsii.member(jsii_name="enablerestore")
    def enablerestore(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enablerestore"))

    @enablerestore.setter
    def enablerestore(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e58c68087fa37efa82c6eb301677e192edd7fe8640f33090f915aca447ebb2b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enablerestore", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Activitycontrol]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Activitycontrol]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Activitycontrol]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9882e3f475c8966050ad30ccad2d791dad923786e5cb5480d666931426c28640)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptions",
    jsii_struct_bases=[],
    name_mapping={
        "activitytype": "activitytype",
        "delaytime": "delaytime",
        "enableactivitytype": "enableactivitytype",
        "enableafteradelay": "enableafteradelay",
    },
)
class VmgroupV2ActivitycontrolRestoreactivitycontroloptions:
    def __init__(
        self,
        *,
        activitytype: typing.Optional[builtins.str] = None,
        delaytime: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime", typing.Dict[builtins.str, typing.Any]]]]] = None,
        enableactivitytype: typing.Optional[builtins.str] = None,
        enableafteradelay: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param activitytype: denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
        :param delaytime: delaytime block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
        :param enableactivitytype: True if the activity type is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
        :param enableafteradelay: True if the activity will be enabled after a delay time interval. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e3f42dac0acaf0e1fc4393ec166908122f012c74af07c363e4b44b769953110)
            check_type(argname="argument activitytype", value=activitytype, expected_type=type_hints["activitytype"])
            check_type(argname="argument delaytime", value=delaytime, expected_type=type_hints["delaytime"])
            check_type(argname="argument enableactivitytype", value=enableactivitytype, expected_type=type_hints["enableactivitytype"])
            check_type(argname="argument enableafteradelay", value=enableafteradelay, expected_type=type_hints["enableafteradelay"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if activitytype is not None:
            self._values["activitytype"] = activitytype
        if delaytime is not None:
            self._values["delaytime"] = delaytime
        if enableactivitytype is not None:
            self._values["enableactivitytype"] = enableactivitytype
        if enableafteradelay is not None:
            self._values["enableafteradelay"] = enableafteradelay

    @builtins.property
    def activitytype(self) -> typing.Optional[builtins.str]:
        '''denotes the activity type being considered [BACKUP, RESTORE, ONLINECI, ARCHIVEPRUNE].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitytype VmgroupV2#activitytype}
        '''
        result = self._values.get("activitytype")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def delaytime(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime"]]]:
        '''delaytime block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#delaytime VmgroupV2#delaytime}
        '''
        result = self._values.get("delaytime")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime"]]], result)

    @builtins.property
    def enableactivitytype(self) -> typing.Optional[builtins.str]:
        '''True if the activity type is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableactivitytype VmgroupV2#enableactivitytype}
        '''
        result = self._values.get("enableactivitytype")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enableafteradelay(self) -> typing.Optional[builtins.str]:
        '''True if the activity will be enabled after a delay time interval.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enableafteradelay VmgroupV2#enableafteradelay}
        '''
        result = self._values.get("enableafteradelay")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolRestoreactivitycontroloptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime",
    jsii_struct_bases=[],
    name_mapping={"time": "time", "timezone": "timezone", "value": "value"},
)
class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime:
    def __init__(
        self,
        *,
        time: typing.Optional[jsii.Number] = None,
        timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone", typing.Dict[builtins.str, typing.Any]]]]] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param time: delay time in unix timestamp. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
        :param timezone: timezone block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        :param value: actual delay time value in string format according to the timezone. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c05bb9b84cc2d0bbb1437d7fc5a1bd3ac0597319865c3003e11eca83abb44de6)
            check_type(argname="argument time", value=time, expected_type=type_hints["time"])
            check_type(argname="argument timezone", value=timezone, expected_type=type_hints["timezone"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if time is not None:
            self._values["time"] = time
        if timezone is not None:
            self._values["timezone"] = timezone
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def time(self) -> typing.Optional[jsii.Number]:
        '''delay time in unix timestamp.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#time VmgroupV2#time}
        '''
        result = self._values.get("time")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timezone(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone"]]]:
        '''timezone block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        '''
        result = self._values.get("timezone")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone"]]], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''actual delay time value in string format according to the timezone.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e038048a18dc76dee911d01a8df412876a2cab99d262a302407079bda550034d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eee64b6747d91d9518e0a0d70990b91fbb648028c454121707adce5ba9bf5d55)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c4d0c457d5fae845c436fd3bb7f9ed94128ef8fcb4eb7dafd2ca277d9ccb98a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea3d6c75490dd60ee37a90c99bcd11e7d97d62b1fc057be36f5bf6d850f29243)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5c9d9b2a38a15ce972ec8f6e58a129974f5c9f5413cd001696553606bd40a6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1b886ffc0da5f11893a86a3e4b063e014de2cf23f159b07feccb92f4ddad729)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68b445970d513131044cc7ba0806f8fb53f0cdb6b2be15b3a1f98c84223327e0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putTimezone")
    def put_timezone(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64b64c83a9a4ce07fd339e77172c470d1ecd6ac51d98d165b526a404a9f69c79)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putTimezone", [value]))

    @jsii.member(jsii_name="resetTime")
    def reset_time(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTime", []))

    @jsii.member(jsii_name="resetTimezone")
    def reset_timezone(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimezone", []))

    @jsii.member(jsii_name="resetValue")
    def reset_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValue", []))

    @builtins.property
    @jsii.member(jsii_name="timezone")
    def timezone(
        self,
    ) -> "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList":
        return typing.cast("VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList", jsii.get(self, "timezone"))

    @builtins.property
    @jsii.member(jsii_name="timeInput")
    def time_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "timeInput"))

    @builtins.property
    @jsii.member(jsii_name="timezoneInput")
    def timezone_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone"]]], jsii.get(self, "timezoneInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="time")
    def time(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "time"))

    @time.setter
    def time(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__866f560abc370deb351f91d036746815496122d407b555483fe85f6df6447198)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "time", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "value"))

    @value.setter
    def value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0aa1415d8fd7c5cc03225f4eb4af2cfeb3c12280e2cda7725d5066f1019e4997)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98406ef0e59aa10ee6be2a050ed15a27d0b5ea3ad082d2261c9114ee2d753777)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52103a12f1d256e348433704c6c03d706587280ce5e1e08c6891475123f805c1)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6640add3b2bd59ff94dd45cda954303b79d18a1c28ce1a0fd3ba5a7a6e7ebaac)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__808bd6681c9cb4d323df88c3f9f513d318f9a82a58f1f6483c9b6c3ad82c9264)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5431940debfbedcf1445ae0465a924ad3bd15b6d35a1438e352f8b791235633b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__148b2bc7d1c6455b41784151890336cd049aa6bd90777d76e2b164622281b7cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00475fab7039fc8c806610502fb13c452ceb4c772dda89af627a023c14a70aaa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__853a0f58162e3c0eb6d6906f810cc0e414da36e8cf07ecdaebd26f6b2897098d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49ac92e7e17d29bec9f343110b43fb352eee636c6a5909ae386ec0cfdb016d2a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb5fe2816664c9cf060de91adf81d10800833bd43df11cbc023064e3089a9fdd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11b72aa2de9bbb8440fe5dc1322fdb554aa7edd0a8818e35cd99fdf0f59cdb26)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1edeed6757a80d9e924b2eeb089e01875153217b4ac12fb1b66ea9fd5adb1c53)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9d21d4b253be8e02659b1ed28510febb95e5c7e75d8f193c251c3ee9e97bcf4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__758ba31d6d17aabaa1c42d5e95233fc792bb0604c8aa7acad9c8700b806e1df1)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69853efa96a070010360615a9c161e722ff02522f48bef811f6aa329160951cf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32d2f67b05e14a0c60325aac7d49622b906987406a19d923184233b97321f83b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a6103f2a2d2adf3337f7018d754a23298dd2335a366d69d12b0e46868a80ad9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptions]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptions]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptions]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__657499f5f61b440c73f63e550a66f31870bef1dc0ea3e050cae67ac30da0df0b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__647838adabcaaed84514f4ec1666e275178400a5b826bbb88b67929ce2bbeb8c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putDelaytime")
    def put_delaytime(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e96779949c14b458a6afc7bb2ff998d1a3b84755db72936dd4e997245f9b2e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putDelaytime", [value]))

    @jsii.member(jsii_name="resetActivitytype")
    def reset_activitytype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetActivitytype", []))

    @jsii.member(jsii_name="resetDelaytime")
    def reset_delaytime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDelaytime", []))

    @jsii.member(jsii_name="resetEnableactivitytype")
    def reset_enableactivitytype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnableactivitytype", []))

    @jsii.member(jsii_name="resetEnableafteradelay")
    def reset_enableafteradelay(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnableafteradelay", []))

    @builtins.property
    @jsii.member(jsii_name="delaytime")
    def delaytime(
        self,
    ) -> VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList:
        return typing.cast(VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList, jsii.get(self, "delaytime"))

    @builtins.property
    @jsii.member(jsii_name="activitytypeInput")
    def activitytype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "activitytypeInput"))

    @builtins.property
    @jsii.member(jsii_name="delaytimeInput")
    def delaytime_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]], jsii.get(self, "delaytimeInput"))

    @builtins.property
    @jsii.member(jsii_name="enableactivitytypeInput")
    def enableactivitytype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enableactivitytypeInput"))

    @builtins.property
    @jsii.member(jsii_name="enableafteradelayInput")
    def enableafteradelay_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enableafteradelayInput"))

    @builtins.property
    @jsii.member(jsii_name="activitytype")
    def activitytype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "activitytype"))

    @activitytype.setter
    def activitytype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__841ace911e31295c28c331d619a786b9fdfc467a2ab2a27662d966013bdde7b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "activitytype", value)

    @builtins.property
    @jsii.member(jsii_name="enableactivitytype")
    def enableactivitytype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enableactivitytype"))

    @enableactivitytype.setter
    def enableactivitytype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed5ec8033af727814b15cf2441491ab2a984b3dd590090f89eb6915d586f4f4e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableactivitytype", value)

    @builtins.property
    @jsii.member(jsii_name="enableafteradelay")
    def enableafteradelay(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enableafteradelay"))

    @enableafteradelay.setter
    def enableafteradelay(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78ccdbb560b2b2c49e8a312cf1cdbce6948071b576a1795157609c74680edf7e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableafteradelay", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptions]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptions]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptions]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd978d2b7da02dd5d98cb6b5dcba753c9a6ba97848691d57110e2d0527d68e90)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Applicationvalidation",
    jsii_struct_bases=[],
    name_mapping={
        "copy": "copy",
        "customvalidationscript": "customvalidationscript",
        "guestcredentials": "guestcredentials",
        "keepvalidatedvmsrunning": "keepvalidatedvmsrunning",
        "maximumnoofthreads": "maximumnoofthreads",
        "recoverytarget": "recoverytarget",
        "schedule": "schedule",
        "usesourcevmesxtomount": "usesourcevmesxtomount",
        "validatevmbackups": "validatevmbackups",
    },
)
class VmgroupV2Applicationvalidation:
    def __init__(
        self,
        *,
        copy: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCopy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        customvalidationscript: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscript", typing.Dict[builtins.str, typing.Any]]]]] = None,
        guestcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationGuestcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        keepvalidatedvmsrunning: typing.Optional[builtins.str] = None,
        maximumnoofthreads: typing.Optional[jsii.Number] = None,
        recoverytarget: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationRecoverytarget", typing.Dict[builtins.str, typing.Any]]]]] = None,
        schedule: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationSchedule", typing.Dict[builtins.str, typing.Any]]]]] = None,
        usesourcevmesxtomount: typing.Optional[builtins.str] = None,
        validatevmbackups: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param copy: copy block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copy VmgroupV2#copy}
        :param customvalidationscript: customvalidationscript block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customvalidationscript VmgroupV2#customvalidationscript}
        :param guestcredentials: guestcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
        :param keepvalidatedvmsrunning: If true then validated VMs will be available until expiration time set on the recovery target. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#keepvalidatedvmsrunning VmgroupV2#keepvalidatedvmsrunning}
        :param maximumnoofthreads: Number of backup Validation Threads. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#maximumnoofthreads VmgroupV2#maximumnoofthreads}
        :param recoverytarget: recoverytarget block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#recoverytarget VmgroupV2#recoverytarget}
        :param schedule: schedule block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#schedule VmgroupV2#schedule}
        :param usesourcevmesxtomount: Use Source VM ESX To Mount. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usesourcevmesxtomount VmgroupV2#usesourcevmesxtomount}
        :param validatevmbackups: True if VM Backup validation is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#validatevmbackups VmgroupV2#validatevmbackups}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6bf4e5136aa57719489bc66009fb3ed18a4c1ed082aa0e892d1d8e2b6985dfb0)
            check_type(argname="argument copy", value=copy, expected_type=type_hints["copy"])
            check_type(argname="argument customvalidationscript", value=customvalidationscript, expected_type=type_hints["customvalidationscript"])
            check_type(argname="argument guestcredentials", value=guestcredentials, expected_type=type_hints["guestcredentials"])
            check_type(argname="argument keepvalidatedvmsrunning", value=keepvalidatedvmsrunning, expected_type=type_hints["keepvalidatedvmsrunning"])
            check_type(argname="argument maximumnoofthreads", value=maximumnoofthreads, expected_type=type_hints["maximumnoofthreads"])
            check_type(argname="argument recoverytarget", value=recoverytarget, expected_type=type_hints["recoverytarget"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument usesourcevmesxtomount", value=usesourcevmesxtomount, expected_type=type_hints["usesourcevmesxtomount"])
            check_type(argname="argument validatevmbackups", value=validatevmbackups, expected_type=type_hints["validatevmbackups"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if copy is not None:
            self._values["copy"] = copy
        if customvalidationscript is not None:
            self._values["customvalidationscript"] = customvalidationscript
        if guestcredentials is not None:
            self._values["guestcredentials"] = guestcredentials
        if keepvalidatedvmsrunning is not None:
            self._values["keepvalidatedvmsrunning"] = keepvalidatedvmsrunning
        if maximumnoofthreads is not None:
            self._values["maximumnoofthreads"] = maximumnoofthreads
        if recoverytarget is not None:
            self._values["recoverytarget"] = recoverytarget
        if schedule is not None:
            self._values["schedule"] = schedule
        if usesourcevmesxtomount is not None:
            self._values["usesourcevmesxtomount"] = usesourcevmesxtomount
        if validatevmbackups is not None:
            self._values["validatevmbackups"] = validatevmbackups

    @builtins.property
    def copy(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCopy"]]]:
        '''copy block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copy VmgroupV2#copy}
        '''
        result = self._values.get("copy")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCopy"]]], result)

    @builtins.property
    def customvalidationscript(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscript"]]]:
        '''customvalidationscript block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customvalidationscript VmgroupV2#customvalidationscript}
        '''
        result = self._values.get("customvalidationscript")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscript"]]], result)

    @builtins.property
    def guestcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentials"]]]:
        '''guestcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
        '''
        result = self._values.get("guestcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentials"]]], result)

    @builtins.property
    def keepvalidatedvmsrunning(self) -> typing.Optional[builtins.str]:
        '''If true then validated VMs will be available until expiration time set on the recovery target.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#keepvalidatedvmsrunning VmgroupV2#keepvalidatedvmsrunning}
        '''
        result = self._values.get("keepvalidatedvmsrunning")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def maximumnoofthreads(self) -> typing.Optional[jsii.Number]:
        '''Number of backup Validation Threads.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#maximumnoofthreads VmgroupV2#maximumnoofthreads}
        '''
        result = self._values.get("maximumnoofthreads")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def recoverytarget(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationRecoverytarget"]]]:
        '''recoverytarget block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#recoverytarget VmgroupV2#recoverytarget}
        '''
        result = self._values.get("recoverytarget")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationRecoverytarget"]]], result)

    @builtins.property
    def schedule(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationSchedule"]]]:
        '''schedule block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#schedule VmgroupV2#schedule}
        '''
        result = self._values.get("schedule")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationSchedule"]]], result)

    @builtins.property
    def usesourcevmesxtomount(self) -> typing.Optional[builtins.str]:
        '''Use Source VM ESX To Mount.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usesourcevmesxtomount VmgroupV2#usesourcevmesxtomount}
        '''
        result = self._values.get("usesourcevmesxtomount")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def validatevmbackups(self) -> typing.Optional[builtins.str]:
        '''True if VM Backup validation is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#validatevmbackups VmgroupV2#validatevmbackups}
        '''
        result = self._values.get("validatevmbackups")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Applicationvalidation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopy",
    jsii_struct_bases=[],
    name_mapping={
        "backupdestination": "backupdestination",
        "copyprecedence": "copyprecedence",
        "id": "id",
        "isactive": "isactive",
        "issnapcopy": "issnapcopy",
        "name": "name",
    },
)
class VmgroupV2ApplicationvalidationCopy:
    def __init__(
        self,
        *,
        backupdestination: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCopyBackupdestination", typing.Dict[builtins.str, typing.Any]]]]] = None,
        copyprecedence: typing.Optional[jsii.Number] = None,
        id: typing.Optional[jsii.Number] = None,
        isactive: typing.Optional[builtins.str] = None,
        issnapcopy: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param backupdestination: backupdestination block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupdestination VmgroupV2#backupdestination}
        :param copyprecedence: Order of backup destinaion copy created in storage policy. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copyprecedence VmgroupV2#copyprecedence}
        :param id: Id of the source copy. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id} Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param isactive: Is this an active backup destination? Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isactive VmgroupV2#isactive}
        :param issnapcopy: Is this a snap copy? Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#issnapcopy VmgroupV2#issnapcopy}
        :param name: Name of the source copy. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__930e5e983884841a61c747482da5acccbb03a985b33058051b3e9c063e507bc8)
            check_type(argname="argument backupdestination", value=backupdestination, expected_type=type_hints["backupdestination"])
            check_type(argname="argument copyprecedence", value=copyprecedence, expected_type=type_hints["copyprecedence"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument isactive", value=isactive, expected_type=type_hints["isactive"])
            check_type(argname="argument issnapcopy", value=issnapcopy, expected_type=type_hints["issnapcopy"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if backupdestination is not None:
            self._values["backupdestination"] = backupdestination
        if copyprecedence is not None:
            self._values["copyprecedence"] = copyprecedence
        if id is not None:
            self._values["id"] = id
        if isactive is not None:
            self._values["isactive"] = isactive
        if issnapcopy is not None:
            self._values["issnapcopy"] = issnapcopy
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def backupdestination(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCopyBackupdestination"]]]:
        '''backupdestination block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupdestination VmgroupV2#backupdestination}
        '''
        result = self._values.get("backupdestination")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCopyBackupdestination"]]], result)

    @builtins.property
    def copyprecedence(self) -> typing.Optional[jsii.Number]:
        '''Order of backup destinaion copy created in storage policy.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#copyprecedence VmgroupV2#copyprecedence}
        '''
        result = self._values.get("copyprecedence")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Id of the source copy.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def isactive(self) -> typing.Optional[builtins.str]:
        '''Is this an active backup destination?

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isactive VmgroupV2#isactive}
        '''
        result = self._values.get("isactive")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def issnapcopy(self) -> typing.Optional[builtins.str]:
        '''Is this a snap copy?

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#issnapcopy VmgroupV2#issnapcopy}
        '''
        result = self._values.get("issnapcopy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the source copy.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCopy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopyBackupdestination",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ApplicationvalidationCopyBackupdestination:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5dea769a7a349977fb8a4e6e7b6be9305664fe955b5a024aa08ca2563f59034)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCopyBackupdestination(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCopyBackupdestinationList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopyBackupdestinationList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a668699b2c97b9f23f2d367b75fe508009ad49f622a20475179f527084204c2)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce95cd9bf15cc8d93da0138d82115705950b33744b4c99399199940407ab5289)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d272cd5e1de081ab3d4502df599d1b486d559f3b43cbe4b107e303467af6b609)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1389573e4e20ee235063fac29ddae1fad183ee368f05f7f5713ea55e2cbbd203)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f97ae072829d63e3bfc02a0cd7ec843006cebb35fba44882d7aac654b396929)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a17e9b9248c07ba4b67599312cbcab6e84292c248542e63373af3df6f809093)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__193d65bd977027d750cf60cbbadaab61ad31b3d1ad01e264c87a5c5630089526)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff33eee369f8f437fd50ed7a14023299b40395430bae63b203c9a23b03f167c9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2035aaa5817e3710c4eb488e567ba1e042a8e15d1c5915675f882455784e854)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopyBackupdestination]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopyBackupdestination]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopyBackupdestination]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ebbcf9ac82f10cea012d68e9b7cf33f38c862a1bf4fc28a075c1816110e0452)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCopyList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopyList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__053abbc0b31aadd032e6114510e00cffea3bbfc08fd8015213013331b251ea7e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCopyOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55d1ce347987a3eaa87d6be85fe6a94fa9e28cfdf1717d50e4cb0ad8d97f79b7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCopyOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89d6f0f6e463a20e0271836890e50fa278c55c8f5c58fe19d89e0c89fee2a8c7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f172ddc22b165cfce0b2d06415fb1943916bb1560ec668fcca257addf2121813)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08724de511918da24ce931ca7b63aa1bd72f2ea2e3a1976a7ed589dc39c8c8e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d256239863fb4628e4ab8c42766c560aa0846fbb369713180e4a19a953c6588a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCopyOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCopyOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35ae19a32f4afb07bc18c1ee48606257355d545072cff4cc3fa3f5aa9833cf88)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putBackupdestination")
    def put_backupdestination(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCopyBackupdestination, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f032515622d7d3048b235306bf99eb5e4f2728af034e5a98722fe411af97e3ef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putBackupdestination", [value]))

    @jsii.member(jsii_name="resetBackupdestination")
    def reset_backupdestination(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBackupdestination", []))

    @jsii.member(jsii_name="resetCopyprecedence")
    def reset_copyprecedence(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCopyprecedence", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetIsactive")
    def reset_isactive(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsactive", []))

    @jsii.member(jsii_name="resetIssnapcopy")
    def reset_issnapcopy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIssnapcopy", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="backupdestination")
    def backupdestination(
        self,
    ) -> VmgroupV2ApplicationvalidationCopyBackupdestinationList:
        return typing.cast(VmgroupV2ApplicationvalidationCopyBackupdestinationList, jsii.get(self, "backupdestination"))

    @builtins.property
    @jsii.member(jsii_name="backupdestinationInput")
    def backupdestination_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]], jsii.get(self, "backupdestinationInput"))

    @builtins.property
    @jsii.member(jsii_name="copyprecedenceInput")
    def copyprecedence_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "copyprecedenceInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="isactiveInput")
    def isactive_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isactiveInput"))

    @builtins.property
    @jsii.member(jsii_name="issnapcopyInput")
    def issnapcopy_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "issnapcopyInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="copyprecedence")
    def copyprecedence(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "copyprecedence"))

    @copyprecedence.setter
    def copyprecedence(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a8a79dc0453729423f1d8fb8a91ef22c111581fe975b187e10c42ab7ba28ed5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "copyprecedence", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cbc38a91ccd28e6da6a4e167f975b8541fa369e3fb6e80579f00511f5129a45)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="isactive")
    def isactive(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isactive"))

    @isactive.setter
    def isactive(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a8754f3476988c97a0e93093041647222ec7ce57598e4853083bc893a828a53)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isactive", value)

    @builtins.property
    @jsii.member(jsii_name="issnapcopy")
    def issnapcopy(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "issnapcopy"))

    @issnapcopy.setter
    def issnapcopy(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__810296af587521740c69a0825d748d24148aac99744ef479c5ee04c6c730d772)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "issnapcopy", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3703cf63d80347f45ad2e2122673635b818720c6cbc187c145f5e5f3b542faa3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopy]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopy]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopy]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dea9d343e705df1d66e943534b67bacac6f3022b0c25f01e5755847e0961ed0e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscript",
    jsii_struct_bases=[],
    name_mapping={"unix": "unix", "windows": "windows"},
)
class VmgroupV2ApplicationvalidationCustomvalidationscript:
    def __init__(
        self,
        *,
        unix: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix", typing.Dict[builtins.str, typing.Any]]]]] = None,
        windows: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param unix: unix block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unix VmgroupV2#unix}
        :param windows: windows block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#windows VmgroupV2#windows}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__385057b0ff462dc2e6af2aad5b46b20ef1f4df72b1ac585a82cd6ca38c7f3d07)
            check_type(argname="argument unix", value=unix, expected_type=type_hints["unix"])
            check_type(argname="argument windows", value=windows, expected_type=type_hints["windows"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if unix is not None:
            self._values["unix"] = unix
        if windows is not None:
            self._values["windows"] = windows

    @builtins.property
    def unix(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix"]]]:
        '''unix block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unix VmgroupV2#unix}
        '''
        result = self._values.get("unix")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix"]]], result)

    @builtins.property
    def windows(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows"]]]:
        '''windows block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#windows VmgroupV2#windows}
        '''
        result = self._values.get("windows")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscript(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b37f13369fc59a3910df08158dc7a08c14acefdcc84f31de3877b385c82c7195)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__802bfde0a072973629de20aab518461ffaee5833b2dcef9234467bbd1028ca9f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c90309b71aef52f265dbf0807de60284262ec924b476862d0031b74384abb01)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eab90ca52e5c6f1db25c23c10fd1957664bb1cc7c1603c19cb4c0c9bc1eb1b38)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dca06422ed0b67d1a39c628c7e23f0c6c1881a2c6c8ace9724c5933a13142a6d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e228a03065ad57db4fd0632ed2bd53c00b1cbedc4ee70e529ab18da72858cf61)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5da4e504edc519329eb7437211535836cd06cd57be26b75128e550a7fd2bd0a9)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putUnix")
    def put_unix(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29133e2ab6a2648dd5695acbee4206c9017be1044e35b5cb3a74dfe86a9e039a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUnix", [value]))

    @jsii.member(jsii_name="putWindows")
    def put_windows(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c47a4caff06b3ffef978ce24e2a08176c77dc5d07e635a6e72fd27b8ad6bcbd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putWindows", [value]))

    @jsii.member(jsii_name="resetUnix")
    def reset_unix(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnix", []))

    @jsii.member(jsii_name="resetWindows")
    def reset_windows(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetWindows", []))

    @builtins.property
    @jsii.member(jsii_name="unix")
    def unix(self) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList", jsii.get(self, "unix"))

    @builtins.property
    @jsii.member(jsii_name="windows")
    def windows(
        self,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList", jsii.get(self, "windows"))

    @builtins.property
    @jsii.member(jsii_name="unixInput")
    def unix_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnix"]]], jsii.get(self, "unixInput"))

    @builtins.property
    @jsii.member(jsii_name="windowsInput")
    def windows_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindows"]]], jsii.get(self, "windowsInput"))

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscript]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscript]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscript]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ef61b115519403cb976a32e37b15d6f4747da7b67895cda955cf3d3680b2deb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnix",
    jsii_struct_bases=[],
    name_mapping={
        "arguments": "arguments",
        "isdisabled": "isdisabled",
        "islocal": "islocal",
        "path": "path",
        "unccredentials": "unccredentials",
        "uncsavedcredentials": "uncsavedcredentials",
    },
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptUnix:
    def __init__(
        self,
        *,
        arguments: typing.Optional[builtins.str] = None,
        isdisabled: typing.Optional[builtins.str] = None,
        islocal: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        unccredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        uncsavedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param arguments: Arguments for the script. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
        :param isdisabled: Is the script disabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
        :param islocal: True if the script is local. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
        :param path: Path for the validation script. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
        :param unccredentials: unccredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
        :param uncsavedcredentials: uncsavedcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89202063a62b46815d13d707c9ec936520ebd3dfeff8d580652901d795d1dafb)
            check_type(argname="argument arguments", value=arguments, expected_type=type_hints["arguments"])
            check_type(argname="argument isdisabled", value=isdisabled, expected_type=type_hints["isdisabled"])
            check_type(argname="argument islocal", value=islocal, expected_type=type_hints["islocal"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument unccredentials", value=unccredentials, expected_type=type_hints["unccredentials"])
            check_type(argname="argument uncsavedcredentials", value=uncsavedcredentials, expected_type=type_hints["uncsavedcredentials"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if arguments is not None:
            self._values["arguments"] = arguments
        if isdisabled is not None:
            self._values["isdisabled"] = isdisabled
        if islocal is not None:
            self._values["islocal"] = islocal
        if path is not None:
            self._values["path"] = path
        if unccredentials is not None:
            self._values["unccredentials"] = unccredentials
        if uncsavedcredentials is not None:
            self._values["uncsavedcredentials"] = uncsavedcredentials

    @builtins.property
    def arguments(self) -> typing.Optional[builtins.str]:
        '''Arguments for the script.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
        '''
        result = self._values.get("arguments")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def isdisabled(self) -> typing.Optional[builtins.str]:
        '''Is the script disabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
        '''
        result = self._values.get("isdisabled")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def islocal(self) -> typing.Optional[builtins.str]:
        '''True if the script is local.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
        '''
        result = self._values.get("islocal")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path for the validation script.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unccredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials"]]]:
        '''unccredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
        '''
        result = self._values.get("unccredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials"]]], result)

    @builtins.property
    def uncsavedcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials"]]]:
        '''uncsavedcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
        '''
        result = self._values.get("uncsavedcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptUnix(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f08a19aa41dd86f74cb890d1fdbd1031afcb4726a19436d0096c96ddfabfb3c4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66e4fac5247903925e24d4a74557f3f008939737edf1bbbca81c5f8c26ffb411)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2111a0c08ee71d382b40cd35d3252ea13b9cf3a8f9a5e45e7b8ed16107859f04)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13250446a81f596acffdb18c646ae8364bd6c9b7a17bea549957fdc9fd0603c1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c489afcb1d86a5604a0932fcb97097133845fa746dcac7f8a40aee5a68fa9c7d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0c4bc2a632fb0cd0b323f7a99d32dd783847b58bdc0215fe10a833b54b47fbf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d2b81569372b017486559be44893992a0b3312a8c20a936e0ccaae722da1dad)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putUnccredentials")
    def put_unccredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c124703573888e31dc0cecc8b0f187bea444b02b3c3761e697d6fe71099876e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUnccredentials", [value]))

    @jsii.member(jsii_name="putUncsavedcredentials")
    def put_uncsavedcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c12cb27ca4f7665784fad05c51fa0ae51f22819830b74ba249236e63eb301da1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUncsavedcredentials", [value]))

    @jsii.member(jsii_name="resetArguments")
    def reset_arguments(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetArguments", []))

    @jsii.member(jsii_name="resetIsdisabled")
    def reset_isdisabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsdisabled", []))

    @jsii.member(jsii_name="resetIslocal")
    def reset_islocal(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIslocal", []))

    @jsii.member(jsii_name="resetPath")
    def reset_path(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPath", []))

    @jsii.member(jsii_name="resetUnccredentials")
    def reset_unccredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnccredentials", []))

    @jsii.member(jsii_name="resetUncsavedcredentials")
    def reset_uncsavedcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUncsavedcredentials", []))

    @builtins.property
    @jsii.member(jsii_name="unccredentials")
    def unccredentials(
        self,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList", jsii.get(self, "unccredentials"))

    @builtins.property
    @jsii.member(jsii_name="uncsavedcredentials")
    def uncsavedcredentials(
        self,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList", jsii.get(self, "uncsavedcredentials"))

    @builtins.property
    @jsii.member(jsii_name="argumentsInput")
    def arguments_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "argumentsInput"))

    @builtins.property
    @jsii.member(jsii_name="isdisabledInput")
    def isdisabled_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isdisabledInput"))

    @builtins.property
    @jsii.member(jsii_name="islocalInput")
    def islocal_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "islocalInput"))

    @builtins.property
    @jsii.member(jsii_name="pathInput")
    def path_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "pathInput"))

    @builtins.property
    @jsii.member(jsii_name="unccredentialsInput")
    def unccredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials"]]], jsii.get(self, "unccredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="uncsavedcredentialsInput")
    def uncsavedcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials"]]], jsii.get(self, "uncsavedcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="arguments")
    def arguments(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "arguments"))

    @arguments.setter
    def arguments(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f94ff8c14e0a9bdbf5c4791cbcbc82b67b1df06b0c094072e33471ba66f94cdb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "arguments", value)

    @builtins.property
    @jsii.member(jsii_name="isdisabled")
    def isdisabled(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isdisabled"))

    @isdisabled.setter
    def isdisabled(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7268169ea03d378ad9441c8363e600773462b1cf8e8d8322d3e54b0a7c20860)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isdisabled", value)

    @builtins.property
    @jsii.member(jsii_name="islocal")
    def islocal(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "islocal"))

    @islocal.setter
    def islocal(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9eb89f8959280db008bf4cb63a7c3ec022a481f043a944ddb1ca35d12ae326e1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "islocal", value)

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "path"))

    @path.setter
    def path(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__daf4475cbf993fe99a80e5c8bbe89d3bdd1005783371e32fca15d59883923f7a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "path", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eff9c76a22e3085ec2381d6e1e77be4d80aff3e4c344d71d598441d7e556ac07)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__221ee345476b952bf573bd8094a2f548e9d77961be6e2b9f378b10b3c2aa2039)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3205f5bef6b3c8982731f2168b84e02fa1c236a4162f2a1726b19d9dd5ccf41e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5abaa008d8c6b5bced0286561297126b8350346c24772ffe5ec338112d1f34aa)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08ef1107c0e291382c8542b629160dc412a1f6f6bd36fbe8b4fa2f17ee1b2948)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8964e73186fba499e3d10baa760239b4809092e5b5f4b164a32bd2efb4713a35)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bde72c5e962b85ddab253770e6a13a5490a65110d51405faa1c5e3aed53313b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b976a2ebf55d23b1d7f165c294c47b68b17b6c0678e07e13b77c2e7c0d99955b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__899b440a2b096f850d18f71d0bff4c5c7ceb2bcf52d3a5bbffa978d3d9de1bfb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fd28f04c55ea44d9610adb9369fd94bfd55f387c37c19b2caf8050298165cdd9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04a6ee2d5aa9c8be93d68f592e078ca4d7df2b14a8e5318c54ad0fa036f5da12)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__761e1adceeca525305a0782ac1f98200a001ff37cf5cc58fde0f02e7e4b559be)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b1847127258c3dbe78edca64be4f1bbdcce86a43d786513ada49d8d54c62a94)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ebfb9d0c0e04f0b9782ca5822a8ec36c9a199f171e5b9ebeb44c763463079a6a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f3c82e828f474e52cbc57f503d1b56a68ce78f301259eedf74290786697850ee)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e8b33e07b6c2abcc7c52609ec40c7389f78bb9e09ffceeea07f2fcee342a0f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ee1237fb77abb811a70f2a5a1581cb46f87a66c1494af340d20c73532b3422c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ee7dc2ac74389ab1698ab0683547682354176e3727503b8c5483eeaf5e9364e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cea1046a49ea2be3b19509c8a59d23d57dbe699ccfad3ef18ecac26f39d54efc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1fd548c9b59f53995c28eca7a4dad69d9d4787b2fd18341b281e56d20a5898af)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e098e99778249d27f3bca3f288b16259e6e3b04333c177156779bcbf8fd63507)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfec73ef813b6307efddc9efc65bb9cccf53415f4dd0775a25e366cd5c806772)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__283118b48269f2b64871ac830e4021027521c6cc0001d62af401020e645bb975)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindows",
    jsii_struct_bases=[],
    name_mapping={
        "arguments": "arguments",
        "isdisabled": "isdisabled",
        "islocal": "islocal",
        "path": "path",
        "unccredentials": "unccredentials",
        "uncsavedcredentials": "uncsavedcredentials",
    },
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptWindows:
    def __init__(
        self,
        *,
        arguments: typing.Optional[builtins.str] = None,
        isdisabled: typing.Optional[builtins.str] = None,
        islocal: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        unccredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        uncsavedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param arguments: Arguments for the script. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
        :param isdisabled: Is the script disabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
        :param islocal: True if the script is local. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
        :param path: Path for the validation script. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
        :param unccredentials: unccredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
        :param uncsavedcredentials: uncsavedcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7bafba6c0a79cdf5fb8d6e2220882f289e72c0bf7a4a0a72c6a9c0765b973355)
            check_type(argname="argument arguments", value=arguments, expected_type=type_hints["arguments"])
            check_type(argname="argument isdisabled", value=isdisabled, expected_type=type_hints["isdisabled"])
            check_type(argname="argument islocal", value=islocal, expected_type=type_hints["islocal"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument unccredentials", value=unccredentials, expected_type=type_hints["unccredentials"])
            check_type(argname="argument uncsavedcredentials", value=uncsavedcredentials, expected_type=type_hints["uncsavedcredentials"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if arguments is not None:
            self._values["arguments"] = arguments
        if isdisabled is not None:
            self._values["isdisabled"] = isdisabled
        if islocal is not None:
            self._values["islocal"] = islocal
        if path is not None:
            self._values["path"] = path
        if unccredentials is not None:
            self._values["unccredentials"] = unccredentials
        if uncsavedcredentials is not None:
            self._values["uncsavedcredentials"] = uncsavedcredentials

    @builtins.property
    def arguments(self) -> typing.Optional[builtins.str]:
        '''Arguments for the script.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#arguments VmgroupV2#arguments}
        '''
        result = self._values.get("arguments")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def isdisabled(self) -> typing.Optional[builtins.str]:
        '''Is the script disabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isdisabled VmgroupV2#isdisabled}
        '''
        result = self._values.get("isdisabled")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def islocal(self) -> typing.Optional[builtins.str]:
        '''True if the script is local.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#islocal VmgroupV2#islocal}
        '''
        result = self._values.get("islocal")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path for the validation script.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#path VmgroupV2#path}
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unccredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials"]]]:
        '''unccredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#unccredentials VmgroupV2#unccredentials}
        '''
        result = self._values.get("unccredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials"]]], result)

    @builtins.property
    def uncsavedcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials"]]]:
        '''uncsavedcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#uncsavedcredentials VmgroupV2#uncsavedcredentials}
        '''
        result = self._values.get("uncsavedcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptWindows(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46d3b9febdf3b3d3026a91b440d10d6e26e424f57d19997378326634190bbe7e)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d8fe9c7e9cea13e31856c05efcaf1806b5c9a9fe7a24c364168da270a670bac)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a78eeea48187750a05084392460cc3626177df2733bd84c0b63cb01a8d299aef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__407005c725a9546bd442a8f266459435334637953e91971d2fc7697b83634054)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b6f67b2920ffcf5c73e863d2e1e20f4dfb2a85602f5d3ff2efc929b40c430c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55d9b3fe76a347e23777fab0cf4d60fcd392d10ee918be5eafaa461483a21c49)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aed6574dfe264a873384a0fe9216786c52cd1efa973afbc177a85b780f41d196)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putUnccredentials")
    def put_unccredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c02255694e1ea8eb3ee5f097d41b2598149036ca7c1a14b322934feee188c46)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUnccredentials", [value]))

    @jsii.member(jsii_name="putUncsavedcredentials")
    def put_uncsavedcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ea73f128fe2292dc614eebf50b823790e7e2875bc597a386eb92cca44060ceb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUncsavedcredentials", [value]))

    @jsii.member(jsii_name="resetArguments")
    def reset_arguments(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetArguments", []))

    @jsii.member(jsii_name="resetIsdisabled")
    def reset_isdisabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsdisabled", []))

    @jsii.member(jsii_name="resetIslocal")
    def reset_islocal(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIslocal", []))

    @jsii.member(jsii_name="resetPath")
    def reset_path(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPath", []))

    @jsii.member(jsii_name="resetUnccredentials")
    def reset_unccredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUnccredentials", []))

    @jsii.member(jsii_name="resetUncsavedcredentials")
    def reset_uncsavedcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUncsavedcredentials", []))

    @builtins.property
    @jsii.member(jsii_name="unccredentials")
    def unccredentials(
        self,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList", jsii.get(self, "unccredentials"))

    @builtins.property
    @jsii.member(jsii_name="uncsavedcredentials")
    def uncsavedcredentials(
        self,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList":
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList", jsii.get(self, "uncsavedcredentials"))

    @builtins.property
    @jsii.member(jsii_name="argumentsInput")
    def arguments_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "argumentsInput"))

    @builtins.property
    @jsii.member(jsii_name="isdisabledInput")
    def isdisabled_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isdisabledInput"))

    @builtins.property
    @jsii.member(jsii_name="islocalInput")
    def islocal_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "islocalInput"))

    @builtins.property
    @jsii.member(jsii_name="pathInput")
    def path_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "pathInput"))

    @builtins.property
    @jsii.member(jsii_name="unccredentialsInput")
    def unccredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials"]]], jsii.get(self, "unccredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="uncsavedcredentialsInput")
    def uncsavedcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials"]]], jsii.get(self, "uncsavedcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="arguments")
    def arguments(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "arguments"))

    @arguments.setter
    def arguments(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb37d0f8ba9d526e3511647eb9bf53a0d0f18c8e2ce3ade0c511b3e9b4737eac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "arguments", value)

    @builtins.property
    @jsii.member(jsii_name="isdisabled")
    def isdisabled(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isdisabled"))

    @isdisabled.setter
    def isdisabled(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__991985b802cd64321e7b976749f5a37247b27cffb8921e8f7f35b5280c9dee89)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isdisabled", value)

    @builtins.property
    @jsii.member(jsii_name="islocal")
    def islocal(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "islocal"))

    @islocal.setter
    def islocal(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__174cbfe0932f8a6376a034327590b075df1ab2c0bc48dfeae9d0c36a4dd552ae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "islocal", value)

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "path"))

    @path.setter
    def path(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24c545a6a32f873c43d48cf171d9063f9107038550761c36dd3fa936c433df18)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "path", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__248050dece5f9e4e4a066f7a7fd8ffc9ad2ae28bf5198c8691f4c4cc429415c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27c94298deb8caa0e0c4528d0643cab2b7ca8f457849661a84db629cbe00c609)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf8a23277538ad78fa1c2fcb6fbcbf4418d48b411bd27acbabe240eefa05d3af)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c5e9566b4c4a5816b08b4f1ef1cee7e958ca8809f0437953ef1174b1d575065)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edce0bc1325f6e642b4c6882adfd05dad72cc55bffb1a3b9d74b4a9da875dce7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__190c63ed9ee0a46606934de2f954e693a706221b8ea09bbebe98e2edd528d3a4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9e23b86a162f88e840ba66d36865ab840a10622e502453d463a9509c9592d66)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9011089a42c154ee2526037de8f9544f94b16e96df7362945acaeb8818cfd23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1672fd84a6161217dae27b8ac89683bf7604b5a5282bd444aa0a7b20dbe261a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d95ac517e6f0e575e8e903badc982eed751a77f65fa0d5a59f5c9eebb1f38dad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e61c2aac4d1e15c55276cfa574d1ce404bed8ea9db10177b9661a3fad43d3320)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__925de80774f647d10fdc3a4fcf0b9a67c99a6946070fe7eb89a9c214ca66cb9d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6483f22ed62c9dbb65743ef07259eb54baac01b2b3711ac27afa904e7dfed242)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ab27c30e6b5f616e135a9edaacd2f682f9568e33bee876f696c98b7efee1670)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__636d6cc2c4a70958cd63b228da271139e164d006a44c72f84a5642090f5d2984)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70a663344d96a4dcd967179f38126bb44daf01cf9bc2ea46fc006c660cbd87db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30bdf2003a2d3ca426b31c61dfb30e698b00054da37e57e9ae6ac7729a5e99a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b24b8e148f3eaa2095dd8823ee3583f40a792defa902ebe014e9e9bb1bb74b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96736f82e14d980a4c465e05ae97eb607c13ea1d78891df69757c2bc0898fe95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4844c339e322ed9e57e0fac53d325641734c5c6cae9fc4e846215e6ba891eec)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0f541fe9940a0c0880442d2e147ab0161d6c5b3ce9805e70b58be190cab6e33)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea6d112c1a010a8deeb4537ef86ec9763d8859218b31658f3920e4762b6a698b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__acd314c6c63f53122b6a4d04ae3023c465a29557a3ae69417dcfc91349a8fb5a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentials",
    jsii_struct_bases=[],
    name_mapping={
        "credentials": "credentials",
        "savedcredentials": "savedcredentials",
    },
)
class VmgroupV2ApplicationvalidationGuestcredentials:
    def __init__(
        self,
        *,
        credentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationGuestcredentialsCredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        savedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param credentials: credentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
        :param savedcredentials: savedcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3a66d223c7e04156da557d892f2385b4f26477e6af87dc18d4439700af6651a)
            check_type(argname="argument credentials", value=credentials, expected_type=type_hints["credentials"])
            check_type(argname="argument savedcredentials", value=savedcredentials, expected_type=type_hints["savedcredentials"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if credentials is not None:
            self._values["credentials"] = credentials
        if savedcredentials is not None:
            self._values["savedcredentials"] = savedcredentials

    @builtins.property
    def credentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsCredentials"]]]:
        '''credentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
        '''
        result = self._values.get("credentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsCredentials"]]], result)

    @builtins.property
    def savedcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials"]]]:
        '''savedcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
        '''
        result = self._values.get("savedcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationGuestcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsCredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2ApplicationvalidationGuestcredentialsCredentials:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf577e80807f5301301b25e1e6be54153de64ca34029ffee58305c5692909097)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationGuestcredentialsCredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29959a6eb8743ef473e02c4b9a2f150c64dd98d56d29f6e008655ef250827605)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5789c7e056b79d077b74ae58a54fe0f372fb650f8b803e062ae37438bdf31a6)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58d1ec05c0b65bdb236a6f8378f079b43b175207264cb7afacef66b930dd32a8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c3af8f42178b91c781a738bc6f8a1c4823ce98519bdf4e12f114e8acb88e5ac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__97abbf855ae304e46b73e37d26f3edab133d52af23a62e595453e6ee40343a83)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47662cfe22893691b0e0b88ad8f96032a10810c843031b2e54e58355bbc30eaf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__867ccc79a8c47ee0e0d2952939edb8a005cc01daed03dcdf8bbfc1e45bb5b105)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22bba30491f350fbc5bc83c80c0c2ba42ae53ddaed65bb40323ec9f9e296b861)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce4cf40092c432550150ad1c8eac7a8ced1023d055ba79f0d4cccf9ae03230dd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsCredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsCredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7feafde3027437416802c1e8d22cc4716a20f6741d1a1f99935e5ff13f3f98d3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationGuestcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b31a87cdce787b753d715d10d32baa37de85f2bd08041635e3e92f24a7ef8c08)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationGuestcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b537b8c355d23aaaaa7394b51b63911e9ac29d696b62b70845d244062557ad3f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationGuestcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbc3a71a6c50d58c80939e8b6595423596ec1685f4481d3c1797eb56ba84b167)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77d673b45e01a62c8435264f5b858b5772079ab1cce8aac5f551e48a1c06493a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c672dfc46ace9b378314b06fa722ee767ecc1c9e8ccc265beb30d5d9c654a89a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a79c9966542d397d0d1e4a8c8f044a4d2a94f4d7c5d6ccb8a80b1ddf415351e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationGuestcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f531b68e67531748895dffb9b19e422f916ba95651264e29e0e66d6d940b2233)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putCredentials")
    def put_credentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentialsCredentials, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d4d646e17411d5871ef7966a882cb1440766dd8ac7ee00cce739b653d3cff31)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCredentials", [value]))

    @jsii.member(jsii_name="putSavedcredentials")
    def put_savedcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fb7549a7dc9c9aa4a05267994f628e0a8511f06813ded03fd441dabdbe89767)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSavedcredentials", [value]))

    @jsii.member(jsii_name="resetCredentials")
    def reset_credentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCredentials", []))

    @jsii.member(jsii_name="resetSavedcredentials")
    def reset_savedcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSavedcredentials", []))

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(
        self,
    ) -> VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList:
        return typing.cast(VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList, jsii.get(self, "credentials"))

    @builtins.property
    @jsii.member(jsii_name="savedcredentials")
    def savedcredentials(
        self,
    ) -> "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList":
        return typing.cast("VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList", jsii.get(self, "savedcredentials"))

    @builtins.property
    @jsii.member(jsii_name="credentialsInput")
    def credentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]], jsii.get(self, "credentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="savedcredentialsInput")
    def savedcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials"]]], jsii.get(self, "savedcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__633cb8c6f5517711e41488a871d069a79c6035dd214d43201869097e32cba1a1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c9dc7684eb8b2091e93eedef85bf205ca8f49b7b19f9921058b812a804b1db1)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0256fbc1940aaa723dbef4ca86df8f3a7cd14fc014e33d42b4c0762ee7d0c2f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e44930b26a582c181314f14bdea8757417ad88c90c1d90ea1c01bbc27fa37f4d)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fa6f458b05c433d575e965d891b167968a7472a00cf357319d13bd389e7e36a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb29b01061d606c6c81a8fdfaf6fefb6139191c3e4d429a1569145395611e87f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59f12b0b650259b7998b72934667db3b6bd5a3562ba1ce08ff470ca0d690e85d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7e1f2257be65dfcdf8ea9819c28b00ec49454227cdfbaa987b344fb2f8468e4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66bc9e2400dbbe7f702799e6b8fffdd50e1473d69809e5b9124ed32147d79d9c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3333309f2e3c52a75f30d7e32803c04aa78f91275026e9ec97370ef1cdcb44b0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b672521be3bc887a54eb410b32a7bf51986a460975fa493f8f3da4d83c2aaa23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4dc00239cba54779e64e6ebe7e5f3687f2c36372bffff457b603895cc6979597)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69a2f57c0eba250b01979ae65de972f80790e08366c58cb0439f28c9ab216643)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__525ebabe5fb3cef6f46d4de1a77e667e73eb6266026dfabf95f943f77e728b78)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4656b633eb91a2a04144a5129c21ec1759a6df82066d5db90a410ea6949c9e6f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d061ccd261aaa904480572f0113f69757831a276b9ab492fbb65b35948058d3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Applicationvalidation]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Applicationvalidation]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Applicationvalidation]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15f4603c426410e89f681b6fca4db2eec1057ab250d0a5990cc1d48cf0e67a46)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9087bd1d9e014ca91f40b652ad2bfa77efc0e025466fc2b91300522a11e1e0a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putCopy")
    def put_copy(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCopy, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90c33c6ddcabd7f855147dcff466487eba41384bca7049b7cf5d056739e782de)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCopy", [value]))

    @jsii.member(jsii_name="putCustomvalidationscript")
    def put_customvalidationscript(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscript, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72e13e8130d61dae036f2a9dbf01b8471837daf83c95f1abb0edfedd28cf10c5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCustomvalidationscript", [value]))

    @jsii.member(jsii_name="putGuestcredentials")
    def put_guestcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentials, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3ba3e7f40e320e29f21eac2d37211ef83e8023cec820edee78acb8419cf7ed0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGuestcredentials", [value]))

    @jsii.member(jsii_name="putRecoverytarget")
    def put_recoverytarget(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationRecoverytarget", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1065e389a0df1e1216d13de3f73d02da8eb9b59b6709541223c9265d6e9b7771)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRecoverytarget", [value]))

    @jsii.member(jsii_name="putSchedule")
    def put_schedule(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ApplicationvalidationSchedule", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0ad25e01cc2046ae749f58870d332bb5286f8aa36b38a4830888bfeeaa8648b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSchedule", [value]))

    @jsii.member(jsii_name="resetCopy")
    def reset_copy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCopy", []))

    @jsii.member(jsii_name="resetCustomvalidationscript")
    def reset_customvalidationscript(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomvalidationscript", []))

    @jsii.member(jsii_name="resetGuestcredentials")
    def reset_guestcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGuestcredentials", []))

    @jsii.member(jsii_name="resetKeepvalidatedvmsrunning")
    def reset_keepvalidatedvmsrunning(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetKeepvalidatedvmsrunning", []))

    @jsii.member(jsii_name="resetMaximumnoofthreads")
    def reset_maximumnoofthreads(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMaximumnoofthreads", []))

    @jsii.member(jsii_name="resetRecoverytarget")
    def reset_recoverytarget(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRecoverytarget", []))

    @jsii.member(jsii_name="resetSchedule")
    def reset_schedule(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSchedule", []))

    @jsii.member(jsii_name="resetUsesourcevmesxtomount")
    def reset_usesourcevmesxtomount(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUsesourcevmesxtomount", []))

    @jsii.member(jsii_name="resetValidatevmbackups")
    def reset_validatevmbackups(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValidatevmbackups", []))

    @builtins.property
    @jsii.member(jsii_name="copy")
    def copy(self) -> VmgroupV2ApplicationvalidationCopyList:
        return typing.cast(VmgroupV2ApplicationvalidationCopyList, jsii.get(self, "copy"))

    @builtins.property
    @jsii.member(jsii_name="customvalidationscript")
    def customvalidationscript(
        self,
    ) -> VmgroupV2ApplicationvalidationCustomvalidationscriptList:
        return typing.cast(VmgroupV2ApplicationvalidationCustomvalidationscriptList, jsii.get(self, "customvalidationscript"))

    @builtins.property
    @jsii.member(jsii_name="guestcredentials")
    def guestcredentials(self) -> VmgroupV2ApplicationvalidationGuestcredentialsList:
        return typing.cast(VmgroupV2ApplicationvalidationGuestcredentialsList, jsii.get(self, "guestcredentials"))

    @builtins.property
    @jsii.member(jsii_name="recoverytarget")
    def recoverytarget(self) -> "VmgroupV2ApplicationvalidationRecoverytargetList":
        return typing.cast("VmgroupV2ApplicationvalidationRecoverytargetList", jsii.get(self, "recoverytarget"))

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> "VmgroupV2ApplicationvalidationScheduleList":
        return typing.cast("VmgroupV2ApplicationvalidationScheduleList", jsii.get(self, "schedule"))

    @builtins.property
    @jsii.member(jsii_name="copyInput")
    def copy_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]], jsii.get(self, "copyInput"))

    @builtins.property
    @jsii.member(jsii_name="customvalidationscriptInput")
    def customvalidationscript_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]], jsii.get(self, "customvalidationscriptInput"))

    @builtins.property
    @jsii.member(jsii_name="guestcredentialsInput")
    def guestcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]], jsii.get(self, "guestcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="keepvalidatedvmsrunningInput")
    def keepvalidatedvmsrunning_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "keepvalidatedvmsrunningInput"))

    @builtins.property
    @jsii.member(jsii_name="maximumnoofthreadsInput")
    def maximumnoofthreads_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "maximumnoofthreadsInput"))

    @builtins.property
    @jsii.member(jsii_name="recoverytargetInput")
    def recoverytarget_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationRecoverytarget"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationRecoverytarget"]]], jsii.get(self, "recoverytargetInput"))

    @builtins.property
    @jsii.member(jsii_name="scheduleInput")
    def schedule_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationSchedule"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ApplicationvalidationSchedule"]]], jsii.get(self, "scheduleInput"))

    @builtins.property
    @jsii.member(jsii_name="usesourcevmesxtomountInput")
    def usesourcevmesxtomount_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "usesourcevmesxtomountInput"))

    @builtins.property
    @jsii.member(jsii_name="validatevmbackupsInput")
    def validatevmbackups_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "validatevmbackupsInput"))

    @builtins.property
    @jsii.member(jsii_name="keepvalidatedvmsrunning")
    def keepvalidatedvmsrunning(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "keepvalidatedvmsrunning"))

    @keepvalidatedvmsrunning.setter
    def keepvalidatedvmsrunning(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b678c6cb4f0f1339edb5e1ae2855cbe6069a8e46bc21720724ba2aaedc229dc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "keepvalidatedvmsrunning", value)

    @builtins.property
    @jsii.member(jsii_name="maximumnoofthreads")
    def maximumnoofthreads(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "maximumnoofthreads"))

    @maximumnoofthreads.setter
    def maximumnoofthreads(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da31e4fcbd51c302501aeddf929212eccec1de7c393b452fa9c2ced9b812e2c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "maximumnoofthreads", value)

    @builtins.property
    @jsii.member(jsii_name="usesourcevmesxtomount")
    def usesourcevmesxtomount(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "usesourcevmesxtomount"))

    @usesourcevmesxtomount.setter
    def usesourcevmesxtomount(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86d32a6081366b12952c13b08ffb10614b1ae85f8fc74ff65dc3c4b701bcc089)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "usesourcevmesxtomount", value)

    @builtins.property
    @jsii.member(jsii_name="validatevmbackups")
    def validatevmbackups(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "validatevmbackups"))

    @validatevmbackups.setter
    def validatevmbackups(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a19ff01c49c79d75ee003186f1d77218f35c62784d5c0a45895b4b0d7775e36)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "validatevmbackups", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Applicationvalidation]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Applicationvalidation]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Applicationvalidation]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0db7086f3230628f6ef05b8fa92a9f412ae17d4a2106f3f9d462e98b287eda3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationRecoverytarget",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2ApplicationvalidationRecoverytarget:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c20dc7441bb5abb76919b5037d84af6eea0aea505620e41c91bbd3b15f46365)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationRecoverytarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationRecoverytargetList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationRecoverytargetList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf6a438d1db50cfc66690c3990e8ddb4a61574ac58f010eea2c6e3f723016608)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationRecoverytargetOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b61a00311777bf5bc238c9d989d84f3b762f39cfec17e3114e686a84e325bac9)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationRecoverytargetOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3e5a8cccd870603f523e553ce6e5fe32fe5892918c3e1a9433f3796fc8b7d2f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc1a5324bfacca8317a365e95e6747388415e4027a21d9f6a622d05b498538b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bf0bb6014d594f4a572764456a4357371438c59e938fb58ea02c40d404679e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationRecoverytarget]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationRecoverytarget]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationRecoverytarget]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc606e50a9bfa2dee3ad4109be95e6e00a9c1887cec20d958125d709aa0444be)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationRecoverytargetOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationRecoverytargetOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d55dc3a1483f11693935e6b1d194ae24d9a5595ed1fe09ecee66c703729605f6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ab0f4ffcbc6c1698a22c0ecc03c4921b221d6a97d72dc723d13a6c2f5973088)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf1e4b666bd92ef46cc86b5dc0375874a34170f0877f9ce19a805108e12e6b29)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationRecoverytarget]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationRecoverytarget]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationRecoverytarget]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76d5a28762c8a421c50a67ded87877a392568b0b21836c4d8911290a73f3b933)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationSchedule",
    jsii_struct_bases=[],
    name_mapping={
        "description": "description",
        "id": "id",
        "isscheduleenabled": "isscheduleenabled",
        "taskid": "taskid",
    },
)
class VmgroupV2ApplicationvalidationSchedule:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        id: typing.Optional[jsii.Number] = None,
        isscheduleenabled: typing.Optional[builtins.str] = None,
        taskid: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param description: Description for validation schedule. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#description VmgroupV2#description}
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param isscheduleenabled: True if application validation schedule is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isscheduleenabled VmgroupV2#isscheduleenabled}
        :param taskid: Job Id for the application validation task. 0 if schedule is disabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#taskid VmgroupV2#taskid}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03f81eb651b9e888049420f686b77019bc1e9e94dc60c372e71f285cf0be7782)
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument isscheduleenabled", value=isscheduleenabled, expected_type=type_hints["isscheduleenabled"])
            check_type(argname="argument taskid", value=taskid, expected_type=type_hints["taskid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if id is not None:
            self._values["id"] = id
        if isscheduleenabled is not None:
            self._values["isscheduleenabled"] = isscheduleenabled
        if taskid is not None:
            self._values["taskid"] = taskid

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''Description for validation schedule.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#description VmgroupV2#description}
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def isscheduleenabled(self) -> typing.Optional[builtins.str]:
        '''True if application validation schedule is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isscheduleenabled VmgroupV2#isscheduleenabled}
        '''
        result = self._values.get("isscheduleenabled")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def taskid(self) -> typing.Optional[jsii.Number]:
        '''Job Id for the application validation task. 0 if schedule is disabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#taskid VmgroupV2#taskid}
        '''
        result = self._values.get("taskid")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ApplicationvalidationSchedule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ApplicationvalidationScheduleList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationScheduleList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e58a2d1ff0c28b8b600f05429382dae7aa303ff2c437ba7ff381b8ece02b5c1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ApplicationvalidationScheduleOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d1acec60ee942e692d174bbf17b05ed93f07095b73776722b9c1a5cb203da2f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ApplicationvalidationScheduleOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__279dc8a96e3cfe53a47c47ddcf9c1f3e501813904927dfac73adc9bb80f720a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24f00858a334f652fe3b0ff1aa1058cf3d79e56c6a4beb83c2f2ed166f4a55ba)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a56f0c5b0063abadd46d65d3253be5c895e6d133c11ffed225f9c6660af7d19a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationSchedule]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationSchedule]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationSchedule]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb1c451c034c32c06fe0b524dec2de5a267799688794e35d000c991589c167b3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ApplicationvalidationScheduleOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ApplicationvalidationScheduleOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78bb77041f4da76c557c448694efb85d5b35def7f0f50977bae26a3b9ba9d52b)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDescription", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetIsscheduleenabled")
    def reset_isscheduleenabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsscheduleenabled", []))

    @jsii.member(jsii_name="resetTaskid")
    def reset_taskid(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTaskid", []))

    @builtins.property
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "descriptionInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="isscheduleenabledInput")
    def isscheduleenabled_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isscheduleenabledInput"))

    @builtins.property
    @jsii.member(jsii_name="taskidInput")
    def taskid_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "taskidInput"))

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "description"))

    @description.setter
    def description(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed5cc68b210a3dc1a63d618f7bee877f0401c63ba1e16a189186aee7084b1c5b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb84be073818b2be783d2f912fadf6533cf6d3da815b6e75cd1cd2f4ba8d9a89)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="isscheduleenabled")
    def isscheduleenabled(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isscheduleenabled"))

    @isscheduleenabled.setter
    def isscheduleenabled(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e89c9f841a3d712026e3c2899df072eb837d03d2d39c552781c9987a6adc56f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isscheduleenabled", value)

    @builtins.property
    @jsii.member(jsii_name="taskid")
    def taskid(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "taskid"))

    @taskid.setter
    def taskid(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4951f632ed2cb7725b29c029f0310dd77febd3f21379078ed3b60acdfb436da3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "taskid", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationSchedule]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationSchedule]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationSchedule]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__358adfe780de0787ded93841b46649ec7ccc819708e0009b6a66306d9861cd90)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Config",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "content": "content",
        "hypervisor": "hypervisor",
        "name": "name",
        "plan": "plan",
        "accessnode": "accessnode",
        "activitycontrol": "activitycontrol",
        "applicationvalidation": "applicationvalidation",
        "diskfilters": "diskfilters",
        "enablefileindexing": "enablefileindexing",
        "filters": "filters",
        "id": "id",
        "meditech": "meditech",
        "meditechsystems": "meditechsystems",
        "securityassociations": "securityassociations",
        "settings": "settings",
        "snapshotmanagement": "snapshotmanagement",
        "storage": "storage",
        "timezone": "timezone",
    },
)
class VmgroupV2Config(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, _cdktf_9a9027ec.TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        content: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Content", typing.Dict[builtins.str, typing.Any]]]],
        hypervisor: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Hypervisor", typing.Dict[builtins.str, typing.Any]]]],
        name: builtins.str,
        plan: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Plan", typing.Dict[builtins.str, typing.Any]]]],
        accessnode: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Accessnode, typing.Dict[builtins.str, typing.Any]]]]] = None,
        activitycontrol: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Activitycontrol, typing.Dict[builtins.str, typing.Any]]]]] = None,
        applicationvalidation: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Applicationvalidation, typing.Dict[builtins.str, typing.Any]]]]] = None,
        diskfilters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Diskfilters", typing.Dict[builtins.str, typing.Any]]]]] = None,
        enablefileindexing: typing.Optional[builtins.str] = None,
        filters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Filters", typing.Dict[builtins.str, typing.Any]]]]] = None,
        id: typing.Optional[builtins.str] = None,
        meditech: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditech", typing.Dict[builtins.str, typing.Any]]]]] = None,
        meditechsystems: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Meditechsystems", typing.Dict[builtins.str, typing.Any]]]]] = None,
        securityassociations: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Securityassociations", typing.Dict[builtins.str, typing.Any]]]]] = None,
        settings: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Settings", typing.Dict[builtins.str, typing.Any]]]]] = None,
        snapshotmanagement: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Snapshotmanagement", typing.Dict[builtins.str, typing.Any]]]]] = None,
        storage: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Storage", typing.Dict[builtins.str, typing.Any]]]]] = None,
        timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2Timezone", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param content: content block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#content VmgroupV2#content}
        :param hypervisor: hypervisor block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#hypervisor VmgroupV2#hypervisor}
        :param name: subclient name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param plan: plan block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#plan VmgroupV2#plan}
        :param accessnode: accessnode block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#accessnode VmgroupV2#accessnode}
        :param activitycontrol: activitycontrol block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitycontrol VmgroupV2#activitycontrol}
        :param applicationvalidation: applicationvalidation block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#applicationvalidation VmgroupV2#applicationvalidation}
        :param diskfilters: diskfilters block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#diskfilters VmgroupV2#diskfilters}
        :param enablefileindexing: True if file indexing needs to be enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablefileindexing VmgroupV2#enablefileindexing}
        :param filters: filters block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filters VmgroupV2#filters}
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param meditech: meditech block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditech VmgroupV2#meditech}
        :param meditechsystems: meditechsystems block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditechsystems VmgroupV2#meditechsystems}
        :param securityassociations: securityassociations block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#securityassociations VmgroupV2#securityassociations}
        :param settings: settings block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#settings VmgroupV2#settings}
        :param snapshotmanagement: snapshotmanagement block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapshotmanagement VmgroupV2#snapshotmanagement}
        :param storage: storage block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#storage VmgroupV2#storage}
        :param timezone: timezone block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a33ab84f055c7a61b511bb955b7b3cb0fdd3e2c746cf335360c4a87a197289b4)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument content", value=content, expected_type=type_hints["content"])
            check_type(argname="argument hypervisor", value=hypervisor, expected_type=type_hints["hypervisor"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument plan", value=plan, expected_type=type_hints["plan"])
            check_type(argname="argument accessnode", value=accessnode, expected_type=type_hints["accessnode"])
            check_type(argname="argument activitycontrol", value=activitycontrol, expected_type=type_hints["activitycontrol"])
            check_type(argname="argument applicationvalidation", value=applicationvalidation, expected_type=type_hints["applicationvalidation"])
            check_type(argname="argument diskfilters", value=diskfilters, expected_type=type_hints["diskfilters"])
            check_type(argname="argument enablefileindexing", value=enablefileindexing, expected_type=type_hints["enablefileindexing"])
            check_type(argname="argument filters", value=filters, expected_type=type_hints["filters"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument meditech", value=meditech, expected_type=type_hints["meditech"])
            check_type(argname="argument meditechsystems", value=meditechsystems, expected_type=type_hints["meditechsystems"])
            check_type(argname="argument securityassociations", value=securityassociations, expected_type=type_hints["securityassociations"])
            check_type(argname="argument settings", value=settings, expected_type=type_hints["settings"])
            check_type(argname="argument snapshotmanagement", value=snapshotmanagement, expected_type=type_hints["snapshotmanagement"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument timezone", value=timezone, expected_type=type_hints["timezone"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "content": content,
            "hypervisor": hypervisor,
            "name": name,
            "plan": plan,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if accessnode is not None:
            self._values["accessnode"] = accessnode
        if activitycontrol is not None:
            self._values["activitycontrol"] = activitycontrol
        if applicationvalidation is not None:
            self._values["applicationvalidation"] = applicationvalidation
        if diskfilters is not None:
            self._values["diskfilters"] = diskfilters
        if enablefileindexing is not None:
            self._values["enablefileindexing"] = enablefileindexing
        if filters is not None:
            self._values["filters"] = filters
        if id is not None:
            self._values["id"] = id
        if meditech is not None:
            self._values["meditech"] = meditech
        if meditechsystems is not None:
            self._values["meditechsystems"] = meditechsystems
        if securityassociations is not None:
            self._values["securityassociations"] = securityassociations
        if settings is not None:
            self._values["settings"] = settings
        if snapshotmanagement is not None:
            self._values["snapshotmanagement"] = snapshotmanagement
        if storage is not None:
            self._values["storage"] = storage
        if timezone is not None:
            self._values["timezone"] = timezone

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(
        self,
    ) -> typing.Optional[typing.Union[jsii.Number, _cdktf_9a9027ec.TerraformCount]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[typing.Union[jsii.Number, _cdktf_9a9027ec.TerraformCount]], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def content(
        self,
    ) -> typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Content"]]:
        '''content block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#content VmgroupV2#content}
        '''
        result = self._values.get("content")
        assert result is not None, "Required property 'content' is missing"
        return typing.cast(typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Content"]], result)

    @builtins.property
    def hypervisor(
        self,
    ) -> typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Hypervisor"]]:
        '''hypervisor block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#hypervisor VmgroupV2#hypervisor}
        '''
        result = self._values.get("hypervisor")
        assert result is not None, "Required property 'hypervisor' is missing"
        return typing.cast(typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Hypervisor"]], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''subclient name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def plan(
        self,
    ) -> typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Plan"]]:
        '''plan block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#plan VmgroupV2#plan}
        '''
        result = self._values.get("plan")
        assert result is not None, "Required property 'plan' is missing"
        return typing.cast(typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Plan"]], result)

    @builtins.property
    def accessnode(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]]:
        '''accessnode block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#accessnode VmgroupV2#accessnode}
        '''
        result = self._values.get("accessnode")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]], result)

    @builtins.property
    def activitycontrol(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]]:
        '''activitycontrol block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#activitycontrol VmgroupV2#activitycontrol}
        '''
        result = self._values.get("activitycontrol")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]], result)

    @builtins.property
    def applicationvalidation(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Applicationvalidation]]]:
        '''applicationvalidation block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#applicationvalidation VmgroupV2#applicationvalidation}
        '''
        result = self._values.get("applicationvalidation")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Applicationvalidation]]], result)

    @builtins.property
    def diskfilters(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Diskfilters"]]]:
        '''diskfilters block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#diskfilters VmgroupV2#diskfilters}
        '''
        result = self._values.get("diskfilters")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Diskfilters"]]], result)

    @builtins.property
    def enablefileindexing(self) -> typing.Optional[builtins.str]:
        '''True if file indexing needs to be enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablefileindexing VmgroupV2#enablefileindexing}
        '''
        result = self._values.get("enablefileindexing")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def filters(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Filters"]]]:
        '''filters block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filters VmgroupV2#filters}
        '''
        result = self._values.get("filters")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Filters"]]], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def meditech(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditech"]]]:
        '''meditech block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditech VmgroupV2#meditech}
        '''
        result = self._values.get("meditech")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditech"]]], result)

    @builtins.property
    def meditechsystems(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditechsystems"]]]:
        '''meditechsystems block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#meditechsystems VmgroupV2#meditechsystems}
        '''
        result = self._values.get("meditechsystems")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Meditechsystems"]]], result)

    @builtins.property
    def securityassociations(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Securityassociations"]]]:
        '''securityassociations block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#securityassociations VmgroupV2#securityassociations}
        '''
        result = self._values.get("securityassociations")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Securityassociations"]]], result)

    @builtins.property
    def settings(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Settings"]]]:
        '''settings block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#settings VmgroupV2#settings}
        '''
        result = self._values.get("settings")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Settings"]]], result)

    @builtins.property
    def snapshotmanagement(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Snapshotmanagement"]]]:
        '''snapshotmanagement block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapshotmanagement VmgroupV2#snapshotmanagement}
        '''
        result = self._values.get("snapshotmanagement")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Snapshotmanagement"]]], result)

    @builtins.property
    def storage(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Storage"]]]:
        '''storage block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#storage VmgroupV2#storage}
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Storage"]]], result)

    @builtins.property
    def timezone(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Timezone"]]]:
        '''timezone block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#timezone VmgroupV2#timezone}
        '''
        result = self._values.get("timezone")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2Timezone"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Config(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Content",
    jsii_struct_bases=[],
    name_mapping={"overwrite": "overwrite", "rulegroups": "rulegroups"},
)
class VmgroupV2Content:
    def __init__(
        self,
        *,
        overwrite: typing.Optional[builtins.str] = None,
        rulegroups: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ContentRulegroups", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param overwrite: True if content in vmgroup has to be overwritten, by default it will append the content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        :param rulegroups: rulegroups block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ebe45fcd91e7dbed853aa75807ece93543ccbabac3b2ac8a996180035c7ec41)
            check_type(argname="argument overwrite", value=overwrite, expected_type=type_hints["overwrite"])
            check_type(argname="argument rulegroups", value=rulegroups, expected_type=type_hints["rulegroups"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if overwrite is not None:
            self._values["overwrite"] = overwrite
        if rulegroups is not None:
            self._values["rulegroups"] = rulegroups

    @builtins.property
    def overwrite(self) -> typing.Optional[builtins.str]:
        '''True if content in vmgroup has to be overwritten, by default it will append the content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        '''
        result = self._values.get("overwrite")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rulegroups(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroups"]]]:
        '''rulegroups block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
        '''
        result = self._values.get("rulegroups")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroups"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Content(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ContentList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ccd6f3fc1a6f228e39970862c654f9b14f53e32ff4f08854139a74e606e27050)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2ContentOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a0b755b11680f5c69706afc277517f30ed1e870988e85e8f105ab269125968b)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ContentOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff4123be0f79764aee58fdb7cab187d286b22230dce1feb8f185b81d6e0ce71b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e0495d9fc4e0f16cffaea34d8c21a0feb7e0a0480fb687fb56f2c50fc2aade7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__05df135bce3bb05ca32f59ba4a4bcce9dc8547650a9b01054a1362de883a8d77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Content]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Content]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Content]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2011d4531e15640c5e90a5ea451b85ee77b7ec7ad5c2746b367c842b28847500)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ContentOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf39c658df45ba101b039cb3186a88a616af8e96dad30ea5786361810aeeb688)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putRulegroups")
    def put_rulegroups(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ContentRulegroups", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9882b90159798a34560ca4a3fcc669ec8b1eb70fea44fdbbc3f4b482afe351cc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRulegroups", [value]))

    @jsii.member(jsii_name="resetOverwrite")
    def reset_overwrite(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOverwrite", []))

    @jsii.member(jsii_name="resetRulegroups")
    def reset_rulegroups(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRulegroups", []))

    @builtins.property
    @jsii.member(jsii_name="rulegroups")
    def rulegroups(self) -> "VmgroupV2ContentRulegroupsList":
        return typing.cast("VmgroupV2ContentRulegroupsList", jsii.get(self, "rulegroups"))

    @builtins.property
    @jsii.member(jsii_name="overwriteInput")
    def overwrite_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "overwriteInput"))

    @builtins.property
    @jsii.member(jsii_name="rulegroupsInput")
    def rulegroups_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroups"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroups"]]], jsii.get(self, "rulegroupsInput"))

    @builtins.property
    @jsii.member(jsii_name="overwrite")
    def overwrite(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "overwrite"))

    @overwrite.setter
    def overwrite(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__799d06e1792ba4f67e0555d761b09317e733756380df73c89a461788d31ed65d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "overwrite", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Content]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Content]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Content]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bd530e8f19b1be6ee3eb3c566f808406bddc7b8c622e6514adfbf5b350ea4b5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroups",
    jsii_struct_bases=[],
    name_mapping={"matchrule": "matchrule", "rules": "rules"},
)
class VmgroupV2ContentRulegroups:
    def __init__(
        self,
        *,
        matchrule: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ContentRulegroupsRules", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param matchrule: Enum which specifies the whether to match all rules or any of the rules [ALL, ANY]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
        :param rules: rules block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ac85285feb2131b8c140d18ddf4cbd3df15430357e2d7eefb8d2e5822061294)
            check_type(argname="argument matchrule", value=matchrule, expected_type=type_hints["matchrule"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if matchrule is not None:
            self._values["matchrule"] = matchrule
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def matchrule(self) -> typing.Optional[builtins.str]:
        '''Enum which specifies the whether to match all rules or any of the rules [ALL, ANY].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
        '''
        result = self._values.get("matchrule")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroupsRules"]]]:
        '''rules block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroupsRules"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ContentRulegroups(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ContentRulegroupsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroupsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d72a693869da69d55a8a7dde071446c0fce651ba96a20d6040647fce03c708ad)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2ContentRulegroupsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a737eb2a2692fb83c81af4dac82b67aa96a14a37398f1d30e007beab11227d6)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ContentRulegroupsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc6b09621d8319dc457ed762e1bd434e5475ab0edadb17a1a0008dfd34f6591b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01013a9cd7821c42a64beff6d45eac6017333242b7b13ce52da16f7d84d76109)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf485e7f7dcc60660a5d428acb710c57c3df046f4aa2adaf841af4b2b2196ec9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroups]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroups]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroups]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c983e50f919bc23d5869b3ce9e20a0961bfd076af34a4e3579923135cc6784e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ContentRulegroupsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroupsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d32964b559a6f03499a30c88bdd8b6b1653d722364db0037915223b284cb9587)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putRules")
    def put_rules(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2ContentRulegroupsRules", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5474b14a29bac10f59abd467bcad9cb2054e1712d57a61b8a736fcf3e4291c6d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRules", [value]))

    @jsii.member(jsii_name="resetMatchrule")
    def reset_matchrule(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMatchrule", []))

    @jsii.member(jsii_name="resetRules")
    def reset_rules(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRules", []))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> "VmgroupV2ContentRulegroupsRulesList":
        return typing.cast("VmgroupV2ContentRulegroupsRulesList", jsii.get(self, "rules"))

    @builtins.property
    @jsii.member(jsii_name="matchruleInput")
    def matchrule_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "matchruleInput"))

    @builtins.property
    @jsii.member(jsii_name="rulesInput")
    def rules_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroupsRules"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2ContentRulegroupsRules"]]], jsii.get(self, "rulesInput"))

    @builtins.property
    @jsii.member(jsii_name="matchrule")
    def matchrule(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "matchrule"))

    @matchrule.setter
    def matchrule(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac15ecba5798f9f899ee79dde5c80ecd5ea1aed0a0852306adc0e443652cf084)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "matchrule", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroups]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroups]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroups]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__893781d6a1c73295581458640eb76c4dfdfb67bfb41dc51c7d8e53e84ad52afb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroupsRules",
    jsii_struct_bases=[],
    name_mapping={"condition": "condition", "name": "name", "type": "type"},
)
class VmgroupV2ContentRulegroupsRules:
    def __init__(
        self,
        *,
        condition: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param condition: Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        :param name: name of the VM to be added as content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param type: [NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4dfa9d80e3edb184e265cedcd2d1e38cf5e85e924f3784bb7a67bcb6dba77f81)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if condition is not None:
            self._values["condition"] = condition
        if name is not None:
            self._values["name"] = name
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def condition(self) -> typing.Optional[builtins.str]:
        '''Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        '''
        result = self._values.get("condition")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''name of the VM to be added as content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''[NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2ContentRulegroupsRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2ContentRulegroupsRulesList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroupsRulesList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__180b61b88a98d9537f55da28f9298da220d99b9e78531b951d93b7ea4f729f20)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2ContentRulegroupsRulesOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b9e6ae6d9d2bf1871dd7cfb31130185038fc79f63f067a83457cf691958e272)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2ContentRulegroupsRulesOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__741981eee2681b3227dc7771192a0b17e91f88a0776b4045c829245b017f44e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5e3edf50a7c589d0a28e4ee205e6521da0e137e275245b4423e5c4ca85b7c1a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__494ec027daee0c48d3c07d03ae8c913cffd2592a23d376616059cfebccaf412b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroupsRules]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroupsRules]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ContentRulegroupsRules]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17033b2917bfb7bd261d644edcd994d072ae884f91c1fe92bc4e4743ccc10ed3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2ContentRulegroupsRulesOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2ContentRulegroupsRulesOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c738a3e1cb26e8911f7c65d2bdcac341493ab4af3dca5e6b4e811b1c7cc4a8c1)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetCondition")
    def reset_condition(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCondition", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetType")
    def reset_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetType", []))

    @builtins.property
    @jsii.member(jsii_name="conditionInput")
    def condition_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "conditionInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "condition"))

    @condition.setter
    def condition(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__078685155d94f5ac1127da23025b3cb3d406aeb4efffc6184ebb055cf2e9e16d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c60c69399fb8c3aab34ed647a72e1e8208bc1a7a3f40b30bffacde657174b2e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9479ff28de6404c0bffda36273bbcbfa64eee70aa31a825b1f081ae7831e991c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroupsRules]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroupsRules]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ContentRulegroupsRules]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b44898eeba9be023857c297cf84bf0372c9763dd44f3318aefdf9886ebc90c56)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Diskfilters",
    jsii_struct_bases=[],
    name_mapping={"overwrite": "overwrite", "rules": "rules"},
)
class VmgroupV2Diskfilters:
    def __init__(
        self,
        *,
        overwrite: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2DiskfiltersRules", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param overwrite: True if content in vmgroup has to be overwritten, by default it will append the content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        :param rules: rules block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4528073bc8307326a76610935c1e59aa46e29da3a530f8eccd43000829a454a9)
            check_type(argname="argument overwrite", value=overwrite, expected_type=type_hints["overwrite"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if overwrite is not None:
            self._values["overwrite"] = overwrite
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def overwrite(self) -> typing.Optional[builtins.str]:
        '''True if content in vmgroup has to be overwritten, by default it will append the content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        '''
        result = self._values.get("overwrite")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2DiskfiltersRules"]]]:
        '''rules block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2DiskfiltersRules"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Diskfilters(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2DiskfiltersList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2DiskfiltersList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be9b6f8a7a46164fd14f88b158612de0fe417f40f69895b12979f92d08b4068a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2DiskfiltersOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67500a81ebe02e0cc548a1182161bbb1aea781e4a5aea071e146c7ff12b66b6e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2DiskfiltersOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__312433070b799d9494822632d1a29d12fb5661dc6e6fac1279dae60f19db756d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e73c7984eee0197a462f3f747dcbb3f2b93629480c0402f89274dc701e984277)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c14e319e140e29740467b371c415d515007343a2ce21350f69c8ddc2a13a793)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Diskfilters]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Diskfilters]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Diskfilters]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f11df5544fd140e691a29ad9b776d1fb55e1ea8f6bf15fb67408f2e608061db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2DiskfiltersOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2DiskfiltersOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99063fab952d7b35e04311f92284c1d38e7f73fbe9fbb6db918a6a6dca71f703)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putRules")
    def put_rules(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2DiskfiltersRules", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e71a5a870c24a57666541c3690c3b22d4166a26d8f5941001b6369e6af4d2ee6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRules", [value]))

    @jsii.member(jsii_name="resetOverwrite")
    def reset_overwrite(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOverwrite", []))

    @jsii.member(jsii_name="resetRules")
    def reset_rules(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRules", []))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> "VmgroupV2DiskfiltersRulesList":
        return typing.cast("VmgroupV2DiskfiltersRulesList", jsii.get(self, "rules"))

    @builtins.property
    @jsii.member(jsii_name="overwriteInput")
    def overwrite_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "overwriteInput"))

    @builtins.property
    @jsii.member(jsii_name="rulesInput")
    def rules_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2DiskfiltersRules"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2DiskfiltersRules"]]], jsii.get(self, "rulesInput"))

    @builtins.property
    @jsii.member(jsii_name="overwrite")
    def overwrite(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "overwrite"))

    @overwrite.setter
    def overwrite(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ce6ac37c1a2649b3ad5ec23f1dd729f202e41e1c66674b161fd9449c71b219f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "overwrite", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Diskfilters]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Diskfilters]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Diskfilters]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44de994f6468f8e9f8275b3363ee8ffadf370a2c2a4d57d6051e9082f75ae6e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2DiskfiltersRules",
    jsii_struct_bases=[],
    name_mapping={
        "condition": "condition",
        "filtertype": "filtertype",
        "name": "name",
        "overwrite": "overwrite",
        "value": "value",
        "vmguid": "vmguid",
        "vmname": "vmname",
    },
)
class VmgroupV2DiskfiltersRules:
    def __init__(
        self,
        *,
        condition: typing.Optional[builtins.str] = None,
        filtertype: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        overwrite: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
        vmguid: typing.Optional[builtins.str] = None,
        vmname: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param condition: Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        :param filtertype: [NONE, DISK_PATH, DISK_PATTERN, DISK_VIRTUAL_DEVICE_NODE, DISK_DATASTORE, DISK_LABEL, DISK_TYPE, DISK_ADDRESS, CONTAINER_PATTERN, DISK_TAG]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filtertype VmgroupV2#filtertype}
        :param name: The string to be filtered. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param overwrite: True if disk filter in vmgroup has to be overwritten, by default it will append the content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        :param value: The value string to be filtered, in case of disk tag , value of tag to be filtered. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        :param vmguid: VM Guid of the Virtual Machine whose disk has to be filtered . This is optional. if not given, all disks of name and type from all Vms added in content will be filtered Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmguid VmgroupV2#vmguid}
        :param vmname: VM Name of the Virtual Machine whose disk has to be filtered . This is optional. if not given, all disks of name and type from all Vms added in content will be filtered Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmname VmgroupV2#vmname}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e5c91b8507d7913f40c6956f6e57b817bab0f97ee041e084e2e68007453c446)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument filtertype", value=filtertype, expected_type=type_hints["filtertype"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument overwrite", value=overwrite, expected_type=type_hints["overwrite"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument vmguid", value=vmguid, expected_type=type_hints["vmguid"])
            check_type(argname="argument vmname", value=vmname, expected_type=type_hints["vmname"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if condition is not None:
            self._values["condition"] = condition
        if filtertype is not None:
            self._values["filtertype"] = filtertype
        if name is not None:
            self._values["name"] = name
        if overwrite is not None:
            self._values["overwrite"] = overwrite
        if value is not None:
            self._values["value"] = value
        if vmguid is not None:
            self._values["vmguid"] = vmguid
        if vmname is not None:
            self._values["vmname"] = vmname

    @builtins.property
    def condition(self) -> typing.Optional[builtins.str]:
        '''Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        '''
        result = self._values.get("condition")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def filtertype(self) -> typing.Optional[builtins.str]:
        '''[NONE, DISK_PATH, DISK_PATTERN, DISK_VIRTUAL_DEVICE_NODE, DISK_DATASTORE, DISK_LABEL, DISK_TYPE, DISK_ADDRESS, CONTAINER_PATTERN, DISK_TAG].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#filtertype VmgroupV2#filtertype}
        '''
        result = self._values.get("filtertype")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The string to be filtered.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def overwrite(self) -> typing.Optional[builtins.str]:
        '''True if disk filter in vmgroup has to be overwritten, by default it will append the content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        '''
        result = self._values.get("overwrite")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''The value string to be filtered, in case of disk tag , value of tag to be filtered.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def vmguid(self) -> typing.Optional[builtins.str]:
        '''VM Guid of the Virtual Machine whose disk has to be filtered .

        This is optional. if not given, all disks of name and type from all Vms added in content will be filtered

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmguid VmgroupV2#vmguid}
        '''
        result = self._values.get("vmguid")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def vmname(self) -> typing.Optional[builtins.str]:
        '''VM Name of the Virtual Machine whose disk has to be filtered .

        This is optional. if not given, all disks of name and type from all Vms added in content will be filtered

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmname VmgroupV2#vmname}
        '''
        result = self._values.get("vmname")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2DiskfiltersRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2DiskfiltersRulesList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2DiskfiltersRulesList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d4ac120fc23dc38b394c3b460456deb95224e5fe38849c725ac97ad678242af)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2DiskfiltersRulesOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__07fa310436db573596a36d7fd68093710d04ee003c674665edcec9f1b169fbfd)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2DiskfiltersRulesOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9265f124a103b8c07115736f09a7fdf83c0b00a625971b27b534df5bc839e8ae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efd9e075d564e2df62b0fa00629f4b64a7d8153c94569e1ccb6dc1667840da26)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4aabd7d2cc223e50a7298636b015d48768a68e320102bf801a414ea41bfec736)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2DiskfiltersRules]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2DiskfiltersRules]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2DiskfiltersRules]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__40a204f6d5159ff32b79515186401cd329d8d3b9d68528e4cca9b07e6ad666e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2DiskfiltersRulesOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2DiskfiltersRulesOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45f7f954f722543e14b47262fcb869a64cf66cef181917f3c625b90f450b0327)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetCondition")
    def reset_condition(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCondition", []))

    @jsii.member(jsii_name="resetFiltertype")
    def reset_filtertype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFiltertype", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetOverwrite")
    def reset_overwrite(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOverwrite", []))

    @jsii.member(jsii_name="resetValue")
    def reset_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValue", []))

    @jsii.member(jsii_name="resetVmguid")
    def reset_vmguid(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetVmguid", []))

    @jsii.member(jsii_name="resetVmname")
    def reset_vmname(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetVmname", []))

    @builtins.property
    @jsii.member(jsii_name="conditionInput")
    def condition_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "conditionInput"))

    @builtins.property
    @jsii.member(jsii_name="filtertypeInput")
    def filtertype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "filtertypeInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="overwriteInput")
    def overwrite_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "overwriteInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="vmguidInput")
    def vmguid_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vmguidInput"))

    @builtins.property
    @jsii.member(jsii_name="vmnameInput")
    def vmname_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vmnameInput"))

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "condition"))

    @condition.setter
    def condition(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__630342ecdd1b18bd5a16abe7aa5b755fcde752021f644d6c4a2e36dc02cfcbd6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="filtertype")
    def filtertype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "filtertype"))

    @filtertype.setter
    def filtertype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0536db7ad685fb81a6e6e56be2aefda057f6fe7fefad8cb43e8160ac79a4c318)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "filtertype", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3a0c920efc936a8d7a05d2be2ae1979986d31a68982edde6ed22a4fa4feaff8c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="overwrite")
    def overwrite(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "overwrite"))

    @overwrite.setter
    def overwrite(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__774d2fe38b061717abad277ca28917e5abad3afbb190d4cfbc45177e9102252e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "overwrite", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "value"))

    @value.setter
    def value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86df816aef3d7899a45be236aa88a6842435d5d68b50d34d348a045f8bf6fa24)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="vmguid")
    def vmguid(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vmguid"))

    @vmguid.setter
    def vmguid(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8c511f0b8e216e6e6d99dbff1c06511122c76bef0d84fde05faa1ca5e704b08)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vmguid", value)

    @builtins.property
    @jsii.member(jsii_name="vmname")
    def vmname(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vmname"))

    @vmname.setter
    def vmname(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__148930f3b3eb23c085bf94fd1e6320f4aedfc20bee8e8408448d6b2f917c5b81)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vmname", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2DiskfiltersRules]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2DiskfiltersRules]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2DiskfiltersRules]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a1a6d7458e8097ea6edfc8ba53b6f971332469b3e9b0645ec344fa10dbafd6c9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Filters",
    jsii_struct_bases=[],
    name_mapping={"overwrite": "overwrite", "rulegroups": "rulegroups"},
)
class VmgroupV2Filters:
    def __init__(
        self,
        *,
        overwrite: typing.Optional[builtins.str] = None,
        rulegroups: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2FiltersRulegroups", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param overwrite: True if content in vmgroup has to be overwritten, by default it will append the content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        :param rulegroups: rulegroups block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a800b1f58501f671ade0905f48d2f676297b3b6ad66253947ebf0ab9fb8e874)
            check_type(argname="argument overwrite", value=overwrite, expected_type=type_hints["overwrite"])
            check_type(argname="argument rulegroups", value=rulegroups, expected_type=type_hints["rulegroups"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if overwrite is not None:
            self._values["overwrite"] = overwrite
        if rulegroups is not None:
            self._values["rulegroups"] = rulegroups

    @builtins.property
    def overwrite(self) -> typing.Optional[builtins.str]:
        '''True if content in vmgroup has to be overwritten, by default it will append the content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#overwrite VmgroupV2#overwrite}
        '''
        result = self._values.get("overwrite")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rulegroups(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroups"]]]:
        '''rulegroups block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rulegroups VmgroupV2#rulegroups}
        '''
        result = self._values.get("rulegroups")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroups"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Filters(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2FiltersList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55faa6d0fa27b33c4ce452f3a3253c86e504cdfce50057ca03e34b8fd80fe071)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2FiltersOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a89cbada02a59d047cb7d2117392fd7d40cab924ecdca0ffeccd2f0bc691f313)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2FiltersOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bccc767b28f8bc678cf2f26032512c9e00aabf194563b30102966543f35b3ab0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b3540d6d6d5cbe984486364d66df0dd65551c2c25da4d96eba6d3d17537d3b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f074b1f9ce6811027af504ce8fcb21fd70e72773fb01e70496d296fb79dd8ea9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Filters]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Filters]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Filters]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__375381ef65e1654b1c772d278a7ee2282b22ad9158181a7d2bc8565ff05161df)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2FiltersOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b25e1f04c5a573da9f39f05398049b1cec8e3b962c197c393b345a939d5e49fd)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putRulegroups")
    def put_rulegroups(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2FiltersRulegroups", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7dcb7a7e5aa35ca30c82e9d3803f17edaa75ced8a1b2739faad9d02b346535aa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRulegroups", [value]))

    @jsii.member(jsii_name="resetOverwrite")
    def reset_overwrite(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetOverwrite", []))

    @jsii.member(jsii_name="resetRulegroups")
    def reset_rulegroups(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRulegroups", []))

    @builtins.property
    @jsii.member(jsii_name="rulegroups")
    def rulegroups(self) -> "VmgroupV2FiltersRulegroupsList":
        return typing.cast("VmgroupV2FiltersRulegroupsList", jsii.get(self, "rulegroups"))

    @builtins.property
    @jsii.member(jsii_name="overwriteInput")
    def overwrite_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "overwriteInput"))

    @builtins.property
    @jsii.member(jsii_name="rulegroupsInput")
    def rulegroups_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroups"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroups"]]], jsii.get(self, "rulegroupsInput"))

    @builtins.property
    @jsii.member(jsii_name="overwrite")
    def overwrite(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "overwrite"))

    @overwrite.setter
    def overwrite(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a5fb5e63081073c6bb92de9e387ef54eff7186539e3ee76f0cf3f0cf07776c4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "overwrite", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Filters]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Filters]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Filters]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e7d1b4a1ca5fdd2938c6fdf9c93df22a263db1e38fc425cf359f4688c494c63)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroups",
    jsii_struct_bases=[],
    name_mapping={"matchrule": "matchrule", "rules": "rules"},
)
class VmgroupV2FiltersRulegroups:
    def __init__(
        self,
        *,
        matchrule: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2FiltersRulegroupsRules", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param matchrule: Enum which specifies the whether to match all rules or any of the rules [ALL, ANY]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
        :param rules: rules block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a6f4d20f465e49bc9ff2655b9de83972f8a8f7b49492845c1d6432e233c4303)
            check_type(argname="argument matchrule", value=matchrule, expected_type=type_hints["matchrule"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if matchrule is not None:
            self._values["matchrule"] = matchrule
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def matchrule(self) -> typing.Optional[builtins.str]:
        '''Enum which specifies the whether to match all rules or any of the rules [ALL, ANY].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#matchrule VmgroupV2#matchrule}
        '''
        result = self._values.get("matchrule")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroupsRules"]]]:
        '''rules block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#rules VmgroupV2#rules}
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroupsRules"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2FiltersRulegroups(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2FiltersRulegroupsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroupsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13d06026f1375f7e433b98ac020e2f9db324fa85e471742547771396d7390e11)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2FiltersRulegroupsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2767ee3dfef3bc27b6fe47886703b225c38ce9f423f3c675c4f53faeee3c0ead)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2FiltersRulegroupsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb45caf1c9c9d80146b30fddeaafeb84a9e025acde75b4aeba7e479ad53a1a33)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__073357708a905b96dc77c81d69ac9a11366c491411d216ac8fdb9a80039417a2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__25d4ddd625f9f3f922070618a70156d61c58fbee58ff775be3fb63d1a07a3464)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroups]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroups]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroups]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__243341b15479cb39da571ee394534afcbf09a3c0667d2541560d4ab541a41090)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2FiltersRulegroupsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroupsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2118584198ff75579796a42b85c7a1aa783535c7f42d784dd4940d418c7d243)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putRules")
    def put_rules(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2FiltersRulegroupsRules", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb4a353b1d7c5cff238a796a9a358dbc095e049f5637387ca2c64e8c91aee4d1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRules", [value]))

    @jsii.member(jsii_name="resetMatchrule")
    def reset_matchrule(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMatchrule", []))

    @jsii.member(jsii_name="resetRules")
    def reset_rules(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRules", []))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> "VmgroupV2FiltersRulegroupsRulesList":
        return typing.cast("VmgroupV2FiltersRulegroupsRulesList", jsii.get(self, "rules"))

    @builtins.property
    @jsii.member(jsii_name="matchruleInput")
    def matchrule_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "matchruleInput"))

    @builtins.property
    @jsii.member(jsii_name="rulesInput")
    def rules_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroupsRules"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2FiltersRulegroupsRules"]]], jsii.get(self, "rulesInput"))

    @builtins.property
    @jsii.member(jsii_name="matchrule")
    def matchrule(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "matchrule"))

    @matchrule.setter
    def matchrule(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10fac5e2d6a01a87752ec5c394d6a0c3124f7cd9e07dcee82501b96b1a830c80)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "matchrule", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroups]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroups]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroups]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3796a3c7eff6b9dad9d8bd1d742d3c4765920c494d43023aa9844e91f2c2790f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroupsRules",
    jsii_struct_bases=[],
    name_mapping={"condition": "condition", "name": "name", "type": "type"},
)
class VmgroupV2FiltersRulegroupsRules:
    def __init__(
        self,
        *,
        condition: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param condition: Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        :param name: name of the VM to be added as content. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param type: [NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47e063d23b05316d1d59fc54e24b82de7eb89e0d94be59bfe77ec60605de00bd)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if condition is not None:
            self._values["condition"] = condition
        if name is not None:
            self._values["name"] = name
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def condition(self) -> typing.Optional[builtins.str]:
        '''Operation type for VM rules/filters [CONTAINS, DOES_NOT_CONTAIN, DOES_NOT_EQUAL, ENDS_WITH, EQUALS, STARTS_WITH].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#condition VmgroupV2#condition}
        '''
        result = self._values.get("condition")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''name of the VM to be added as content.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''[NONE, SERVER, RES_POOL, VAPP, DATACENTER, FOLDER, CLUSTER, DATASTORE, DATASTORE_CLUSTER, VM, VM_NAME, VM_GUEST_OS, VM_GUEST_HOST_NAME, CLUSTER_SHARED_VOLUMES, LOCAL_DISK, CLUSTER_DISK, UNPROTECTED_VMS, ROOT, FILE_SERVER, SMB_SHARE, TYPES_FOLDER, VM_FOLDER, SERVER_FOLDER, TEMPLATE_FOLDER, STORAGE_REPOSITORY_FOLDER, VAPPFOLDER, DATACENTER_FOLDER, CLUSTER_FOLDER, VM_POWER_STATE, VM_NOTES, VM_CUSTOM_ATTRIBUTE, NETWORK, USER, VM_TEMPLATE, TAG, TAG_CATEGORY, SUBCLIENT, CLIENT_GROUP, PROTECTION_DOMAIN, CONSISTENCY_GROUP, INSTANCE_SIZE, ORGANIZATION, IMAGES, STORAGE_POLICY, DATABASE, TABLE, PROJECT, SELECTOR, MANAGED_BY, REPLICATION_MODE, METADATATAG, CATALOG, VAPPTEMPLATE, VOLUME].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2FiltersRulegroupsRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2FiltersRulegroupsRulesList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroupsRulesList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ffe47bfbf11d3cb34f1676a63e57206835420a9995a0d84917d1e3d62975dc0f)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2FiltersRulegroupsRulesOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0945e768a8bf26a4bb2f9863821b441ac74cc83ef50e93a737b254625a6fdd76)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2FiltersRulegroupsRulesOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__985e106b18cd2d8808bb10f1ed804b44c7dd95de4cbe9ddcdf8c169136ab450d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f835877423add519a8c0f8f0f518cbf8053e64ae2c1b41869ea36553243ee9a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e6d218a13407828655ab4ffe2fec4c07fc4e238a86b8fefe649326475d561ef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroupsRules]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroupsRules]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2FiltersRulegroupsRules]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e841764e611b34e5e4858cb98ecedffc9da1ec76620c14be87f578c91e031bc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2FiltersRulegroupsRulesOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2FiltersRulegroupsRulesOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baa37d3d07d084bd6867c781011e1409af7d259f6cb7acb7f1dfd20ef56b1dbc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetCondition")
    def reset_condition(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCondition", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetType")
    def reset_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetType", []))

    @builtins.property
    @jsii.member(jsii_name="conditionInput")
    def condition_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "conditionInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "condition"))

    @condition.setter
    def condition(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6553e055292f45d8fa3f564fc7d96e48731155c99ebcb86173d87bd8f1b17126)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1974a4b10f82a83cb6b6b12a7cf49eed99c2957ae834b5c2e65d8fae5d3c12be)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9e65b43950d076735de4d65a5bc0a4d4e8a248f1e2f00c3e073a0a47abf507f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroupsRules]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroupsRules]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2FiltersRulegroupsRules]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7aae918e039133faa2c263f858dedaafbd9797dbddf45c08fefdd64b3fd5508b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Hypervisor",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2Hypervisor:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__139abe3a190d6febb7898670bc5244259ed89c5dc188176b59fecb582ac50dd6)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Hypervisor(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2HypervisorList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2HypervisorList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be0fe994311787888283080e2d1408860b7f7204926c9dc8378f86174d0c801d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2HypervisorOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6fe453fc2559e8488f41970194c50824623c9e11c102c34aa7e24313d3cec4f7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2HypervisorOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89c7ffc3f52df59c53bde53aae301c8dba26296fe0ee8c595add11d7302ce30a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baca13a2568951ba1326641aeb0b2257b2b82af489bc2f0c8d935232eaec97ca)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77ff32aef8b95ae0a4916ccc82933b2c8361477c23b30da0bc347c5227e59d23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Hypervisor]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Hypervisor]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Hypervisor]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e168b211d0d231676ed71ca0638268abb7aaf495a244bb3fa3470ce3eb8c53a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2HypervisorOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2HypervisorOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83df61b330e73e38b9b8182de3b1d19ba5ad7c40a0702df56bbf67a3bc4649cb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dee9096601b9cd5d1a3431e832cbdf584472e87d65a2739558b2e309819f66f0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecf87d7dbd6cefe46885844cabf1ad249230a8d875944d8aae754bfa72b541e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Hypervisor]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Hypervisor]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Hypervisor]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e70d89695b3b11ea7a2549a09326de510f2cf045d1f59f2c39594154ccf57c88)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Meditech",
    jsii_struct_bases=[],
    name_mapping={
        "listenerip": "listenerip",
        "listenerport": "listenerport",
        "mbftimeout": "mbftimeout",
        "systemname": "systemname",
        "useraccount": "useraccount",
    },
)
class VmgroupV2Meditech:
    def __init__(
        self,
        *,
        listenerip: typing.Optional[builtins.str] = None,
        listenerport: typing.Optional[jsii.Number] = None,
        mbftimeout: typing.Optional[jsii.Number] = None,
        systemname: typing.Optional[builtins.str] = None,
        useraccount: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2MeditechUseraccount", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param listenerip: Meditech Listener IP of FQDN name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
        :param listenerport: Meditech Listener Port. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
        :param mbftimeout: MBF timeout (in seconds). Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
        :param systemname: Meditech system name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
        :param useraccount: useraccount block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7370bd9c94b16774b4a6c4b0a2467f3601addd2d562778070efb0e8a4c6e116d)
            check_type(argname="argument listenerip", value=listenerip, expected_type=type_hints["listenerip"])
            check_type(argname="argument listenerport", value=listenerport, expected_type=type_hints["listenerport"])
            check_type(argname="argument mbftimeout", value=mbftimeout, expected_type=type_hints["mbftimeout"])
            check_type(argname="argument systemname", value=systemname, expected_type=type_hints["systemname"])
            check_type(argname="argument useraccount", value=useraccount, expected_type=type_hints["useraccount"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if listenerip is not None:
            self._values["listenerip"] = listenerip
        if listenerport is not None:
            self._values["listenerport"] = listenerport
        if mbftimeout is not None:
            self._values["mbftimeout"] = mbftimeout
        if systemname is not None:
            self._values["systemname"] = systemname
        if useraccount is not None:
            self._values["useraccount"] = useraccount

    @builtins.property
    def listenerip(self) -> typing.Optional[builtins.str]:
        '''Meditech Listener IP of FQDN name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
        '''
        result = self._values.get("listenerip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def listenerport(self) -> typing.Optional[jsii.Number]:
        '''Meditech Listener Port.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
        '''
        result = self._values.get("listenerport")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def mbftimeout(self) -> typing.Optional[jsii.Number]:
        '''MBF timeout (in seconds).

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
        '''
        result = self._values.get("mbftimeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def systemname(self) -> typing.Optional[builtins.str]:
        '''Meditech system name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
        '''
        result = self._values.get("systemname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def useraccount(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechUseraccount"]]]:
        '''useraccount block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
        '''
        result = self._values.get("useraccount")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechUseraccount"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Meditech(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2MeditechList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d1fd98e6abf336e53de59108fb22b70cb1cee42ed99a3b1c5d69864f2fa5ba8d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2MeditechOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47c4e8280f8eecdc0da662d404e28028f8f33c5b2775ec7654e906c380e549d7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2MeditechOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__908e45c97fb2f48ae983935e743866f525d50c0417555209ac03bf423753e668)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1233d370ac782e864703db6f59c9133f4b7e92c1763d675fe154948090b5f64)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__82ccf470b9cf8d956dead36d3c5d9a46bb9848c2ad3d43f0fde11d75271667bf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditech]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditech]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditech]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02efc97879d887d126000f33b383c43fbc628c892757adc98be5ee1c644aa36b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2MeditechOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16c3237171c3f3a74cb32bc643a5980a9b88e8f0c0c7bf5461dcca13cf48f103)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putUseraccount")
    def put_useraccount(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2MeditechUseraccount", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78b91a3423a5e3a7a6073b830878f7fc72e092a4e67adbd0afec6c0221cba337)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUseraccount", [value]))

    @jsii.member(jsii_name="resetListenerip")
    def reset_listenerip(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetListenerip", []))

    @jsii.member(jsii_name="resetListenerport")
    def reset_listenerport(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetListenerport", []))

    @jsii.member(jsii_name="resetMbftimeout")
    def reset_mbftimeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMbftimeout", []))

    @jsii.member(jsii_name="resetSystemname")
    def reset_systemname(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSystemname", []))

    @jsii.member(jsii_name="resetUseraccount")
    def reset_useraccount(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUseraccount", []))

    @builtins.property
    @jsii.member(jsii_name="useraccount")
    def useraccount(self) -> "VmgroupV2MeditechUseraccountList":
        return typing.cast("VmgroupV2MeditechUseraccountList", jsii.get(self, "useraccount"))

    @builtins.property
    @jsii.member(jsii_name="listeneripInput")
    def listenerip_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "listeneripInput"))

    @builtins.property
    @jsii.member(jsii_name="listenerportInput")
    def listenerport_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "listenerportInput"))

    @builtins.property
    @jsii.member(jsii_name="mbftimeoutInput")
    def mbftimeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "mbftimeoutInput"))

    @builtins.property
    @jsii.member(jsii_name="systemnameInput")
    def systemname_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "systemnameInput"))

    @builtins.property
    @jsii.member(jsii_name="useraccountInput")
    def useraccount_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechUseraccount"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechUseraccount"]]], jsii.get(self, "useraccountInput"))

    @builtins.property
    @jsii.member(jsii_name="listenerip")
    def listenerip(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "listenerip"))

    @listenerip.setter
    def listenerip(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a8d3b600f3554368212a8200f7f8389f0fa987042d9c7bfcdae71f6aff4ebbf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "listenerip", value)

    @builtins.property
    @jsii.member(jsii_name="listenerport")
    def listenerport(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "listenerport"))

    @listenerport.setter
    def listenerport(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aebc8792de0a861a5b4dacdef9713eac37d1cf149e25f98f9f75391442d4cd2f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "listenerport", value)

    @builtins.property
    @jsii.member(jsii_name="mbftimeout")
    def mbftimeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "mbftimeout"))

    @mbftimeout.setter
    def mbftimeout(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87fd78e1494e4115ea74701dea956aa269e45e07be30f55f39c0f81f84089b68)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "mbftimeout", value)

    @builtins.property
    @jsii.member(jsii_name="systemname")
    def systemname(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "systemname"))

    @systemname.setter
    def systemname(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cff551ec8c02a57466b13fb3bab28562c1e27da75e834de90c157947eac7dc2f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "systemname", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditech]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditech]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditech]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ab5b8d1af6cbffb1fa0d6e03043b3cd40bc9983221968b6fb2d55f13b65e1fd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechUseraccount",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2MeditechUseraccount:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__48c1a7a43824eee2bbddf498d6bbf536b5ef97c50810e574dd6f7e2b7791f775)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2MeditechUseraccount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2MeditechUseraccountList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechUseraccountList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__defb9c31681ea6bc6223c4cd425b61a18c1592787fcdb66a05d77f3ed7a1d2cc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2MeditechUseraccountOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89e1d4498aef011e54a5a595da51377dee5eb00c0a97e888b4ea813a730ae96c)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2MeditechUseraccountOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70a1f5bc05ee4a261bd5a8031c6164553c8dfc5ce57ee1447bce2ee56cde4d52)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cffae274e95104855020994648e4b2039e6069cb52b8e8ccca32667e0b73cb3b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3399e72ecf7908ff91ef12c044d6508b557f16861ff8cbc49a0aafc339a3ea9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechUseraccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechUseraccount]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechUseraccount]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74dc39ce685ce80eefed2a8d42bae5f9c2c278d267e484dea32ea436f355fd2b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2MeditechUseraccountOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechUseraccountOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6f13257e9bc11cc987bf1eb7418d793106cf499b1655d7a06cba0a8dca27203)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d81d353340f23d79108fb6182f82317e95d10f7cfd4392e815a6ae64c6cc1e8a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c983102e38c7a7bf81dd9e00500a72d4741c673ce6e5e13272ed550f147dc8d1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechUseraccount]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechUseraccount]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechUseraccount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d42b891c6c9f65e4523caf23f2b4ec4919d2a23f2f730c4c08d7c4c4b27bc307)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Meditechsystems",
    jsii_struct_bases=[],
    name_mapping={
        "listenerip": "listenerip",
        "listenerport": "listenerport",
        "mbftimeout": "mbftimeout",
        "systemname": "systemname",
        "useraccount": "useraccount",
    },
)
class VmgroupV2Meditechsystems:
    def __init__(
        self,
        *,
        listenerip: typing.Optional[builtins.str] = None,
        listenerport: typing.Optional[jsii.Number] = None,
        mbftimeout: typing.Optional[jsii.Number] = None,
        systemname: typing.Optional[builtins.str] = None,
        useraccount: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2MeditechsystemsUseraccount", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param listenerip: Meditech Listener IP of FQDN name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
        :param listenerport: Meditech Listener Port. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
        :param mbftimeout: MBF timeout (in seconds). Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
        :param systemname: Meditech system name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
        :param useraccount: useraccount block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08ce187a01c43c0f6a1b59fcdd78fdb10b677777925e9af89029bab70b4f3230)
            check_type(argname="argument listenerip", value=listenerip, expected_type=type_hints["listenerip"])
            check_type(argname="argument listenerport", value=listenerport, expected_type=type_hints["listenerport"])
            check_type(argname="argument mbftimeout", value=mbftimeout, expected_type=type_hints["mbftimeout"])
            check_type(argname="argument systemname", value=systemname, expected_type=type_hints["systemname"])
            check_type(argname="argument useraccount", value=useraccount, expected_type=type_hints["useraccount"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if listenerip is not None:
            self._values["listenerip"] = listenerip
        if listenerport is not None:
            self._values["listenerport"] = listenerport
        if mbftimeout is not None:
            self._values["mbftimeout"] = mbftimeout
        if systemname is not None:
            self._values["systemname"] = systemname
        if useraccount is not None:
            self._values["useraccount"] = useraccount

    @builtins.property
    def listenerip(self) -> typing.Optional[builtins.str]:
        '''Meditech Listener IP of FQDN name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerip VmgroupV2#listenerip}
        '''
        result = self._values.get("listenerip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def listenerport(self) -> typing.Optional[jsii.Number]:
        '''Meditech Listener Port.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#listenerport VmgroupV2#listenerport}
        '''
        result = self._values.get("listenerport")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def mbftimeout(self) -> typing.Optional[jsii.Number]:
        '''MBF timeout (in seconds).

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#mbftimeout VmgroupV2#mbftimeout}
        '''
        result = self._values.get("mbftimeout")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def systemname(self) -> typing.Optional[builtins.str]:
        '''Meditech system name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#systemname VmgroupV2#systemname}
        '''
        result = self._values.get("systemname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def useraccount(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechsystemsUseraccount"]]]:
        '''useraccount block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useraccount VmgroupV2#useraccount}
        '''
        result = self._values.get("useraccount")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechsystemsUseraccount"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Meditechsystems(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2MeditechsystemsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechsystemsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e85789735525b071bd77c28c16641e0087647f402e78d58e628910d275de666)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2MeditechsystemsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__093fd8010844255703fd109032e61e5e52b37a9092b64d7e1db9e6ead081d57e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2MeditechsystemsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d745b44d4008bd6fd0156b4a59f0e033284effb682f770fa10a2686d59e375d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f53504de20c73f26d465358687c9de09fcdeb42936247eaa5cd469f0c225c046)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6507a9a185ae1ff03b16139516c9d39db02767d99c555d79554a6c8a122623e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditechsystems]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditechsystems]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Meditechsystems]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2adef6ba12f5d235cc90881567d9272a27549425dcfeb051dcaa0a37b1b59b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2MeditechsystemsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechsystemsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fca87bbed9b45ab56c469a9a33bf68930645b7b37e80601bef0122229a3d0580)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putUseraccount")
    def put_useraccount(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2MeditechsystemsUseraccount", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a97bb1d7f15bc0a9ab5da8dbd9ab6326412ae1411c2a4acc7b9a16e9b7992b75)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUseraccount", [value]))

    @jsii.member(jsii_name="resetListenerip")
    def reset_listenerip(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetListenerip", []))

    @jsii.member(jsii_name="resetListenerport")
    def reset_listenerport(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetListenerport", []))

    @jsii.member(jsii_name="resetMbftimeout")
    def reset_mbftimeout(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetMbftimeout", []))

    @jsii.member(jsii_name="resetSystemname")
    def reset_systemname(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSystemname", []))

    @jsii.member(jsii_name="resetUseraccount")
    def reset_useraccount(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUseraccount", []))

    @builtins.property
    @jsii.member(jsii_name="useraccount")
    def useraccount(self) -> "VmgroupV2MeditechsystemsUseraccountList":
        return typing.cast("VmgroupV2MeditechsystemsUseraccountList", jsii.get(self, "useraccount"))

    @builtins.property
    @jsii.member(jsii_name="listeneripInput")
    def listenerip_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "listeneripInput"))

    @builtins.property
    @jsii.member(jsii_name="listenerportInput")
    def listenerport_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "listenerportInput"))

    @builtins.property
    @jsii.member(jsii_name="mbftimeoutInput")
    def mbftimeout_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "mbftimeoutInput"))

    @builtins.property
    @jsii.member(jsii_name="systemnameInput")
    def systemname_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "systemnameInput"))

    @builtins.property
    @jsii.member(jsii_name="useraccountInput")
    def useraccount_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechsystemsUseraccount"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2MeditechsystemsUseraccount"]]], jsii.get(self, "useraccountInput"))

    @builtins.property
    @jsii.member(jsii_name="listenerip")
    def listenerip(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "listenerip"))

    @listenerip.setter
    def listenerip(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5083d3b3fd12bdf434902c04d391b3cb22c6e61d21fe241f7dd24df7d07f834)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "listenerip", value)

    @builtins.property
    @jsii.member(jsii_name="listenerport")
    def listenerport(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "listenerport"))

    @listenerport.setter
    def listenerport(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9ccb11f36118439a895efafa68df3b4fe924f75f7503e5fa24766b5fc97222f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "listenerport", value)

    @builtins.property
    @jsii.member(jsii_name="mbftimeout")
    def mbftimeout(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "mbftimeout"))

    @mbftimeout.setter
    def mbftimeout(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2548b8c75672d5d0e352db2b4c6193fdb88dce701bfccd442a019f73adbba126)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "mbftimeout", value)

    @builtins.property
    @jsii.member(jsii_name="systemname")
    def systemname(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "systemname"))

    @systemname.setter
    def systemname(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19fe19e0dff54a4ce32977d6d2013a6cf4168813363b861e57296641756fbc25)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "systemname", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditechsystems]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditechsystems]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Meditechsystems]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c33225dea45b477f0e1408c5c997ec0c2022e7525113b72bfa2c0a6b334af21)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechsystemsUseraccount",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2MeditechsystemsUseraccount:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b54e6d8487b5ce814adc36f07cc73b871cac7d2d619d71724d944851e68d6bd)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2MeditechsystemsUseraccount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2MeditechsystemsUseraccountList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechsystemsUseraccountList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df31b166d8cee8a716fd65abfe5f85f355b4aca7727af7c634ab2af29529406d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2MeditechsystemsUseraccountOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b35f0b608c88508696990c97ec1b296860894c7969a8d1f73ff106796238bea4)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2MeditechsystemsUseraccountOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__625e1a6f07599b87d4d8038b08a110cfba787de99cf51bc1b7c853bdfa6994e3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28bfae9d6c4738553650df9e2c535d2e038f239692da9892af26c6e8aba7b3a1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b71d8bfda730958f85da7aa32b389e7d9b01e2211b696f51d3c1475ac110618)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechsystemsUseraccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechsystemsUseraccount]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2MeditechsystemsUseraccount]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84e363801c560f3e5c13ada500588375ee584f2dc3ca25edc88a7fb081485fd8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2MeditechsystemsUseraccountOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2MeditechsystemsUseraccountOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c94f0594986760592b810d018c34862619202b7ef0e899b7dac30ead9752c0b)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d775c28099fcf71dc84655ca425aa7eaa0f415cf730ea5d3fd6300a6d0f42bc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8a81307b9c1c318e4b4c927e40ca2636ae23facec98eaed8d16da76f317a238)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechsystemsUseraccount]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechsystemsUseraccount]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2MeditechsystemsUseraccount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f3d12fef5beca8e41b7ca88502af2052ec7348474462ef19a15c532ba863be5c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Plan",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2Plan:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__116c8f46e62c07489bb308d6ab7f49a6668cbd70c3bbbb99df7e7b4bf1c23104)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Plan(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2PlanList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2PlanList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5631227acc95999b06784e7e6572336e01587d7b92f06ef5996a388ce7fb89e4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2PlanOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33b68215c19473dbc1bf2b3db8f5c404ef60fe6181d13bdea6471d3b78914652)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2PlanOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b6b22636b22715dbc192ff9c76ee4c497413e3280db0591ae4a511f503e0e887)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26b89708a012661eacda3d122682500999243019e6b0a02f3483a23c8d0c1f4d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f05bcdb9e8daa3055ae4b57cbc72a525026ee38b36933b19d2afc0ab7ff35d17)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Plan]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Plan]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Plan]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a28560b69587e4b2bfbe32a7381c19065158d0275a086860e1871d0922c2b139)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2PlanOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2PlanOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__81ceab3a6db02532d8714bb06122c48abedf4d8c1e8a897e60673522c66cabb0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e139afb2c2cc171ae17b8cc6d858cb562711be169cb5a41a2739698eec3c37ce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baa36398fb70be5aa89fca181b020684a31bb3de6af2a9f45839ae3c573b51b5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Plan]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Plan]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Plan]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ffceaad4ecaf1ef0ba7bce66c4b34c80938be8dc8cb582bd79b1612d53578e3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Securityassociations",
    jsii_struct_bases=[],
    name_mapping={
        "externalusergroup": "externalusergroup",
        "iscreatorassociation": "iscreatorassociation",
        "permissionlist": "permissionlist",
        "role": "role",
        "user": "user",
        "usergroup": "usergroup",
    },
)
class VmgroupV2Securityassociations:
    def __init__(
        self,
        *,
        externalusergroup: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsExternalusergroup", typing.Dict[builtins.str, typing.Any]]]]] = None,
        iscreatorassociation: typing.Optional[builtins.str] = None,
        permissionlist: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsPermissionlistStruct", typing.Dict[builtins.str, typing.Any]]]]] = None,
        role: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsRole", typing.Dict[builtins.str, typing.Any]]]]] = None,
        user: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsUser", typing.Dict[builtins.str, typing.Any]]]]] = None,
        usergroup: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsUsergroup", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param externalusergroup: externalusergroup block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#externalusergroup VmgroupV2#externalusergroup}
        :param iscreatorassociation: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#iscreatorassociation VmgroupV2#iscreatorassociation}.
        :param permissionlist: permissionlist block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionlist VmgroupV2#permissionlist}
        :param role: role block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#role VmgroupV2#role}
        :param user: user block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#user VmgroupV2#user}
        :param usergroup: usergroup block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usergroup VmgroupV2#usergroup}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ec8a249251e999045e20df48cc4dae8e711d2a74985ba604a94dd3bfeb97b561)
            check_type(argname="argument externalusergroup", value=externalusergroup, expected_type=type_hints["externalusergroup"])
            check_type(argname="argument iscreatorassociation", value=iscreatorassociation, expected_type=type_hints["iscreatorassociation"])
            check_type(argname="argument permissionlist", value=permissionlist, expected_type=type_hints["permissionlist"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
            check_type(argname="argument usergroup", value=usergroup, expected_type=type_hints["usergroup"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if externalusergroup is not None:
            self._values["externalusergroup"] = externalusergroup
        if iscreatorassociation is not None:
            self._values["iscreatorassociation"] = iscreatorassociation
        if permissionlist is not None:
            self._values["permissionlist"] = permissionlist
        if role is not None:
            self._values["role"] = role
        if user is not None:
            self._values["user"] = user
        if usergroup is not None:
            self._values["usergroup"] = usergroup

    @builtins.property
    def externalusergroup(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsExternalusergroup"]]]:
        '''externalusergroup block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#externalusergroup VmgroupV2#externalusergroup}
        '''
        result = self._values.get("externalusergroup")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsExternalusergroup"]]], result)

    @builtins.property
    def iscreatorassociation(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#iscreatorassociation VmgroupV2#iscreatorassociation}.'''
        result = self._values.get("iscreatorassociation")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def permissionlist(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsPermissionlistStruct"]]]:
        '''permissionlist block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionlist VmgroupV2#permissionlist}
        '''
        result = self._values.get("permissionlist")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsPermissionlistStruct"]]], result)

    @builtins.property
    def role(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsRole"]]]:
        '''role block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#role VmgroupV2#role}
        '''
        result = self._values.get("role")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsRole"]]], result)

    @builtins.property
    def user(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUser"]]]:
        '''user block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#user VmgroupV2#user}
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUser"]]], result)

    @builtins.property
    def usergroup(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUsergroup"]]]:
        '''usergroup block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usergroup VmgroupV2#usergroup}
        '''
        result = self._values.get("usergroup")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUsergroup"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Securityassociations(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsExternalusergroup",
    jsii_struct_bases=[],
    name_mapping={
        "id": "id",
        "name": "name",
        "providerid": "providerid",
        "providername": "providername",
    },
)
class VmgroupV2SecurityassociationsExternalusergroup:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        providerid: typing.Optional[jsii.Number] = None,
        providername: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: User Group Id. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id} Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: External Group Name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param providerid: Provider id. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providerid VmgroupV2#providerid}
        :param providername: Provider Name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providername VmgroupV2#providername}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ed7e3288f20133a1885c1dc3eb8a3d08f12fe03885e3f4d284adf2152dec814)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument providerid", value=providerid, expected_type=type_hints["providerid"])
            check_type(argname="argument providername", value=providername, expected_type=type_hints["providername"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name
        if providerid is not None:
            self._values["providerid"] = providerid
        if providername is not None:
            self._values["providername"] = providername

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''User Group Id.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''External Group Name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def providerid(self) -> typing.Optional[jsii.Number]:
        '''Provider id.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providerid VmgroupV2#providerid}
        '''
        result = self._values.get("providerid")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def providername(self) -> typing.Optional[builtins.str]:
        '''Provider Name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#providername VmgroupV2#providername}
        '''
        result = self._values.get("providername")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SecurityassociationsExternalusergroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SecurityassociationsExternalusergroupList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsExternalusergroupList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0347b74b19b3dff2e99f1745e0c9c2428661f89df94d7b6192fa108204311fc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SecurityassociationsExternalusergroupOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__905590a2705335bb4a86f01f2095d87a2b4ac643f880849bc2a34553ad542ee2)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsExternalusergroupOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b447ed969fcbd35310fe966916cafacb6468b423c4b387ad9f654fcec1d7ac4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b02ef711e4b2665f080ca503a151aec2081358d91996e505d17f8a1caf5ae911)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dd062595b6e8ee6e921d5919cfd79a942f835875b285e6617748d9dc620adba4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsExternalusergroup]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsExternalusergroup]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsExternalusergroup]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b8136e84ef8586dfc3baa643df0c44896158767c68125b991e8160e66c32d47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsExternalusergroupOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsExternalusergroupOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24d78b880b3e4ea13d503c250a65c2c4a5e78cb0d6673ccdfe60d75d747b7df3)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetProviderid")
    def reset_providerid(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProviderid", []))

    @jsii.member(jsii_name="resetProvidername")
    def reset_providername(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetProvidername", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="provideridInput")
    def providerid_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "provideridInput"))

    @builtins.property
    @jsii.member(jsii_name="providernameInput")
    def providername_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "providernameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7766ec2cd411b669df47e00e4c9ce4f16f95a303ae14ec35f79b22e5ead3703)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46fec4bd0838da506b0353450828dc00e7cf71668b7532a26ce11403881cab84)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="providerid")
    def providerid(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "providerid"))

    @providerid.setter
    def providerid(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2abfed16b87cc5e34caf39ed438d2b9418523f0b7b4b67552c14500b432ea4c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "providerid", value)

    @builtins.property
    @jsii.member(jsii_name="providername")
    def providername(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "providername"))

    @providername.setter
    def providername(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49f6993b3c0ad6bd6d570197523d9ce8a33282d92e0c9fb10b2d9ef547f21065)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "providername", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsExternalusergroup]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsExternalusergroup]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsExternalusergroup]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53d9779abdcf1cea889aa6e9605beb584732e647edf57c52925778a6c65f151e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a01e90526d0099d99e1a9831c38c96f830b497ec8b43945cef1d31cc21a88360)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2SecurityassociationsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77257ba62b2600ca5237fdff42f672ed897d557d3fe2a3e3ee13660847790d44)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7c1ba123ac3115b6f84dfca5d018d3c8188b31f928f050e15e2337b799a4ad5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c3f75ed5ebd6d175f0437baddf5d709c4810b2053cc66450173cc2f8ed0cd6e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f02790dd4617e0d70fde8e81b875e43fad08f708b27cdebe3cc473281b4fc2aa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Securityassociations]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Securityassociations]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Securityassociations]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__559f696f6c77858bfdb7735112b5a16d03192fed162ff60f95b55015bf5a7be6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__060b1971911d169c3e548fa46d4b275cc35210485eac01afb626d52ca12e4aeb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putExternalusergroup")
    def put_externalusergroup(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SecurityassociationsExternalusergroup, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__05e17d8bb6e702af6904d706d9b6ac2334888434bbc18afc699459ef8dee297f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putExternalusergroup", [value]))

    @jsii.member(jsii_name="putPermissionlist")
    def put_permissionlist(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsPermissionlistStruct", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71f26d181d8a1ac4c8ef46781375c6e64adea505e74821ca5130af6730c541f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putPermissionlist", [value]))

    @jsii.member(jsii_name="putRole")
    def put_role(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsRole", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9deb3129d10be49f5161a7c85abbe4285c5c9c43518ebe33cd4a1ae45e20143)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRole", [value]))

    @jsii.member(jsii_name="putUser")
    def put_user(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsUser", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ed80ac30ecad78ad0e811a24eff1285d3bf0a77e762d4eefda28867050cd030)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUser", [value]))

    @jsii.member(jsii_name="putUsergroup")
    def put_usergroup(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SecurityassociationsUsergroup", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3960e7e603a6d5c8d7a9e3d55af493c7597c83340a3b8b77dddd895f39e80629)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putUsergroup", [value]))

    @jsii.member(jsii_name="resetExternalusergroup")
    def reset_externalusergroup(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetExternalusergroup", []))

    @jsii.member(jsii_name="resetIscreatorassociation")
    def reset_iscreatorassociation(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIscreatorassociation", []))

    @jsii.member(jsii_name="resetPermissionlist")
    def reset_permissionlist(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPermissionlist", []))

    @jsii.member(jsii_name="resetRole")
    def reset_role(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRole", []))

    @jsii.member(jsii_name="resetUser")
    def reset_user(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUser", []))

    @jsii.member(jsii_name="resetUsergroup")
    def reset_usergroup(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUsergroup", []))

    @builtins.property
    @jsii.member(jsii_name="externalusergroup")
    def externalusergroup(self) -> VmgroupV2SecurityassociationsExternalusergroupList:
        return typing.cast(VmgroupV2SecurityassociationsExternalusergroupList, jsii.get(self, "externalusergroup"))

    @builtins.property
    @jsii.member(jsii_name="permissionlist")
    def permissionlist(self) -> "VmgroupV2SecurityassociationsPermissionlistStructList":
        return typing.cast("VmgroupV2SecurityassociationsPermissionlistStructList", jsii.get(self, "permissionlist"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> "VmgroupV2SecurityassociationsRoleList":
        return typing.cast("VmgroupV2SecurityassociationsRoleList", jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> "VmgroupV2SecurityassociationsUserList":
        return typing.cast("VmgroupV2SecurityassociationsUserList", jsii.get(self, "user"))

    @builtins.property
    @jsii.member(jsii_name="usergroup")
    def usergroup(self) -> "VmgroupV2SecurityassociationsUsergroupList":
        return typing.cast("VmgroupV2SecurityassociationsUsergroupList", jsii.get(self, "usergroup"))

    @builtins.property
    @jsii.member(jsii_name="externalusergroupInput")
    def externalusergroup_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsExternalusergroup]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsExternalusergroup]]], jsii.get(self, "externalusergroupInput"))

    @builtins.property
    @jsii.member(jsii_name="iscreatorassociationInput")
    def iscreatorassociation_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "iscreatorassociationInput"))

    @builtins.property
    @jsii.member(jsii_name="permissionlistInput")
    def permissionlist_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsPermissionlistStruct"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsPermissionlistStruct"]]], jsii.get(self, "permissionlistInput"))

    @builtins.property
    @jsii.member(jsii_name="roleInput")
    def role_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsRole"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsRole"]]], jsii.get(self, "roleInput"))

    @builtins.property
    @jsii.member(jsii_name="usergroupInput")
    def usergroup_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUsergroup"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUsergroup"]]], jsii.get(self, "usergroupInput"))

    @builtins.property
    @jsii.member(jsii_name="userInput")
    def user_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUser"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SecurityassociationsUser"]]], jsii.get(self, "userInput"))

    @builtins.property
    @jsii.member(jsii_name="iscreatorassociation")
    def iscreatorassociation(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "iscreatorassociation"))

    @iscreatorassociation.setter
    def iscreatorassociation(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__624a81119c181dc46b088aafc63675cfc03931ff4d3bad986a86015c42cd1cc8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "iscreatorassociation", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Securityassociations]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Securityassociations]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Securityassociations]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a03f65ba3f82a13ef0cd91b19de681c19e1b0702bffba0d0345121cbed5b68d5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsPermissionlistStruct",
    jsii_struct_bases=[],
    name_mapping={
        "categoryid": "categoryid",
        "categoryname": "categoryname",
        "exclude": "exclude",
        "permissionid": "permissionid",
        "permissionname": "permissionname",
        "type": "type",
    },
)
class VmgroupV2SecurityassociationsPermissionlistStruct:
    def __init__(
        self,
        *,
        categoryid: typing.Optional[jsii.Number] = None,
        categoryname: typing.Optional[builtins.str] = None,
        exclude: typing.Optional[builtins.str] = None,
        permissionid: typing.Optional[jsii.Number] = None,
        permissionname: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param categoryid: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryid VmgroupV2#categoryid}.
        :param categoryname: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryname VmgroupV2#categoryname}.
        :param exclude: Flag to specify if this is included permission or excluded permission. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#exclude VmgroupV2#exclude}
        :param permissionid: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionid VmgroupV2#permissionid}.
        :param permissionname: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionname VmgroupV2#permissionname}.
        :param type: Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e359168f63441d820e7012ef7213cc0f60c0c1f5ec5a8d6111c60854db63e83)
            check_type(argname="argument categoryid", value=categoryid, expected_type=type_hints["categoryid"])
            check_type(argname="argument categoryname", value=categoryname, expected_type=type_hints["categoryname"])
            check_type(argname="argument exclude", value=exclude, expected_type=type_hints["exclude"])
            check_type(argname="argument permissionid", value=permissionid, expected_type=type_hints["permissionid"])
            check_type(argname="argument permissionname", value=permissionname, expected_type=type_hints["permissionname"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if categoryid is not None:
            self._values["categoryid"] = categoryid
        if categoryname is not None:
            self._values["categoryname"] = categoryname
        if exclude is not None:
            self._values["exclude"] = exclude
        if permissionid is not None:
            self._values["permissionid"] = permissionid
        if permissionname is not None:
            self._values["permissionname"] = permissionname
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def categoryid(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryid VmgroupV2#categoryid}.'''
        result = self._values.get("categoryid")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def categoryname(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#categoryname VmgroupV2#categoryname}.'''
        result = self._values.get("categoryname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def exclude(self) -> typing.Optional[builtins.str]:
        '''Flag to specify if this is included permission or excluded permission.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#exclude VmgroupV2#exclude}
        '''
        result = self._values.get("exclude")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def permissionid(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionid VmgroupV2#permissionid}.'''
        result = self._values.get("permissionid")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def permissionname(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#permissionname VmgroupV2#permissionname}.'''
        result = self._values.get("permissionname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Returns the type of association. [ALL_CATEGORIES, CATEGORY_ENTITY, PERMISSION_ENTITY].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#type VmgroupV2#type}
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SecurityassociationsPermissionlistStruct(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SecurityassociationsPermissionlistStructList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsPermissionlistStructList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d679230b7e49b99f1a6d052e29c548c13254531f897724a61477d2dadc1578f3)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SecurityassociationsPermissionlistStructOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b18a700bd2cf6dd6362c06b2d9263030e30ee8345d2b4baa3617700d79c234cf)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsPermissionlistStructOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d51dc8b320a527f85f9d8b69cc8f6e35a45bca9962717bd9121df6b281aec86d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7af4f522dc442636195b75d4e8b54a9d337aa7a8b5b4d6775267826d9681029)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23e516b73c61e983c5a87cef5efebf61ecbb72e6c59fd273009d3cd5924faa90)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsPermissionlistStruct]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsPermissionlistStruct]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsPermissionlistStruct]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3588c2e40eaf10c356c765f1afce36c70ee14de9adb87482b0719a247e8fb47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsPermissionlistStructOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsPermissionlistStructOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c5655e005d7a618c35b411cbb93fec96c7ce66f3052a460df394201645e8561)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetCategoryid")
    def reset_categoryid(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCategoryid", []))

    @jsii.member(jsii_name="resetCategoryname")
    def reset_categoryname(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCategoryname", []))

    @jsii.member(jsii_name="resetExclude")
    def reset_exclude(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetExclude", []))

    @jsii.member(jsii_name="resetPermissionid")
    def reset_permissionid(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPermissionid", []))

    @jsii.member(jsii_name="resetPermissionname")
    def reset_permissionname(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPermissionname", []))

    @jsii.member(jsii_name="resetType")
    def reset_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetType", []))

    @builtins.property
    @jsii.member(jsii_name="categoryidInput")
    def categoryid_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "categoryidInput"))

    @builtins.property
    @jsii.member(jsii_name="categorynameInput")
    def categoryname_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "categorynameInput"))

    @builtins.property
    @jsii.member(jsii_name="excludeInput")
    def exclude_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "excludeInput"))

    @builtins.property
    @jsii.member(jsii_name="permissionidInput")
    def permissionid_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "permissionidInput"))

    @builtins.property
    @jsii.member(jsii_name="permissionnameInput")
    def permissionname_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "permissionnameInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="categoryid")
    def categoryid(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "categoryid"))

    @categoryid.setter
    def categoryid(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e385cd1529be299ddc74bc51d88f931624e883ebcd6e3aa40dae5f5dc4fc378c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "categoryid", value)

    @builtins.property
    @jsii.member(jsii_name="categoryname")
    def categoryname(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "categoryname"))

    @categoryname.setter
    def categoryname(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68b44391238fe621cd083c4ab8b32b482468660ec46136816a87feac665dd249)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "categoryname", value)

    @builtins.property
    @jsii.member(jsii_name="exclude")
    def exclude(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "exclude"))

    @exclude.setter
    def exclude(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dec51ba2e622dda55ee15448da5302b6c9d83d414fa3fb7fde25f3a55d062105)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "exclude", value)

    @builtins.property
    @jsii.member(jsii_name="permissionid")
    def permissionid(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "permissionid"))

    @permissionid.setter
    def permissionid(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54a8e2890f3cb4bcd41dfe96030bde9faca3469cdd185e521c0d66bec30dc8f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "permissionid", value)

    @builtins.property
    @jsii.member(jsii_name="permissionname")
    def permissionname(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "permissionname"))

    @permissionname.setter
    def permissionname(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8040e617df469fc21effe87d2e0b4becfce503f766b230b5c6a17269f18fb8c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "permissionname", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43f7b1a7d5cb2d36f0aa149b7584a36aa4c2252871376cdead10a11d4bf36b13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsPermissionlistStruct]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsPermissionlistStruct]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsPermissionlistStruct]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f3e81e9270e0ae6aaba278324a1e58b14ed1af889b84b644a2d06e2bc3c8da08)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsRole",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SecurityassociationsRole:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc91c59464d88e530b1a022124262a08c78f56c9c3e446cf43df3adfbc45ce2e)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SecurityassociationsRole(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SecurityassociationsRoleList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsRoleList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b561c133e8ba80551dbcb64c92dd8f8813b41ece414f769691581f14594c258c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SecurityassociationsRoleOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__234ced3fc1dc4051a4e8c078637a2123ff7d05b91a96fd70c1f9a74d30902dc7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsRoleOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc4709f17d62016f023c13c6e43b457ad3577b25ba8a66383353301618ef2f7f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e872322c36cac31c5866dabd3cdbb3ce3dfd3aea617c9e013eeab2bec14c018d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ed6d50e3596a566a4e70abd36caa5adc9707a8ca6513df4883d74a82817fc47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsRole]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsRole]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsRole]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91f478b9aafaaf6160e8cb8a86d4ca702c8fd0fd984c992e728b649c2b20a572)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsRoleOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsRoleOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1813fd4359624589355312fc7a2b758e956947eb83069184f64fd11468952b52)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__029846c4394708d5a59cc107a82da64282dced848247aed72778dc0d9db5952c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__545a8ebf5e9e2939d90709a68095d9c8399b0b2a17828d476d17399f0b63d288)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsRole]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsRole]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsRole]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9340eec94050469497998536b405c644c37b1e939356d8d4f941f79fda8b1e84)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUser",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SecurityassociationsUser:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f7e3a8958a337bb18b641cb7a46143b95f44d23e6c0c163194c701fd6f04369)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SecurityassociationsUser(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SecurityassociationsUserList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUserList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fdf54bc23edf913bdbf02db11854c2e525c886229d20d2b7b6d71c2f534ea3ae)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SecurityassociationsUserOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3352f75104c1fa3332b51a55c768a9f58f7a1b69f47a1ef454e71fdba2ef23e7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsUserOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4244ecb80c86048dfe1929ef39574d354f174b4f4b33e7480f971296a09fa974)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87ced1bbec73274f4844e6aaf7e45ac0cec048be1120c8b365a442ef88311b58)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49f83d2762e935c54aed00101625ae117cf570455f4eeb5b7f3a9f63e2543a40)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUser]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUser]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUser]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a1405c378e3e498c5cbb3eed8676cb9eb618aadfeb8c344aa0692a3e22f301cd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsUserOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUserOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4df89dff562c44a82ef766b07477d32d442c399d605f475c547b18693fb8051)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d49354d86cbc18d5cc73d1c81d571093d21b95287b97e5aa0da7cc7519ef0f5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d192c4ab0404bceca82b286d4685ec26080c9989a40ae3f91d3287dde73f841)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUser]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUser]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUser]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96970aeb08530ad33d36b1411708486b487752d017d45d4d3dbe0c3c5e1df921)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUsergroup",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SecurityassociationsUsergroup:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf88382657e80b180bbcadcad4cb8ac44259a2d8c6dc53b62b906978fd62cd08)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SecurityassociationsUsergroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SecurityassociationsUsergroupList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUsergroupList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc30c8c3c14f02bf42ffdfdc3a97b3cdf031fb4a807a6e515860acd444a09912)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SecurityassociationsUsergroupOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2542b8efb49c032e2604ec40a2da7bb0b56071a82a0b7452678b3790f7b0b265)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SecurityassociationsUsergroupOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bb93a8fb6a1ed97be2f87fe13c423550e700655ca9a13447dcfd0741e17fb8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__120c3c841365bed507f452e268f05f046b8c85b725dd4c2ae64f9f1c1d80388d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4586c9a36d1831124a71f1b233e752ec9a3e47ee05a9cc8f3f64c017c58a8781)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUsergroup]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUsergroup]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SecurityassociationsUsergroup]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b983bd1d5bcb94c167a3ccabd6b189bb3fa6d1ae579ac5f772966da7dbb32f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SecurityassociationsUsergroupOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SecurityassociationsUsergroupOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b58968966c332ae50b84ca46ca368b0ba456b525746b84782a845268d14620bc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4aa4020879bd5d5b074cabe4734099cc75de933fb109b9e3ef4603073145e551)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c64696b0f0f4570f84a19f202ea9d0c035308f9289357df64bcf851fba7b1b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUsergroup]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUsergroup]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SecurityassociationsUsergroup]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c8fd2595d8760ed1ed9ae8f3ce0de58ae0a06712e630ed4a9941938adea72fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Settings",
    jsii_struct_bases=[],
    name_mapping={
        "allowemptysubclient": "allowemptysubclient",
        "autodetectvmowner": "autodetectvmowner",
        "collectfiledetailsforgranularrecovery": "collectfiledetailsforgranularrecovery",
        "collectfiledetailsfromsnapshotcopy": "collectfiledetailsfromsnapshotcopy",
        "crossaccount": "crossaccount",
        "customsnapshotresourcegroup": "customsnapshotresourcegroup",
        "customsnapshottags": "customsnapshottags",
        "datastorefreespacecheck": "datastorefreespacecheck",
        "datastorefreespacerequired": "datastorefreespacerequired",
        "guestcredentials": "guestcredentials",
        "isapplicationaware": "isapplicationaware",
        "isvmgroupdiskfiltersincluded": "isvmgroupdiskfiltersincluded",
        "jobstarttime": "jobstarttime",
        "noofreaders": "noofreaders",
        "regionalsnapshot": "regionalsnapshot",
        "transportmode": "transportmode",
        "usechangedblocktrackingonvm": "usechangedblocktrackingonvm",
        "usevmcheckpointsetting": "usevmcheckpointsetting",
        "vmbackuptype": "vmbackuptype",
    },
)
class VmgroupV2Settings:
    def __init__(
        self,
        *,
        allowemptysubclient: typing.Optional[builtins.str] = None,
        autodetectvmowner: typing.Optional[builtins.str] = None,
        collectfiledetailsforgranularrecovery: typing.Optional[builtins.str] = None,
        collectfiledetailsfromsnapshotcopy: typing.Optional[builtins.str] = None,
        crossaccount: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsCrossaccount", typing.Dict[builtins.str, typing.Any]]]]] = None,
        customsnapshotresourcegroup: typing.Optional[builtins.str] = None,
        customsnapshottags: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsCustomsnapshottags", typing.Dict[builtins.str, typing.Any]]]]] = None,
        datastorefreespacecheck: typing.Optional[builtins.str] = None,
        datastorefreespacerequired: typing.Optional[jsii.Number] = None,
        guestcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsGuestcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        isapplicationaware: typing.Optional[builtins.str] = None,
        isvmgroupdiskfiltersincluded: typing.Optional[builtins.str] = None,
        jobstarttime: typing.Optional[jsii.Number] = None,
        noofreaders: typing.Optional[jsii.Number] = None,
        regionalsnapshot: typing.Optional[builtins.str] = None,
        transportmode: typing.Optional[builtins.str] = None,
        usechangedblocktrackingonvm: typing.Optional[builtins.str] = None,
        usevmcheckpointsetting: typing.Optional[builtins.str] = None,
        vmbackuptype: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param allowemptysubclient: True if empty subclient is allowed. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#allowemptysubclient VmgroupV2#allowemptysubclient}
        :param autodetectvmowner: True if auto detect VM Owner enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#autodetectvmowner VmgroupV2#autodetectvmowner}
        :param collectfiledetailsforgranularrecovery: True if metadata collection is enabled. Only applicable for Indexing v1. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsforgranularrecovery VmgroupV2#collectfiledetailsforgranularrecovery}
        :param collectfiledetailsfromsnapshotcopy: True if metadata collection is enabled for intellisnap jobs. Only applicable for Indexing v1. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsfromsnapshotcopy VmgroupV2#collectfiledetailsfromsnapshotcopy}
        :param crossaccount: crossaccount block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#crossaccount VmgroupV2#crossaccount}
        :param customsnapshotresourcegroup: Custom snapshot resource group name for Azure. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshotresourcegroup VmgroupV2#customsnapshotresourcegroup}
        :param customsnapshottags: customsnapshottags block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshottags VmgroupV2#customsnapshottags}
        :param datastorefreespacecheck: True if Datastore Free space check is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacecheck VmgroupV2#datastorefreespacecheck}
        :param datastorefreespacerequired: precentage of datastore free space check value. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacerequired VmgroupV2#datastorefreespacerequired}
        :param guestcredentials: guestcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
        :param isapplicationaware: Is the VM App Aware. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isapplicationaware VmgroupV2#isapplicationaware}
        :param isvmgroupdiskfiltersincluded: Is VM group disk filters included in VM instance disk filters. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isvmgroupdiskfiltersincluded VmgroupV2#isvmgroupdiskfiltersincluded}
        :param jobstarttime: Start Time for the VM Group Job. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#jobstarttime VmgroupV2#jobstarttime}
        :param noofreaders: Number of readers for backup. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#noofreaders VmgroupV2#noofreaders}
        :param regionalsnapshot: True when snapshot storage location is regional. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#regionalsnapshot VmgroupV2#regionalsnapshot}
        :param transportmode: transport mode based on environment. Values are case sensitive [AUTO, SAN, HOT_ADD, NAS, NBD_SSL, NBD]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#transportmode VmgroupV2#transportmode}
        :param usechangedblocktrackingonvm: True if Changed Block Tracking is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usechangedblocktrackingonvm VmgroupV2#usechangedblocktrackingonvm}
        :param usevmcheckpointsetting: True if use VM CheckPoint setting is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usevmcheckpointsetting VmgroupV2#usevmcheckpointsetting}
        :param vmbackuptype: [APPLICATION_AWARE, FILE_SYSTEM_AND_APPLICATION_CONSISTENT, CRASH_CONSISTENT, APP_BASED_BACKUP, INHERITED]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmbackuptype VmgroupV2#vmbackuptype}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71b07148e54c45ce4ad8e8d2d9ef422e96c36185f621bb3b3dba4c2f63310320)
            check_type(argname="argument allowemptysubclient", value=allowemptysubclient, expected_type=type_hints["allowemptysubclient"])
            check_type(argname="argument autodetectvmowner", value=autodetectvmowner, expected_type=type_hints["autodetectvmowner"])
            check_type(argname="argument collectfiledetailsforgranularrecovery", value=collectfiledetailsforgranularrecovery, expected_type=type_hints["collectfiledetailsforgranularrecovery"])
            check_type(argname="argument collectfiledetailsfromsnapshotcopy", value=collectfiledetailsfromsnapshotcopy, expected_type=type_hints["collectfiledetailsfromsnapshotcopy"])
            check_type(argname="argument crossaccount", value=crossaccount, expected_type=type_hints["crossaccount"])
            check_type(argname="argument customsnapshotresourcegroup", value=customsnapshotresourcegroup, expected_type=type_hints["customsnapshotresourcegroup"])
            check_type(argname="argument customsnapshottags", value=customsnapshottags, expected_type=type_hints["customsnapshottags"])
            check_type(argname="argument datastorefreespacecheck", value=datastorefreespacecheck, expected_type=type_hints["datastorefreespacecheck"])
            check_type(argname="argument datastorefreespacerequired", value=datastorefreespacerequired, expected_type=type_hints["datastorefreespacerequired"])
            check_type(argname="argument guestcredentials", value=guestcredentials, expected_type=type_hints["guestcredentials"])
            check_type(argname="argument isapplicationaware", value=isapplicationaware, expected_type=type_hints["isapplicationaware"])
            check_type(argname="argument isvmgroupdiskfiltersincluded", value=isvmgroupdiskfiltersincluded, expected_type=type_hints["isvmgroupdiskfiltersincluded"])
            check_type(argname="argument jobstarttime", value=jobstarttime, expected_type=type_hints["jobstarttime"])
            check_type(argname="argument noofreaders", value=noofreaders, expected_type=type_hints["noofreaders"])
            check_type(argname="argument regionalsnapshot", value=regionalsnapshot, expected_type=type_hints["regionalsnapshot"])
            check_type(argname="argument transportmode", value=transportmode, expected_type=type_hints["transportmode"])
            check_type(argname="argument usechangedblocktrackingonvm", value=usechangedblocktrackingonvm, expected_type=type_hints["usechangedblocktrackingonvm"])
            check_type(argname="argument usevmcheckpointsetting", value=usevmcheckpointsetting, expected_type=type_hints["usevmcheckpointsetting"])
            check_type(argname="argument vmbackuptype", value=vmbackuptype, expected_type=type_hints["vmbackuptype"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if allowemptysubclient is not None:
            self._values["allowemptysubclient"] = allowemptysubclient
        if autodetectvmowner is not None:
            self._values["autodetectvmowner"] = autodetectvmowner
        if collectfiledetailsforgranularrecovery is not None:
            self._values["collectfiledetailsforgranularrecovery"] = collectfiledetailsforgranularrecovery
        if collectfiledetailsfromsnapshotcopy is not None:
            self._values["collectfiledetailsfromsnapshotcopy"] = collectfiledetailsfromsnapshotcopy
        if crossaccount is not None:
            self._values["crossaccount"] = crossaccount
        if customsnapshotresourcegroup is not None:
            self._values["customsnapshotresourcegroup"] = customsnapshotresourcegroup
        if customsnapshottags is not None:
            self._values["customsnapshottags"] = customsnapshottags
        if datastorefreespacecheck is not None:
            self._values["datastorefreespacecheck"] = datastorefreespacecheck
        if datastorefreespacerequired is not None:
            self._values["datastorefreespacerequired"] = datastorefreespacerequired
        if guestcredentials is not None:
            self._values["guestcredentials"] = guestcredentials
        if isapplicationaware is not None:
            self._values["isapplicationaware"] = isapplicationaware
        if isvmgroupdiskfiltersincluded is not None:
            self._values["isvmgroupdiskfiltersincluded"] = isvmgroupdiskfiltersincluded
        if jobstarttime is not None:
            self._values["jobstarttime"] = jobstarttime
        if noofreaders is not None:
            self._values["noofreaders"] = noofreaders
        if regionalsnapshot is not None:
            self._values["regionalsnapshot"] = regionalsnapshot
        if transportmode is not None:
            self._values["transportmode"] = transportmode
        if usechangedblocktrackingonvm is not None:
            self._values["usechangedblocktrackingonvm"] = usechangedblocktrackingonvm
        if usevmcheckpointsetting is not None:
            self._values["usevmcheckpointsetting"] = usevmcheckpointsetting
        if vmbackuptype is not None:
            self._values["vmbackuptype"] = vmbackuptype

    @builtins.property
    def allowemptysubclient(self) -> typing.Optional[builtins.str]:
        '''True if empty subclient is allowed.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#allowemptysubclient VmgroupV2#allowemptysubclient}
        '''
        result = self._values.get("allowemptysubclient")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def autodetectvmowner(self) -> typing.Optional[builtins.str]:
        '''True if auto detect VM Owner enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#autodetectvmowner VmgroupV2#autodetectvmowner}
        '''
        result = self._values.get("autodetectvmowner")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def collectfiledetailsforgranularrecovery(self) -> typing.Optional[builtins.str]:
        '''True if metadata collection is enabled. Only applicable for Indexing v1.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsforgranularrecovery VmgroupV2#collectfiledetailsforgranularrecovery}
        '''
        result = self._values.get("collectfiledetailsforgranularrecovery")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def collectfiledetailsfromsnapshotcopy(self) -> typing.Optional[builtins.str]:
        '''True if metadata collection is enabled for intellisnap jobs. Only applicable for Indexing v1.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#collectfiledetailsfromsnapshotcopy VmgroupV2#collectfiledetailsfromsnapshotcopy}
        '''
        result = self._values.get("collectfiledetailsfromsnapshotcopy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def crossaccount(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCrossaccount"]]]:
        '''crossaccount block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#crossaccount VmgroupV2#crossaccount}
        '''
        result = self._values.get("crossaccount")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCrossaccount"]]], result)

    @builtins.property
    def customsnapshotresourcegroup(self) -> typing.Optional[builtins.str]:
        '''Custom snapshot resource group name for Azure.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshotresourcegroup VmgroupV2#customsnapshotresourcegroup}
        '''
        result = self._values.get("customsnapshotresourcegroup")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def customsnapshottags(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCustomsnapshottags"]]]:
        '''customsnapshottags block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#customsnapshottags VmgroupV2#customsnapshottags}
        '''
        result = self._values.get("customsnapshottags")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCustomsnapshottags"]]], result)

    @builtins.property
    def datastorefreespacecheck(self) -> typing.Optional[builtins.str]:
        '''True if Datastore Free space check is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacecheck VmgroupV2#datastorefreespacecheck}
        '''
        result = self._values.get("datastorefreespacecheck")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def datastorefreespacerequired(self) -> typing.Optional[jsii.Number]:
        '''precentage of datastore free space check value.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#datastorefreespacerequired VmgroupV2#datastorefreespacerequired}
        '''
        result = self._values.get("datastorefreespacerequired")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def guestcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentials"]]]:
        '''guestcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#guestcredentials VmgroupV2#guestcredentials}
        '''
        result = self._values.get("guestcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentials"]]], result)

    @builtins.property
    def isapplicationaware(self) -> typing.Optional[builtins.str]:
        '''Is the VM App Aware.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isapplicationaware VmgroupV2#isapplicationaware}
        '''
        result = self._values.get("isapplicationaware")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def isvmgroupdiskfiltersincluded(self) -> typing.Optional[builtins.str]:
        '''Is VM group disk filters included in VM instance disk filters.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isvmgroupdiskfiltersincluded VmgroupV2#isvmgroupdiskfiltersincluded}
        '''
        result = self._values.get("isvmgroupdiskfiltersincluded")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def jobstarttime(self) -> typing.Optional[jsii.Number]:
        '''Start Time for the VM Group Job.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#jobstarttime VmgroupV2#jobstarttime}
        '''
        result = self._values.get("jobstarttime")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def noofreaders(self) -> typing.Optional[jsii.Number]:
        '''Number of readers for backup.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#noofreaders VmgroupV2#noofreaders}
        '''
        result = self._values.get("noofreaders")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def regionalsnapshot(self) -> typing.Optional[builtins.str]:
        '''True when snapshot storage location is regional.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#regionalsnapshot VmgroupV2#regionalsnapshot}
        '''
        result = self._values.get("regionalsnapshot")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def transportmode(self) -> typing.Optional[builtins.str]:
        '''transport mode based on environment. Values are case sensitive [AUTO, SAN, HOT_ADD, NAS, NBD_SSL, NBD].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#transportmode VmgroupV2#transportmode}
        '''
        result = self._values.get("transportmode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def usechangedblocktrackingonvm(self) -> typing.Optional[builtins.str]:
        '''True if Changed Block Tracking is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usechangedblocktrackingonvm VmgroupV2#usechangedblocktrackingonvm}
        '''
        result = self._values.get("usechangedblocktrackingonvm")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def usevmcheckpointsetting(self) -> typing.Optional[builtins.str]:
        '''True if use VM CheckPoint setting is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#usevmcheckpointsetting VmgroupV2#usevmcheckpointsetting}
        '''
        result = self._values.get("usevmcheckpointsetting")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def vmbackuptype(self) -> typing.Optional[builtins.str]:
        '''[APPLICATION_AWARE, FILE_SYSTEM_AND_APPLICATION_CONSISTENT, CRASH_CONSISTENT, APP_BASED_BACKUP, INHERITED].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmbackuptype VmgroupV2#vmbackuptype}
        '''
        result = self._values.get("vmbackuptype")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Settings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccount",
    jsii_struct_bases=[],
    name_mapping={
        "destinationaccount": "destinationaccount",
        "fullcopy": "fullcopy",
        "shareonly": "shareonly",
    },
)
class VmgroupV2SettingsCrossaccount:
    def __init__(
        self,
        *,
        destinationaccount: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsCrossaccountDestinationaccount", typing.Dict[builtins.str, typing.Any]]]]] = None,
        fullcopy: typing.Optional[builtins.str] = None,
        shareonly: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param destinationaccount: destinationaccount block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#destinationaccount VmgroupV2#destinationaccount}
        :param fullcopy: True if full copy of amazon snapshot to different amazon account is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#fullcopy VmgroupV2#fullcopy}
        :param shareonly: True if replicate and copy or sharing of amazon snapshot to different amazon account in same or different geographic location is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#shareonly VmgroupV2#shareonly}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb5eff771a0f0992de6bca7f156989e166ac5c62a8ff0b0255ce21da486bc391)
            check_type(argname="argument destinationaccount", value=destinationaccount, expected_type=type_hints["destinationaccount"])
            check_type(argname="argument fullcopy", value=fullcopy, expected_type=type_hints["fullcopy"])
            check_type(argname="argument shareonly", value=shareonly, expected_type=type_hints["shareonly"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if destinationaccount is not None:
            self._values["destinationaccount"] = destinationaccount
        if fullcopy is not None:
            self._values["fullcopy"] = fullcopy
        if shareonly is not None:
            self._values["shareonly"] = shareonly

    @builtins.property
    def destinationaccount(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCrossaccountDestinationaccount"]]]:
        '''destinationaccount block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#destinationaccount VmgroupV2#destinationaccount}
        '''
        result = self._values.get("destinationaccount")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsCrossaccountDestinationaccount"]]], result)

    @builtins.property
    def fullcopy(self) -> typing.Optional[builtins.str]:
        '''True if full copy of amazon snapshot to different amazon account is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#fullcopy VmgroupV2#fullcopy}
        '''
        result = self._values.get("fullcopy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shareonly(self) -> typing.Optional[builtins.str]:
        '''True if replicate and copy or sharing of amazon snapshot to different amazon account in same or different geographic location is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#shareonly VmgroupV2#shareonly}
        '''
        result = self._values.get("shareonly")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsCrossaccount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccountDestinationaccount",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SettingsCrossaccountDestinationaccount:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab33321d8442d9a4e5dc98a9def8eaa5e5db88d5a0b7a0e396da2fa88cd5093e)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsCrossaccountDestinationaccount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SettingsCrossaccountDestinationaccountList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccountDestinationaccountList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2954dce4581ce3fec6f5748af2e0b543a8c99b46e12b21527c05dc0a2805c989)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SettingsCrossaccountDestinationaccountOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b4cc1f9a71771d660ae468f7ec2fdf92d8545a6233d192a620cee411a09477e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsCrossaccountDestinationaccountOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__656cf74707234054730fb125757eeba0ad2e7f06f29abbf030f8a26a98ff9588)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0f8473283cf286537d06350338b77561a38de1c20fb68f46ebc9362ac7c5177)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0679c3bb6cc7e018a0376a3ec0c851d199a678629a4c0d5085b856152076deb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccountDestinationaccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccountDestinationaccount]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccountDestinationaccount]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e53d07b7863266bafb184d9f447759d0b1dcb554ad6bf0beafad937cc698319)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsCrossaccountDestinationaccountOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccountDestinationaccountOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65fc9550feadb50d53466baba7cb1a8edaced810209fae3bc76e8c9216bea580)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da5d82f99b8acda8b701cdd008a325660ad469699efcefc15f0862b3c88eb08a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12aaf3dec48b438354c731c6b158cf490e5dcb21d832738eba5d9b14d6ffe5f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccountDestinationaccount]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccountDestinationaccount]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccountDestinationaccount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52dfa9013bbd0f5fdf327795c2580b356c384104af2b6c990e1d2c250dce1d47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsCrossaccountList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccountList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7ee1d0c75245034dda03f15fe7c28a6bc16980ea30c60aab0068fb2b9ad400d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2SettingsCrossaccountOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac771fd0021c39648a6d0f381a98329d598ccbf4c4dcc661d2bdc92ff9144f2e)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsCrossaccountOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__220ff45bc08169ac722b5f8ae058f3f96bd5f064df933b1d8f8af0c78ebffb17)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__555e527a02696c3869048a7f81266cd83bc66092713d21b684ed9d28da171eac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2980ccbce352d131ca27206fec4d3592c7916f9c3de1bbf4299026e997c8efc4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccount]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccount]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f2e735a7d12a12ce34b88fb0a072f0f133716b09d93699b3666904f5311c1553)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsCrossaccountOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCrossaccountOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e56252d6f362da571b36b51d991a88047834ba7bac2a00891da6a5a3660e68ae)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putDestinationaccount")
    def put_destinationaccount(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SettingsCrossaccountDestinationaccount, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ca9cb745a057eaea2e26cfea28fa81ccd0bb2b62fb58d6b26795df522f6c6f9d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putDestinationaccount", [value]))

    @jsii.member(jsii_name="resetDestinationaccount")
    def reset_destinationaccount(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDestinationaccount", []))

    @jsii.member(jsii_name="resetFullcopy")
    def reset_fullcopy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFullcopy", []))

    @jsii.member(jsii_name="resetShareonly")
    def reset_shareonly(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetShareonly", []))

    @builtins.property
    @jsii.member(jsii_name="destinationaccount")
    def destinationaccount(self) -> VmgroupV2SettingsCrossaccountDestinationaccountList:
        return typing.cast(VmgroupV2SettingsCrossaccountDestinationaccountList, jsii.get(self, "destinationaccount"))

    @builtins.property
    @jsii.member(jsii_name="destinationaccountInput")
    def destinationaccount_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccountDestinationaccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccountDestinationaccount]]], jsii.get(self, "destinationaccountInput"))

    @builtins.property
    @jsii.member(jsii_name="fullcopyInput")
    def fullcopy_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "fullcopyInput"))

    @builtins.property
    @jsii.member(jsii_name="shareonlyInput")
    def shareonly_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "shareonlyInput"))

    @builtins.property
    @jsii.member(jsii_name="fullcopy")
    def fullcopy(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "fullcopy"))

    @fullcopy.setter
    def fullcopy(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__450dd7a679c0e210706c54135e80a8e607b815022da839ab59623c5976253d8e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "fullcopy", value)

    @builtins.property
    @jsii.member(jsii_name="shareonly")
    def shareonly(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "shareonly"))

    @shareonly.setter
    def shareonly(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e71782df57ee788e0b71bd10c08f2d67df5a4e20d6ddf2f33f87405f6090cc5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "shareonly", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccount]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccount]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCrossaccount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cf66ed60cb1433195161738fe2f5614e39099b9089c29ea80000fd6f1dac631)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCustomsnapshottags",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class VmgroupV2SettingsCustomsnapshottags:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: represents name of the tag. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param value: represents value of the tag. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4970d8bdff9bbf3912fd52763389cb6c792ced15dd134e87aa81487e33bb2a48)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''represents name of the tag.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''represents value of the tag.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#value VmgroupV2#value}
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsCustomsnapshottags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SettingsCustomsnapshottagsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCustomsnapshottagsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70c3c098fa0c0e6f6dd35a8a74c7a9bef2f64c6354507e80b2a7a0b0d0c05ccf)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SettingsCustomsnapshottagsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ad53d6161b016c5040a596f27642d5281fee1aa288803fcc63d454e173c930f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsCustomsnapshottagsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65fdf294152cfdf74a853e17a24156f7100edcb93403d38831b963d0eb3dad93)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b748012c2c5bf2ebf54b5e163f8afed7a1c893908062dbade9999b6171c507c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf0f9e919a436c5225bc9a6dc5ec56e882a79428e8fa58366f42554398cb81fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCustomsnapshottags]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCustomsnapshottags]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCustomsnapshottags]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8017bec135f7a4510ce3588fb6db6ba0ccdf9cc4b8a0498dfbceaa91d6088d23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsCustomsnapshottagsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsCustomsnapshottagsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60cb02e66b5e621cc3ef5b10ced7a8bbaa1e30db0aa2d8f35e27b4155791a9a6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetValue")
    def reset_value(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetValue", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "valueInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f96d71436d99fb32ee112e0b10b87a66c0ca68f255219c035777011abb28ae4f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "value"))

    @value.setter
    def value(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71fc73a42d371e080e4cf748f9688dc6a6df5e93a51c00fb7dd49a8673cf6f7d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCustomsnapshottags]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCustomsnapshottags]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsCustomsnapshottags]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59b5dcb74cb4a88b87f62a0ad3d20e31bc164161352fb5cfc26598f75994e00d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentials",
    jsii_struct_bases=[],
    name_mapping={
        "credentials": "credentials",
        "savedcredentials": "savedcredentials",
    },
)
class VmgroupV2SettingsGuestcredentials:
    def __init__(
        self,
        *,
        credentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsGuestcredentialsCredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
        savedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsGuestcredentialsSavedcredentials", typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param credentials: credentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
        :param savedcredentials: savedcredentials block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bb2031ec179441f32aa691304ae0f99679b025947e51c9214e25a30589fb651)
            check_type(argname="argument credentials", value=credentials, expected_type=type_hints["credentials"])
            check_type(argname="argument savedcredentials", value=savedcredentials, expected_type=type_hints["savedcredentials"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if credentials is not None:
            self._values["credentials"] = credentials
        if savedcredentials is not None:
            self._values["savedcredentials"] = savedcredentials

    @builtins.property
    def credentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsCredentials"]]]:
        '''credentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#credentials VmgroupV2#credentials}
        '''
        result = self._values.get("credentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsCredentials"]]], result)

    @builtins.property
    def savedcredentials(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsSavedcredentials"]]]:
        '''savedcredentials block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#savedcredentials VmgroupV2#savedcredentials}
        '''
        result = self._values.get("savedcredentials")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsSavedcredentials"]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsGuestcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsCredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "password": "password"},
)
class VmgroupV2SettingsGuestcredentialsCredentials:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param name: username to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        :param password: password to access the network path. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__81c27e6d0dbf82bd22da9a2227d74f9bf68fc4b84fcf31b562dd767f8d585bd7)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''username to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''password to access the network path.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#password VmgroupV2#password}
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsGuestcredentialsCredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SettingsGuestcredentialsCredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsCredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fdae182e36d7b56222be9f9eabf382a92f8132a36a1ad0ee184844591a46477d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SettingsGuestcredentialsCredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baaf428e543d90327ed9f5267aae9f7250bb2bfc5532b93dad3b5b16d6808b49)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsGuestcredentialsCredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88b41193ea9899bc26a1ddbca6a00426ad7655323418290bfa8d466b9d4acb6b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92329f895e4ea86a7c9d826c9da87da58baa96e8b6a3effbb4a3d40732c28abe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ebe52816015eaf7c0620141306bade7ed1d7b22dfb5d89d9c800eb74b927cd3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsCredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsCredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsCredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a108d7911d793b7a08316bc0427c4d6550110a732ca78fb3ea4fb62e51ffda43)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsGuestcredentialsCredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsCredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__644d348ec40bbea35db4a2c933ca88e2d946de65814f62e531bb2d76caf5e9ef)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPassword", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "passwordInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5fb68d3e04bebd1b0d5fdab53f8cc5a5b702adf08baabf59381e4c661532e4e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "password"))

    @password.setter
    def password(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26ce29d2c7c4d8cc4d5ccb344b8ed6441d8a741feed3c8bb1bfb0780f510f460)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "password", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsCredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsCredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsCredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f870d755ea4642ef53bffbfc2e4cadefc0115ae48ac6b58d344a03d14285be0c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsGuestcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d43ad1ad7e2edd5dd7d75a77c3a0d2b9c92d82a4a528e99c69b0174ef4b529b)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SettingsGuestcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6443e5b465430c8f22f02fe8ec2d6f64ea10e9abcf1754010181af642f3b5004)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsGuestcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78026c464a704254b171d779dc5359139507d3bd3589aa71f29fe9c9fd1d7914)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64cf66a0a9905be79a797a93f9215762ecf1c51616a081a763f5d45033e747c8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a4466927b7af7fb2a6945e7d40ec3fb868bb924e13ed0e500ba3ab20e0ad896)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed4d0356e75120f258bb3045935e9c93430daac44f002004e8a1240792a9b995)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsGuestcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7071ca8667d7ef3f068b2f4977442b95453490d7c6123f16f4531e54e6c570ad)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putCredentials")
    def put_credentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SettingsGuestcredentialsCredentials, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee9e8894be87703903f0ed12d4bf2e0bb8032e4627bfb4e15f7990980bb4e743)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCredentials", [value]))

    @jsii.member(jsii_name="putSavedcredentials")
    def put_savedcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SettingsGuestcredentialsSavedcredentials", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33b740ded7996b3d5195f1ec6f5cf5d3f4e8e2b1dccd58b57843abbbc8bf573a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSavedcredentials", [value]))

    @jsii.member(jsii_name="resetCredentials")
    def reset_credentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCredentials", []))

    @jsii.member(jsii_name="resetSavedcredentials")
    def reset_savedcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSavedcredentials", []))

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(self) -> VmgroupV2SettingsGuestcredentialsCredentialsList:
        return typing.cast(VmgroupV2SettingsGuestcredentialsCredentialsList, jsii.get(self, "credentials"))

    @builtins.property
    @jsii.member(jsii_name="savedcredentials")
    def savedcredentials(
        self,
    ) -> "VmgroupV2SettingsGuestcredentialsSavedcredentialsList":
        return typing.cast("VmgroupV2SettingsGuestcredentialsSavedcredentialsList", jsii.get(self, "savedcredentials"))

    @builtins.property
    @jsii.member(jsii_name="credentialsInput")
    def credentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsCredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsCredentials]]], jsii.get(self, "credentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="savedcredentialsInput")
    def savedcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsSavedcredentials"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SettingsGuestcredentialsSavedcredentials"]]], jsii.get(self, "savedcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d72c714dde5e2cd15e94057a2c5330e9882de7f8ceb54371dddd2263861a554a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsSavedcredentials",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class VmgroupV2SettingsGuestcredentialsSavedcredentials:
    def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a896d8eeb69ae09354002a9d41e9aacb4830f8eeded54aa5c5a287bbb4ac53d6)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SettingsGuestcredentialsSavedcredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SettingsGuestcredentialsSavedcredentialsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsSavedcredentialsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31179b2201b62f9eae92b30778d6a51f97062c39b5aa7b1d56eb0b0282837336)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1dcf0a66e45c515c7d21bf053df195a11d08733254be7238b21066ef70109c71)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ef63fbf5b4293f7add4651a630d8d6cd580a37f791fa4c78a01cdc4191a3cb7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d114b23e8cdc264ac7882ad63bc51add0c6ce11aef4088b5732d198001df805)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0eae842a3abe87dde59fb76412c6455e1ca1d798d7c59d4f1bee4b43cb67ef3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsSavedcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsSavedcredentials]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentialsSavedcredentials]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64cf21fd4a239303767447cb333891f41dd0fd7144964b813b64a870e3ec484d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa8aaaf4ed00809a23572ae05d62fd15e98eda0233dd358a762285419db27aa5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__82bf394d158925653b9d62fd3ddb12c07a6e63177aa9012d9f2e95be8c144165)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsSavedcredentials]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsSavedcredentials]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SettingsGuestcredentialsSavedcredentials]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b502bb2bd1b05277e646059eaaf3325ec3e0d1941e218a5e9b78baeb6586a1d1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d1056301200dbc1a310b7d793d4f62759a49725a73b9fc8e27038fa2ce3afde0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2SettingsOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e6272fac3d19c32703e571207312af4ebd13c44f2273a6106cc740bd10dd77f)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SettingsOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__658b88375fac9a5b4f3234e33c3bcd1b68eb6d16551afee38dd1f0e9095e17a4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54e023cefb637989b8820139a1262e4614037d9226d43a3a64b8a86468eb4a02)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__286e028e11853ee796ad808a3fbdce57a0aac6d688136d74befbd03c0a610e73)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Settings]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Settings]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Settings]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12b076248bc1362e2f7761d207fa29f5dcdeb7f5a58d6b0b5ed956662388f6bb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SettingsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SettingsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e73642e61d79685d762a9d0395b3990087673f2b73216c4a0ae80697ab74e12)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putCrossaccount")
    def put_crossaccount(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SettingsCrossaccount, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba2af581ad78fc0108f6a8d7de6bc4b6984125d66bb8974e8a6acafdc7e401b4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCrossaccount", [value]))

    @jsii.member(jsii_name="putCustomsnapshottags")
    def put_customsnapshottags(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SettingsCustomsnapshottags, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0ea6ee531cb7929983133708a0ec3c1ee52a2a21ec5d1379aad39bb270db9b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putCustomsnapshottags", [value]))

    @jsii.member(jsii_name="putGuestcredentials")
    def put_guestcredentials(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2SettingsGuestcredentials, typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43cb0a8721e5256e1e4a2b79688f43987a1058eb38bc1235134f892170f10914)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putGuestcredentials", [value]))

    @jsii.member(jsii_name="resetAllowemptysubclient")
    def reset_allowemptysubclient(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAllowemptysubclient", []))

    @jsii.member(jsii_name="resetAutodetectvmowner")
    def reset_autodetectvmowner(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAutodetectvmowner", []))

    @jsii.member(jsii_name="resetCollectfiledetailsforgranularrecovery")
    def reset_collectfiledetailsforgranularrecovery(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCollectfiledetailsforgranularrecovery", []))

    @jsii.member(jsii_name="resetCollectfiledetailsfromsnapshotcopy")
    def reset_collectfiledetailsfromsnapshotcopy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCollectfiledetailsfromsnapshotcopy", []))

    @jsii.member(jsii_name="resetCrossaccount")
    def reset_crossaccount(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCrossaccount", []))

    @jsii.member(jsii_name="resetCustomsnapshotresourcegroup")
    def reset_customsnapshotresourcegroup(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomsnapshotresourcegroup", []))

    @jsii.member(jsii_name="resetCustomsnapshottags")
    def reset_customsnapshottags(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomsnapshottags", []))

    @jsii.member(jsii_name="resetDatastorefreespacecheck")
    def reset_datastorefreespacecheck(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDatastorefreespacecheck", []))

    @jsii.member(jsii_name="resetDatastorefreespacerequired")
    def reset_datastorefreespacerequired(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDatastorefreespacerequired", []))

    @jsii.member(jsii_name="resetGuestcredentials")
    def reset_guestcredentials(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGuestcredentials", []))

    @jsii.member(jsii_name="resetIsapplicationaware")
    def reset_isapplicationaware(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsapplicationaware", []))

    @jsii.member(jsii_name="resetIsvmgroupdiskfiltersincluded")
    def reset_isvmgroupdiskfiltersincluded(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsvmgroupdiskfiltersincluded", []))

    @jsii.member(jsii_name="resetJobstarttime")
    def reset_jobstarttime(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetJobstarttime", []))

    @jsii.member(jsii_name="resetNoofreaders")
    def reset_noofreaders(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNoofreaders", []))

    @jsii.member(jsii_name="resetRegionalsnapshot")
    def reset_regionalsnapshot(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRegionalsnapshot", []))

    @jsii.member(jsii_name="resetTransportmode")
    def reset_transportmode(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTransportmode", []))

    @jsii.member(jsii_name="resetUsechangedblocktrackingonvm")
    def reset_usechangedblocktrackingonvm(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUsechangedblocktrackingonvm", []))

    @jsii.member(jsii_name="resetUsevmcheckpointsetting")
    def reset_usevmcheckpointsetting(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUsevmcheckpointsetting", []))

    @jsii.member(jsii_name="resetVmbackuptype")
    def reset_vmbackuptype(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetVmbackuptype", []))

    @builtins.property
    @jsii.member(jsii_name="crossaccount")
    def crossaccount(self) -> VmgroupV2SettingsCrossaccountList:
        return typing.cast(VmgroupV2SettingsCrossaccountList, jsii.get(self, "crossaccount"))

    @builtins.property
    @jsii.member(jsii_name="customsnapshottags")
    def customsnapshottags(self) -> VmgroupV2SettingsCustomsnapshottagsList:
        return typing.cast(VmgroupV2SettingsCustomsnapshottagsList, jsii.get(self, "customsnapshottags"))

    @builtins.property
    @jsii.member(jsii_name="guestcredentials")
    def guestcredentials(self) -> VmgroupV2SettingsGuestcredentialsList:
        return typing.cast(VmgroupV2SettingsGuestcredentialsList, jsii.get(self, "guestcredentials"))

    @builtins.property
    @jsii.member(jsii_name="allowemptysubclientInput")
    def allowemptysubclient_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "allowemptysubclientInput"))

    @builtins.property
    @jsii.member(jsii_name="autodetectvmownerInput")
    def autodetectvmowner_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "autodetectvmownerInput"))

    @builtins.property
    @jsii.member(jsii_name="collectfiledetailsforgranularrecoveryInput")
    def collectfiledetailsforgranularrecovery_input(
        self,
    ) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "collectfiledetailsforgranularrecoveryInput"))

    @builtins.property
    @jsii.member(jsii_name="collectfiledetailsfromsnapshotcopyInput")
    def collectfiledetailsfromsnapshotcopy_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "collectfiledetailsfromsnapshotcopyInput"))

    @builtins.property
    @jsii.member(jsii_name="crossaccountInput")
    def crossaccount_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccount]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCrossaccount]]], jsii.get(self, "crossaccountInput"))

    @builtins.property
    @jsii.member(jsii_name="customsnapshotresourcegroupInput")
    def customsnapshotresourcegroup_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customsnapshotresourcegroupInput"))

    @builtins.property
    @jsii.member(jsii_name="customsnapshottagsInput")
    def customsnapshottags_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCustomsnapshottags]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsCustomsnapshottags]]], jsii.get(self, "customsnapshottagsInput"))

    @builtins.property
    @jsii.member(jsii_name="datastorefreespacecheckInput")
    def datastorefreespacecheck_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "datastorefreespacecheckInput"))

    @builtins.property
    @jsii.member(jsii_name="datastorefreespacerequiredInput")
    def datastorefreespacerequired_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "datastorefreespacerequiredInput"))

    @builtins.property
    @jsii.member(jsii_name="guestcredentialsInput")
    def guestcredentials_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentials]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SettingsGuestcredentials]]], jsii.get(self, "guestcredentialsInput"))

    @builtins.property
    @jsii.member(jsii_name="isapplicationawareInput")
    def isapplicationaware_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isapplicationawareInput"))

    @builtins.property
    @jsii.member(jsii_name="isvmgroupdiskfiltersincludedInput")
    def isvmgroupdiskfiltersincluded_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isvmgroupdiskfiltersincludedInput"))

    @builtins.property
    @jsii.member(jsii_name="jobstarttimeInput")
    def jobstarttime_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "jobstarttimeInput"))

    @builtins.property
    @jsii.member(jsii_name="noofreadersInput")
    def noofreaders_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "noofreadersInput"))

    @builtins.property
    @jsii.member(jsii_name="regionalsnapshotInput")
    def regionalsnapshot_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionalsnapshotInput"))

    @builtins.property
    @jsii.member(jsii_name="transportmodeInput")
    def transportmode_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "transportmodeInput"))

    @builtins.property
    @jsii.member(jsii_name="usechangedblocktrackingonvmInput")
    def usechangedblocktrackingonvm_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "usechangedblocktrackingonvmInput"))

    @builtins.property
    @jsii.member(jsii_name="usevmcheckpointsettingInput")
    def usevmcheckpointsetting_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "usevmcheckpointsettingInput"))

    @builtins.property
    @jsii.member(jsii_name="vmbackuptypeInput")
    def vmbackuptype_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vmbackuptypeInput"))

    @builtins.property
    @jsii.member(jsii_name="allowemptysubclient")
    def allowemptysubclient(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "allowemptysubclient"))

    @allowemptysubclient.setter
    def allowemptysubclient(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__064b05d1b239eca2ba882787bfd844f71f3e8ea0a3646ea1fd67125723ebbb2d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "allowemptysubclient", value)

    @builtins.property
    @jsii.member(jsii_name="autodetectvmowner")
    def autodetectvmowner(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "autodetectvmowner"))

    @autodetectvmowner.setter
    def autodetectvmowner(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89289d4cfdd099e7111eb1a5f8ee8e24c61e25fac12c5293570771dcefb6d21e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "autodetectvmowner", value)

    @builtins.property
    @jsii.member(jsii_name="collectfiledetailsforgranularrecovery")
    def collectfiledetailsforgranularrecovery(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "collectfiledetailsforgranularrecovery"))

    @collectfiledetailsforgranularrecovery.setter
    def collectfiledetailsforgranularrecovery(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f437105292c2125f77d6dd72c8917d455faaa55039abe386e08281443784fd85)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "collectfiledetailsforgranularrecovery", value)

    @builtins.property
    @jsii.member(jsii_name="collectfiledetailsfromsnapshotcopy")
    def collectfiledetailsfromsnapshotcopy(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "collectfiledetailsfromsnapshotcopy"))

    @collectfiledetailsfromsnapshotcopy.setter
    def collectfiledetailsfromsnapshotcopy(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5af8b8ece5bedeb640006051183b3fee7813441b9ec9ede105b84dc629b9da44)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "collectfiledetailsfromsnapshotcopy", value)

    @builtins.property
    @jsii.member(jsii_name="customsnapshotresourcegroup")
    def customsnapshotresourcegroup(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customsnapshotresourcegroup"))

    @customsnapshotresourcegroup.setter
    def customsnapshotresourcegroup(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b12119d1cdfe21cef7196e26d1196f49371b43a33d4fa579c4724565fa94e944)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customsnapshotresourcegroup", value)

    @builtins.property
    @jsii.member(jsii_name="datastorefreespacecheck")
    def datastorefreespacecheck(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "datastorefreespacecheck"))

    @datastorefreespacecheck.setter
    def datastorefreespacecheck(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__492eff525130087c32a2f3408435d24753df94eb20055c99cd188786e35ba379)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "datastorefreespacecheck", value)

    @builtins.property
    @jsii.member(jsii_name="datastorefreespacerequired")
    def datastorefreespacerequired(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "datastorefreespacerequired"))

    @datastorefreespacerequired.setter
    def datastorefreespacerequired(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00b8e6de88d897de900c9b9e67835ad7f4dad5798a3c1e198bc28c83f7da5d4f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "datastorefreespacerequired", value)

    @builtins.property
    @jsii.member(jsii_name="isapplicationaware")
    def isapplicationaware(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isapplicationaware"))

    @isapplicationaware.setter
    def isapplicationaware(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df9bb1ee9ec76ec249e68614f41b3ea589e2de1e0f8c7671197e536332a561cb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isapplicationaware", value)

    @builtins.property
    @jsii.member(jsii_name="isvmgroupdiskfiltersincluded")
    def isvmgroupdiskfiltersincluded(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isvmgroupdiskfiltersincluded"))

    @isvmgroupdiskfiltersincluded.setter
    def isvmgroupdiskfiltersincluded(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__210abc626ba0182108b20cac22c922ee82bf44b6a1ee5cecb626a351f1f0a56d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isvmgroupdiskfiltersincluded", value)

    @builtins.property
    @jsii.member(jsii_name="jobstarttime")
    def jobstarttime(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "jobstarttime"))

    @jobstarttime.setter
    def jobstarttime(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df84fc35eb5d55831f518fe334445a14f3e66a245004178f12419a5d40177be3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobstarttime", value)

    @builtins.property
    @jsii.member(jsii_name="noofreaders")
    def noofreaders(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "noofreaders"))

    @noofreaders.setter
    def noofreaders(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa06537c37c19781c1cf90a47932e80bdb010dbb849c0699fd3ec61cd0711306)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "noofreaders", value)

    @builtins.property
    @jsii.member(jsii_name="regionalsnapshot")
    def regionalsnapshot(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "regionalsnapshot"))

    @regionalsnapshot.setter
    def regionalsnapshot(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b57568cab3aa1e2a7f1a96e735fb37da82a611649d156d19bb2864f28ec0957)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "regionalsnapshot", value)

    @builtins.property
    @jsii.member(jsii_name="transportmode")
    def transportmode(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "transportmode"))

    @transportmode.setter
    def transportmode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49c0c7b4b4b89f13f9d32c17d535eb47c64eeb0dbce83713c777944f8507c7fb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "transportmode", value)

    @builtins.property
    @jsii.member(jsii_name="usechangedblocktrackingonvm")
    def usechangedblocktrackingonvm(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "usechangedblocktrackingonvm"))

    @usechangedblocktrackingonvm.setter
    def usechangedblocktrackingonvm(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c4b5c6d96bd8c1b6054f142fcde0462c269c98daa8f75a50b2155f3f344fc3c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "usechangedblocktrackingonvm", value)

    @builtins.property
    @jsii.member(jsii_name="usevmcheckpointsetting")
    def usevmcheckpointsetting(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "usevmcheckpointsetting"))

    @usevmcheckpointsetting.setter
    def usevmcheckpointsetting(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c0470dda7ef076e7b61fe95d0a86675eb6b6905f0b332cdcf4eeefb26992fd1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "usevmcheckpointsetting", value)

    @builtins.property
    @jsii.member(jsii_name="vmbackuptype")
    def vmbackuptype(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vmbackuptype"))

    @vmbackuptype.setter
    def vmbackuptype(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c5471e373fc818ba89617b32c506df281ff5e14ca4c654167245453bff877be5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vmbackuptype", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Settings]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Settings]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Settings]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c16d025945b29e362ced12936ac4f8cdb880cd6904e19ab89defa337b179cf9a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Snapshotmanagement",
    jsii_struct_bases=[],
    name_mapping={
        "backupcopyinterface": "backupcopyinterface",
        "enablehardwaresnapshot": "enablehardwaresnapshot",
        "isindependentdisksenabled": "isindependentdisksenabled",
        "israwdevicemapsenabled": "israwdevicemapsenabled",
        "snapengine": "snapengine",
        "snapmountesxhost": "snapmountesxhost",
        "snapmountproxy": "snapmountproxy",
        "useseparateproxyforsnaptotape": "useseparateproxyforsnaptotape",
        "vmapplicationusername": "vmapplicationusername",
    },
)
class VmgroupV2Snapshotmanagement:
    def __init__(
        self,
        *,
        backupcopyinterface: typing.Optional[builtins.str] = None,
        enablehardwaresnapshot: typing.Optional[builtins.str] = None,
        isindependentdisksenabled: typing.Optional[builtins.str] = None,
        israwdevicemapsenabled: typing.Optional[builtins.str] = None,
        snapengine: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SnapshotmanagementSnapengine", typing.Dict[builtins.str, typing.Any]]]]] = None,
        snapmountesxhost: typing.Optional[builtins.str] = None,
        snapmountproxy: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SnapshotmanagementSnapmountproxy", typing.Dict[builtins.str, typing.Any]]]]] = None,
        useseparateproxyforsnaptotape: typing.Optional[builtins.str] = None,
        vmapplicationusername: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param backupcopyinterface: [FILE_SYSTEM, RMAN, VOLUME_COPY]. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupcopyinterface VmgroupV2#backupcopyinterface}
        :param enablehardwaresnapshot: True if hardware snapshot is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablehardwaresnapshot VmgroupV2#enablehardwaresnapshot}
        :param isindependentdisksenabled: True if independent disk option is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isindependentdisksenabled VmgroupV2#isindependentdisksenabled}
        :param israwdevicemapsenabled: True if raw device maps option is enabled. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#israwdevicemapsenabled VmgroupV2#israwdevicemapsenabled}
        :param snapengine: snapengine block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapengine VmgroupV2#snapengine}
        :param snapmountesxhost: Name of ESX Host. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountesxhost VmgroupV2#snapmountesxhost}
        :param snapmountproxy: snapmountproxy block. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountproxy VmgroupV2#snapmountproxy}
        :param useseparateproxyforsnaptotape: True if separate proxy client is used for snap to tape. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useseparateproxyforsnaptotape VmgroupV2#useseparateproxyforsnaptotape}
        :param vmapplicationusername: Virtual machine application user name. Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmapplicationusername VmgroupV2#vmapplicationusername}
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2bf0828b693903780314647893c5efb14568f2b379ca3a9d33f2b6685d8a2a7)
            check_type(argname="argument backupcopyinterface", value=backupcopyinterface, expected_type=type_hints["backupcopyinterface"])
            check_type(argname="argument enablehardwaresnapshot", value=enablehardwaresnapshot, expected_type=type_hints["enablehardwaresnapshot"])
            check_type(argname="argument isindependentdisksenabled", value=isindependentdisksenabled, expected_type=type_hints["isindependentdisksenabled"])
            check_type(argname="argument israwdevicemapsenabled", value=israwdevicemapsenabled, expected_type=type_hints["israwdevicemapsenabled"])
            check_type(argname="argument snapengine", value=snapengine, expected_type=type_hints["snapengine"])
            check_type(argname="argument snapmountesxhost", value=snapmountesxhost, expected_type=type_hints["snapmountesxhost"])
            check_type(argname="argument snapmountproxy", value=snapmountproxy, expected_type=type_hints["snapmountproxy"])
            check_type(argname="argument useseparateproxyforsnaptotape", value=useseparateproxyforsnaptotape, expected_type=type_hints["useseparateproxyforsnaptotape"])
            check_type(argname="argument vmapplicationusername", value=vmapplicationusername, expected_type=type_hints["vmapplicationusername"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if backupcopyinterface is not None:
            self._values["backupcopyinterface"] = backupcopyinterface
        if enablehardwaresnapshot is not None:
            self._values["enablehardwaresnapshot"] = enablehardwaresnapshot
        if isindependentdisksenabled is not None:
            self._values["isindependentdisksenabled"] = isindependentdisksenabled
        if israwdevicemapsenabled is not None:
            self._values["israwdevicemapsenabled"] = israwdevicemapsenabled
        if snapengine is not None:
            self._values["snapengine"] = snapengine
        if snapmountesxhost is not None:
            self._values["snapmountesxhost"] = snapmountesxhost
        if snapmountproxy is not None:
            self._values["snapmountproxy"] = snapmountproxy
        if useseparateproxyforsnaptotape is not None:
            self._values["useseparateproxyforsnaptotape"] = useseparateproxyforsnaptotape
        if vmapplicationusername is not None:
            self._values["vmapplicationusername"] = vmapplicationusername

    @builtins.property
    def backupcopyinterface(self) -> typing.Optional[builtins.str]:
        '''[FILE_SYSTEM, RMAN, VOLUME_COPY].

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#backupcopyinterface VmgroupV2#backupcopyinterface}
        '''
        result = self._values.get("backupcopyinterface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enablehardwaresnapshot(self) -> typing.Optional[builtins.str]:
        '''True if hardware snapshot is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#enablehardwaresnapshot VmgroupV2#enablehardwaresnapshot}
        '''
        result = self._values.get("enablehardwaresnapshot")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def isindependentdisksenabled(self) -> typing.Optional[builtins.str]:
        '''True if independent disk option is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#isindependentdisksenabled VmgroupV2#isindependentdisksenabled}
        '''
        result = self._values.get("isindependentdisksenabled")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def israwdevicemapsenabled(self) -> typing.Optional[builtins.str]:
        '''True if raw device maps option is enabled.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#israwdevicemapsenabled VmgroupV2#israwdevicemapsenabled}
        '''
        result = self._values.get("israwdevicemapsenabled")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def snapengine(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapengine"]]]:
        '''snapengine block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapengine VmgroupV2#snapengine}
        '''
        result = self._values.get("snapengine")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapengine"]]], result)

    @builtins.property
    def snapmountesxhost(self) -> typing.Optional[builtins.str]:
        '''Name of ESX Host.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountesxhost VmgroupV2#snapmountesxhost}
        '''
        result = self._values.get("snapmountesxhost")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def snapmountproxy(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapmountproxy"]]]:
        '''snapmountproxy block.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#snapmountproxy VmgroupV2#snapmountproxy}
        '''
        result = self._values.get("snapmountproxy")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapmountproxy"]]], result)

    @builtins.property
    def useseparateproxyforsnaptotape(self) -> typing.Optional[builtins.str]:
        '''True if separate proxy client is used for snap to tape.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#useseparateproxyforsnaptotape VmgroupV2#useseparateproxyforsnaptotape}
        '''
        result = self._values.get("useseparateproxyforsnaptotape")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def vmapplicationusername(self) -> typing.Optional[builtins.str]:
        '''Virtual machine application user name.

        Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#vmapplicationusername VmgroupV2#vmapplicationusername}
        '''
        result = self._values.get("vmapplicationusername")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Snapshotmanagement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SnapshotmanagementList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d951b1b60c6478ddbf9c44983edf0e9204a2ddae0a8bb1a33c0671238d4ac06c)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2SnapshotmanagementOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d9f4e6df15d3d516782fb155659cce1d6369e056f973afea01c66c0e53b6574)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SnapshotmanagementOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1874fa81d8155998886c60cc88c2a14e7a25283c19e5599a349383eb81ccc2b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73ad8605e155d8f319e50c070261cd4204de8b634e614c865a02946ff9d0e8bf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__964ae631ada17e4e7ae47fa54ec8f3f849bc5b09712c028d6f534a5f4320a074)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Snapshotmanagement]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Snapshotmanagement]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Snapshotmanagement]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7f8ef50edff6f4f5b7f800e37a1c8408756a069d7aee870757ed3bae4c22993)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SnapshotmanagementOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69198d2f3347a65ac9e248673be6ca6ce6f887b77e1b20f4875dc548d6a38fc5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putSnapengine")
    def put_snapengine(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SnapshotmanagementSnapengine", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e81322c9213e7c2c7ee5f5c60c3522653ae686d4c5d6a56598845b41f17729e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSnapengine", [value]))

    @jsii.member(jsii_name="putSnapmountproxy")
    def put_snapmountproxy(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["VmgroupV2SnapshotmanagementSnapmountproxy", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cea0422010d77795eb1c245b668fef6d549029251a07034de9980eb9d6514069)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putSnapmountproxy", [value]))

    @jsii.member(jsii_name="resetBackupcopyinterface")
    def reset_backupcopyinterface(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBackupcopyinterface", []))

    @jsii.member(jsii_name="resetEnablehardwaresnapshot")
    def reset_enablehardwaresnapshot(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnablehardwaresnapshot", []))

    @jsii.member(jsii_name="resetIsindependentdisksenabled")
    def reset_isindependentdisksenabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsindependentdisksenabled", []))

    @jsii.member(jsii_name="resetIsrawdevicemapsenabled")
    def reset_israwdevicemapsenabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetIsrawdevicemapsenabled", []))

    @jsii.member(jsii_name="resetSnapengine")
    def reset_snapengine(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSnapengine", []))

    @jsii.member(jsii_name="resetSnapmountesxhost")
    def reset_snapmountesxhost(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSnapmountesxhost", []))

    @jsii.member(jsii_name="resetSnapmountproxy")
    def reset_snapmountproxy(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSnapmountproxy", []))

    @jsii.member(jsii_name="resetUseseparateproxyforsnaptotape")
    def reset_useseparateproxyforsnaptotape(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUseseparateproxyforsnaptotape", []))

    @jsii.member(jsii_name="resetVmapplicationusername")
    def reset_vmapplicationusername(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetVmapplicationusername", []))

    @builtins.property
    @jsii.member(jsii_name="snapengine")
    def snapengine(self) -> "VmgroupV2SnapshotmanagementSnapengineList":
        return typing.cast("VmgroupV2SnapshotmanagementSnapengineList", jsii.get(self, "snapengine"))

    @builtins.property
    @jsii.member(jsii_name="snapmountproxy")
    def snapmountproxy(self) -> "VmgroupV2SnapshotmanagementSnapmountproxyList":
        return typing.cast("VmgroupV2SnapshotmanagementSnapmountproxyList", jsii.get(self, "snapmountproxy"))

    @builtins.property
    @jsii.member(jsii_name="backupcopyinterfaceInput")
    def backupcopyinterface_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "backupcopyinterfaceInput"))

    @builtins.property
    @jsii.member(jsii_name="enablehardwaresnapshotInput")
    def enablehardwaresnapshot_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "enablehardwaresnapshotInput"))

    @builtins.property
    @jsii.member(jsii_name="isindependentdisksenabledInput")
    def isindependentdisksenabled_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "isindependentdisksenabledInput"))

    @builtins.property
    @jsii.member(jsii_name="israwdevicemapsenabledInput")
    def israwdevicemapsenabled_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "israwdevicemapsenabledInput"))

    @builtins.property
    @jsii.member(jsii_name="snapengineInput")
    def snapengine_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapengine"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapengine"]]], jsii.get(self, "snapengineInput"))

    @builtins.property
    @jsii.member(jsii_name="snapmountesxhostInput")
    def snapmountesxhost_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "snapmountesxhostInput"))

    @builtins.property
    @jsii.member(jsii_name="snapmountproxyInput")
    def snapmountproxy_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapmountproxy"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["VmgroupV2SnapshotmanagementSnapmountproxy"]]], jsii.get(self, "snapmountproxyInput"))

    @builtins.property
    @jsii.member(jsii_name="useseparateproxyforsnaptotapeInput")
    def useseparateproxyforsnaptotape_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "useseparateproxyforsnaptotapeInput"))

    @builtins.property
    @jsii.member(jsii_name="vmapplicationusernameInput")
    def vmapplicationusername_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "vmapplicationusernameInput"))

    @builtins.property
    @jsii.member(jsii_name="backupcopyinterface")
    def backupcopyinterface(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "backupcopyinterface"))

    @backupcopyinterface.setter
    def backupcopyinterface(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5708ddff12c41c73a430f4c380f8f39f1ca4cb2ae0bec608f33b14b152904345)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "backupcopyinterface", value)

    @builtins.property
    @jsii.member(jsii_name="enablehardwaresnapshot")
    def enablehardwaresnapshot(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "enablehardwaresnapshot"))

    @enablehardwaresnapshot.setter
    def enablehardwaresnapshot(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c87f2165a0d962eea270ff9213403613d3d043243929a23f3c668650431a5a6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enablehardwaresnapshot", value)

    @builtins.property
    @jsii.member(jsii_name="isindependentdisksenabled")
    def isindependentdisksenabled(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "isindependentdisksenabled"))

    @isindependentdisksenabled.setter
    def isindependentdisksenabled(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ded26553502c4dd1a5ab49fc6aa909d7eb768c6a7e3a36036916d417cc2aefd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "isindependentdisksenabled", value)

    @builtins.property
    @jsii.member(jsii_name="israwdevicemapsenabled")
    def israwdevicemapsenabled(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "israwdevicemapsenabled"))

    @israwdevicemapsenabled.setter
    def israwdevicemapsenabled(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79ec50f8a2d2e1f2f51fb1ec57f632f56c1c8a4d6133897fbf4841d331e6660e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "israwdevicemapsenabled", value)

    @builtins.property
    @jsii.member(jsii_name="snapmountesxhost")
    def snapmountesxhost(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "snapmountesxhost"))

    @snapmountesxhost.setter
    def snapmountesxhost(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6870b732b7558b989d4bde81b32582ed587b94f2876c2ca532d001710b42ed79)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "snapmountesxhost", value)

    @builtins.property
    @jsii.member(jsii_name="useseparateproxyforsnaptotape")
    def useseparateproxyforsnaptotape(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "useseparateproxyforsnaptotape"))

    @useseparateproxyforsnaptotape.setter
    def useseparateproxyforsnaptotape(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6ee2a6b12b05bef08644c8085fbde25b005c9f92c8e3583c31bc7d2f93bd080)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "useseparateproxyforsnaptotape", value)

    @builtins.property
    @jsii.member(jsii_name="vmapplicationusername")
    def vmapplicationusername(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "vmapplicationusername"))

    @vmapplicationusername.setter
    def vmapplicationusername(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a683b98287eeb5f67b79bbdab84be038beccca2ae42bb2d9dbd81be4f377ccc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vmapplicationusername", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Snapshotmanagement]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Snapshotmanagement]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Snapshotmanagement]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5955953f528b99422e4a9c660de5bccf13af8f781b84b0e6b12614c9818a109a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapengine",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SnapshotmanagementSnapengine:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ac42c7a1764352daf050a99f0e80f2c025884314b6db9f8f64592caec488768)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SnapshotmanagementSnapengine(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SnapshotmanagementSnapengineList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapengineList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4acfe82575637b70ebee5164dc24899faa0619b5d614e1bb221a3c0e6d93e309)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SnapshotmanagementSnapengineOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64e54cbaf945f554e275c67ca545bfedea42e44ab5b6411544189285f699f432)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SnapshotmanagementSnapengineOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2680e6b88170ff75c78a2ed7699e12174e5afa2ad746625ba6a1d96b2a8307f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4de64ef13eac18afc64770b1c807f5b7b4c548b5a7cc960f2cbba8c6ff9a22a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b4034f1f26dfc0006b75b514a85f6749358fb5c472cf346f8f942d0eb1282c5d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapengine]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapengine]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapengine]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fedb261c64e578b101b6c48976d940837ad4e0bc8bfff4c240a7c4f02e3ec0a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SnapshotmanagementSnapengineOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapengineOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ec4025a6e1631f3b7b83c496fea2299d6050e47502eb7e4aaa2c5867813e71ce)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03e7b166fbf90888303b0b6a986b9dc2e51fb029b238376a9dbd3ccd537f7c45)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24f05ecc8fa7664880c913fcaea76ce4bc3085239fe522d82241e6670df23c28)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapengine]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapengine]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapengine]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb1650682342652004256afb154072f307afe9c1381cae7cf806cd5dfe609061)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapmountproxy",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2SnapshotmanagementSnapmountproxy:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa11c00dbcda327a9f29df59ec002f5144f44d836a78ff40e526780498ef1a5e)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2SnapshotmanagementSnapmountproxy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2SnapshotmanagementSnapmountproxyList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapmountproxyList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ad0f6a9bd1ec14360ba24326d41e8cdc2756a0303935add4e688568a4ad5ea8)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "VmgroupV2SnapshotmanagementSnapmountproxyOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91c360dac4dc94260415809b5b35765f82212116b39a213f3153f97db1e19dd9)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2SnapshotmanagementSnapmountproxyOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc125d560347e38d442cd18b21506d4765d2329b2dc88476632ab8a44ccee688)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44756bd977055b4ad03b95e84ba94e3ab918671d7245e8c9ef290d0766a86271)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0bb58b4d2d00d8d29c1b4308e9efec9b9b36a49cfccc7d374a2c491c9b8222e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapmountproxy]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapmountproxy]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2SnapshotmanagementSnapmountproxy]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__acc903ed50e9919cbcb03f37522199a4000a8fd4608d6aeed8de207a0a986746)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2SnapshotmanagementSnapmountproxyOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2SnapshotmanagementSnapmountproxyOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd3a43758c0d1805f9023188b9db664a91ef0c02acf81aebda63c77c27bdd7e0)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0bbeb508b475df7733573007d9f7fc77869e84fa889680e43f04c412510b3f9f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a30b228cd1a31c4ccd53a63a8fef66d617b6ec5e2f98e021bafae236f8e7469c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapmountproxy]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapmountproxy]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2SnapshotmanagementSnapmountproxy]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a398d863928a6df522fd7a33522d80e21f1f7b3c96cde756d935569e31edcd92)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Storage",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2Storage:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c44e7b9edbcc62ffc63fc6eb857059f181ee7ec5a5ce36e1f7274a790f4adb79)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Storage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2StorageList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2StorageList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e7e2cd8d7a9e9329d6ff0eb773223c0f93a0553b9e99e561bc559f955977e9ce)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2StorageOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d88c5e74d8fad2452d06c70e256e3e6bda1017a1bf807f0d808031e7cd5d9e3a)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2StorageOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d64a52b4e8b1c06bec6b08b95e9d09d30f589675c73eee649f3cebaf12b36dcf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6885ac06ec66dfaacf5b6399ea7a695564fbf16bd641847bc2426de043e431bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1646ff7116ef96f13d0a0b0a970404631889d4d5e746a51625c7bbd7f5f45fce)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Storage]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Storage]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Storage]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9930fd76f7018f3e70b1fdb38ab82788eb464529f0f0211b1c2b7e38718f7a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2StorageOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2StorageOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50b0e5648be18093827b7a4d3f0c302ff5148adb9b152a8407ab66eaa3166e6d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f1be39f65ecdb1d0e1b1c5487a94c8f0ae83fc88a905a0243a78e29d6ee773c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d9aa41e992455dbdecc8f6f0425ebd06d2035957408943bfdedc9b9e4fbc022)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Storage]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Storage]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Storage]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0283c47a0cfde687b8acb76f97a841b213544dc965c70c65a84a38d33674f965)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="commvault.vmgroupV2.VmgroupV2Timezone",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name"},
)
class VmgroupV2Timezone:
    def __init__(
        self,
        *,
        id: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param id: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param name: Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d63042a104a8e92c302b0a2ac658b4dd3ac3649ad4a380ab525d957fcc2f25a2)
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def id(self) -> typing.Optional[jsii.Number]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#id VmgroupV2#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://registry.terraform.io/providers/commvault/commvault/1.2.10/docs/resources/vmgroup_v2#name VmgroupV2#name}.'''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VmgroupV2Timezone(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class VmgroupV2TimezoneList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2TimezoneList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b03acc5d42d7240b269cd4a0e45867207833da8446896864112dfcfc27e1d116)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> "VmgroupV2TimezoneOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01574936f98d8f5e4330a6347599561512753ecc1305168efe6476dc70d71411)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("VmgroupV2TimezoneOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f210f56d254a7dcf265f05c434fd343fadc3655afa45aead4180e78fca5b838f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ea1dfdde9c0a1688a75fb6010273747c34fe1f2bb0c4b2e3d30743c5b007fcf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__953de9f53235e65d826c648203efe80ca69b3da1ebd707d9bbcb52421ed33dc1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Timezone]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Timezone]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Timezone]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abd842ca3f44816789eb09171ade8113cf4aa85f8ff4ad4941dd49e067b00f7c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class VmgroupV2TimezoneOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="commvault.vmgroupV2.VmgroupV2TimezoneOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0c62d99cde6cf98eed4bd2c294581aed027826136ecc6b8ea865e2c314efbdb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetName")
    def reset_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetName", []))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "id"))

    @id.setter
    def id(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af5c617b477a1105f6488a8a1b8c545b65adc38ce9d2dd8caa6de2ec0c08a750)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__083ff54fb02bb242b3802fe4e8fa79f26ea00e938fcb4d7f359ed9dac047bfde)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Timezone]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Timezone]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Timezone]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31524cda2130a03555dbdc84796e3b4d04194c33b5e1978aef1b8629136b05da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "VmgroupV2",
    "VmgroupV2Accessnode",
    "VmgroupV2AccessnodeList",
    "VmgroupV2AccessnodeOutputReference",
    "VmgroupV2Activitycontrol",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptions",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeList",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeOutputReference",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneList",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezoneOutputReference",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsList",
    "VmgroupV2ActivitycontrolBackupactivitycontroloptionsOutputReference",
    "VmgroupV2ActivitycontrolList",
    "VmgroupV2ActivitycontrolOutputReference",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptions",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeList",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeOutputReference",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneList",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezoneOutputReference",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsList",
    "VmgroupV2ActivitycontrolRestoreactivitycontroloptionsOutputReference",
    "VmgroupV2Applicationvalidation",
    "VmgroupV2ApplicationvalidationCopy",
    "VmgroupV2ApplicationvalidationCopyBackupdestination",
    "VmgroupV2ApplicationvalidationCopyBackupdestinationList",
    "VmgroupV2ApplicationvalidationCopyBackupdestinationOutputReference",
    "VmgroupV2ApplicationvalidationCopyList",
    "VmgroupV2ApplicationvalidationCopyOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscript",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnix",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentialsOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentialsOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindows",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentialsOutputReference",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsList",
    "VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentialsOutputReference",
    "VmgroupV2ApplicationvalidationGuestcredentials",
    "VmgroupV2ApplicationvalidationGuestcredentialsCredentials",
    "VmgroupV2ApplicationvalidationGuestcredentialsCredentialsList",
    "VmgroupV2ApplicationvalidationGuestcredentialsCredentialsOutputReference",
    "VmgroupV2ApplicationvalidationGuestcredentialsList",
    "VmgroupV2ApplicationvalidationGuestcredentialsOutputReference",
    "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials",
    "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsList",
    "VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentialsOutputReference",
    "VmgroupV2ApplicationvalidationList",
    "VmgroupV2ApplicationvalidationOutputReference",
    "VmgroupV2ApplicationvalidationRecoverytarget",
    "VmgroupV2ApplicationvalidationRecoverytargetList",
    "VmgroupV2ApplicationvalidationRecoverytargetOutputReference",
    "VmgroupV2ApplicationvalidationSchedule",
    "VmgroupV2ApplicationvalidationScheduleList",
    "VmgroupV2ApplicationvalidationScheduleOutputReference",
    "VmgroupV2Config",
    "VmgroupV2Content",
    "VmgroupV2ContentList",
    "VmgroupV2ContentOutputReference",
    "VmgroupV2ContentRulegroups",
    "VmgroupV2ContentRulegroupsList",
    "VmgroupV2ContentRulegroupsOutputReference",
    "VmgroupV2ContentRulegroupsRules",
    "VmgroupV2ContentRulegroupsRulesList",
    "VmgroupV2ContentRulegroupsRulesOutputReference",
    "VmgroupV2Diskfilters",
    "VmgroupV2DiskfiltersList",
    "VmgroupV2DiskfiltersOutputReference",
    "VmgroupV2DiskfiltersRules",
    "VmgroupV2DiskfiltersRulesList",
    "VmgroupV2DiskfiltersRulesOutputReference",
    "VmgroupV2Filters",
    "VmgroupV2FiltersList",
    "VmgroupV2FiltersOutputReference",
    "VmgroupV2FiltersRulegroups",
    "VmgroupV2FiltersRulegroupsList",
    "VmgroupV2FiltersRulegroupsOutputReference",
    "VmgroupV2FiltersRulegroupsRules",
    "VmgroupV2FiltersRulegroupsRulesList",
    "VmgroupV2FiltersRulegroupsRulesOutputReference",
    "VmgroupV2Hypervisor",
    "VmgroupV2HypervisorList",
    "VmgroupV2HypervisorOutputReference",
    "VmgroupV2Meditech",
    "VmgroupV2MeditechList",
    "VmgroupV2MeditechOutputReference",
    "VmgroupV2MeditechUseraccount",
    "VmgroupV2MeditechUseraccountList",
    "VmgroupV2MeditechUseraccountOutputReference",
    "VmgroupV2Meditechsystems",
    "VmgroupV2MeditechsystemsList",
    "VmgroupV2MeditechsystemsOutputReference",
    "VmgroupV2MeditechsystemsUseraccount",
    "VmgroupV2MeditechsystemsUseraccountList",
    "VmgroupV2MeditechsystemsUseraccountOutputReference",
    "VmgroupV2Plan",
    "VmgroupV2PlanList",
    "VmgroupV2PlanOutputReference",
    "VmgroupV2Securityassociations",
    "VmgroupV2SecurityassociationsExternalusergroup",
    "VmgroupV2SecurityassociationsExternalusergroupList",
    "VmgroupV2SecurityassociationsExternalusergroupOutputReference",
    "VmgroupV2SecurityassociationsList",
    "VmgroupV2SecurityassociationsOutputReference",
    "VmgroupV2SecurityassociationsPermissionlistStruct",
    "VmgroupV2SecurityassociationsPermissionlistStructList",
    "VmgroupV2SecurityassociationsPermissionlistStructOutputReference",
    "VmgroupV2SecurityassociationsRole",
    "VmgroupV2SecurityassociationsRoleList",
    "VmgroupV2SecurityassociationsRoleOutputReference",
    "VmgroupV2SecurityassociationsUser",
    "VmgroupV2SecurityassociationsUserList",
    "VmgroupV2SecurityassociationsUserOutputReference",
    "VmgroupV2SecurityassociationsUsergroup",
    "VmgroupV2SecurityassociationsUsergroupList",
    "VmgroupV2SecurityassociationsUsergroupOutputReference",
    "VmgroupV2Settings",
    "VmgroupV2SettingsCrossaccount",
    "VmgroupV2SettingsCrossaccountDestinationaccount",
    "VmgroupV2SettingsCrossaccountDestinationaccountList",
    "VmgroupV2SettingsCrossaccountDestinationaccountOutputReference",
    "VmgroupV2SettingsCrossaccountList",
    "VmgroupV2SettingsCrossaccountOutputReference",
    "VmgroupV2SettingsCustomsnapshottags",
    "VmgroupV2SettingsCustomsnapshottagsList",
    "VmgroupV2SettingsCustomsnapshottagsOutputReference",
    "VmgroupV2SettingsGuestcredentials",
    "VmgroupV2SettingsGuestcredentialsCredentials",
    "VmgroupV2SettingsGuestcredentialsCredentialsList",
    "VmgroupV2SettingsGuestcredentialsCredentialsOutputReference",
    "VmgroupV2SettingsGuestcredentialsList",
    "VmgroupV2SettingsGuestcredentialsOutputReference",
    "VmgroupV2SettingsGuestcredentialsSavedcredentials",
    "VmgroupV2SettingsGuestcredentialsSavedcredentialsList",
    "VmgroupV2SettingsGuestcredentialsSavedcredentialsOutputReference",
    "VmgroupV2SettingsList",
    "VmgroupV2SettingsOutputReference",
    "VmgroupV2Snapshotmanagement",
    "VmgroupV2SnapshotmanagementList",
    "VmgroupV2SnapshotmanagementOutputReference",
    "VmgroupV2SnapshotmanagementSnapengine",
    "VmgroupV2SnapshotmanagementSnapengineList",
    "VmgroupV2SnapshotmanagementSnapengineOutputReference",
    "VmgroupV2SnapshotmanagementSnapmountproxy",
    "VmgroupV2SnapshotmanagementSnapmountproxyList",
    "VmgroupV2SnapshotmanagementSnapmountproxyOutputReference",
    "VmgroupV2Storage",
    "VmgroupV2StorageList",
    "VmgroupV2StorageOutputReference",
    "VmgroupV2Timezone",
    "VmgroupV2TimezoneList",
    "VmgroupV2TimezoneOutputReference",
]

publication.publish()

def _typecheckingstub__37f8686b27db69ccf4a9c75cc4e306a6fa34217590ee2a747bcd13c77299dc24(
    scope: _constructs_77d1e7e8.Construct,
    id_: builtins.str,
    *,
    content: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Content, typing.Dict[builtins.str, typing.Any]]]],
    hypervisor: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Hypervisor, typing.Dict[builtins.str, typing.Any]]]],
    name: builtins.str,
    plan: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Plan, typing.Dict[builtins.str, typing.Any]]]],
    accessnode: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Accessnode, typing.Dict[builtins.str, typing.Any]]]]] = None,
    activitycontrol: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Activitycontrol, typing.Dict[builtins.str, typing.Any]]]]] = None,
    applicationvalidation: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Applicationvalidation, typing.Dict[builtins.str, typing.Any]]]]] = None,
    diskfilters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Diskfilters, typing.Dict[builtins.str, typing.Any]]]]] = None,
    enablefileindexing: typing.Optional[builtins.str] = None,
    filters: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Filters, typing.Dict[builtins.str, typing.Any]]]]] = None,
    id: typing.Optional[builtins.str] = None,
    meditech: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Meditech, typing.Dict[builtins.str, typing.Any]]]]] = None,
    meditechsystems: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Meditechsystems, typing.Dict[builtins.str, typing.Any]]]]] = None,
    securityassociations: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Securityassociations, typing.Dict[builtins.str, typing.Any]]]]] = None,
    settings: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Settings, typing.Dict[builtins.str, typing.Any]]]]] = None,
    snapshotmanagement: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Snapshotmanagement, typing.Dict[builtins.str, typing.Any]]]]] = None,
    storage: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Storage, typing.Dict[builtins.str, typing.Any]]]]] = None,
    timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Timezone, typing.Dict[builtins.str, typing.Any]]]]] = None,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[typing.Union[jsii.Number, _cdktf_9a9027ec.TerraformCount]] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8b92a1c6faa6348dd8d32fc7dcbbd70487bd403887cef60b32c92a4752b0473d(
    scope: _constructs_77d1e7e8.Construct,
    import_to_id: builtins.str,
    import_from_id: builtins.str,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1d80223f10a76b45b99f876fbf444d0fd5d64d74464dc885feba3058c5a5ee77(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Accessnode, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ff6053e9067b9bb89ac526f90d362fd6211980292544206e1311692c39f37ab2(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Activitycontrol, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__753961f606f2b6bba9cff98228e8ed2df17e6e4dcbbd2167753d280b32e4e138(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Applicationvalidation, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2b2c9158fc817c51fbb447ea3b2dae8672bfaea29c064b24cd6fa8ef218bdd2a(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Content, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3a182d700ef600ef2fc6566854e9f31272f9792dab242fdd1c027f26492c05f8(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Diskfilters, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__aa9a5a282af6cebc91d5a6cb8b9d8e15ae30ce8dd075adf485990a64c58a8c2c(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Filters, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4cd2b1833c9ad713c152e3e091980b1802404039ec3dbf90e5ad5b878de6d723(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Hypervisor, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__112bd8d484aa27423bfa6c48b7c0daf6e493d5594c70a43b762fe78f3b099cbd(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Meditech, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__72180c9927a72ff716282ba22cc004ceb74d364df24319f2d1dac7915bfdfff5(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Meditechsystems, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__187275d9b4f5a865bd88fb4716e7d8eea971162b87f1398e6fc39fc17c8b72a1(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Plan, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a7a54790337e37f469349af23628609c752c92aca940855090b75ccd1f09cea5(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Securityassociations, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5ac221b8ca6689717ab46174f09e24242cc1fffd3d77126eadf79a762c34ac15(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Settings, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__40daf0a59c796ff6b64d6c666f9f3cc502f593aa4aa5b1cf6e0aff85b9ac2ded(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Snapshotmanagement, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a26d41d7d315c346e29f5f14a62851d9e9dbe2f8b43fc3ab6b87e57cfd1a0035(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Storage, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__76e8bf18a4fe8e38195fa088cd9fc370c55c1ae91437ed22aef71be3882076ee(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2Timezone, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6e7ad0ea0b76691c55438abe260cd280487e3116534ad3833e1fed0a5149d03e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0fdb0f16d99a6f0c8e9e99c6c986a0479c3ce2def30d7020ff21f73fa587ba25(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9677a28bb6ddbf1bd7e29aee422dccea7fdf8eb330fb57dc26a34b6471d4abbf(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dbad56d18a9e0a0882fef1a434a93a2f84626bd1c296b0068faf9c5cca58efb3(
    *,
    id: typing.Optional[jsii.Number] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__60b7eb2b9da769741675a8317b558dfbdeb36642e0f721a59a2ae61387b16ca4(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__746e1291b2aa71004ecf67f202125a3f122c935bc4f8c4389c76de12104d3674(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9ccc03573b528ade0dc6c0857cf4de4a2f0fbd38c3e6f26a75549da8a1c13371(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b46e8501b435b6973761a8693aaf108c4aaed19ab8e59dc92926bdc8162914db(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__defbed6cbc7bdcf1b6fd429d94b4bb4c00b643247f7a3718b02cde8ae39a9f9f(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1bf5db4cf036191aedc02cfdf7a60a663665b5c9a7201ccb61ad4a22e30c37c3(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Accessnode]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7e4b10749c6e8cbc67da9b59b5a51208394a42074a641c567f3f7c0f927930ad(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c7adee0993cefb8cf9391693c07456fa02e0308f714b5f89978559112677bb7b(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__970b4ee34ec7a09675d397f364a21bee73f54fefc28bcee1e302455e76e14c0f(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Accessnode]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dbbba5ba4cf426ee2508e80cd881f18194f8591ccdbffc2a30dfdf646a4edc1a(
    *,
    backupactivitycontroloptions: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptions, typing.Dict[builtins.str, typing.Any]]]]] = None,
    enablebackup: typing.Optional[builtins.str] = None,
    enablerestore: typing.Optional[builtins.str] = None,
    restoreactivitycontroloptions: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptions, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bda6ba63d6e7838760826431d515ea8e3709c9cdd30aee4cbfc08a14ea8d6e50(
    *,
    activitytype: typing.Optional[builtins.str] = None,
    delaytime: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]]] = None,
    enableactivitytype: typing.Optional[builtins.str] = None,
    enableafteradelay: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b78dcb50f3d5878d50febc5e23acb603092564d4865a11e6077a8258eea44ba5(
    *,
    time: typing.Optional[jsii.Number] = None,
    timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone, typing.Dict[builtins.str, typing.Any]]]]] = None,
    value: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__08f1c18e7cb1e2a96355717799937bd3450d0d3712aa1d8aac5c2f3c0bd77723(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cae5d1e763b6831b6001c9649488558e03784523a3eee77c5daf323ea0d8ca3b(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__866a0ef4449978f81c19f92ba9184145feb2a7c4a3990d0390c9fa13ac768f06(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__17a9dd4cfd5e08950561e39b6af60039b7c176f8bba64f6062bef852182607fb(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9c1b6a7eba48569d534089522962f313e750df017bdfe3730b89a07552c54675(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3c807f665407624ece5e7fee41b587f42866a66fec056e6f4c3516f6dc1297e6(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__309557685e43e654cb68657381e4277e422e1a3a24f2a6f5ea23743d948e45d5(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9f55566e673efc80463cd4d1dc56ce967ebe44b3cfc2dfaf9f8345458cced804(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__43e0ddd47e4dfaffc110bf69db9e17e91d105702e9e33f3eca2e8b6a52b9a188(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d9e15f7eac5b6224a8a9e50cf773a0ba3fc79a331b9ccb3dff6137c8050b48aa(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b10ff9573b947784a2334dd69b9973357c5e7dc5809f47c892c8e0a6aa0ccb9d(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__67dac461c88fa1e5bba5daebaefa172ea350a4143375521ab1bbb901bc4eff0a(
    *,
    id: typing.Optional[jsii.Number] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ae47f1eb93e8cf57d35828f6cb422ccca16e3f3c7f20424f45e2866d0acca318(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9c30aee612ba7a2aa28baa85067200f3dee7ccc17fc554b32cc6b09c40c14e90(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5bc76891b9cdeb2a9934cce645ff40606b1d118603710adb99dccaddb11aa148(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e519df2aca11493f40edaee6f30c74d115b53d30e1e4189cc83bb0e8b364c7cb(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b3e2827783d0b63d6a22ae7ea769533c096408bd550f4d85258de9bac44e63cb(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__456e0a53d63054cb6215fa918367c96eeacf01912fb936fbfbad47381519c968(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dc7a40b3d4760514c85f47ebc87fc01cdc160b62a3f079c74eb2eab8783c9594(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4337cd18e38c2a55b49ee83c126f4e56fa7da7d77121583ee33b0140c4d2dcc7(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e9d6678fa237377b731e0aa07474cf5e205685279585c4100cc924a92f8080c8(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b61d553fdd904fc4a08e444d3b69744e95ef8264012fd46406de0154e99f0af7(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytimeTimezone]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__61fa32feaf0c13a78cb198acf02f528332006fad075e705b143502af92c935d1(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__660810a486612f9a60ef5c131cc87feb203e023ba1865b3da094678e471e0a5d(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e9dd713edfccc9aa376103542418b9c415e9cbccbaa758a7722fbee7127e17a2(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__afa1ba2255334c916405dfc388e39ac1a9b22d6c88d217bd836a3cf33e92df22(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__959fb4d7c672eb67c368bcd07bead2bbd17cceb215eaa6e3d484b363304e6b8e(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8a15a139957830e9f3fd1533aa9e188ffb217862797990cb14c0b72b233c7429(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolBackupactivitycontroloptions]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a6582cac8d25cf965bcbdc6a84a2f79e4aebb715cb2541d40c63065062ffa8e3(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a5861de0e25fb2711572e90e21335ae805442ca2019610847a45498158270c95(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__022c76fb2959e45352a13fea579aefff2610985f7c57923ed9b1634902f55c62(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a8627c79ee0da1edc59c70033093f2421abca703c59f543d9fe78b0a300bec85(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__db942ddc22cd6d26a8eb3320baa2962aa2e6710ef2c00011e041805ac1b479bc(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__67139cbb727145b454d9d179645971c5df16bbdbc8dd0bc0c68f0df223aa2a8c(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolBackupactivitycontroloptions]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c25934448fdbe08cb546162c16f60b6943b48df41dbd37601d12c67335a8fea5(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a84e66aac620767ffdd6cf75f8b6cca6eda56bc9468411b7dd95237e4fbd6d3f(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__19caab2bb68ce238809692fcf63044662538dc30223135a3962fad0d17621427(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c92c9d8c29d94f94ba91e494f04950bc14d52da5e4e153a8de2e75d8b7222914(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__11239f57245dfeeb6494317a56748b385d8efaabc7faa3e0bc6c3f54f5c38828(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__91a710c4f4447dfae3adc611e455cde5463766bffe5c7e9ebe7eccaef3b497db(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2Activitycontrol]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d22350133a05e32d4667f75d4d57e08d381a3545e0123523b21a8aad3172ea94(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e7306976c58f1f07691367beae6532ce9927fe79228358d9d8845cc0baf1341e(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolBackupactivitycontroloptions, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bbe8262f67e9940e8891c3aee317766001aa29afb9b67f278f1b8e5a4d2f9bde(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptions, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__54a2bb16753b5d113dcd4bc09376416fcd4bec4b4f5aaa3db5ec7d8e793e03a6(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e58c68087fa37efa82c6eb301677e192edd7fe8640f33090f915aca447ebb2b3(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9882e3f475c8966050ad30ccad2d791dad923786e5cb5480d666931426c28640(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2Activitycontrol]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6e3f42dac0acaf0e1fc4393ec166908122f012c74af07c363e4b44b769953110(
    *,
    activitytype: typing.Optional[builtins.str] = None,
    delaytime: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]]] = None,
    enableactivitytype: typing.Optional[builtins.str] = None,
    enableafteradelay: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c05bb9b84cc2d0bbb1437d7fc5a1bd3ac0597319865c3003e11eca83abb44de6(
    *,
    time: typing.Optional[jsii.Number] = None,
    timezone: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone, typing.Dict[builtins.str, typing.Any]]]]] = None,
    value: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e038048a18dc76dee911d01a8df412876a2cab99d262a302407079bda550034d(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eee64b6747d91d9518e0a0d70990b91fbb648028c454121707adce5ba9bf5d55(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7c4d0c457d5fae845c436fd3bb7f9ed94128ef8fcb4eb7dafd2ca277d9ccb98a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ea3d6c75490dd60ee37a90c99bcd11e7d97d62b1fc057be36f5bf6d850f29243(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f5c9d9b2a38a15ce972ec8f6e58a129974f5c9f5413cd001696553606bd40a6c(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e1b886ffc0da5f11893a86a3e4b063e014de2cf23f159b07feccb92f4ddad729(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__68b445970d513131044cc7ba0806f8fb53f0cdb6b2be15b3a1f98c84223327e0(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__64b64c83a9a4ce07fd339e77172c470d1ecd6ac51d98d165b526a404a9f69c79(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__866f560abc370deb351f91d036746815496122d407b555483fe85f6df6447198(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0aa1415d8fd7c5cc03225f4eb4af2cfeb3c12280e2cda7725d5066f1019e4997(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__98406ef0e59aa10ee6be2a050ed15a27d0b5ea3ad082d2261c9114ee2d753777(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__52103a12f1d256e348433704c6c03d706587280ce5e1e08c6891475123f805c1(
    *,
    id: typing.Optional[jsii.Number] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6640add3b2bd59ff94dd45cda954303b79d18a1c28ce1a0fd3ba5a7a6e7ebaac(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__808bd6681c9cb4d323df88c3f9f513d318f9a82a58f1f6483c9b6c3ad82c9264(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5431940debfbedcf1445ae0465a924ad3bd15b6d35a1438e352f8b791235633b(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__148b2bc7d1c6455b41784151890336cd049aa6bd90777d76e2b164622281b7cb(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__00475fab7039fc8c806610502fb13c452ceb4c772dda89af627a023c14a70aaa(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__853a0f58162e3c0eb6d6906f810cc0e414da36e8cf07ecdaebd26f6b2897098d(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__49ac92e7e17d29bec9f343110b43fb352eee636c6a5909ae386ec0cfdb016d2a(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bb5fe2816664c9cf060de91adf81d10800833bd43df11cbc023064e3089a9fdd(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__11b72aa2de9bbb8440fe5dc1322fdb554aa7edd0a8818e35cd99fdf0f59cdb26(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1edeed6757a80d9e924b2eeb089e01875153217b4ac12fb1b66ea9fd5adb1c53(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytimeTimezone]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b9d21d4b253be8e02659b1ed28510febb95e5c7e75d8f193c251c3ee9e97bcf4(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__758ba31d6d17aabaa1c42d5e95233fc792bb0604c8aa7acad9c8700b806e1df1(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__69853efa96a070010360615a9c161e722ff02522f48bef811f6aa329160951cf(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__32d2f67b05e14a0c60325aac7d49622b906987406a19d923184233b97321f83b(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4a6103f2a2d2adf3337f7018d754a23298dd2335a366d69d12b0e46868a80ad9(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__657499f5f61b440c73f63e550a66f31870bef1dc0ea3e050cae67ac30da0df0b(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ActivitycontrolRestoreactivitycontroloptions]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__647838adabcaaed84514f4ec1666e275178400a5b826bbb88b67929ce2bbeb8c(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3e96779949c14b458a6afc7bb2ff998d1a3b84755db72936dd4e997245f9b2e2(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ActivitycontrolRestoreactivitycontroloptionsDelaytime, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__841ace911e31295c28c331d619a786b9fdfc467a2ab2a27662d966013bdde7b2(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ed5ec8033af727814b15cf2441491ab2a984b3dd590090f89eb6915d586f4f4e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__78ccdbb560b2b2c49e8a312cf1cdbce6948071b576a1795157609c74680edf7e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bd978d2b7da02dd5d98cb6b5dcba753c9a6ba97848691d57110e2d0527d68e90(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ActivitycontrolRestoreactivitycontroloptions]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6bf4e5136aa57719489bc66009fb3ed18a4c1ed082aa0e892d1d8e2b6985dfb0(
    *,
    copy: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCopy, typing.Dict[builtins.str, typing.Any]]]]] = None,
    customvalidationscript: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscript, typing.Dict[builtins.str, typing.Any]]]]] = None,
    guestcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
    keepvalidatedvmsrunning: typing.Optional[builtins.str] = None,
    maximumnoofthreads: typing.Optional[jsii.Number] = None,
    recoverytarget: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationRecoverytarget, typing.Dict[builtins.str, typing.Any]]]]] = None,
    schedule: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationSchedule, typing.Dict[builtins.str, typing.Any]]]]] = None,
    usesourcevmesxtomount: typing.Optional[builtins.str] = None,
    validatevmbackups: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__930e5e983884841a61c747482da5acccbb03a985b33058051b3e9c063e507bc8(
    *,
    backupdestination: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCopyBackupdestination, typing.Dict[builtins.str, typing.Any]]]]] = None,
    copyprecedence: typing.Optional[jsii.Number] = None,
    id: typing.Optional[jsii.Number] = None,
    isactive: typing.Optional[builtins.str] = None,
    issnapcopy: typing.Optional[builtins.str] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b5dea769a7a349977fb8a4e6e7b6be9305664fe955b5a024aa08ca2563f59034(
    *,
    id: typing.Optional[jsii.Number] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8a668699b2c97b9f23f2d367b75fe508009ad49f622a20475179f527084204c2(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ce95cd9bf15cc8d93da0138d82115705950b33744b4c99399199940407ab5289(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d272cd5e1de081ab3d4502df599d1b486d559f3b43cbe4b107e303467af6b609(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1389573e4e20ee235063fac29ddae1fad183ee368f05f7f5713ea55e2cbbd203(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1f97ae072829d63e3bfc02a0cd7ec843006cebb35fba44882d7aac654b396929(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2a17e9b9248c07ba4b67599312cbcab6e84292c248542e63373af3df6f809093(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopyBackupdestination]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__193d65bd977027d750cf60cbbadaab61ad31b3d1ad01e264c87a5c5630089526(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ff33eee369f8f437fd50ed7a14023299b40395430bae63b203c9a23b03f167c9(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c2035aaa5817e3710c4eb488e567ba1e042a8e15d1c5915675f882455784e854(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3ebbcf9ac82f10cea012d68e9b7cf33f38c862a1bf4fc28a075c1816110e0452(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopyBackupdestination]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__053abbc0b31aadd032e6114510e00cffea3bbfc08fd8015213013331b251ea7e(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__55d1ce347987a3eaa87d6be85fe6a94fa9e28cfdf1717d50e4cb0ad8d97f79b7(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__89d6f0f6e463a20e0271836890e50fa278c55c8f5c58fe19d89e0c89fee2a8c7(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f172ddc22b165cfce0b2d06415fb1943916bb1560ec668fcca257addf2121813(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__08724de511918da24ce931ca7b63aa1bd72f2ea2e3a1976a7ed589dc39c8c8e5(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d256239863fb4628e4ab8c42766c560aa0846fbb369713180e4a19a953c6588a(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCopy]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__35ae19a32f4afb07bc18c1ee48606257355d545072cff4cc3fa3f5aa9833cf88(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f032515622d7d3048b235306bf99eb5e4f2728af034e5a98722fe411af97e3ef(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCopyBackupdestination, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2a8a79dc0453729423f1d8fb8a91ef22c111581fe975b187e10c42ab7ba28ed5(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4cbc38a91ccd28e6da6a4e167f975b8541fa369e3fb6e80579f00511f5129a45(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9a8754f3476988c97a0e93093041647222ec7ce57598e4853083bc893a828a53(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__810296af587521740c69a0825d748d24148aac99744ef479c5ee04c6c730d772(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3703cf63d80347f45ad2e2122673635b818720c6cbc187c145f5e5f3b542faa3(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dea9d343e705df1d66e943534b67bacac6f3022b0c25f01e5755847e0961ed0e(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCopy]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__385057b0ff462dc2e6af2aad5b46b20ef1f4df72b1ac585a82cd6ca38c7f3d07(
    *,
    unix: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix, typing.Dict[builtins.str, typing.Any]]]]] = None,
    windows: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b37f13369fc59a3910df08158dc7a08c14acefdcc84f31de3877b385c82c7195(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__802bfde0a072973629de20aab518461ffaee5833b2dcef9234467bbd1028ca9f(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4c90309b71aef52f265dbf0807de60284262ec924b476862d0031b74384abb01(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eab90ca52e5c6f1db25c23c10fd1957664bb1cc7c1603c19cb4c0c9bc1eb1b38(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dca06422ed0b67d1a39c628c7e23f0c6c1881a2c6c8ace9724c5933a13142a6d(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e228a03065ad57db4fd0632ed2bd53c00b1cbedc4ee70e529ab18da72858cf61(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscript]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5da4e504edc519329eb7437211535836cd06cd57be26b75128e550a7fd2bd0a9(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__29133e2ab6a2648dd5695acbee4206c9017be1044e35b5cb3a74dfe86a9e039a(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5c47a4caff06b3ffef978ce24e2a08176c77dc5d07e635a6e72fd27b8ad6bcbd(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2ef61b115519403cb976a32e37b15d6f4747da7b67895cda955cf3d3680b2deb(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscript]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__89202063a62b46815d13d707c9ec936520ebd3dfeff8d580652901d795d1dafb(
    *,
    arguments: typing.Optional[builtins.str] = None,
    isdisabled: typing.Optional[builtins.str] = None,
    islocal: typing.Optional[builtins.str] = None,
    path: typing.Optional[builtins.str] = None,
    unccredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
    uncsavedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f08a19aa41dd86f74cb890d1fdbd1031afcb4726a19436d0096c96ddfabfb3c4(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__66e4fac5247903925e24d4a74557f3f008939737edf1bbbca81c5f8c26ffb411(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2111a0c08ee71d382b40cd35d3252ea13b9cf3a8f9a5e45e7b8ed16107859f04(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__13250446a81f596acffdb18c646ae8364bd6c9b7a17bea549957fdc9fd0603c1(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c489afcb1d86a5604a0932fcb97097133845fa746dcac7f8a40aee5a68fa9c7d(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d0c4bc2a632fb0cd0b323f7a99d32dd783847b58bdc0215fe10a833b54b47fbf(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5d2b81569372b017486559be44893992a0b3312a8c20a936e0ccaae722da1dad(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c124703573888e31dc0cecc8b0f187bea444b02b3c3761e697d6fe71099876e6(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c12cb27ca4f7665784fad05c51fa0ae51f22819830b74ba249236e63eb301da1(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f94ff8c14e0a9bdbf5c4791cbcbc82b67b1df06b0c094072e33471ba66f94cdb(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a7268169ea03d378ad9441c8363e600773462b1cf8e8d8322d3e54b0a7c20860(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9eb89f8959280db008bf4cb63a7c3ec022a481f043a944ddb1ca35d12ae326e1(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__daf4475cbf993fe99a80e5c8bbe89d3bdd1005783371e32fca15d59883923f7a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eff9c76a22e3085ec2381d6e1e77be4d80aff3e4c344d71d598441d7e556ac07(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnix]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__221ee345476b952bf573bd8094a2f548e9d77961be6e2b9f378b10b3c2aa2039(
    *,
    name: typing.Optional[builtins.str] = None,
    password: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3205f5bef6b3c8982731f2168b84e02fa1c236a4162f2a1726b19d9dd5ccf41e(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5abaa008d8c6b5bced0286561297126b8350346c24772ffe5ec338112d1f34aa(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__08ef1107c0e291382c8542b629160dc412a1f6f6bd36fbe8b4fa2f17ee1b2948(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8964e73186fba499e3d10baa760239b4809092e5b5f4b164a32bd2efb4713a35(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4bde72c5e962b85ddab253770e6a13a5490a65110d51405faa1c5e3aed53313b(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b976a2ebf55d23b1d7f165c294c47b68b17b6c0678e07e13b77c2e7c0d99955b(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__899b440a2b096f850d18f71d0bff4c5c7ceb2bcf52d3a5bbffa978d3d9de1bfb(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fd28f04c55ea44d9610adb9369fd94bfd55f387c37c19b2caf8050298165cdd9(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__04a6ee2d5aa9c8be93d68f592e078ca4d7df2b14a8e5318c54ad0fa036f5da12(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__761e1adceeca525305a0782ac1f98200a001ff37cf5cc58fde0f02e7e4b559be(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUnccredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8b1847127258c3dbe78edca64be4f1bbdcce86a43d786513ada49d8d54c62a94(
    *,
    id: typing.Optional[jsii.Number] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ebfb9d0c0e04f0b9782ca5822a8ec36c9a199f171e5b9ebeb44c763463079a6a(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f3c82e828f474e52cbc57f503d1b56a68ce78f301259eedf74290786697850ee(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0e8b33e07b6c2abcc7c52609ec40c7389f78bb9e09ffceeea07f2fcee342a0f2(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7ee1237fb77abb811a70f2a5a1581cb46f87a66c1494af340d20c73532b3422c(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2ee7dc2ac74389ab1698ab0683547682354176e3727503b8c5483eeaf5e9364e(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cea1046a49ea2be3b19509c8a59d23d57dbe699ccfad3ef18ecac26f39d54efc(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1fd548c9b59f53995c28eca7a4dad69d9d4787b2fd18341b281e56d20a5898af(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e098e99778249d27f3bca3f288b16259e6e3b04333c177156779bcbf8fd63507(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bfec73ef813b6307efddc9efc65bb9cccf53415f4dd0775a25e366cd5c806772(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__283118b48269f2b64871ac830e4021027521c6cc0001d62af401020e645bb975(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptUnixUncsavedcredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7bafba6c0a79cdf5fb8d6e2220882f289e72c0bf7a4a0a72c6a9c0765b973355(
    *,
    arguments: typing.Optional[builtins.str] = None,
    isdisabled: typing.Optional[builtins.str] = None,
    islocal: typing.Optional[builtins.str] = None,
    path: typing.Optional[builtins.str] = None,
    unccredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
    uncsavedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__46d3b9febdf3b3d3026a91b440d10d6e26e424f57d19997378326634190bbe7e(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9d8fe9c7e9cea13e31856c05efcaf1806b5c9a9fe7a24c364168da270a670bac(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a78eeea48187750a05084392460cc3626177df2733bd84c0b63cb01a8d299aef(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__407005c725a9546bd442a8f266459435334637953e91971d2fc7697b83634054(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3b6f67b2920ffcf5c73e863d2e1e20f4dfb2a85602f5d3ff2efc929b40c430c0(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__55d9b3fe76a347e23777fab0cf4d60fcd392d10ee918be5eafaa461483a21c49(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__aed6574dfe264a873384a0fe9216786c52cd1efa973afbc177a85b780f41d196(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0c02255694e1ea8eb3ee5f097d41b2598149036ca7c1a14b322934feee188c46(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3ea73f128fe2292dc614eebf50b823790e7e2875bc597a386eb92cca44060ceb(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bb37d0f8ba9d526e3511647eb9bf53a0d0f18c8e2ce3ade0c511b3e9b4737eac(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__991985b802cd64321e7b976749f5a37247b27cffb8921e8f7f35b5280c9dee89(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__174cbfe0932f8a6376a034327590b075df1ab2c0bc48dfeae9d0c36a4dd552ae(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__24c545a6a32f873c43d48cf171d9063f9107038550761c36dd3fa936c433df18(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__248050dece5f9e4e4a066f7a7fd8ffc9ad2ae28bf5198c8691f4c4cc429415c4(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindows]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__27c94298deb8caa0e0c4528d0643cab2b7ca8f457849661a84db629cbe00c609(
    *,
    name: typing.Optional[builtins.str] = None,
    password: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bf8a23277538ad78fa1c2fcb6fbcbf4418d48b411bd27acbabe240eefa05d3af(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8c5e9566b4c4a5816b08b4f1ef1cee7e958ca8809f0437953ef1174b1d575065(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__edce0bc1325f6e642b4c6882adfd05dad72cc55bffb1a3b9d74b4a9da875dce7(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__190c63ed9ee0a46606934de2f954e693a706221b8ea09bbebe98e2edd528d3a4(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a9e23b86a162f88e840ba66d36865ab840a10622e502453d463a9509c9592d66(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d9011089a42c154ee2526037de8f9544f94b16e96df7362945acaeb8818cfd23(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e1672fd84a6161217dae27b8ac89683bf7604b5a5282bd444aa0a7b20dbe261a(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d95ac517e6f0e575e8e903badc982eed751a77f65fa0d5a59f5c9eebb1f38dad(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e61c2aac4d1e15c55276cfa574d1ce404bed8ea9db10177b9661a3fad43d3320(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__925de80774f647d10fdc3a4fcf0b9a67c99a6946070fe7eb89a9c214ca66cb9d(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUnccredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6483f22ed62c9dbb65743ef07259eb54baac01b2b3711ac27afa904e7dfed242(
    *,
    id: typing.Optional[jsii.Number] = None,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7ab27c30e6b5f616e135a9edaacd2f682f9568e33bee876f696c98b7efee1670(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__636d6cc2c4a70958cd63b228da271139e164d006a44c72f84a5642090f5d2984(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__70a663344d96a4dcd967179f38126bb44daf01cf9bc2ea46fc006c660cbd87db(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__30bdf2003a2d3ca426b31c61dfb30e698b00054da37e57e9ae6ac7729a5e99a5(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4b24b8e148f3eaa2095dd8823ee3583f40a792defa902ebe014e9e9bb1bb74b2(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__96736f82e14d980a4c465e05ae97eb607c13ea1d78891df69757c2bc0898fe95(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b4844c339e322ed9e57e0fac53d325641734c5c6cae9fc4e846215e6ba891eec(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e0f541fe9940a0c0880442d2e147ab0161d6c5b3ce9805e70b58be190cab6e33(
    value: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ea6d112c1a010a8deeb4537ef86ec9763d8859218b31658f3920e4762b6a698b(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__acd314c6c63f53122b6a4d04ae3023c465a29557a3ae69417dcfc91349a8fb5a(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationCustomvalidationscriptWindowsUncsavedcredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d3a66d223c7e04156da557d892f2385b4f26477e6af87dc18d4439700af6651a(
    *,
    credentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentialsCredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
    savedcredentials: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cf577e80807f5301301b25e1e6be54153de64ca34029ffee58305c5692909097(
    *,
    name: typing.Optional[builtins.str] = None,
    password: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__29959a6eb8743ef473e02c4b9a2f150c64dd98d56d29f6e008655ef250827605(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b5789c7e056b79d077b74ae58a54fe0f372fb650f8b803e062ae37438bdf31a6(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__58d1ec05c0b65bdb236a6f8378f079b43b175207264cb7afacef66b930dd32a8(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7c3af8f42178b91c781a738bc6f8a1c4823ce98519bdf4e12f114e8acb88e5ac(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__97abbf855ae304e46b73e37d26f3edab133d52af23a62e595453e6ee40343a83(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__47662cfe22893691b0e0b88ad8f96032a10810c843031b2e54e58355bbc30eaf(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsCredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__867ccc79a8c47ee0e0d2952939edb8a005cc01daed03dcdf8bbfc1e45bb5b105(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__22bba30491f350fbc5bc83c80c0c2ba42ae53ddaed65bb40323ec9f9e296b861(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ce4cf40092c432550150ad1c8eac7a8ced1023d055ba79f0d4cccf9ae03230dd(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7feafde3027437416802c1e8d22cc4716a20f6741d1a1f99935e5ff13f3f98d3(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsCredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b31a87cdce787b753d715d10d32baa37de85f2bd08041635e3e92f24a7ef8c08(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b537b8c355d23aaaaa7394b51b63911e9ac29d696b62b70845d244062557ad3f(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fbc3a71a6c50d58c80939e8b6595423596ec1685f4481d3c1797eb56ba84b167(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__77d673b45e01a62c8435264f5b858b5772079ab1cce8aac5f551e48a1c06493a(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__c672dfc46ace9b378314b06fa722ee767ecc1c9e8ccc265beb30d5d9c654a89a(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a79c9966542d397d0d1e4a8c8f044a4d2a94f4d7c5d6ccb8a80b1ddf415351e2(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f531b68e67531748895dffb9b19e422f916ba95651264e29e0e66d6d940b2233(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3d4d646e17411d5871ef7966a882cb1440766dd8ac7ee00cce739b653d3cff31(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentialsCredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9fb7549a7dc9c9aa4a05267994f628e0a8511f06813ded03fd441dabdbe89767(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__633cb8c6f5517711e41488a871d069a79c6035dd214d43201869097e32cba1a1(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8c9dc7684eb8b2091e93eedef85bf205ca8f49b7b19f9921058b812a804b1db1(
    *,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e0256fbc1940aaa723dbef4ca86df8f3a7cd14fc014e33d42b4c0762ee7d0c2f(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e44930b26a582c181314f14bdea8757417ad88c90c1d90ea1c01bbc27fa37f4d(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0fa6f458b05c433d575e965d891b167968a7472a00cf357319d13bd389e7e36a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eb29b01061d606c6c81a8fdfaf6fefb6139191c3e4d429a1569145395611e87f(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__59f12b0b650259b7998b72934667db3b6bd5a3562ba1ce08ff470ca0d690e85d(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a7e1f2257be65dfcdf8ea9819c28b00ec49454227cdfbaa987b344fb2f8468e4(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__66bc9e2400dbbe7f702799e6b8fffdd50e1473d69809e5b9124ed32147d79d9c(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3333309f2e3c52a75f30d7e32803c04aa78f91275026e9ec97370ef1cdcb44b0(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b672521be3bc887a54eb410b32a7bf51986a460975fa493f8f3da4d83c2aaa23(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, VmgroupV2ApplicationvalidationGuestcredentialsSavedcredentials]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4dc00239cba54779e64e6ebe7e5f3687f2c36372bffff457b603895cc6979597(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__69a2f57c0eba250b01979ae65de972f80790e08366c58cb0439f28c9ab216643(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__525ebabe5fb3cef6f46d4de1a77e667e73eb6266026dfabf95f943f77e728b78(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4656b633eb91a2a04144a5129c21ec1759a6df82066d5db90a410ea6949c9e6f(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5d061ccd261aaa904480572f0113f69757831a276b9ab492fbb65b35948058d3(