

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import asyncio
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_common_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_common_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_common_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("breez_sdk_spark_bindings")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_breez_sdk_common_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_breez_sdk_common_checksum_method_restclient_get() != 32450:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_common_checksum_method_restclient_post() != 14213:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
class _UniffiVTableCallbackInterfaceRestClient(ctypes.Structure):
    _fields_ = [
        ("get", _UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD0),
        ("post", _UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD1),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
_UniffiLib.uniffi_breez_sdk_common_fn_clone_restclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_common_fn_clone_restclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_common_fn_free_restclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_common_fn_free_restclient.restype = None
_UniffiLib.uniffi_breez_sdk_common_fn_init_callback_vtable_restclient.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceRestClient),
)
_UniffiLib.uniffi_breez_sdk_common_fn_init_callback_vtable_restclient.restype = None
_UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_get.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_get.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_post.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_post.restype = ctypes.c_uint64
_UniffiLib.ffi_breez_sdk_common_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_common_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_common_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rustbuffer_free.restype = None
_UniffiLib.ffi_breez_sdk_common_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i8.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i16.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_u64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_u64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_i64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_i64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_f32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_f32.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_f64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_f64.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_pointer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_poll_void.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_cancel_void.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_common_rust_future_free_void.restype = None
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_common_rust_future_complete_void.restype = None
_UniffiLib.uniffi_breez_sdk_common_checksum_method_restclient_get.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_common_checksum_method_restclient_get.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_common_checksum_method_restclient_post.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_common_checksum_method_restclient_post.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_common_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_breez_sdk_common_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt16(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u16"
    VALUE_MIN = 0
    VALUE_MAX = 2**16

    @staticmethod
    def read(buf):
        return buf.read_u16()

    @staticmethod
    def write(value, buf):
        buf.write_u16(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class RestClient(typing.Protocol):
    def get(self, url: "str",headers: "typing.Optional[dict[str, str]]"):
        """
        Makes a GET request and logs on DEBUG.
        ### Arguments
        - `url`: the URL on which GET will be called
        - `headers`: optional headers that will be set on the request
        """

        raise NotImplementedError
    def post(self, url: "str",headers: "typing.Optional[dict[str, str]]",body: "typing.Optional[str]"):
        """
        Makes a POST request, and logs on DEBUG.
        ### Arguments
        - `url`: the URL on which POST will be called
        - `headers`: the optional POST headers
        - `body`: the optional POST body
        """

        raise NotImplementedError


class RestClientImpl:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_common_fn_free_restclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_common_fn_clone_restclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def get(self, url: "str",headers: "typing.Optional[dict[str, str]]") -> "RestResponse":
        """
        Makes a GET request and logs on DEBUG.
        ### Arguments
        - `url`: the URL on which GET will be called
        - `headers`: optional headers that will be set on the request
        """

        _UniffiConverterString.check_lower(url)
        
        _UniffiConverterOptionalMapStringString.check_lower(headers)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_get(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(url),
        _UniffiConverterOptionalMapStringString.lower(headers)
            ),
            _UniffiLib.ffi_breez_sdk_common_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_common_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_common_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeRestResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeServiceConnectivityError,

        )



    async def post(self, url: "str",headers: "typing.Optional[dict[str, str]]",body: "typing.Optional[str]") -> "RestResponse":
        """
        Makes a POST request, and logs on DEBUG.
        ### Arguments
        - `url`: the URL on which POST will be called
        - `headers`: the optional POST headers
        - `body`: the optional POST body
        """

        _UniffiConverterString.check_lower(url)
        
        _UniffiConverterOptionalMapStringString.check_lower(headers)
        
        _UniffiConverterOptionalString.check_lower(body)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_common_fn_method_restclient_post(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(url),
        _UniffiConverterOptionalMapStringString.lower(headers),
        _UniffiConverterOptionalString.lower(body)
            ),
            _UniffiLib.ffi_breez_sdk_common_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_common_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_common_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeRestResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeServiceConnectivityError,

        )


# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
_UNIFFI_IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class _UniffiCallbackInterfaceFfiConverter:
    _handle_map = _UniffiHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplRestClient:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD0
    def get(
            uniffi_handle,
            url,
            headers,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeRestClient._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(url), _UniffiConverterOptionalMapStringString.lift(headers), )
            method = uniffi_obj.get
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterTypeRestResponse.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, ServiceConnectivityError, _UniffiConverterTypeServiceConnectivityError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_REST_CLIENT_METHOD1
    def post(
            uniffi_handle,
            url,
            headers,
            body,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeRestClient._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(url), _UniffiConverterOptionalMapStringString.lift(headers), _UniffiConverterOptionalString.lift(body), )
            method = uniffi_obj.post
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterTypeRestResponse.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, ServiceConnectivityError, _UniffiConverterTypeServiceConnectivityError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeRestClient._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceRestClient(
        get,
        post,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_common_fn_init_callback_vtable_restclient(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeRestClient:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return RestClientImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: RestClient):
        pass

    @staticmethod
    def lower(value: RestClient):
        return _UniffiConverterTypeRestClient._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: RestClient, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))


class AesSuccessActionData:
    """
    Payload of the AES success action, as received from the LNURL endpoint

    See [`AesSuccessActionDataDecrypted`] for a similar wrapper containing the decrypted payload
    """

    description: "str"
    """
    Contents description, up to 144 characters
    """

    ciphertext: "str"
    """
    Base64, AES-encrypted data where encryption key is payment preimage, up to 4kb of characters
    """

    iv: "str"
    """
    Base64, initialization vector, exactly 24 characters
    """

    def __init__(self, *, description: "str", ciphertext: "str", iv: "str"):
        self.description = description
        self.ciphertext = ciphertext
        self.iv = iv

    def __str__(self):
        return "AesSuccessActionData(description={}, ciphertext={}, iv={})".format(self.description, self.ciphertext, self.iv)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.ciphertext != other.ciphertext:
            return False
        if self.iv != other.iv:
            return False
        return True

class _UniffiConverterTypeAesSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AesSuccessActionData(
            description=_UniffiConverterString.read(buf),
            ciphertext=_UniffiConverterString.read(buf),
            iv=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.ciphertext)
        _UniffiConverterString.check_lower(value.iv)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.ciphertext, buf)
        _UniffiConverterString.write(value.iv, buf)


class AesSuccessActionDataDecrypted:
    """
    Wrapper for the decrypted [`AesSuccessActionData`] payload
    """

    description: "str"
    """
    Contents description, up to 144 characters
    """

    plaintext: "str"
    """
    Decrypted content
    """

    def __init__(self, *, description: "str", plaintext: "str"):
        self.description = description
        self.plaintext = plaintext

    def __str__(self):
        return "AesSuccessActionDataDecrypted(description={}, plaintext={})".format(self.description, self.plaintext)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.plaintext != other.plaintext:
            return False
        return True

class _UniffiConverterTypeAesSuccessActionDataDecrypted(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AesSuccessActionDataDecrypted(
            description=_UniffiConverterString.read(buf),
            plaintext=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.plaintext)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.plaintext, buf)


class Bip21Details:
    amount_sat: "typing.Optional[int]"
    asset_id: "typing.Optional[str]"
    uri: "str"
    extras: "typing.List[Bip21Extra]"
    label: "typing.Optional[str]"
    message: "typing.Optional[str]"
    payment_methods: "typing.List[InputType]"
    def __init__(self, *, amount_sat: "typing.Optional[int]", asset_id: "typing.Optional[str]", uri: "str", extras: "typing.List[Bip21Extra]", label: "typing.Optional[str]", message: "typing.Optional[str]", payment_methods: "typing.List[InputType]"):
        self.amount_sat = amount_sat
        self.asset_id = asset_id
        self.uri = uri
        self.extras = extras
        self.label = label
        self.message = message
        self.payment_methods = payment_methods

    def __str__(self):
        return "Bip21Details(amount_sat={}, asset_id={}, uri={}, extras={}, label={}, message={}, payment_methods={})".format(self.amount_sat, self.asset_id, self.uri, self.extras, self.label, self.message, self.payment_methods)

    def __eq__(self, other):
        if self.amount_sat != other.amount_sat:
            return False
        if self.asset_id != other.asset_id:
            return False
        if self.uri != other.uri:
            return False
        if self.extras != other.extras:
            return False
        if self.label != other.label:
            return False
        if self.message != other.message:
            return False
        if self.payment_methods != other.payment_methods:
            return False
        return True

class _UniffiConverterTypeBip21Details(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bip21Details(
            amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            asset_id=_UniffiConverterOptionalString.read(buf),
            uri=_UniffiConverterString.read(buf),
            extras=_UniffiConverterSequenceTypeBip21Extra.read(buf),
            label=_UniffiConverterOptionalString.read(buf),
            message=_UniffiConverterOptionalString.read(buf),
            payment_methods=_UniffiConverterSequenceTypeInputType.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt64.check_lower(value.amount_sat)
        _UniffiConverterOptionalString.check_lower(value.asset_id)
        _UniffiConverterString.check_lower(value.uri)
        _UniffiConverterSequenceTypeBip21Extra.check_lower(value.extras)
        _UniffiConverterOptionalString.check_lower(value.label)
        _UniffiConverterOptionalString.check_lower(value.message)
        _UniffiConverterSequenceTypeInputType.check_lower(value.payment_methods)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt64.write(value.amount_sat, buf)
        _UniffiConverterOptionalString.write(value.asset_id, buf)
        _UniffiConverterString.write(value.uri, buf)
        _UniffiConverterSequenceTypeBip21Extra.write(value.extras, buf)
        _UniffiConverterOptionalString.write(value.label, buf)
        _UniffiConverterOptionalString.write(value.message, buf)
        _UniffiConverterSequenceTypeInputType.write(value.payment_methods, buf)


class Bip21Extra:
    key: "str"
    value: "str"
    def __init__(self, *, key: "str", value: "str"):
        self.key = key
        self.value = value

    def __str__(self):
        return "Bip21Extra(key={}, value={})".format(self.key, self.value)

    def __eq__(self, other):
        if self.key != other.key:
            return False
        if self.value != other.value:
            return False
        return True

class _UniffiConverterTypeBip21Extra(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bip21Extra(
            key=_UniffiConverterString.read(buf),
            value=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.key)
        _UniffiConverterString.check_lower(value.value)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.key, buf)
        _UniffiConverterString.write(value.value, buf)


class BitcoinAddressDetails:
    address: "str"
    network: "BitcoinNetwork"
    source: "PaymentRequestSource"
    def __init__(self, *, address: "str", network: "BitcoinNetwork", source: "PaymentRequestSource"):
        self.address = address
        self.network = network
        self.source = source

    def __str__(self):
        return "BitcoinAddressDetails(address={}, network={}, source={})".format(self.address, self.network, self.source)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.network != other.network:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeBitcoinAddressDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BitcoinAddressDetails(
            address=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.network)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.network, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class Bolt11Invoice:
    bolt11: "str"
    source: "PaymentRequestSource"
    def __init__(self, *, bolt11: "str", source: "PaymentRequestSource"):
        self.bolt11 = bolt11
        self.source = source

    def __str__(self):
        return "Bolt11Invoice(bolt11={}, source={})".format(self.bolt11, self.source)

    def __eq__(self, other):
        if self.bolt11 != other.bolt11:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeBolt11Invoice(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt11Invoice(
            bolt11=_UniffiConverterString.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.bolt11)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.bolt11, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class Bolt11InvoiceDetails:
    amount_msat: "typing.Optional[int]"
    description: "typing.Optional[str]"
    description_hash: "typing.Optional[str]"
    expiry: "int"
    invoice: "Bolt11Invoice"
    min_final_cltv_expiry_delta: "int"
    network: "BitcoinNetwork"
    payee_pubkey: "str"
    payment_hash: "str"
    payment_secret: "str"
    routing_hints: "typing.List[Bolt11RouteHint]"
    timestamp: "int"
    def __init__(self, *, amount_msat: "typing.Optional[int]", description: "typing.Optional[str]", description_hash: "typing.Optional[str]", expiry: "int", invoice: "Bolt11Invoice", min_final_cltv_expiry_delta: "int", network: "BitcoinNetwork", payee_pubkey: "str", payment_hash: "str", payment_secret: "str", routing_hints: "typing.List[Bolt11RouteHint]", timestamp: "int"):
        self.amount_msat = amount_msat
        self.description = description
        self.description_hash = description_hash
        self.expiry = expiry
        self.invoice = invoice
        self.min_final_cltv_expiry_delta = min_final_cltv_expiry_delta
        self.network = network
        self.payee_pubkey = payee_pubkey
        self.payment_hash = payment_hash
        self.payment_secret = payment_secret
        self.routing_hints = routing_hints
        self.timestamp = timestamp

    def __str__(self):
        return "Bolt11InvoiceDetails(amount_msat={}, description={}, description_hash={}, expiry={}, invoice={}, min_final_cltv_expiry_delta={}, network={}, payee_pubkey={}, payment_hash={}, payment_secret={}, routing_hints={}, timestamp={})".format(self.amount_msat, self.description, self.description_hash, self.expiry, self.invoice, self.min_final_cltv_expiry_delta, self.network, self.payee_pubkey, self.payment_hash, self.payment_secret, self.routing_hints, self.timestamp)

    def __eq__(self, other):
        if self.amount_msat != other.amount_msat:
            return False
        if self.description != other.description:
            return False
        if self.description_hash != other.description_hash:
            return False
        if self.expiry != other.expiry:
            return False
        if self.invoice != other.invoice:
            return False
        if self.min_final_cltv_expiry_delta != other.min_final_cltv_expiry_delta:
            return False
        if self.network != other.network:
            return False
        if self.payee_pubkey != other.payee_pubkey:
            return False
        if self.payment_hash != other.payment_hash:
            return False
        if self.payment_secret != other.payment_secret:
            return False
        if self.routing_hints != other.routing_hints:
            return False
        if self.timestamp != other.timestamp:
            return False
        return True

class _UniffiConverterTypeBolt11InvoiceDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt11InvoiceDetails(
            amount_msat=_UniffiConverterOptionalUInt64.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
            description_hash=_UniffiConverterOptionalString.read(buf),
            expiry=_UniffiConverterUInt64.read(buf),
            invoice=_UniffiConverterTypeBolt11Invoice.read(buf),
            min_final_cltv_expiry_delta=_UniffiConverterUInt64.read(buf),
            network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            payee_pubkey=_UniffiConverterString.read(buf),
            payment_hash=_UniffiConverterString.read(buf),
            payment_secret=_UniffiConverterString.read(buf),
            routing_hints=_UniffiConverterSequenceTypeBolt11RouteHint.read(buf),
            timestamp=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt64.check_lower(value.amount_msat)
        _UniffiConverterOptionalString.check_lower(value.description)
        _UniffiConverterOptionalString.check_lower(value.description_hash)
        _UniffiConverterUInt64.check_lower(value.expiry)
        _UniffiConverterTypeBolt11Invoice.check_lower(value.invoice)
        _UniffiConverterUInt64.check_lower(value.min_final_cltv_expiry_delta)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.network)
        _UniffiConverterString.check_lower(value.payee_pubkey)
        _UniffiConverterString.check_lower(value.payment_hash)
        _UniffiConverterString.check_lower(value.payment_secret)
        _UniffiConverterSequenceTypeBolt11RouteHint.check_lower(value.routing_hints)
        _UniffiConverterUInt64.check_lower(value.timestamp)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt64.write(value.amount_msat, buf)
        _UniffiConverterOptionalString.write(value.description, buf)
        _UniffiConverterOptionalString.write(value.description_hash, buf)
        _UniffiConverterUInt64.write(value.expiry, buf)
        _UniffiConverterTypeBolt11Invoice.write(value.invoice, buf)
        _UniffiConverterUInt64.write(value.min_final_cltv_expiry_delta, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.network, buf)
        _UniffiConverterString.write(value.payee_pubkey, buf)
        _UniffiConverterString.write(value.payment_hash, buf)
        _UniffiConverterString.write(value.payment_secret, buf)
        _UniffiConverterSequenceTypeBolt11RouteHint.write(value.routing_hints, buf)
        _UniffiConverterUInt64.write(value.timestamp, buf)


class Bolt11RouteHint:
    hops: "typing.List[Bolt11RouteHintHop]"
    def __init__(self, *, hops: "typing.List[Bolt11RouteHintHop]"):
        self.hops = hops

    def __str__(self):
        return "Bolt11RouteHint(hops={})".format(self.hops)

    def __eq__(self, other):
        if self.hops != other.hops:
            return False
        return True

class _UniffiConverterTypeBolt11RouteHint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt11RouteHint(
            hops=_UniffiConverterSequenceTypeBolt11RouteHintHop.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeBolt11RouteHintHop.check_lower(value.hops)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeBolt11RouteHintHop.write(value.hops, buf)


class Bolt11RouteHintHop:
    src_node_id: "str"
    """
    The `node_id` of the non-target end of the route
    """

    short_channel_id: "str"
    """
    The `short_channel_id` of this channel
    """

    fees_base_msat: "int"
    """
    The fees which must be paid to use this channel
    """

    fees_proportional_millionths: "int"
    cltv_expiry_delta: "int"
    """
    The difference in CLTV values between this node and the next node.
    """

    htlc_minimum_msat: "typing.Optional[int]"
    """
    The minimum value, in msat, which must be relayed to the next hop.
    """

    htlc_maximum_msat: "typing.Optional[int]"
    """
    The maximum value in msat available for routing with a single HTLC.
    """

    def __init__(self, *, src_node_id: "str", short_channel_id: "str", fees_base_msat: "int", fees_proportional_millionths: "int", cltv_expiry_delta: "int", htlc_minimum_msat: "typing.Optional[int]", htlc_maximum_msat: "typing.Optional[int]"):
        self.src_node_id = src_node_id
        self.short_channel_id = short_channel_id
        self.fees_base_msat = fees_base_msat
        self.fees_proportional_millionths = fees_proportional_millionths
        self.cltv_expiry_delta = cltv_expiry_delta
        self.htlc_minimum_msat = htlc_minimum_msat
        self.htlc_maximum_msat = htlc_maximum_msat

    def __str__(self):
        return "Bolt11RouteHintHop(src_node_id={}, short_channel_id={}, fees_base_msat={}, fees_proportional_millionths={}, cltv_expiry_delta={}, htlc_minimum_msat={}, htlc_maximum_msat={})".format(self.src_node_id, self.short_channel_id, self.fees_base_msat, self.fees_proportional_millionths, self.cltv_expiry_delta, self.htlc_minimum_msat, self.htlc_maximum_msat)

    def __eq__(self, other):
        if self.src_node_id != other.src_node_id:
            return False
        if self.short_channel_id != other.short_channel_id:
            return False
        if self.fees_base_msat != other.fees_base_msat:
            return False
        if self.fees_proportional_millionths != other.fees_proportional_millionths:
            return False
        if self.cltv_expiry_delta != other.cltv_expiry_delta:
            return False
        if self.htlc_minimum_msat != other.htlc_minimum_msat:
            return False
        if self.htlc_maximum_msat != other.htlc_maximum_msat:
            return False
        return True

class _UniffiConverterTypeBolt11RouteHintHop(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt11RouteHintHop(
            src_node_id=_UniffiConverterString.read(buf),
            short_channel_id=_UniffiConverterString.read(buf),
            fees_base_msat=_UniffiConverterUInt32.read(buf),
            fees_proportional_millionths=_UniffiConverterUInt32.read(buf),
            cltv_expiry_delta=_UniffiConverterUInt16.read(buf),
            htlc_minimum_msat=_UniffiConverterOptionalUInt64.read(buf),
            htlc_maximum_msat=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.src_node_id)
        _UniffiConverterString.check_lower(value.short_channel_id)
        _UniffiConverterUInt32.check_lower(value.fees_base_msat)
        _UniffiConverterUInt32.check_lower(value.fees_proportional_millionths)
        _UniffiConverterUInt16.check_lower(value.cltv_expiry_delta)
        _UniffiConverterOptionalUInt64.check_lower(value.htlc_minimum_msat)
        _UniffiConverterOptionalUInt64.check_lower(value.htlc_maximum_msat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.src_node_id, buf)
        _UniffiConverterString.write(value.short_channel_id, buf)
        _UniffiConverterUInt32.write(value.fees_base_msat, buf)
        _UniffiConverterUInt32.write(value.fees_proportional_millionths, buf)
        _UniffiConverterUInt16.write(value.cltv_expiry_delta, buf)
        _UniffiConverterOptionalUInt64.write(value.htlc_minimum_msat, buf)
        _UniffiConverterOptionalUInt64.write(value.htlc_maximum_msat, buf)


class Bolt12Invoice:
    invoice: "str"
    source: "PaymentRequestSource"
    def __init__(self, *, invoice: "str", source: "PaymentRequestSource"):
        self.invoice = invoice
        self.source = source

    def __str__(self):
        return "Bolt12Invoice(invoice={}, source={})".format(self.invoice, self.source)

    def __eq__(self, other):
        if self.invoice != other.invoice:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeBolt12Invoice(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12Invoice(
            invoice=_UniffiConverterString.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.invoice)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.invoice, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class Bolt12InvoiceDetails:
    amount_msat: "int"
    invoice: "Bolt12Invoice"
    def __init__(self, *, amount_msat: "int", invoice: "Bolt12Invoice"):
        self.amount_msat = amount_msat
        self.invoice = invoice

    def __str__(self):
        return "Bolt12InvoiceDetails(amount_msat={}, invoice={})".format(self.amount_msat, self.invoice)

    def __eq__(self, other):
        if self.amount_msat != other.amount_msat:
            return False
        if self.invoice != other.invoice:
            return False
        return True

class _UniffiConverterTypeBolt12InvoiceDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12InvoiceDetails(
            amount_msat=_UniffiConverterUInt64.read(buf),
            invoice=_UniffiConverterTypeBolt12Invoice.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.amount_msat)
        _UniffiConverterTypeBolt12Invoice.check_lower(value.invoice)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.amount_msat, buf)
        _UniffiConverterTypeBolt12Invoice.write(value.invoice, buf)


class Bolt12InvoiceRequestDetails:

    def __str__(self):
        return "Bolt12InvoiceRequestDetails()".format()

    def __eq__(self, other):
        return True

class _UniffiConverterTypeBolt12InvoiceRequestDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12InvoiceRequestDetails(
        )

    @staticmethod
    def check_lower(value):
        pass

    @staticmethod
    def write(value, buf):
        pass


class Bolt12Offer:
    offer: "str"
    source: "PaymentRequestSource"
    def __init__(self, *, offer: "str", source: "PaymentRequestSource"):
        self.offer = offer
        self.source = source

    def __str__(self):
        return "Bolt12Offer(offer={}, source={})".format(self.offer, self.source)

    def __eq__(self, other):
        if self.offer != other.offer:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeBolt12Offer(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12Offer(
            offer=_UniffiConverterString.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.offer)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.offer, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class Bolt12OfferBlindedPath:
    blinded_hops: "typing.List[str]"
    def __init__(self, *, blinded_hops: "typing.List[str]"):
        self.blinded_hops = blinded_hops

    def __str__(self):
        return "Bolt12OfferBlindedPath(blinded_hops={})".format(self.blinded_hops)

    def __eq__(self, other):
        if self.blinded_hops != other.blinded_hops:
            return False
        return True

class _UniffiConverterTypeBolt12OfferBlindedPath(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12OfferBlindedPath(
            blinded_hops=_UniffiConverterSequenceString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceString.check_lower(value.blinded_hops)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceString.write(value.blinded_hops, buf)


class Bolt12OfferDetails:
    absolute_expiry: "typing.Optional[int]"
    chains: "typing.List[str]"
    description: "typing.Optional[str]"
    issuer: "typing.Optional[str]"
    min_amount: "typing.Optional[Amount]"
    offer: "Bolt12Offer"
    paths: "typing.List[Bolt12OfferBlindedPath]"
    signing_pubkey: "typing.Optional[str]"
    def __init__(self, *, absolute_expiry: "typing.Optional[int]", chains: "typing.List[str]", description: "typing.Optional[str]", issuer: "typing.Optional[str]", min_amount: "typing.Optional[Amount]", offer: "Bolt12Offer", paths: "typing.List[Bolt12OfferBlindedPath]", signing_pubkey: "typing.Optional[str]"):
        self.absolute_expiry = absolute_expiry
        self.chains = chains
        self.description = description
        self.issuer = issuer
        self.min_amount = min_amount
        self.offer = offer
        self.paths = paths
        self.signing_pubkey = signing_pubkey

    def __str__(self):
        return "Bolt12OfferDetails(absolute_expiry={}, chains={}, description={}, issuer={}, min_amount={}, offer={}, paths={}, signing_pubkey={})".format(self.absolute_expiry, self.chains, self.description, self.issuer, self.min_amount, self.offer, self.paths, self.signing_pubkey)

    def __eq__(self, other):
        if self.absolute_expiry != other.absolute_expiry:
            return False
        if self.chains != other.chains:
            return False
        if self.description != other.description:
            return False
        if self.issuer != other.issuer:
            return False
        if self.min_amount != other.min_amount:
            return False
        if self.offer != other.offer:
            return False
        if self.paths != other.paths:
            return False
        if self.signing_pubkey != other.signing_pubkey:
            return False
        return True

class _UniffiConverterTypeBolt12OfferDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Bolt12OfferDetails(
            absolute_expiry=_UniffiConverterOptionalUInt64.read(buf),
            chains=_UniffiConverterSequenceString.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
            issuer=_UniffiConverterOptionalString.read(buf),
            min_amount=_UniffiConverterOptionalTypeAmount.read(buf),
            offer=_UniffiConverterTypeBolt12Offer.read(buf),
            paths=_UniffiConverterSequenceTypeBolt12OfferBlindedPath.read(buf),
            signing_pubkey=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt64.check_lower(value.absolute_expiry)
        _UniffiConverterSequenceString.check_lower(value.chains)
        _UniffiConverterOptionalString.check_lower(value.description)
        _UniffiConverterOptionalString.check_lower(value.issuer)
        _UniffiConverterOptionalTypeAmount.check_lower(value.min_amount)
        _UniffiConverterTypeBolt12Offer.check_lower(value.offer)
        _UniffiConverterSequenceTypeBolt12OfferBlindedPath.check_lower(value.paths)
        _UniffiConverterOptionalString.check_lower(value.signing_pubkey)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt64.write(value.absolute_expiry, buf)
        _UniffiConverterSequenceString.write(value.chains, buf)
        _UniffiConverterOptionalString.write(value.description, buf)
        _UniffiConverterOptionalString.write(value.issuer, buf)
        _UniffiConverterOptionalTypeAmount.write(value.min_amount, buf)
        _UniffiConverterTypeBolt12Offer.write(value.offer, buf)
        _UniffiConverterSequenceTypeBolt12OfferBlindedPath.write(value.paths, buf)
        _UniffiConverterOptionalString.write(value.signing_pubkey, buf)


class CurrencyInfo:
    """
    Details about a supported currency in the fiat rate feed
    """

    name: "str"
    fraction_size: "int"
    spacing: "typing.Optional[int]"
    symbol: "typing.Optional[Symbol]"
    uniq_symbol: "typing.Optional[Symbol]"
    localized_name: "typing.List[LocalizedName]"
    locale_overrides: "typing.List[LocaleOverrides]"
    def __init__(self, *, name: "str", fraction_size: "int", spacing: "typing.Optional[int]", symbol: "typing.Optional[Symbol]", uniq_symbol: "typing.Optional[Symbol]", localized_name: "typing.List[LocalizedName]", locale_overrides: "typing.List[LocaleOverrides]"):
        self.name = name
        self.fraction_size = fraction_size
        self.spacing = spacing
        self.symbol = symbol
        self.uniq_symbol = uniq_symbol
        self.localized_name = localized_name
        self.locale_overrides = locale_overrides

    def __str__(self):
        return "CurrencyInfo(name={}, fraction_size={}, spacing={}, symbol={}, uniq_symbol={}, localized_name={}, locale_overrides={})".format(self.name, self.fraction_size, self.spacing, self.symbol, self.uniq_symbol, self.localized_name, self.locale_overrides)

    def __eq__(self, other):
        if self.name != other.name:
            return False
        if self.fraction_size != other.fraction_size:
            return False
        if self.spacing != other.spacing:
            return False
        if self.symbol != other.symbol:
            return False
        if self.uniq_symbol != other.uniq_symbol:
            return False
        if self.localized_name != other.localized_name:
            return False
        if self.locale_overrides != other.locale_overrides:
            return False
        return True

class _UniffiConverterTypeCurrencyInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CurrencyInfo(
            name=_UniffiConverterString.read(buf),
            fraction_size=_UniffiConverterUInt32.read(buf),
            spacing=_UniffiConverterOptionalUInt32.read(buf),
            symbol=_UniffiConverterOptionalTypeSymbol.read(buf),
            uniq_symbol=_UniffiConverterOptionalTypeSymbol.read(buf),
            localized_name=_UniffiConverterSequenceTypeLocalizedName.read(buf),
            locale_overrides=_UniffiConverterSequenceTypeLocaleOverrides.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt32.check_lower(value.fraction_size)
        _UniffiConverterOptionalUInt32.check_lower(value.spacing)
        _UniffiConverterOptionalTypeSymbol.check_lower(value.symbol)
        _UniffiConverterOptionalTypeSymbol.check_lower(value.uniq_symbol)
        _UniffiConverterSequenceTypeLocalizedName.check_lower(value.localized_name)
        _UniffiConverterSequenceTypeLocaleOverrides.check_lower(value.locale_overrides)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt32.write(value.fraction_size, buf)
        _UniffiConverterOptionalUInt32.write(value.spacing, buf)
        _UniffiConverterOptionalTypeSymbol.write(value.symbol, buf)
        _UniffiConverterOptionalTypeSymbol.write(value.uniq_symbol, buf)
        _UniffiConverterSequenceTypeLocalizedName.write(value.localized_name, buf)
        _UniffiConverterSequenceTypeLocaleOverrides.write(value.locale_overrides, buf)


class FiatCurrency:
    """
    Wrapper around the [`CurrencyInfo`] of a fiat currency
    """

    id: "str"
    info: "CurrencyInfo"
    def __init__(self, *, id: "str", info: "CurrencyInfo"):
        self.id = id
        self.info = info

    def __str__(self):
        return "FiatCurrency(id={}, info={})".format(self.id, self.info)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.info != other.info:
            return False
        return True

class _UniffiConverterTypeFiatCurrency(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return FiatCurrency(
            id=_UniffiConverterString.read(buf),
            info=_UniffiConverterTypeCurrencyInfo.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.id)
        _UniffiConverterTypeCurrencyInfo.check_lower(value.info)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.id, buf)
        _UniffiConverterTypeCurrencyInfo.write(value.info, buf)


class LightningAddressDetails:
    address: "str"
    pay_request: "LnurlPayRequestDetails"
    def __init__(self, *, address: "str", pay_request: "LnurlPayRequestDetails"):
        self.address = address
        self.pay_request = pay_request

    def __str__(self):
        return "LightningAddressDetails(address={}, pay_request={})".format(self.address, self.pay_request)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.pay_request != other.pay_request:
            return False
        return True

class _UniffiConverterTypeLightningAddressDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LightningAddressDetails(
            address=_UniffiConverterString.read(buf),
            pay_request=_UniffiConverterTypeLnurlPayRequestDetails.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeLnurlPayRequestDetails.check_lower(value.pay_request)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeLnurlPayRequestDetails.write(value.pay_request, buf)


class LnurlAuthRequestDetails:
    """
    Wrapped in a [`LnurlAuth`], this is the result of [`parse`] when given a LNURL-auth endpoint.

    It represents the endpoint's parameters for the LNURL workflow.

    See <https://github.com/lnurl/luds/blob/luds/04.md>
    """

    k1: "str"
    """
    Hex encoded 32 bytes of challenge
    """

    action: "typing.Optional[str]"
    """
    When available, one of: register, login, link, auth
    """

    domain: "str"
    """
    Indicates the domain of the LNURL-auth service, to be shown to the user when asking for
    auth confirmation, as per LUD-04 spec.
    """

    url: "str"
    """
    Indicates the URL of the LNURL-auth service, including the query arguments. This will be
    extended with the signed challenge and the linking key, then called in the second step of the workflow.
    """

    def __init__(self, *, k1: "str", action: "typing.Optional[str]", domain: "str", url: "str"):
        self.k1 = k1
        self.action = action
        self.domain = domain
        self.url = url

    def __str__(self):
        return "LnurlAuthRequestDetails(k1={}, action={}, domain={}, url={})".format(self.k1, self.action, self.domain, self.url)

    def __eq__(self, other):
        if self.k1 != other.k1:
            return False
        if self.action != other.action:
            return False
        if self.domain != other.domain:
            return False
        if self.url != other.url:
            return False
        return True

class _UniffiConverterTypeLnurlAuthRequestDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlAuthRequestDetails(
            k1=_UniffiConverterString.read(buf),
            action=_UniffiConverterOptionalString.read(buf),
            domain=_UniffiConverterString.read(buf),
            url=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.k1)
        _UniffiConverterOptionalString.check_lower(value.action)
        _UniffiConverterString.check_lower(value.domain)
        _UniffiConverterString.check_lower(value.url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.k1, buf)
        _UniffiConverterOptionalString.write(value.action, buf)
        _UniffiConverterString.write(value.domain, buf)
        _UniffiConverterString.write(value.url, buf)


class LnurlErrorDetails:
    """
    Wrapped in a [`LnUrlError`], this represents a LNURL-endpoint error.
    """

    reason: "str"
    def __init__(self, *, reason: "str"):
        self.reason = reason

    def __str__(self):
        return "LnurlErrorDetails(reason={})".format(self.reason)

    def __eq__(self, other):
        if self.reason != other.reason:
            return False
        return True

class _UniffiConverterTypeLnurlErrorDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlErrorDetails(
            reason=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.reason)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.reason, buf)


class LnurlPayRequestDetails:
    callback: "str"
    min_sendable: "int"
    """
    The minimum amount, in millisats, that this LNURL-pay endpoint accepts
    """

    max_sendable: "int"
    """
    The maximum amount, in millisats, that this LNURL-pay endpoint accepts
    """

    metadata_str: "str"
    """
    As per LUD-06, `metadata` is a raw string (e.g. a json representation of the inner map).
    Use `metadata_vec()` to get the parsed items.
    """

    comment_allowed: "int"
    """
    The comment length accepted by this endpoint

    See <https://github.com/lnurl/luds/blob/luds/12.md>
    """

    domain: "str"
    """
    Indicates the domain of the LNURL-pay service, to be shown to the user when asking for
    payment input, as per LUD-06 spec.

    Note: this is not the domain of the callback, but the domain of the LNURL-pay endpoint.
    """

    url: "str"
    address: "typing.Optional[str]"
    """
    Optional lightning address if that was used to resolve the lnurl.
    """

    allows_nostr: "bool"
    """
    Value indicating whether the recipient supports Nostr Zaps through NIP-57.

    See <https://github.com/nostr-protocol/nips/blob/master/57.md>
    """

    nostr_pubkey: "typing.Optional[str]"
    """
    Optional recipient's lnurl provider's Nostr pubkey for NIP-57. If it exists it should be a
    valid BIP 340 public key in hex.

    See <https://github.com/nostr-protocol/nips/blob/master/57.md>
    See <https://github.com/bitcoin/bips/blob/master/bip-0340.mediawiki>
    """

    def __init__(self, *, callback: "str", min_sendable: "int", max_sendable: "int", metadata_str: "str", comment_allowed: "int", domain: "str", url: "str", address: "typing.Optional[str]", allows_nostr: "bool", nostr_pubkey: "typing.Optional[str]"):
        self.callback = callback
        self.min_sendable = min_sendable
        self.max_sendable = max_sendable
        self.metadata_str = metadata_str
        self.comment_allowed = comment_allowed
        self.domain = domain
        self.url = url
        self.address = address
        self.allows_nostr = allows_nostr
        self.nostr_pubkey = nostr_pubkey

    def __str__(self):
        return "LnurlPayRequestDetails(callback={}, min_sendable={}, max_sendable={}, metadata_str={}, comment_allowed={}, domain={}, url={}, address={}, allows_nostr={}, nostr_pubkey={})".format(self.callback, self.min_sendable, self.max_sendable, self.metadata_str, self.comment_allowed, self.domain, self.url, self.address, self.allows_nostr, self.nostr_pubkey)

    def __eq__(self, other):
        if self.callback != other.callback:
            return False
        if self.min_sendable != other.min_sendable:
            return False
        if self.max_sendable != other.max_sendable:
            return False
        if self.metadata_str != other.metadata_str:
            return False
        if self.comment_allowed != other.comment_allowed:
            return False
        if self.domain != other.domain:
            return False
        if self.url != other.url:
            return False
        if self.address != other.address:
            return False
        if self.allows_nostr != other.allows_nostr:
            return False
        if self.nostr_pubkey != other.nostr_pubkey:
            return False
        return True

class _UniffiConverterTypeLnurlPayRequestDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlPayRequestDetails(
            callback=_UniffiConverterString.read(buf),
            min_sendable=_UniffiConverterUInt64.read(buf),
            max_sendable=_UniffiConverterUInt64.read(buf),
            metadata_str=_UniffiConverterString.read(buf),
            comment_allowed=_UniffiConverterUInt16.read(buf),
            domain=_UniffiConverterString.read(buf),
            url=_UniffiConverterString.read(buf),
            address=_UniffiConverterOptionalString.read(buf),
            allows_nostr=_UniffiConverterBool.read(buf),
            nostr_pubkey=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.callback)
        _UniffiConverterUInt64.check_lower(value.min_sendable)
        _UniffiConverterUInt64.check_lower(value.max_sendable)
        _UniffiConverterString.check_lower(value.metadata_str)
        _UniffiConverterUInt16.check_lower(value.comment_allowed)
        _UniffiConverterString.check_lower(value.domain)
        _UniffiConverterString.check_lower(value.url)
        _UniffiConverterOptionalString.check_lower(value.address)
        _UniffiConverterBool.check_lower(value.allows_nostr)
        _UniffiConverterOptionalString.check_lower(value.nostr_pubkey)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.callback, buf)
        _UniffiConverterUInt64.write(value.min_sendable, buf)
        _UniffiConverterUInt64.write(value.max_sendable, buf)
        _UniffiConverterString.write(value.metadata_str, buf)
        _UniffiConverterUInt16.write(value.comment_allowed, buf)
        _UniffiConverterString.write(value.domain, buf)
        _UniffiConverterString.write(value.url, buf)
        _UniffiConverterOptionalString.write(value.address, buf)
        _UniffiConverterBool.write(value.allows_nostr, buf)
        _UniffiConverterOptionalString.write(value.nostr_pubkey, buf)


class LnurlWithdrawRequestDetails:
    callback: "str"
    k1: "str"
    default_description: "str"
    min_withdrawable: "int"
    """
    The minimum amount, in millisats, that this LNURL-withdraw endpoint accepts
    """

    max_withdrawable: "int"
    """
    The maximum amount, in millisats, that this LNURL-withdraw endpoint accepts
    """

    def __init__(self, *, callback: "str", k1: "str", default_description: "str", min_withdrawable: "int", max_withdrawable: "int"):
        self.callback = callback
        self.k1 = k1
        self.default_description = default_description
        self.min_withdrawable = min_withdrawable
        self.max_withdrawable = max_withdrawable

    def __str__(self):
        return "LnurlWithdrawRequestDetails(callback={}, k1={}, default_description={}, min_withdrawable={}, max_withdrawable={})".format(self.callback, self.k1, self.default_description, self.min_withdrawable, self.max_withdrawable)

    def __eq__(self, other):
        if self.callback != other.callback:
            return False
        if self.k1 != other.k1:
            return False
        if self.default_description != other.default_description:
            return False
        if self.min_withdrawable != other.min_withdrawable:
            return False
        if self.max_withdrawable != other.max_withdrawable:
            return False
        return True

class _UniffiConverterTypeLnurlWithdrawRequestDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlWithdrawRequestDetails(
            callback=_UniffiConverterString.read(buf),
            k1=_UniffiConverterString.read(buf),
            default_description=_UniffiConverterString.read(buf),
            min_withdrawable=_UniffiConverterUInt64.read(buf),
            max_withdrawable=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.callback)
        _UniffiConverterString.check_lower(value.k1)
        _UniffiConverterString.check_lower(value.default_description)
        _UniffiConverterUInt64.check_lower(value.min_withdrawable)
        _UniffiConverterUInt64.check_lower(value.max_withdrawable)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.callback, buf)
        _UniffiConverterString.write(value.k1, buf)
        _UniffiConverterString.write(value.default_description, buf)
        _UniffiConverterUInt64.write(value.min_withdrawable, buf)
        _UniffiConverterUInt64.write(value.max_withdrawable, buf)


class LocaleOverrides:
    """
    Locale-specific settings for the representation of a currency
    """

    locale: "str"
    spacing: "typing.Optional[int]"
    symbol: "Symbol"
    def __init__(self, *, locale: "str", spacing: "typing.Optional[int]", symbol: "Symbol"):
        self.locale = locale
        self.spacing = spacing
        self.symbol = symbol

    def __str__(self):
        return "LocaleOverrides(locale={}, spacing={}, symbol={})".format(self.locale, self.spacing, self.symbol)

    def __eq__(self, other):
        if self.locale != other.locale:
            return False
        if self.spacing != other.spacing:
            return False
        if self.symbol != other.symbol:
            return False
        return True

class _UniffiConverterTypeLocaleOverrides(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocaleOverrides(
            locale=_UniffiConverterString.read(buf),
            spacing=_UniffiConverterOptionalUInt32.read(buf),
            symbol=_UniffiConverterTypeSymbol.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.locale)
        _UniffiConverterOptionalUInt32.check_lower(value.spacing)
        _UniffiConverterTypeSymbol.check_lower(value.symbol)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.locale, buf)
        _UniffiConverterOptionalUInt32.write(value.spacing, buf)
        _UniffiConverterTypeSymbol.write(value.symbol, buf)


class LocalizedName:
    """
    Localized name of a currency
    """

    locale: "str"
    name: "str"
    def __init__(self, *, locale: "str", name: "str"):
        self.locale = locale
        self.name = name

    def __str__(self):
        return "LocalizedName(locale={}, name={})".format(self.locale, self.name)

    def __eq__(self, other):
        if self.locale != other.locale:
            return False
        if self.name != other.name:
            return False
        return True

class _UniffiConverterTypeLocalizedName(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalizedName(
            locale=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.locale)
        _UniffiConverterString.check_lower(value.name)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.locale, buf)
        _UniffiConverterString.write(value.name, buf)


class MessageSuccessActionData:
    message: "str"
    def __init__(self, *, message: "str"):
        self.message = message

    def __str__(self):
        return "MessageSuccessActionData(message={})".format(self.message)

    def __eq__(self, other):
        if self.message != other.message:
            return False
        return True

class _UniffiConverterTypeMessageSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return MessageSuccessActionData(
            message=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.message)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.message, buf)


class PaymentRequestSource:
    bip_21_uri: "typing.Optional[str]"
    bip_353_address: "typing.Optional[str]"
    def __init__(self, *, bip_21_uri: "typing.Optional[str]", bip_353_address: "typing.Optional[str]"):
        self.bip_21_uri = bip_21_uri
        self.bip_353_address = bip_353_address

    def __str__(self):
        return "PaymentRequestSource(bip_21_uri={}, bip_353_address={})".format(self.bip_21_uri, self.bip_353_address)

    def __eq__(self, other):
        if self.bip_21_uri != other.bip_21_uri:
            return False
        if self.bip_353_address != other.bip_353_address:
            return False
        return True

class _UniffiConverterTypePaymentRequestSource(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PaymentRequestSource(
            bip_21_uri=_UniffiConverterOptionalString.read(buf),
            bip_353_address=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.bip_21_uri)
        _UniffiConverterOptionalString.check_lower(value.bip_353_address)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.bip_21_uri, buf)
        _UniffiConverterOptionalString.write(value.bip_353_address, buf)


class Rate:
    """
    Denominator in an exchange rate
    """

    coin: "str"
    value: "float"
    def __init__(self, *, coin: "str", value: "float"):
        self.coin = coin
        self.value = value

    def __str__(self):
        return "Rate(coin={}, value={})".format(self.coin, self.value)

    def __eq__(self, other):
        if self.coin != other.coin:
            return False
        if self.value != other.value:
            return False
        return True

class _UniffiConverterTypeRate(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Rate(
            coin=_UniffiConverterString.read(buf),
            value=_UniffiConverterDouble.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.coin)
        _UniffiConverterDouble.check_lower(value.value)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.coin, buf)
        _UniffiConverterDouble.write(value.value, buf)


class RestResponse:
    status: "int"
    body: "str"
    def __init__(self, *, status: "int", body: "str"):
        self.status = status
        self.body = body

    def __str__(self):
        return "RestResponse(status={}, body={})".format(self.status, self.body)

    def __eq__(self, other):
        if self.status != other.status:
            return False
        if self.body != other.body:
            return False
        return True

class _UniffiConverterTypeRestResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RestResponse(
            status=_UniffiConverterUInt16.read(buf),
            body=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt16.check_lower(value.status)
        _UniffiConverterString.check_lower(value.body)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt16.write(value.status, buf)
        _UniffiConverterString.write(value.body, buf)


class SatsPayment:
    amount: "typing.Optional[int]"
    def __init__(self, *, amount: "typing.Optional[int]"):
        self.amount = amount

    def __str__(self):
        return "SatsPayment(amount={})".format(self.amount)

    def __eq__(self, other):
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypeSatsPayment(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SatsPayment(
            amount=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt64.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt64.write(value.amount, buf)


class SilentPaymentAddressDetails:
    address: "str"
    network: "BitcoinNetwork"
    source: "PaymentRequestSource"
    def __init__(self, *, address: "str", network: "BitcoinNetwork", source: "PaymentRequestSource"):
        self.address = address
        self.network = network
        self.source = source

    def __str__(self):
        return "SilentPaymentAddressDetails(address={}, network={}, source={})".format(self.address, self.network, self.source)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.network != other.network:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeSilentPaymentAddressDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SilentPaymentAddressDetails(
            address=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.network)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.network, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class SparkAddress:
    identity_public_key: "str"
    network: "BitcoinNetwork"
    spark_invoice_fields: "typing.Optional[SparkInvoiceFields]"
    signature: "typing.Optional[str]"
    def __init__(self, *, identity_public_key: "str", network: "BitcoinNetwork", spark_invoice_fields: "typing.Optional[SparkInvoiceFields]", signature: "typing.Optional[str]"):
        self.identity_public_key = identity_public_key
        self.network = network
        self.spark_invoice_fields = spark_invoice_fields
        self.signature = signature

    def __str__(self):
        return "SparkAddress(identity_public_key={}, network={}, spark_invoice_fields={}, signature={})".format(self.identity_public_key, self.network, self.spark_invoice_fields, self.signature)

    def __eq__(self, other):
        if self.identity_public_key != other.identity_public_key:
            return False
        if self.network != other.network:
            return False
        if self.spark_invoice_fields != other.spark_invoice_fields:
            return False
        if self.signature != other.signature:
            return False
        return True

class _UniffiConverterTypeSparkAddress(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SparkAddress(
            identity_public_key=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeBitcoinNetwork.read(buf),
            spark_invoice_fields=_UniffiConverterOptionalTypeSparkInvoiceFields.read(buf),
            signature=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.identity_public_key)
        _UniffiConverterTypeBitcoinNetwork.check_lower(value.network)
        _UniffiConverterOptionalTypeSparkInvoiceFields.check_lower(value.spark_invoice_fields)
        _UniffiConverterOptionalString.check_lower(value.signature)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.identity_public_key, buf)
        _UniffiConverterTypeBitcoinNetwork.write(value.network, buf)
        _UniffiConverterOptionalTypeSparkInvoiceFields.write(value.spark_invoice_fields, buf)
        _UniffiConverterOptionalString.write(value.signature, buf)


class SparkAddressDetails:
    address: "str"
    decoded_address: "SparkAddress"
    source: "PaymentRequestSource"
    def __init__(self, *, address: "str", decoded_address: "SparkAddress", source: "PaymentRequestSource"):
        self.address = address
        self.decoded_address = decoded_address
        self.source = source

    def __str__(self):
        return "SparkAddressDetails(address={}, decoded_address={}, source={})".format(self.address, self.decoded_address, self.source)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.decoded_address != other.decoded_address:
            return False
        if self.source != other.source:
            return False
        return True

class _UniffiConverterTypeSparkAddressDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SparkAddressDetails(
            address=_UniffiConverterString.read(buf),
            decoded_address=_UniffiConverterTypeSparkAddress.read(buf),
            source=_UniffiConverterTypePaymentRequestSource.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeSparkAddress.check_lower(value.decoded_address)
        _UniffiConverterTypePaymentRequestSource.check_lower(value.source)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeSparkAddress.write(value.decoded_address, buf)
        _UniffiConverterTypePaymentRequestSource.write(value.source, buf)


class SparkInvoiceFields:
    id: "str"
    version: "int"
    memo: "typing.Optional[str]"
    sender_public_key: "typing.Optional[str]"
    expiry_time: "typing.Optional[int]"
    payment_type: "typing.Optional[SparkAddressPaymentType]"
    def __init__(self, *, id: "str", version: "int", memo: "typing.Optional[str]", sender_public_key: "typing.Optional[str]", expiry_time: "typing.Optional[int]", payment_type: "typing.Optional[SparkAddressPaymentType]"):
        self.id = id
        self.version = version
        self.memo = memo
        self.sender_public_key = sender_public_key
        self.expiry_time = expiry_time
        self.payment_type = payment_type

    def __str__(self):
        return "SparkInvoiceFields(id={}, version={}, memo={}, sender_public_key={}, expiry_time={}, payment_type={})".format(self.id, self.version, self.memo, self.sender_public_key, self.expiry_time, self.payment_type)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.version != other.version:
            return False
        if self.memo != other.memo:
            return False
        if self.sender_public_key != other.sender_public_key:
            return False
        if self.expiry_time != other.expiry_time:
            return False
        if self.payment_type != other.payment_type:
            return False
        return True

class _UniffiConverterTypeSparkInvoiceFields(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SparkInvoiceFields(
            id=_UniffiConverterString.read(buf),
            version=_UniffiConverterUInt32.read(buf),
            memo=_UniffiConverterOptionalString.read(buf),
            sender_public_key=_UniffiConverterOptionalString.read(buf),
            expiry_time=_UniffiConverterOptionalUInt64.read(buf),
            payment_type=_UniffiConverterOptionalTypeSparkAddressPaymentType.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.id)
        _UniffiConverterUInt32.check_lower(value.version)
        _UniffiConverterOptionalString.check_lower(value.memo)
        _UniffiConverterOptionalString.check_lower(value.sender_public_key)
        _UniffiConverterOptionalUInt64.check_lower(value.expiry_time)
        _UniffiConverterOptionalTypeSparkAddressPaymentType.check_lower(value.payment_type)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.id, buf)
        _UniffiConverterUInt32.write(value.version, buf)
        _UniffiConverterOptionalString.write(value.memo, buf)
        _UniffiConverterOptionalString.write(value.sender_public_key, buf)
        _UniffiConverterOptionalUInt64.write(value.expiry_time, buf)
        _UniffiConverterOptionalTypeSparkAddressPaymentType.write(value.payment_type, buf)


class Symbol:
    """
    Settings for the symbol representation of a currency
    """

    grapheme: "typing.Optional[str]"
    template: "typing.Optional[str]"
    rtl: "typing.Optional[bool]"
    position: "typing.Optional[int]"
    def __init__(self, *, grapheme: "typing.Optional[str]", template: "typing.Optional[str]", rtl: "typing.Optional[bool]", position: "typing.Optional[int]"):
        self.grapheme = grapheme
        self.template = template
        self.rtl = rtl
        self.position = position

    def __str__(self):
        return "Symbol(grapheme={}, template={}, rtl={}, position={})".format(self.grapheme, self.template, self.rtl, self.position)

    def __eq__(self, other):
        if self.grapheme != other.grapheme:
            return False
        if self.template != other.template:
            return False
        if self.rtl != other.rtl:
            return False
        if self.position != other.position:
            return False
        return True

class _UniffiConverterTypeSymbol(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Symbol(
            grapheme=_UniffiConverterOptionalString.read(buf),
            template=_UniffiConverterOptionalString.read(buf),
            rtl=_UniffiConverterOptionalBool.read(buf),
            position=_UniffiConverterOptionalUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.grapheme)
        _UniffiConverterOptionalString.check_lower(value.template)
        _UniffiConverterOptionalBool.check_lower(value.rtl)
        _UniffiConverterOptionalUInt32.check_lower(value.position)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.grapheme, buf)
        _UniffiConverterOptionalString.write(value.template, buf)
        _UniffiConverterOptionalBool.write(value.rtl, buf)
        _UniffiConverterOptionalUInt32.write(value.position, buf)


class TokensPayment:
    token_identifier: "typing.Optional[str]"
    amount: "typing.Optional[int]"
    def __init__(self, *, token_identifier: "typing.Optional[str]", amount: "typing.Optional[int]"):
        self.token_identifier = token_identifier
        self.amount = amount

    def __str__(self):
        return "TokensPayment(token_identifier={}, amount={})".format(self.token_identifier, self.amount)

    def __eq__(self, other):
        if self.token_identifier != other.token_identifier:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypeTokensPayment(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TokensPayment(
            token_identifier=_UniffiConverterOptionalString.read(buf),
            amount=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.token_identifier)
        _UniffiConverterOptionalUInt64.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.token_identifier, buf)
        _UniffiConverterOptionalUInt64.write(value.amount, buf)


class UrlSuccessActionData:
    description: "str"
    """
    Contents description, up to 144 characters
    """

    url: "str"
    """
    URL of the success action
    """

    matches_callback_domain: "bool"
    """
    Indicates the success URL domain matches the LNURL callback domain.

    See <https://github.com/lnurl/luds/blob/luds/09.md>
    """

    def __init__(self, *, description: "str", url: "str", matches_callback_domain: "bool"):
        self.description = description
        self.url = url
        self.matches_callback_domain = matches_callback_domain

    def __str__(self):
        return "UrlSuccessActionData(description={}, url={}, matches_callback_domain={})".format(self.description, self.url, self.matches_callback_domain)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.url != other.url:
            return False
        if self.matches_callback_domain != other.matches_callback_domain:
            return False
        return True

class _UniffiConverterTypeUrlSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return UrlSuccessActionData(
            description=_UniffiConverterString.read(buf),
            url=_UniffiConverterString.read(buf),
            matches_callback_domain=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.url)
        _UniffiConverterBool.check_lower(value.matches_callback_domain)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.url, buf)
        _UniffiConverterBool.write(value.matches_callback_domain, buf)





class AesSuccessActionDataResult:
    """
    Result of decryption of [`AesSuccessActionData`] payload
    """

    def __init__(self):
        raise RuntimeError("AesSuccessActionDataResult cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class DECRYPTED:
        data: "AesSuccessActionDataDecrypted"

        def __init__(self,data: "AesSuccessActionDataDecrypted"):
            self.data = data

        def __str__(self):
            return "AesSuccessActionDataResult.DECRYPTED(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_decrypted():
                return False
            if self.data != other.data:
                return False
            return True
    
    class ERROR_STATUS:
        reason: "str"

        def __init__(self,reason: "str"):
            self.reason = reason

        def __str__(self):
            return "AesSuccessActionDataResult.ERROR_STATUS(reason={})".format(self.reason)

        def __eq__(self, other):
            if not other.is_error_status():
                return False
            if self.reason != other.reason:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_decrypted(self) -> bool:
        return isinstance(self, AesSuccessActionDataResult.DECRYPTED)
    def is_error_status(self) -> bool:
        return isinstance(self, AesSuccessActionDataResult.ERROR_STATUS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
AesSuccessActionDataResult.DECRYPTED = type("AesSuccessActionDataResult.DECRYPTED", (AesSuccessActionDataResult.DECRYPTED, AesSuccessActionDataResult,), {})  # type: ignore
AesSuccessActionDataResult.ERROR_STATUS = type("AesSuccessActionDataResult.ERROR_STATUS", (AesSuccessActionDataResult.ERROR_STATUS, AesSuccessActionDataResult,), {})  # type: ignore




class _UniffiConverterTypeAesSuccessActionDataResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AesSuccessActionDataResult.DECRYPTED(
                _UniffiConverterTypeAesSuccessActionDataDecrypted.read(buf),
            )
        if variant == 2:
            return AesSuccessActionDataResult.ERROR_STATUS(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_decrypted():
            _UniffiConverterTypeAesSuccessActionDataDecrypted.check_lower(value.data)
            return
        if value.is_error_status():
            _UniffiConverterString.check_lower(value.reason)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_decrypted():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionDataDecrypted.write(value.data, buf)
        if value.is_error_status():
            buf.write_i32(2)
            _UniffiConverterString.write(value.reason, buf)







class Amount:
    def __init__(self):
        raise RuntimeError("Amount cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN:
        amount_msat: "int"

        def __init__(self,amount_msat: "int"):
            self.amount_msat = amount_msat

        def __str__(self):
            return "Amount.BITCOIN(amount_msat={})".format(self.amount_msat)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.amount_msat != other.amount_msat:
                return False
            return True
    
    class CURRENCY:
        """
        An amount of currency specified using ISO 4712.
        """

        iso4217_code: "str"
        """
        The currency that the amount is denominated in.
        """

        fractional_amount: "int"
        """
        The amount in the currency unit adjusted by the ISO 4712 exponent (e.g., USD cents).
        """


        def __init__(self,iso4217_code: "str", fractional_amount: "int"):
            self.iso4217_code = iso4217_code
            self.fractional_amount = fractional_amount

        def __str__(self):
            return "Amount.CURRENCY(iso4217_code={}, fractional_amount={})".format(self.iso4217_code, self.fractional_amount)

        def __eq__(self, other):
            if not other.is_currency():
                return False
            if self.iso4217_code != other.iso4217_code:
                return False
            if self.fractional_amount != other.fractional_amount:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin(self) -> bool:
        return isinstance(self, Amount.BITCOIN)
    def is_currency(self) -> bool:
        return isinstance(self, Amount.CURRENCY)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Amount.BITCOIN = type("Amount.BITCOIN", (Amount.BITCOIN, Amount,), {})  # type: ignore
Amount.CURRENCY = type("Amount.CURRENCY", (Amount.CURRENCY, Amount,), {})  # type: ignore




class _UniffiConverterTypeAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Amount.BITCOIN(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return Amount.CURRENCY(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin():
            _UniffiConverterUInt64.check_lower(value.amount_msat)
            return
        if value.is_currency():
            _UniffiConverterString.check_lower(value.iso4217_code)
            _UniffiConverterUInt64.check_lower(value.fractional_amount)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.amount_msat, buf)
        if value.is_currency():
            buf.write_i32(2)
            _UniffiConverterString.write(value.iso4217_code, buf)
            _UniffiConverterUInt64.write(value.fractional_amount, buf)







class BitcoinNetwork(enum.Enum):
    BITCOIN = 0
    """
    Mainnet
    """

    
    TESTNET3 = 1
    
    TESTNET4 = 2
    
    SIGNET = 3
    
    REGTEST = 4
    


class _UniffiConverterTypeBitcoinNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return BitcoinNetwork.BITCOIN
        if variant == 2:
            return BitcoinNetwork.TESTNET3
        if variant == 3:
            return BitcoinNetwork.TESTNET4
        if variant == 4:
            return BitcoinNetwork.SIGNET
        if variant == 5:
            return BitcoinNetwork.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == BitcoinNetwork.BITCOIN:
            return
        if value == BitcoinNetwork.TESTNET3:
            return
        if value == BitcoinNetwork.TESTNET4:
            return
        if value == BitcoinNetwork.SIGNET:
            return
        if value == BitcoinNetwork.REGTEST:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == BitcoinNetwork.BITCOIN:
            buf.write_i32(1)
        if value == BitcoinNetwork.TESTNET3:
            buf.write_i32(2)
        if value == BitcoinNetwork.TESTNET4:
            buf.write_i32(3)
        if value == BitcoinNetwork.SIGNET:
            buf.write_i32(4)
        if value == BitcoinNetwork.REGTEST:
            buf.write_i32(5)







class InputType:
    def __init__(self):
        raise RuntimeError("InputType cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN_ADDRESS:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], BitcoinAddressDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'BitcoinAddressDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BITCOIN_ADDRESS{self._values!r}"

        def __eq__(self, other):
            if not other.is_bitcoin_address():
                return False
            return self._values == other._values
    class BOLT11_INVOICE:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], Bolt11InvoiceDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'Bolt11InvoiceDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BOLT11_INVOICE{self._values!r}"

        def __eq__(self, other):
            if not other.is_bolt11_invoice():
                return False
            return self._values == other._values
    class BOLT12_INVOICE:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], Bolt12InvoiceDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'Bolt12InvoiceDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BOLT12_INVOICE{self._values!r}"

        def __eq__(self, other):
            if not other.is_bolt12_invoice():
                return False
            return self._values == other._values
    class BOLT12_OFFER:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], Bolt12OfferDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'Bolt12OfferDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BOLT12_OFFER{self._values!r}"

        def __eq__(self, other):
            if not other.is_bolt12_offer():
                return False
            return self._values == other._values
    class LIGHTNING_ADDRESS:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], LightningAddressDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'LightningAddressDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.LIGHTNING_ADDRESS{self._values!r}"

        def __eq__(self, other):
            if not other.is_lightning_address():
                return False
            return self._values == other._values
    class LNURL_PAY:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], LnurlPayRequestDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'LnurlPayRequestDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.LNURL_PAY{self._values!r}"

        def __eq__(self, other):
            if not other.is_lnurl_pay():
                return False
            return self._values == other._values
    class SILENT_PAYMENT_ADDRESS:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], SilentPaymentAddressDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'SilentPaymentAddressDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.SILENT_PAYMENT_ADDRESS{self._values!r}"

        def __eq__(self, other):
            if not other.is_silent_payment_address():
                return False
            return self._values == other._values
    class LNURL_AUTH:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], LnurlAuthRequestDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'LnurlAuthRequestDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.LNURL_AUTH{self._values!r}"

        def __eq__(self, other):
            if not other.is_lnurl_auth():
                return False
            return self._values == other._values
    class URL:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.URL{self._values!r}"

        def __eq__(self, other):
            if not other.is_url():
                return False
            return self._values == other._values
    class BIP21:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], Bip21Details):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'Bip21Details', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BIP21{self._values!r}"

        def __eq__(self, other):
            if not other.is_bip21():
                return False
            return self._values == other._values
    class BOLT12_INVOICE_REQUEST:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], Bolt12InvoiceRequestDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'Bolt12InvoiceRequestDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.BOLT12_INVOICE_REQUEST{self._values!r}"

        def __eq__(self, other):
            if not other.is_bolt12_invoice_request():
                return False
            return self._values == other._values
    class LNURL_WITHDRAW:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], LnurlWithdrawRequestDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'LnurlWithdrawRequestDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.LNURL_WITHDRAW{self._values!r}"

        def __eq__(self, other):
            if not other.is_lnurl_withdraw():
                return False
            return self._values == other._values
    class SPARK_ADDRESS:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], SparkAddressDetails):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'SparkAddressDetails', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"InputType.SPARK_ADDRESS{self._values!r}"

        def __eq__(self, other):
            if not other.is_spark_address():
                return False
            return self._values == other._values
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin_address(self) -> bool:
        return isinstance(self, InputType.BITCOIN_ADDRESS)
    def is_bolt11_invoice(self) -> bool:
        return isinstance(self, InputType.BOLT11_INVOICE)
    def is_bolt12_invoice(self) -> bool:
        return isinstance(self, InputType.BOLT12_INVOICE)
    def is_bolt12_offer(self) -> bool:
        return isinstance(self, InputType.BOLT12_OFFER)
    def is_lightning_address(self) -> bool:
        return isinstance(self, InputType.LIGHTNING_ADDRESS)
    def is_lnurl_pay(self) -> bool:
        return isinstance(self, InputType.LNURL_PAY)
    def is_silent_payment_address(self) -> bool:
        return isinstance(self, InputType.SILENT_PAYMENT_ADDRESS)
    def is_lnurl_auth(self) -> bool:
        return isinstance(self, InputType.LNURL_AUTH)
    def is_url(self) -> bool:
        return isinstance(self, InputType.URL)
    def is_bip21(self) -> bool:
        return isinstance(self, InputType.BIP21)
    def is_bolt12_invoice_request(self) -> bool:
        return isinstance(self, InputType.BOLT12_INVOICE_REQUEST)
    def is_lnurl_withdraw(self) -> bool:
        return isinstance(self, InputType.LNURL_WITHDRAW)
    def is_spark_address(self) -> bool:
        return isinstance(self, InputType.SPARK_ADDRESS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
InputType.BITCOIN_ADDRESS = type("InputType.BITCOIN_ADDRESS", (InputType.BITCOIN_ADDRESS, InputType,), {})  # type: ignore
InputType.BOLT11_INVOICE = type("InputType.BOLT11_INVOICE", (InputType.BOLT11_INVOICE, InputType,), {})  # type: ignore
InputType.BOLT12_INVOICE = type("InputType.BOLT12_INVOICE", (InputType.BOLT12_INVOICE, InputType,), {})  # type: ignore
InputType.BOLT12_OFFER = type("InputType.BOLT12_OFFER", (InputType.BOLT12_OFFER, InputType,), {})  # type: ignore
InputType.LIGHTNING_ADDRESS = type("InputType.LIGHTNING_ADDRESS", (InputType.LIGHTNING_ADDRESS, InputType,), {})  # type: ignore
InputType.LNURL_PAY = type("InputType.LNURL_PAY", (InputType.LNURL_PAY, InputType,), {})  # type: ignore
InputType.SILENT_PAYMENT_ADDRESS = type("InputType.SILENT_PAYMENT_ADDRESS", (InputType.SILENT_PAYMENT_ADDRESS, InputType,), {})  # type: ignore
InputType.LNURL_AUTH = type("InputType.LNURL_AUTH", (InputType.LNURL_AUTH, InputType,), {})  # type: ignore
InputType.URL = type("InputType.URL", (InputType.URL, InputType,), {})  # type: ignore
InputType.BIP21 = type("InputType.BIP21", (InputType.BIP21, InputType,), {})  # type: ignore
InputType.BOLT12_INVOICE_REQUEST = type("InputType.BOLT12_INVOICE_REQUEST", (InputType.BOLT12_INVOICE_REQUEST, InputType,), {})  # type: ignore
InputType.LNURL_WITHDRAW = type("InputType.LNURL_WITHDRAW", (InputType.LNURL_WITHDRAW, InputType,), {})  # type: ignore
InputType.SPARK_ADDRESS = type("InputType.SPARK_ADDRESS", (InputType.SPARK_ADDRESS, InputType,), {})  # type: ignore




class _UniffiConverterTypeInputType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return InputType.BITCOIN_ADDRESS(
                _UniffiConverterTypeBitcoinAddressDetails.read(buf),
            )
        if variant == 2:
            return InputType.BOLT11_INVOICE(
                _UniffiConverterTypeBolt11InvoiceDetails.read(buf),
            )
        if variant == 3:
            return InputType.BOLT12_INVOICE(
                _UniffiConverterTypeBolt12InvoiceDetails.read(buf),
            )
        if variant == 4:
            return InputType.BOLT12_OFFER(
                _UniffiConverterTypeBolt12OfferDetails.read(buf),
            )
        if variant == 5:
            return InputType.LIGHTNING_ADDRESS(
                _UniffiConverterTypeLightningAddressDetails.read(buf),
            )
        if variant == 6:
            return InputType.LNURL_PAY(
                _UniffiConverterTypeLnurlPayRequestDetails.read(buf),
            )
        if variant == 7:
            return InputType.SILENT_PAYMENT_ADDRESS(
                _UniffiConverterTypeSilentPaymentAddressDetails.read(buf),
            )
        if variant == 8:
            return InputType.LNURL_AUTH(
                _UniffiConverterTypeLnurlAuthRequestDetails.read(buf),
            )
        if variant == 9:
            return InputType.URL(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return InputType.BIP21(
                _UniffiConverterTypeBip21Details.read(buf),
            )
        if variant == 11:
            return InputType.BOLT12_INVOICE_REQUEST(
                _UniffiConverterTypeBolt12InvoiceRequestDetails.read(buf),
            )
        if variant == 12:
            return InputType.LNURL_WITHDRAW(
                _UniffiConverterTypeLnurlWithdrawRequestDetails.read(buf),
            )
        if variant == 13:
            return InputType.SPARK_ADDRESS(
                _UniffiConverterTypeSparkAddressDetails.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin_address():
            _UniffiConverterTypeBitcoinAddressDetails.check_lower(value._values[0])
            return
        if value.is_bolt11_invoice():
            _UniffiConverterTypeBolt11InvoiceDetails.check_lower(value._values[0])
            return
        if value.is_bolt12_invoice():
            _UniffiConverterTypeBolt12InvoiceDetails.check_lower(value._values[0])
            return
        if value.is_bolt12_offer():
            _UniffiConverterTypeBolt12OfferDetails.check_lower(value._values[0])
            return
        if value.is_lightning_address():
            _UniffiConverterTypeLightningAddressDetails.check_lower(value._values[0])
            return
        if value.is_lnurl_pay():
            _UniffiConverterTypeLnurlPayRequestDetails.check_lower(value._values[0])
            return
        if value.is_silent_payment_address():
            _UniffiConverterTypeSilentPaymentAddressDetails.check_lower(value._values[0])
            return
        if value.is_lnurl_auth():
            _UniffiConverterTypeLnurlAuthRequestDetails.check_lower(value._values[0])
            return
        if value.is_url():
            _UniffiConverterString.check_lower(value._values[0])
            return
        if value.is_bip21():
            _UniffiConverterTypeBip21Details.check_lower(value._values[0])
            return
        if value.is_bolt12_invoice_request():
            _UniffiConverterTypeBolt12InvoiceRequestDetails.check_lower(value._values[0])
            return
        if value.is_lnurl_withdraw():
            _UniffiConverterTypeLnurlWithdrawRequestDetails.check_lower(value._values[0])
            return
        if value.is_spark_address():
            _UniffiConverterTypeSparkAddressDetails.check_lower(value._values[0])
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin_address():
            buf.write_i32(1)
            _UniffiConverterTypeBitcoinAddressDetails.write(value._values[0], buf)
        if value.is_bolt11_invoice():
            buf.write_i32(2)
            _UniffiConverterTypeBolt11InvoiceDetails.write(value._values[0], buf)
        if value.is_bolt12_invoice():
            buf.write_i32(3)
            _UniffiConverterTypeBolt12InvoiceDetails.write(value._values[0], buf)
        if value.is_bolt12_offer():
            buf.write_i32(4)
            _UniffiConverterTypeBolt12OfferDetails.write(value._values[0], buf)
        if value.is_lightning_address():
            buf.write_i32(5)
            _UniffiConverterTypeLightningAddressDetails.write(value._values[0], buf)
        if value.is_lnurl_pay():
            buf.write_i32(6)
            _UniffiConverterTypeLnurlPayRequestDetails.write(value._values[0], buf)
        if value.is_silent_payment_address():
            buf.write_i32(7)
            _UniffiConverterTypeSilentPaymentAddressDetails.write(value._values[0], buf)
        if value.is_lnurl_auth():
            buf.write_i32(8)
            _UniffiConverterTypeLnurlAuthRequestDetails.write(value._values[0], buf)
        if value.is_url():
            buf.write_i32(9)
            _UniffiConverterString.write(value._values[0], buf)
        if value.is_bip21():
            buf.write_i32(10)
            _UniffiConverterTypeBip21Details.write(value._values[0], buf)
        if value.is_bolt12_invoice_request():
            buf.write_i32(11)
            _UniffiConverterTypeBolt12InvoiceRequestDetails.write(value._values[0], buf)
        if value.is_lnurl_withdraw():
            buf.write_i32(12)
            _UniffiConverterTypeLnurlWithdrawRequestDetails.write(value._values[0], buf)
        if value.is_spark_address():
            buf.write_i32(13)
            _UniffiConverterTypeSparkAddressDetails.write(value._values[0], buf)







class LnurlCallbackStatus:
    """
    Contains the result of the entire LNURL interaction, as reported by the LNURL endpoint.

    * `Ok` indicates the interaction with the endpoint was valid, and the endpoint
    - started to pay the invoice asynchronously in the case of LNURL-withdraw,
    - verified the client signature in the case of LNURL-auth
    * `Error` indicates a generic issue the LNURL endpoint encountered, including a freetext
    description of the reason.

    Both cases are described in LUD-03 <https://github.com/lnurl/luds/blob/luds/03.md> & LUD-04: <https://github.com/lnurl/luds/blob/luds/04.md>
    """

    def __init__(self):
        raise RuntimeError("LnurlCallbackStatus cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class OK:
        """
        On-wire format is: `{"status": "OK"}`
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "LnurlCallbackStatus.OK()".format()

        def __eq__(self, other):
            if not other.is_ok():
                return False
            return True
    
    class ERROR_STATUS:
        """
        On-wire format is: `{"status": "ERROR", "reason": "error details..."}`
        """

        error_details: "LnurlErrorDetails"

        def __init__(self,error_details: "LnurlErrorDetails"):
            self.error_details = error_details

        def __str__(self):
            return "LnurlCallbackStatus.ERROR_STATUS(error_details={})".format(self.error_details)

        def __eq__(self, other):
            if not other.is_error_status():
                return False
            if self.error_details != other.error_details:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_ok(self) -> bool:
        return isinstance(self, LnurlCallbackStatus.OK)
    def is_error_status(self) -> bool:
        return isinstance(self, LnurlCallbackStatus.ERROR_STATUS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LnurlCallbackStatus.OK = type("LnurlCallbackStatus.OK", (LnurlCallbackStatus.OK, LnurlCallbackStatus,), {})  # type: ignore
LnurlCallbackStatus.ERROR_STATUS = type("LnurlCallbackStatus.ERROR_STATUS", (LnurlCallbackStatus.ERROR_STATUS, LnurlCallbackStatus,), {})  # type: ignore




class _UniffiConverterTypeLnurlCallbackStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnurlCallbackStatus.OK(
            )
        if variant == 2:
            return LnurlCallbackStatus.ERROR_STATUS(
                _UniffiConverterTypeLnurlErrorDetails.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_ok():
            return
        if value.is_error_status():
            _UniffiConverterTypeLnurlErrorDetails.check_lower(value.error_details)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_ok():
            buf.write_i32(1)
        if value.is_error_status():
            buf.write_i32(2)
            _UniffiConverterTypeLnurlErrorDetails.write(value.error_details, buf)




# ServiceConnectivityError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class ServiceConnectivityError(Exception):
    pass

_UniffiTempServiceConnectivityError = ServiceConnectivityError

class ServiceConnectivityError:  # type: ignore
    class Builder(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Builder({})".format(str(self))
    _UniffiTempServiceConnectivityError.Builder = Builder # type: ignore
    class Redirect(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Redirect({})".format(str(self))
    _UniffiTempServiceConnectivityError.Redirect = Redirect # type: ignore
    class Status(_UniffiTempServiceConnectivityError):
        def __init__(self, status, body):
            super().__init__(", ".join([
                "status={!r}".format(status),
                "body={!r}".format(body),
            ]))
            self.status = status
            self.body = body

        def __repr__(self):
            return "ServiceConnectivityError.Status({})".format(str(self))
    _UniffiTempServiceConnectivityError.Status = Status # type: ignore
    class Timeout(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Timeout({})".format(str(self))
    _UniffiTempServiceConnectivityError.Timeout = Timeout # type: ignore
    class Request(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Request({})".format(str(self))
    _UniffiTempServiceConnectivityError.Request = Request # type: ignore
    class Connect(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Connect({})".format(str(self))
    _UniffiTempServiceConnectivityError.Connect = Connect # type: ignore
    class Body(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Body({})".format(str(self))
    _UniffiTempServiceConnectivityError.Body = Body # type: ignore
    class Decode(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Decode({})".format(str(self))
    _UniffiTempServiceConnectivityError.Decode = Decode # type: ignore
    class Json(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Json({})".format(str(self))
    _UniffiTempServiceConnectivityError.Json = Json # type: ignore
    class Other(_UniffiTempServiceConnectivityError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ServiceConnectivityError.Other({})".format(str(self))
    _UniffiTempServiceConnectivityError.Other = Other # type: ignore

ServiceConnectivityError = _UniffiTempServiceConnectivityError # type: ignore
del _UniffiTempServiceConnectivityError


class _UniffiConverterTypeServiceConnectivityError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ServiceConnectivityError.Builder(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return ServiceConnectivityError.Redirect(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return ServiceConnectivityError.Status(
                _UniffiConverterUInt16.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return ServiceConnectivityError.Timeout(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return ServiceConnectivityError.Request(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return ServiceConnectivityError.Connect(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return ServiceConnectivityError.Body(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return ServiceConnectivityError.Decode(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return ServiceConnectivityError.Json(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return ServiceConnectivityError.Other(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, ServiceConnectivityError.Builder):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Redirect):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Status):
            _UniffiConverterUInt16.check_lower(value.status)
            _UniffiConverterString.check_lower(value.body)
            return
        if isinstance(value, ServiceConnectivityError.Timeout):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Request):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Connect):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Body):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Decode):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Json):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ServiceConnectivityError.Other):
            _UniffiConverterString.check_lower(value._values[0])
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, ServiceConnectivityError.Builder):
            buf.write_i32(1)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Redirect):
            buf.write_i32(2)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Status):
            buf.write_i32(3)
            _UniffiConverterUInt16.write(value.status, buf)
            _UniffiConverterString.write(value.body, buf)
        if isinstance(value, ServiceConnectivityError.Timeout):
            buf.write_i32(4)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Request):
            buf.write_i32(5)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Connect):
            buf.write_i32(6)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Body):
            buf.write_i32(7)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Decode):
            buf.write_i32(8)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Json):
            buf.write_i32(9)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ServiceConnectivityError.Other):
            buf.write_i32(10)
            _UniffiConverterString.write(value._values[0], buf)





class SparkAddressPaymentType:
    def __init__(self):
        raise RuntimeError("SparkAddressPaymentType cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class TOKENS_PAYMENT:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], TokensPayment):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'TokensPayment', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"SparkAddressPaymentType.TOKENS_PAYMENT{self._values!r}"

        def __eq__(self, other):
            if not other.is_tokens_payment():
                return False
            return self._values == other._values
    class SATS_PAYMENT:
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], SatsPayment):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'SatsPayment', got '{type(values[0])}'")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"SparkAddressPaymentType.SATS_PAYMENT{self._values!r}"

        def __eq__(self, other):
            if not other.is_sats_payment():
                return False
            return self._values == other._values
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_tokens_payment(self) -> bool:
        return isinstance(self, SparkAddressPaymentType.TOKENS_PAYMENT)
    def is_sats_payment(self) -> bool:
        return isinstance(self, SparkAddressPaymentType.SATS_PAYMENT)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SparkAddressPaymentType.TOKENS_PAYMENT = type("SparkAddressPaymentType.TOKENS_PAYMENT", (SparkAddressPaymentType.TOKENS_PAYMENT, SparkAddressPaymentType,), {})  # type: ignore
SparkAddressPaymentType.SATS_PAYMENT = type("SparkAddressPaymentType.SATS_PAYMENT", (SparkAddressPaymentType.SATS_PAYMENT, SparkAddressPaymentType,), {})  # type: ignore




class _UniffiConverterTypeSparkAddressPaymentType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SparkAddressPaymentType.TOKENS_PAYMENT(
                _UniffiConverterTypeTokensPayment.read(buf),
            )
        if variant == 2:
            return SparkAddressPaymentType.SATS_PAYMENT(
                _UniffiConverterTypeSatsPayment.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_tokens_payment():
            _UniffiConverterTypeTokensPayment.check_lower(value._values[0])
            return
        if value.is_sats_payment():
            _UniffiConverterTypeSatsPayment.check_lower(value._values[0])
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_tokens_payment():
            buf.write_i32(1)
            _UniffiConverterTypeTokensPayment.write(value._values[0], buf)
        if value.is_sats_payment():
            buf.write_i32(2)
            _UniffiConverterTypeSatsPayment.write(value._values[0], buf)







class SuccessAction:
    """
    Supported success action types

    Receiving any other (unsupported) success action type will result in a failed parsing,
    which will abort the LNURL-pay workflow, as per LUD-09.
    """

    def __init__(self):
        raise RuntimeError("SuccessAction cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class AES:
        """
        AES type, described in LUD-10
        """

        data: "AesSuccessActionData"

        def __init__(self,data: "AesSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.AES(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_aes():
                return False
            if self.data != other.data:
                return False
            return True
    
    class MESSAGE:
        """
        Message type, described in LUD-09
        """

        data: "MessageSuccessActionData"

        def __init__(self,data: "MessageSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.MESSAGE(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_message():
                return False
            if self.data != other.data:
                return False
            return True
    
    class URL:
        """
        URL type, described in LUD-09
        """

        data: "UrlSuccessActionData"

        def __init__(self,data: "UrlSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.URL(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_url():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_aes(self) -> bool:
        return isinstance(self, SuccessAction.AES)
    def is_message(self) -> bool:
        return isinstance(self, SuccessAction.MESSAGE)
    def is_url(self) -> bool:
        return isinstance(self, SuccessAction.URL)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SuccessAction.AES = type("SuccessAction.AES", (SuccessAction.AES, SuccessAction,), {})  # type: ignore
SuccessAction.MESSAGE = type("SuccessAction.MESSAGE", (SuccessAction.MESSAGE, SuccessAction,), {})  # type: ignore
SuccessAction.URL = type("SuccessAction.URL", (SuccessAction.URL, SuccessAction,), {})  # type: ignore




class _UniffiConverterTypeSuccessAction(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SuccessAction.AES(
                _UniffiConverterTypeAesSuccessActionData.read(buf),
            )
        if variant == 2:
            return SuccessAction.MESSAGE(
                _UniffiConverterTypeMessageSuccessActionData.read(buf),
            )
        if variant == 3:
            return SuccessAction.URL(
                _UniffiConverterTypeUrlSuccessActionData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_aes():
            _UniffiConverterTypeAesSuccessActionData.check_lower(value.data)
            return
        if value.is_message():
            _UniffiConverterTypeMessageSuccessActionData.check_lower(value.data)
            return
        if value.is_url():
            _UniffiConverterTypeUrlSuccessActionData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_aes():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionData.write(value.data, buf)
        if value.is_message():
            buf.write_i32(2)
            _UniffiConverterTypeMessageSuccessActionData.write(value.data, buf)
        if value.is_url():
            buf.write_i32(3)
            _UniffiConverterTypeUrlSuccessActionData.write(value.data, buf)







class SuccessActionProcessed:
    """
    [`SuccessAction`] where contents are ready to be consumed by the caller

    Contents are identical to [`SuccessAction`], except for AES where the ciphertext is decrypted.
    """

    def __init__(self):
        raise RuntimeError("SuccessActionProcessed cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class AES:
        """
        See [`SuccessAction::Aes`] for received payload

        See [`AesSuccessActionDataDecrypted`] for decrypted payload
        """

        result: "AesSuccessActionDataResult"

        def __init__(self,result: "AesSuccessActionDataResult"):
            self.result = result

        def __str__(self):
            return "SuccessActionProcessed.AES(result={})".format(self.result)

        def __eq__(self, other):
            if not other.is_aes():
                return False
            if self.result != other.result:
                return False
            return True
    
    class MESSAGE:
        """
        See [`SuccessAction::Message`]
        """

        data: "MessageSuccessActionData"

        def __init__(self,data: "MessageSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessActionProcessed.MESSAGE(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_message():
                return False
            if self.data != other.data:
                return False
            return True
    
    class URL:
        """
        See [`SuccessAction::Url`]
        """

        data: "UrlSuccessActionData"

        def __init__(self,data: "UrlSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessActionProcessed.URL(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_url():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_aes(self) -> bool:
        return isinstance(self, SuccessActionProcessed.AES)
    def is_message(self) -> bool:
        return isinstance(self, SuccessActionProcessed.MESSAGE)
    def is_url(self) -> bool:
        return isinstance(self, SuccessActionProcessed.URL)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SuccessActionProcessed.AES = type("SuccessActionProcessed.AES", (SuccessActionProcessed.AES, SuccessActionProcessed,), {})  # type: ignore
SuccessActionProcessed.MESSAGE = type("SuccessActionProcessed.MESSAGE", (SuccessActionProcessed.MESSAGE, SuccessActionProcessed,), {})  # type: ignore
SuccessActionProcessed.URL = type("SuccessActionProcessed.URL", (SuccessActionProcessed.URL, SuccessActionProcessed,), {})  # type: ignore




class _UniffiConverterTypeSuccessActionProcessed(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SuccessActionProcessed.AES(
                _UniffiConverterTypeAesSuccessActionDataResult.read(buf),
            )
        if variant == 2:
            return SuccessActionProcessed.MESSAGE(
                _UniffiConverterTypeMessageSuccessActionData.read(buf),
            )
        if variant == 3:
            return SuccessActionProcessed.URL(
                _UniffiConverterTypeUrlSuccessActionData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_aes():
            _UniffiConverterTypeAesSuccessActionDataResult.check_lower(value.result)
            return
        if value.is_message():
            _UniffiConverterTypeMessageSuccessActionData.check_lower(value.data)
            return
        if value.is_url():
            _UniffiConverterTypeUrlSuccessActionData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_aes():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionDataResult.write(value.result, buf)
        if value.is_message():
            buf.write_i32(2)
            _UniffiConverterTypeMessageSuccessActionData.write(value.data, buf)
        if value.is_url():
            buf.write_i32(3)
            _UniffiConverterTypeUrlSuccessActionData.write(value.data, buf)





class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalBool(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterBool.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterBool.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterBool.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSparkInvoiceFields(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSparkInvoiceFields.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSparkInvoiceFields.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSparkInvoiceFields.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSymbol(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSymbol.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSymbol.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSymbol.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAmount.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAmount.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAmount.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSparkAddressPaymentType(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSparkAddressPaymentType.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSparkAddressPaymentType.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSparkAddressPaymentType.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalMapStringString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterMapStringString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterMapStringString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterMapStringString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterString.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterString.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterString.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeBip21Extra(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeBip21Extra.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeBip21Extra.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeBip21Extra.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeBolt11RouteHint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeBolt11RouteHint.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeBolt11RouteHint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeBolt11RouteHint.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeBolt11RouteHintHop(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeBolt11RouteHintHop.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeBolt11RouteHintHop.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeBolt11RouteHintHop.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeBolt12OfferBlindedPath(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeBolt12OfferBlindedPath.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeBolt12OfferBlindedPath.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeBolt12OfferBlindedPath.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLocaleOverrides(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLocaleOverrides.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLocaleOverrides.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLocaleOverrides.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLocalizedName(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLocalizedName.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLocalizedName.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLocalizedName.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeInputType(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeInputType.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeInputType.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeInputType.read(buf) for i in range(count)
        ]



class _UniffiConverterMapStringString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterString.read(buf)
            d[key] = val
        return d

# Async support# RustFuturePoll values
_UNIFFI_RUST_FUTURE_POLL_READY = 0
_UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1

# Stores futures for _uniffi_continuation_callback
_UniffiContinuationHandleMap = _UniffiHandleMap()

_UNIFFI_GLOBAL_EVENT_LOOP = None

"""
Set the event loop to use for async functions

This is needed if some async functions run outside of the eventloop, for example:
    - A non-eventloop thread is spawned, maybe from `EventLoop.run_in_executor` or maybe from the
      Rust code spawning its own thread.
    - The Rust code calls an async callback method from a sync callback function, using something
      like `pollster` to block on the async call.

In this case, we need an event loop to run the Python async function, but there's no eventloop set
for the thread.  Use `uniffi_set_event_loop` to force an eventloop to be used in this case.
"""
def uniffi_set_event_loop(eventloop: asyncio.BaseEventLoop):
    global _UNIFFI_GLOBAL_EVENT_LOOP
    _UNIFFI_GLOBAL_EVENT_LOOP = eventloop

def _uniffi_get_event_loop():
    if _UNIFFI_GLOBAL_EVENT_LOOP is not None:
        return _UNIFFI_GLOBAL_EVENT_LOOP
    else:
        return asyncio.get_running_loop()

# Continuation callback for async functions
# lift the return value or error and resolve the future, causing the async function to resume.
@_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK
def _uniffi_continuation_callback(future_ptr, poll_code):
    (eventloop, future) = _UniffiContinuationHandleMap.remove(future_ptr)
    eventloop.call_soon_threadsafe(_uniffi_set_future_result, future, poll_code)

def _uniffi_set_future_result(future, poll_code):
    if not future.cancelled():
        future.set_result(poll_code)

async def _uniffi_rust_call_async(rust_future, ffi_poll, ffi_complete, ffi_free, lift_func, error_ffi_converter):
    try:
        eventloop = _uniffi_get_event_loop()

        # Loop and poll until we see a _UNIFFI_RUST_FUTURE_POLL_READY value
        while True:
            future = eventloop.create_future()
            ffi_poll(
                rust_future,
                _uniffi_continuation_callback,
                _UniffiContinuationHandleMap.insert((eventloop, future)),
            )
            poll_code = await future
            if poll_code == _UNIFFI_RUST_FUTURE_POLL_READY:
                break

        return lift_func(
            _uniffi_rust_call_with_error(error_ffi_converter, ffi_complete, rust_future)
        )
    finally:
        ffi_free(rust_future)
def _uniffi_trait_interface_call_async(make_call, handle_success, handle_error):
    async def make_call_and_call_callback():
        try:
            handle_success(await make_call())
        except Exception as e:
            print("UniFFI: Unhandled exception in trait interface call", file=sys.stderr)
            traceback.print_exc(file=sys.stderr)
            handle_error(
                _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR,
                _UniffiConverterString.lower(repr(e)),
            )
    eventloop = _uniffi_get_event_loop()
    task = asyncio.run_coroutine_threadsafe(make_call_and_call_callback(), eventloop)
    handle = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.insert((eventloop, task))
    return _UniffiForeignFuture(handle, _uniffi_foreign_future_free)

def _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, error_type, lower_error):
    async def make_call_and_call_callback():
        try:
            try:
                handle_success(await make_call())
            except error_type as e:
                handle_error(
                    _UniffiRustCallStatus.CALL_ERROR,
                    lower_error(e),
                )
        except Exception as e:
            print("UniFFI: Unhandled exception in trait interface call", file=sys.stderr)
            traceback.print_exc(file=sys.stderr)
            handle_error(
                _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR,
                _UniffiConverterString.lower(repr(e)),
            )
    eventloop = _uniffi_get_event_loop()
    task = asyncio.run_coroutine_threadsafe(make_call_and_call_callback(), eventloop)
    handle = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.insert((eventloop, task))
    return _UniffiForeignFuture(handle, _uniffi_foreign_future_free)

_UNIFFI_FOREIGN_FUTURE_HANDLE_MAP = _UniffiHandleMap()

@_UNIFFI_FOREIGN_FUTURE_FREE
def _uniffi_foreign_future_free(handle):
    (eventloop, task) = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.remove(handle)
    eventloop.call_soon(_uniffi_foreign_future_do_free, task)

def _uniffi_foreign_future_do_free(task):
    if not task.done():
        task.cancel()

__all__ = [
    "InternalError",
    "AesSuccessActionDataResult",
    "Amount",
    "BitcoinNetwork",
    "InputType",
    "LnurlCallbackStatus",
    "ServiceConnectivityError",
    "SparkAddressPaymentType",
    "SuccessAction",
    "SuccessActionProcessed",
    "AesSuccessActionData",
    "AesSuccessActionDataDecrypted",
    "Bip21Details",
    "Bip21Extra",
    "BitcoinAddressDetails",
    "Bolt11Invoice",
    "Bolt11InvoiceDetails",
    "Bolt11RouteHint",
    "Bolt11RouteHintHop",
    "Bolt12Invoice",
    "Bolt12InvoiceDetails",
    "Bolt12InvoiceRequestDetails",
    "Bolt12Offer",
    "Bolt12OfferBlindedPath",
    "Bolt12OfferDetails",
    "CurrencyInfo",
    "FiatCurrency",
    "LightningAddressDetails",
    "LnurlAuthRequestDetails",
    "LnurlErrorDetails",
    "LnurlPayRequestDetails",
    "LnurlWithdrawRequestDetails",
    "LocaleOverrides",
    "LocalizedName",
    "MessageSuccessActionData",
    "PaymentRequestSource",
    "Rate",
    "RestResponse",
    "SatsPayment",
    "SilentPaymentAddressDetails",
    "SparkAddress",
    "SparkAddressDetails",
    "SparkInvoiceFields",
    "Symbol",
    "TokensPayment",
    "UrlSuccessActionData",
    "RestClient",
]

