# coding: utf-8

"""
Earnix DataService API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Annotated, Self

from earnix_elevate.clients.data.models.connection_details_response import (
    ConnectionDetailsResponse,
)
from earnix_elevate.clients.data.models.data_version_response import DataVersionResponse
from earnix_elevate.clients.data.models.user_response import UserResponse


class DataTableResponse(BaseModel):
    """
    DataTableResponse
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=100)]] = (
        None
    )
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    tags: Optional[List[StrictStr]] = None
    id: Optional[StrictInt] = None
    lock_version: Optional[StrictInt] = Field(default=None, alias="lockVersion")
    data_source_id: Optional[StrictInt] = Field(default=None, alias="dataSourceId")
    data_version_exist: Optional[StrictBool] = Field(
        default=None, alias="dataVersionExist"
    )
    created_by: Optional[UserResponse] = Field(default=None, alias="createdBy")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    last_modified_by: Optional[UserResponse] = Field(
        default=None, alias="lastModifiedBy"
    )
    last_modified_date: Optional[datetime] = Field(
        default=None, alias="lastModifiedDate"
    )
    latest_data_version: Optional[DataVersionResponse] = Field(
        default=None, alias="latestDataVersion"
    )
    connection_details: Optional[ConnectionDetailsResponse] = Field(
        default=None, alias="connectionDetails"
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "tags",
        "id",
        "lockVersion",
        "dataSourceId",
        "dataVersionExist",
        "createdBy",
        "createdDate",
        "lastModifiedBy",
        "lastModifiedDate",
        "latestDataVersion",
        "connectionDetails",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataTableResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict["createdBy"] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict["lastModifiedBy"] = self.last_modified_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latest_data_version
        if self.latest_data_version:
            _dict["latestDataVersion"] = self.latest_data_version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of connection_details
        if self.connection_details:
            _dict["connectionDetails"] = self.connection_details.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataTableResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "id": obj.get("id"),
                "lockVersion": obj.get("lockVersion"),
                "dataSourceId": obj.get("dataSourceId"),
                "dataVersionExist": obj.get("dataVersionExist"),
                "createdBy": UserResponse.from_dict(obj["createdBy"])
                if obj.get("createdBy") is not None
                else None,
                "createdDate": obj.get("createdDate"),
                "lastModifiedBy": UserResponse.from_dict(obj["lastModifiedBy"])
                if obj.get("lastModifiedBy") is not None
                else None,
                "lastModifiedDate": obj.get("lastModifiedDate"),
                "latestDataVersion": DataVersionResponse.from_dict(
                    obj["latestDataVersion"]
                )
                if obj.get("latestDataVersion") is not None
                else None,
                "connectionDetails": ConnectionDetailsResponse.from_dict(
                    obj["connectionDetails"]
                )
                if obj.get("connectionDetails") is not None
                else None,
            }
        )
        return _obj
