# coding: utf-8

"""
Earnix import export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import ConfigDict, Field
from typing_extensions import Annotated, Self

from earnix_elevate.clients.imx.models.create_connection_request import (
    CreateConnectionRequest,
)


class CreateSnowflakeConnectionRequest(CreateConnectionRequest):
    """
    CreateSnowflakeConnectionRequest
    """  # noqa: E501

    database: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    var_schema: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(
        default=None, alias="schema"
    )
    warehouse: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    username: Annotated[str, Field(min_length=1, strict=True, max_length=500)]
    password: Annotated[str, Field(min_length=1, strict=True, max_length=500)]
    host: Annotated[str, Field(min_length=1, strict=True, max_length=500)]
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "tags",
        "type",
        "database",
        "schema",
        "warehouse",
        "username",
        "password",
        "host",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSnowflakeConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        # set to None if database (nullable) is None
        # and model_fields_set contains the field
        if self.database is None and "database" in self.model_fields_set:
            _dict["database"] = None

        # set to None if var_schema (nullable) is None
        # and model_fields_set contains the field
        if self.var_schema is None and "var_schema" in self.model_fields_set:
            _dict["schema"] = None

        # set to None if warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse is None and "warehouse" in self.model_fields_set:
            _dict["warehouse"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSnowflakeConnectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "type": obj.get("type"),
                "database": obj.get("database"),
                "schema": obj.get("schema"),
                "warehouse": obj.get("warehouse"),
                "username": obj.get("username"),
                "password": obj.get("password"),
                "host": obj.get("host"),
            }
        )
        return _obj
