# coding: utf-8

"""
Earnix DataService API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated, Self


class AddDataSetRecipeNodeRequest(BaseModel):
    """
    AddDataSetRecipeNodeRequest
    """  # noqa: E501

    source_data_set_node_ids: Optional[List[StrictInt]] = Field(
        default=None, alias="sourceDataSetNodeIds"
    )
    type: Optional[StrictStr] = None
    name: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=100)]] = (
        None
    )
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    tags: Optional[List[StrictStr]] = None
    data_set_id: Optional[StrictInt] = Field(default=None, alias="dataSetId")
    source_data_set_version_number: Optional[StrictInt] = Field(
        default=None,
        description="Optional. If null, the latest version will be used.",
        alias="sourceDataSetVersionNumber",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "tags",
        "dataSetId",
        "sourceDataSetVersionNumber",
    ]

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["TRANSFORMATION", "STRUCTURE"]):
            raise ValueError(
                "must be one of enum values ('TRANSFORMATION', 'STRUCTURE')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddDataSetRecipeNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddDataSetRecipeNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "dataSetId": obj.get("dataSetId"),
                "sourceDataSetVersionNumber": obj.get("sourceDataSetVersionNumber"),
            }
        )
        return _obj
