# coding: utf-8

"""
Earnix import export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import ConfigDict, Field, field_validator
from typing_extensions import Annotated, Self

from earnix_elevate.clients.imx.models.merge_connection_request import (
    MergeConnectionRequest,
)


class MergeS3ConnectionRequest(MergeConnectionRequest):
    """
    MergeS3ConnectionRequest
    """  # noqa: E501

    path_restriction: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = (
        Field(default=None, alias="pathRestriction")
    )
    access_key_id: Optional[
        Annotated[str, Field(min_length=16, strict=True, max_length=128)]
    ] = Field(default=None, alias="accessKeyId")
    secret_access_key: Optional[
        Annotated[str, Field(min_length=16, strict=True, max_length=1024)]
    ] = Field(default=None, alias="secretAccessKey")
    endpoint: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "type",
        "pathRestriction",
        "accessKeyId",
        "secretAccessKey",
        "endpoint",
    ]

    @field_validator("access_key_id")
    def access_key_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator("endpoint")
    def endpoint_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^https:\/\/.+$", value):
            raise ValueError(r"must validate the regular expression /^https:\/\/.+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MergeS3ConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        # set to None if path_restriction (nullable) is None
        # and model_fields_set contains the field
        if (
            self.path_restriction is None
            and "path_restriction" in self.model_fields_set
        ):
            _dict["pathRestriction"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MergeS3ConnectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "lockVersion": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "type": obj.get("type"),
                "pathRestriction": obj.get("pathRestriction"),
                "accessKeyId": obj.get("accessKeyId"),
                "secretAccessKey": obj.get("secretAccessKey"),
                "endpoint": obj.get("endpoint"),
            }
        )
        return _obj
