# coding: utf-8

"""
Earnix import export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from importlib import import_module
from typing import TYPE_CHECKING, Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Annotated

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.update_bucket_data_source_request import (
        UpdateBucketDataSourceRequest,
    )
    from earnix_elevate.clients.imx.models.update_rdbms_data_source_request import (
        UpdateRDBMSDataSourceRequest,
    )


class UpdateDataSourceRequest(BaseModel):
    """
    UpdateDataSourceRequest
    """  # noqa: E501

    type: StrictStr
    id: StrictInt
    lock_version: StrictInt = Field(alias="lockVersion")
    name: Annotated[str, Field(min_length=3, strict=True, max_length=100)]
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = None
    tags: Optional[List[StrictStr]] = None
    connection_id: StrictInt = Field(alias="connectionId")
    __properties: ClassVar[List[str]] = [
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "connectionId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "bucket": "UpdateBucketDataSourceRequest",
        "rdbms": "UpdateRDBMSDataSourceRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Optional[Union[UpdateBucketDataSourceRequest, UpdateRDBMSDataSourceRequest]]:
        """Create an instance of UpdateDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: Dict[str, Any]
    ) -> Optional[Union[UpdateBucketDataSourceRequest, UpdateRDBMSDataSourceRequest]]:
        """Create an instance of UpdateDataSourceRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "UpdateBucketDataSourceRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.update_bucket_data_source_request"
            ).UpdateBucketDataSourceRequest.from_dict(obj)
        if object_type == "UpdateRDBMSDataSourceRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.update_rdbms_data_source_request"
            ).UpdateRDBMSDataSourceRequest.from_dict(obj)

        raise ValueError(
            "UpdateDataSourceRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
