/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.method.MethodInvoker;
import org.springframework.binding.method.MethodSignature;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.action.SuccessEventFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractBeanInvokingAction
extends AbstractAction {
    private MethodSignature methodSignature;
    private MethodInvoker methodInvoker = new MethodInvoker();
    private ActionResultExposer methodResultExposer;
    private ResultEventFactory resultEventFactory = new SuccessEventFactory();

    protected AbstractBeanInvokingAction(MethodSignature methodSignature) {
        Assert.notNull((Object)methodSignature, (String)"The signature of the target method to invoke is required");
        this.methodSignature = methodSignature;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public ActionResultExposer getMethodResultExposer() {
        return this.methodResultExposer;
    }

    public void setMethodResultExposer(ActionResultExposer methodResultExposer) {
        this.methodResultExposer = methodResultExposer;
    }

    protected ResultEventFactory getResultEventFactory() {
        return this.resultEventFactory;
    }

    public void setResultEventFactory(ResultEventFactory resultEventFactory) {
        this.resultEventFactory = resultEventFactory;
    }

    public void setConversionService(ConversionService conversionService) {
        this.methodInvoker.setConversionService(conversionService);
    }

    protected MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object bean = this.getBean(context);
        Object returnValue = this.getMethodInvoker().invoke(this.methodSignature, bean, (Object)context);
        if (this.methodResultExposer != null) {
            this.methodResultExposer.exposeResult(returnValue, context);
        }
        return this.resultEventFactory.createResultEvent(bean, returnValue, context);
    }

    protected abstract Object getBean(RequestContext var1) throws Exception;
}

