/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.servlet.HttpSessionMapBindingListener;
import org.springframework.webflow.core.collection.AttributeMapBindingListener;
import org.springframework.webflow.core.collection.CollectionUtils;

public class PortletSessionMap
extends StringKeyedMapAdapter
implements SharedMap {
    private PortletRequest request;
    private int scope;

    public PortletSessionMap(PortletRequest request, int scope) {
        this.request = request;
        this.scope = scope;
    }

    private PortletSession getSession() {
        return this.request.getPortletSession(false);
    }

    protected Object getAttribute(String key) {
        PortletSession session = this.getSession();
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(key, this.scope);
        if (value instanceof HttpSessionMapBindingListener) {
            return ((HttpSessionMapBindingListener)value).getListener();
        }
        return value;
    }

    protected void setAttribute(String key, Object value) {
        PortletSession session = this.request.getPortletSession(true);
        if (value instanceof AttributeMapBindingListener) {
            session.setAttribute(key, (Object)new HttpSessionMapBindingListener((AttributeMapBindingListener)value, (Map)((Object)this)), this.scope);
        } else {
            session.setAttribute(key, value, this.scope);
        }
    }

    protected void removeAttribute(String key) {
        PortletSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key, this.scope);
        }
    }

    protected Iterator getAttributeNames() {
        PortletSession session = this.getSession();
        return session == null ? CollectionUtils.EMPTY_ITERATOR : CollectionUtils.toIterator(session.getAttributeNames(this.scope));
    }

    public Object getMutex() {
        PortletSession session = this.request.getPortletSession(true);
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE, this.scope);
        return mutex != null ? mutex : session;
    }
}

